/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.multifile.signature;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaSignature;

public final class JavaFieldSignature
extends JavaSignature<ASTFieldDeclaration> {
    private static final Map<Integer, JavaFieldSignature> POOL = new HashMap<Integer, JavaFieldSignature>();
    public final boolean isStatic;
    public final boolean isFinal;

    private JavaFieldSignature(JavaSignature.Visibility visibility, boolean isStatic, boolean isFinal) {
        super(visibility);
        this.isStatic = isStatic;
        this.isFinal = isFinal;
    }

    public String toString() {
        return "JavaFieldSignature{isStatic=" + this.isStatic + ", isFinal=" + this.isFinal + ", visibility=" + (Object)((Object)this.visibility) + '}';
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return JavaFieldSignature.code(this.visibility, this.isStatic, this.isFinal);
    }

    private static int code(JavaSignature.Visibility visibility, boolean isStatic, boolean isFinal) {
        return visibility.hashCode() * 31 + (isStatic ? 1 : 0) * 2 + (isFinal ? 1 : 0);
    }

    public static JavaFieldSignature buildFor(ASTFieldDeclaration node) {
        int code = JavaFieldSignature.code(JavaSignature.Visibility.get(node), node.isStatic(), node.isFinal());
        if (!POOL.containsKey(code)) {
            POOL.put(code, new JavaFieldSignature(JavaSignature.Visibility.get(node), node.isStatic(), node.isFinal()));
        }
        return POOL.get(code);
    }
}

