/**
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */
/* Generated By:JJTree: Do not edit this line. ASTClassOrInterfaceDeclaration.java */

package net.sourceforge.pmd.lang.java.ast;

import java.util.List;

import net.sourceforge.pmd.lang.ast.Node;


public class ASTClassOrInterfaceDeclaration extends AbstractJavaAccessTypeNode implements ASTAnyTypeDeclaration {

    private boolean isLocal;
    private boolean isLocalComputed; // guard for lazy evaluation of isLocal()

    private boolean isInterface;
    private JavaQualifiedName qualifiedName;

    public ASTClassOrInterfaceDeclaration(int id) {
        super(id);
    }

    public ASTClassOrInterfaceDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public boolean isFindBoundary() {
        return isNested();
    }

    /**
     * Accept the visitor. *
     */
    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isNested() {
        return jjtGetParent() instanceof ASTClassOrInterfaceBodyDeclaration
            || jjtGetParent() instanceof ASTAnnotationTypeMemberDeclaration;
    }


    /**
     * Returns true if the class is declared inside a block other
     * than the body of another class, or the top level.
     */
    public boolean isLocal() {
        if (!isLocalComputed) {
            Node current = jjtGetParent();
            while (current != null) {
                if (current instanceof ASTAnyTypeDeclaration) {
                    isLocal = false;
                    break;
                } else if (current instanceof ASTMethodOrConstructorDeclaration
                        || current instanceof ASTInitializer) {
                    isLocal = true;
                    break;
                }
                current = current.jjtGetParent();
            }
            if (current == null) {
                isLocal = false;
            }
            isLocalComputed = true;
        }
        return isLocal;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface() {
        this.isInterface = true;
    }

    @Override
    public JavaQualifiedName getQualifiedName() {
        if (qualifiedName == null) {
            if (isNested() || isLocal()) {
                ASTAnyTypeDeclaration parent = this.getFirstParentOfType(ASTAnyTypeDeclaration.class);
                JavaQualifiedName parentQN = parent.getQualifiedName();

                qualifiedName = isLocal()
                        ? JavaQualifiedName.ofLocalClass(parentQN, this.getImage())
                        : JavaQualifiedName.ofNestedClass(parentQN, this.getImage());
                return qualifiedName;
            }

            qualifiedName = JavaQualifiedName.ofOuterClass(this);
        }

        return qualifiedName;
    }

    @Override
    public TypeKind getTypeKind() {
        return isInterface() ? TypeKind.INTERFACE : TypeKind.CLASS;
    }


    @Override
    public List<ASTAnyTypeBodyDeclaration> getDeclarations() {
        return getFirstChildOfType(ASTClassOrInterfaceBody.class)
            .findChildrenOfType(ASTAnyTypeBodyDeclaration.class);
    }
}
