/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeMemberDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.ast.JavaQualifiedName;

public class ASTClassOrInterfaceDeclaration
extends AbstractJavaAccessTypeNode
implements ASTAnyTypeDeclaration {
    private boolean isLocal;
    private boolean isLocalComputed;
    private boolean isInterface;
    private JavaQualifiedName qualifiedName;

    public ASTClassOrInterfaceDeclaration(int id) {
        super(id);
    }

    public ASTClassOrInterfaceDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    public boolean isFindBoundary() {
        return this.isNested();
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isNested() {
        return this.jjtGetParent() instanceof ASTClassOrInterfaceBodyDeclaration || this.jjtGetParent() instanceof ASTAnnotationTypeMemberDeclaration;
    }

    public boolean isLocal() {
        if (!this.isLocalComputed) {
            Node current;
            for (current = this.jjtGetParent(); current != null; current = current.jjtGetParent()) {
                if (current instanceof ASTAnyTypeDeclaration) {
                    this.isLocal = false;
                    break;
                }
                if (!(current instanceof ASTMethodOrConstructorDeclaration) && !(current instanceof ASTInitializer)) continue;
                this.isLocal = true;
                break;
            }
            if (current == null) {
                this.isLocal = false;
            }
            this.isLocalComputed = true;
        }
        return this.isLocal;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface() {
        this.isInterface = true;
    }

    @Override
    public JavaQualifiedName getQualifiedName() {
        if (this.qualifiedName == null) {
            if (this.isNested() || this.isLocal()) {
                ASTAnyTypeDeclaration parent = (ASTAnyTypeDeclaration)this.getFirstParentOfType(ASTAnyTypeDeclaration.class);
                JavaQualifiedName parentQN = parent.getQualifiedName();
                this.qualifiedName = this.isLocal() ? JavaQualifiedName.ofLocalClass(parentQN, this.getImage()) : JavaQualifiedName.ofNestedClass(parentQN, this.getImage());
                return this.qualifiedName;
            }
            this.qualifiedName = JavaQualifiedName.ofOuterClass(this);
        }
        return this.qualifiedName;
    }

    @Override
    public ASTAnyTypeDeclaration.TypeKind getTypeKind() {
        return this.isInterface() ? ASTAnyTypeDeclaration.TypeKind.INTERFACE : ASTAnyTypeDeclaration.TypeKind.CLASS;
    }

    @Override
    public List<ASTAnyTypeBodyDeclaration> getDeclarations() {
        return ((ASTClassOrInterfaceBody)this.getFirstChildOfType(ASTClassOrInterfaceBody.class)).findChildrenOfType(ASTAnyTypeBodyDeclaration.class);
    }
}

