/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.math.BigInteger;
import java.util.Locale;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;

public class ASTLiteral
extends AbstractJavaTypeNode {
    private boolean isInt;
    private boolean isFloat;
    private boolean isChar;
    private boolean isString;
    private static final Pattern SINGLE_CHAR_ESCAPE_PATTERN = Pattern.compile("^\"\\\\(([ntbrf\\\\'\\\"])|([0-7][0-7]?)|([0-3][0-7][0-7]))\"");

    public ASTLiteral(int id) {
        super(id);
    }

    public ASTLiteral(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void setIntLiteral() {
        this.isInt = true;
    }

    public boolean isIntLiteral() {
        String image = this.getImage();
        return this.isInt && image != null && image.length() > 0 && !image.endsWith("l") && !image.endsWith("L");
    }

    public boolean isLongLiteral() {
        String image = this.getImage();
        return this.isInt && image != null && image.length() > 0 && (image.endsWith("l") || image.endsWith("L"));
    }

    public void setFloatLiteral() {
        this.isFloat = true;
    }

    public boolean isFloatLiteral() {
        char lastChar;
        String image = this.getImage();
        return this.isFloat && image != null && image.length() > 0 && ((lastChar = image.charAt(image.length() - 1)) == 'f' || lastChar == 'F');
    }

    public boolean isDoubleLiteral() {
        char lastChar;
        String image = this.getImage();
        return this.isFloat && image != null && image.length() > 0 && ((lastChar = image.charAt(image.length() - 1)) == 'd' || lastChar == 'D' || Character.isDigit(lastChar) || lastChar == '.');
    }

    private String stripIntValue() {
        String image = this.getImage().toLowerCase(Locale.ROOT).replaceAll("_", "");
        boolean isNegative = false;
        if (image.charAt(0) == '-') {
            isNegative = true;
            image = image.substring(1);
        }
        if (image.endsWith("l")) {
            image = image.substring(0, image.length() - 1);
        }
        if (image.charAt(0) == '0' && image.length() > 1) {
            image = image.charAt(1) == 'x' || image.charAt(1) == 'b' ? image.substring(2) : image.substring(1);
        }
        if (isNegative) {
            return "-" + image;
        }
        return image;
    }

    private String stripFloatValue() {
        return this.getImage().toLowerCase(Locale.ROOT).replaceAll("_", "");
    }

    private int getIntBase() {
        int offset;
        String image = this.getImage().toLowerCase(Locale.ROOT);
        int n = offset = image.charAt(0) == '-' ? 1 : 0;
        if (image.startsWith("0x", offset)) {
            return 16;
        }
        if (image.startsWith("0b", offset)) {
            return 2;
        }
        if (image.startsWith("0", offset) && image.length() > 1) {
            return 8;
        }
        return 10;
    }

    public int getValueAsInt() {
        return (int)this.getValueAsLong();
    }

    public long getValueAsLong() {
        BigInteger bigInt = new BigInteger(this.stripIntValue(), this.getIntBase());
        return bigInt.longValue();
    }

    public float getValueAsFloat() {
        return Float.parseFloat(this.stripFloatValue());
    }

    public double getValueAsDouble() {
        return Double.parseDouble(this.stripFloatValue());
    }

    public void setCharLiteral() {
        this.isChar = true;
    }

    public boolean isCharLiteral() {
        return this.isChar;
    }

    public void setStringLiteral() {
        this.isString = true;
    }

    public boolean isStringLiteral() {
        return this.isString;
    }

    public String getEscapedStringLiteral() {
        String image = this.getImage();
        if (!this.isStringLiteral() && !this.isCharLiteral()) {
            return image;
        }
        int fullLength = this.getEndColumn() - this.getBeginColumn();
        if (fullLength > image.length()) {
            StringBuilder result = new StringBuilder(fullLength);
            for (int i = 0; i < image.length(); ++i) {
                char c = image.charAt(i);
                if (c < ' ' || c > '\u00ff' || image.length() == 1) {
                    String hex = "0000" + Integer.toHexString(c);
                    result.append("\\u").append(hex.substring(hex.length() - 4));
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }
        return image;
    }

    public boolean isSingleCharacterStringLiteral() {
        if (this.isString) {
            String image = this.getImage();
            int length = image.length();
            if (length == 3) {
                return true;
            }
            if (image.charAt(1) == '\\') {
                return SINGLE_CHAR_ESCAPE_PATTERN.matcher(image).matches();
            }
        }
        return false;
    }
}

