/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractLombokAwareRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class ImmutableFieldRule
extends AbstractLombokAwareRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Object result = super.visit(node, data);
        Map vars = node.getScope().getDeclarations(VariableNameDeclaration.class);
        List<ASTConstructorDeclaration> constructors = this.findAllConstructors(node);
        for (Map.Entry entry : vars.entrySet()) {
            FieldImmutabilityType type;
            VariableNameDeclaration field = (VariableNameDeclaration)entry.getKey();
            AccessNode accessNodeParent = field.getAccessNodeParent();
            if (accessNodeParent.isStatic() || !accessNodeParent.isPrivate() || accessNodeParent.isFinal() || accessNodeParent.isVolatile() || this.hasClassLombokAnnotation() || this.hasIgnoredAnnotation((Annotatable)((Object)accessNodeParent)) || (type = this.initializedInConstructor((List)entry.getValue(), new HashSet<ASTConstructorDeclaration>(constructors))) == FieldImmutabilityType.MUTABLE || type != FieldImmutabilityType.IMMUTABLE && (type != FieldImmutabilityType.CHECKDECL || !this.initializedWhenDeclared(field))) continue;
            this.addViolation(data, (Node)field.getNode(), field.getImage());
        }
        return result;
    }

    private boolean initializedWhenDeclared(VariableNameDeclaration field) {
        return field.getAccessNodeParent().hasDescendantOfType(ASTVariableInitializer.class);
    }

    private FieldImmutabilityType initializedInConstructor(List<NameOccurrence> usages, Set<ASTConstructorDeclaration> allConstructors) {
        FieldImmutabilityType result = FieldImmutabilityType.MUTABLE;
        int methodInitCount = 0;
        int lambdaUsage = 0;
        HashSet<ASTConstructorDeclaration> consSet = new HashSet<ASTConstructorDeclaration>();
        for (NameOccurrence occ : usages) {
            JavaNameOccurrence jocc = (JavaNameOccurrence)occ;
            if (!jocc.isOnLeftHandSide() && !jocc.isSelfAssignment()) continue;
            JavaNode node = jocc.getLocation();
            ASTConstructorDeclaration constructor = (ASTConstructorDeclaration)node.getFirstParentOfType(ASTConstructorDeclaration.class);
            if (constructor != null) {
                if (this.inLoopOrTry((Node)node)) continue;
                if (node.getFirstParentOfType(ASTIfStatement.class) != null) {
                    ++methodInitCount;
                }
                if (this.inAnonymousInnerClass((Node)node)) {
                    ++methodInitCount;
                    continue;
                }
                if (node.getFirstParentOfType(ASTLambdaExpression.class) != null) {
                    ++lambdaUsage;
                    continue;
                }
                consSet.add(constructor);
                continue;
            }
            if (node.getFirstParentOfType(ASTMethodDeclaration.class) != null) {
                ++methodInitCount;
                continue;
            }
            if (node.getFirstParentOfType(ASTLambdaExpression.class) == null) continue;
            ++lambdaUsage;
        }
        if (usages.isEmpty() || methodInitCount == 0 && lambdaUsage == 0 && consSet.isEmpty()) {
            result = FieldImmutabilityType.CHECKDECL;
        } else {
            allConstructors.removeAll(consSet);
            if (allConstructors.isEmpty() && methodInitCount == 0 && lambdaUsage == 0) {
                result = FieldImmutabilityType.IMMUTABLE;
            }
        }
        return result;
    }

    private boolean inLoopOrTry(Node node) {
        return node.getFirstParentOfType(ASTTryStatement.class) != null || node.getFirstParentOfType(ASTForStatement.class) != null || node.getFirstParentOfType(ASTWhileStatement.class) != null || node.getFirstParentOfType(ASTDoStatement.class) != null;
    }

    private boolean inAnonymousInnerClass(Node node) {
        ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        return parent != null && parent.isAnonymousInnerClass();
    }

    private List<ASTConstructorDeclaration> findAllConstructors(ASTClassOrInterfaceDeclaration node) {
        return ((ASTClassOrInterfaceBody)node.getFirstChildOfType(ASTClassOrInterfaceBody.class)).findDescendantsOfType(ASTConstructorDeclaration.class);
    }

    private static enum FieldImmutabilityType {
        MUTABLE,
        IMMUTABLE,
        CHECKDECL;

    }
}

