/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UnnecessaryLocalBeforeReturnRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<Boolean> STATEMENT_ORDER_MATTERS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"statementOrderMatters").defaultValue((Object)true)).desc("If set to false this rule no longer requires the variable declaration and return statement to be on consecutive lines. Any variable that is used solely in a return statement will be reported.")).build();

    public UnnecessaryLocalBeforeReturnRule() {
        this.definePropertyDescriptor(STATEMENT_ORDER_MATTERS);
    }

    @Override
    public Object visit(ASTMethodDeclaration meth, Object data) {
        if (meth.isVoid() || meth.isAbstract() || meth.isNative()) {
            return data;
        }
        return super.visit(meth, data);
    }

    @Override
    public Object visit(ASTReturnStatement rtn, Object data) {
        ASTName name = (ASTName)rtn.getFirstDescendantOfType(ASTName.class);
        if (name == null) {
            return data;
        }
        if (rtn.findDescendantsOfType(ASTExpression.class).size() > 1 || rtn.findDescendantsOfType(ASTPrimaryExpression.class).size() > 1 || this.isMethodCall(rtn)) {
            return data;
        }
        Map vars = name.getScope().getDeclarations(VariableNameDeclaration.class);
        for (Map.Entry entry : vars.entrySet()) {
            NameOccurrence occ;
            List usages;
            VariableNameDeclaration variableDeclaration = (VariableNameDeclaration)entry.getKey();
            if (variableDeclaration.getDeclaratorId().isFormalParameter() || (usages = (List)entry.getValue()).size() != 1 || !(occ = (NameOccurrence)usages.get(0)).getLocation().equals(name) || !this.isNotAnnotated(variableDeclaration)) continue;
            String var = name.getImage();
            if (var.indexOf(46) != -1) {
                var = var.substring(0, var.indexOf(46));
            }
            if (this.isInitDataModifiedAfterInit(variableDeclaration, rtn) || this.statementsBeforeReturn(variableDeclaration, rtn)) continue;
            this.addViolation(data, (Node)rtn, var);
        }
        return data;
    }

    private boolean statementsBeforeReturn(VariableNameDeclaration variableDeclaration, ASTReturnStatement returnStatement) {
        if (!((Boolean)this.getProperty(STATEMENT_ORDER_MATTERS)).booleanValue()) {
            return false;
        }
        ASTBlockStatement declarationStatement = (ASTBlockStatement)variableDeclaration.getAccessNodeParent().getFirstParentOfType(ASTBlockStatement.class);
        ASTBlockStatement returnBlockStatement = (ASTBlockStatement)returnStatement.getFirstParentOfType(ASTBlockStatement.class);
        if (declarationStatement.jjtGetParent() == returnBlockStatement.jjtGetParent()) {
            return returnBlockStatement.jjtGetChildIndex() - declarationStatement.jjtGetChildIndex() > 1;
        }
        return false;
    }

    private static boolean isAfter(Node n1, Node n2) {
        return n1.getBeginLine() > n2.getBeginLine() || n1.getBeginLine() == n2.getBeginLine() && n1.getBeginColumn() >= n2.getEndColumn();
    }

    private boolean isInitDataModifiedAfterInit(VariableNameDeclaration variableDeclaration, ASTReturnStatement rtn) {
        ASTVariableInitializer initializer = (ASTVariableInitializer)variableDeclaration.getAccessNodeParent().getFirstDescendantOfType(ASTVariableInitializer.class);
        if (initializer != null) {
            ASTBlockStatement initializerStmt = (ASTBlockStatement)variableDeclaration.getAccessNodeParent().getFirstParentOfType(ASTBlockStatement.class);
            ASTBlockStatement rtnStmt = (ASTBlockStatement)rtn.getFirstParentOfType(ASTBlockStatement.class);
            List referencedNames = initializer.findDescendantsOfType(ASTName.class);
            for (ASTName refName : referencedNames) {
                Scope scope = refName.getScope();
                do {
                    Map declarations = scope.getDeclarations(VariableNameDeclaration.class);
                    for (Map.Entry entry : declarations.entrySet()) {
                        if (!((VariableNameDeclaration)entry.getKey()).getName().equals(refName.getImage())) continue;
                        for (NameOccurrence occ : (List)entry.getValue()) {
                            ASTBlockStatement location = (ASTBlockStatement)occ.getLocation().getFirstParentOfType(ASTBlockStatement.class);
                            if (!UnnecessaryLocalBeforeReturnRule.isAfter((Node)location, (Node)initializerStmt) || !UnnecessaryLocalBeforeReturnRule.isAfter((Node)rtnStmt, (Node)location)) continue;
                            return true;
                        }
                        return false;
                    }
                } while ((scope = scope.getParent()) != null);
            }
        }
        return false;
    }

    private boolean isNotAnnotated(VariableNameDeclaration variableDeclaration) {
        AccessNode accessNodeParent = variableDeclaration.getAccessNodeParent();
        return !accessNodeParent.hasDescendantOfType(ASTAnnotation.class);
    }

    private boolean isMethodCall(ASTReturnStatement rtn) {
        List suffix = rtn.findDescendantsOfType(ASTPrimarySuffix.class);
        for (ASTPrimarySuffix element : suffix) {
            if (!element.isArguments()) continue;
            return true;
        }
        return false;
    }
}

