/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.VariableAccess;
import net.sourceforge.pmd.lang.dfa.pathfinder.CurrentPath;
import net.sourceforge.pmd.lang.dfa.pathfinder.DAAPathFinder;
import net.sourceforge.pmd.lang.dfa.pathfinder.Executable;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.errorprone.DaaRuleViolation;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class DataflowAnomalyAnalysisRule
extends AbstractJavaRule
implements Executable {
    private static final PropertyDescriptor<Integer> MAX_PATH_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxPaths").desc("Maximum number of checked paths per method. A lower value will increase the performance of the rule but may decrease anomalies found.")).require(NumericConstraints.inRange((Number)100, (Number)8000))).defaultValue((Object)1000)).build();
    private static final PropertyDescriptor<Integer> MAX_VIOLATIONS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maxViolations").desc("Maximum number of anomalies per class")).require(NumericConstraints.inRange((Number)1, (Number)2000))).defaultValue((Object)100)).build();
    private RuleContext rc;
    private List<DaaRuleViolation> daaRuleViolations;
    private int maxRuleViolations;
    private int currentRuleViolationCount;

    public DataflowAnomalyAnalysisRule() {
        this.definePropertyDescriptor(MAX_PATH_DESCRIPTOR);
        this.definePropertyDescriptor(MAX_VIOLATIONS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.maxRuleViolations = (Integer)this.getProperty(MAX_VIOLATIONS_DESCRIPTOR);
        this.currentRuleViolationCount = 0;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration methodDeclaration, Object data) {
        this.rc = (RuleContext)data;
        this.daaRuleViolations = new ArrayList<DaaRuleViolation>();
        DataFlowNode node = (DataFlowNode)methodDeclaration.getDataFlowNode().getFlow().get(0);
        DAAPathFinder pathFinder = new DAAPathFinder(node, (Executable)this, ((Integer)this.getProperty(MAX_PATH_DESCRIPTOR)).intValue());
        pathFinder.run();
        super.visit(methodDeclaration, data);
        return data;
    }

    public void execute(CurrentPath path) {
        if (this.maxNumberOfViolationsReached()) {
            return;
        }
        HashMap<String, Usage> usagesByVarName = new HashMap<String, Usage>();
        for (DataFlowNode inode : path) {
            if (inode.getVariableAccess() == null) continue;
            for (VariableAccess va : inode.getVariableAccess()) {
                Usage lastUsage = (Usage)usagesByVarName.get(va.getVariableName());
                if (lastUsage != null) {
                    this.checkVariableAccess(inode, va, lastUsage);
                }
                Usage newUsage = new Usage(va.getAccessType(), inode);
                usagesByVarName.put(va.getVariableName(), newUsage);
            }
        }
    }

    private void checkVariableAccess(DataFlowNode inode, VariableAccess va, Usage u) {
        int startLine = u.node.getLine();
        int endLine = inode.getLine();
        Node lastNode = inode.getNode();
        Node firstNode = u.node.getNode();
        if (va.accessTypeMatches(u.accessType) && va.isDefinition()) {
            this.addDaaViolation(this.rc, lastNode, "DD", va.getVariableName(), startLine, endLine);
        } else if (u.accessType == 2 && va.isReference()) {
            this.addDaaViolation(this.rc, lastNode, "UR", va.getVariableName(), startLine, endLine);
        } else if (u.accessType == 0 && va.isUndefinition()) {
            this.addDaaViolation(this.rc, firstNode, "DU", va.getVariableName(), startLine, endLine);
        }
    }

    private void addDaaViolation(Object data, Node node, String type, String var, int startLine, int endLine) {
        if (!this.maxNumberOfViolationsReached() && !this.violationAlreadyExists(type, var, startLine, endLine) && node != null) {
            RuleContext ctx = (RuleContext)data;
            String msg = type;
            if (this.getMessage() != null) {
                msg = MessageFormat.format(this.getMessage(), type, var, startLine, endLine);
            }
            DaaRuleViolation violation = new DaaRuleViolation((Rule)this, ctx, node, type, msg, var, startLine, endLine);
            ctx.getReport().addRuleViolation((RuleViolation)violation);
            this.daaRuleViolations.add(violation);
            ++this.currentRuleViolationCount;
        }
    }

    private boolean maxNumberOfViolationsReached() {
        return this.currentRuleViolationCount >= this.maxRuleViolations;
    }

    private boolean violationAlreadyExists(String type, String var, int startLine, int endLine) {
        for (DaaRuleViolation violation : this.daaRuleViolations) {
            if (violation.getBeginLine() != startLine || violation.getEndLine() != endLine || !violation.getType().equals(type) || !violation.getVariableName().equals(var)) continue;
            return true;
        }
        return false;
    }

    private static class Usage {
        public int accessType;
        public DataFlowNode node;

        Usage(int accessType, DataFlowNode node) {
            this.accessType = accessType;
            this.node = node;
        }

        public String toString() {
            return "accessType = " + this.accessType + ", line = " + this.node.getLine();
        }
    }
}

