/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;

public class AccessorClassGenerationRule
extends AbstractJavaRule {
    private Map<String, List<ASTConstructorDeclaration>> privateConstructors = new HashMap<String, List<ASTConstructorDeclaration>>();

    public AccessorClassGenerationRule() {
        this.addRuleChainVisit(ASTConstructorDeclaration.class);
        this.addRuleChainVisit(ASTAllocationExpression.class);
    }

    public void end(RuleContext ctx) {
        super.end(ctx);
        this.privateConstructors.clear();
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (node.isPrivate()) {
            String className = node.jjtGetParent().jjtGetParent().jjtGetParent().getImage();
            if (!this.privateConstructors.containsKey(className)) {
                this.privateConstructors.put(className, new ArrayList());
            }
            this.privateConstructors.get(className).add(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        ASTArguments callArguments;
        ASTClassOrInterfaceType type;
        List<ASTConstructorDeclaration> constructors;
        if (node.jjtGetChild(0) instanceof ASTClassOrInterfaceType && (constructors = this.privateConstructors.get((type = (ASTClassOrInterfaceType)node.jjtGetChild(0)).getImage())) != null && (callArguments = (ASTArguments)node.getFirstChildOfType(ASTArguments.class)) != null) {
            ClassScope enclosingScope = (ClassScope)node.getScope().getEnclosingScope(ClassScope.class);
            for (ASTConstructorDeclaration cd : constructors) {
                if (cd.getScope().getEnclosingScope(ClassScope.class) == enclosingScope) break;
                if (cd.getArity() != callArguments.getArgumentCount()) continue;
                this.addViolation(data, (Node)node);
                break;
            }
        }
        return data;
    }
}

