/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class ConfusingTernaryRule
extends AbstractJavaRule {
    private static PropertyDescriptor<Boolean> ignoreElseIfProperty = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreElseIf").desc("Ignore conditions with an else-if case")).defaultValue((Object)false)).build();

    public ConfusingTernaryRule() {
        this.definePropertyDescriptor(ignoreElseIfProperty);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        Node jnode;
        Node inode;
        if (node.getNumChildren() == 3 && (inode = node.getChild(0)) instanceof ASTExpression && inode.getNumChildren() == 1 && ConfusingTernaryRule.isMatch(jnode = inode.getChild(0)) && (!((Boolean)this.getProperty(ignoreElseIfProperty)).booleanValue() || !(((JavaNode)node.getChild(2)).getChild(0) instanceof ASTIfStatement) && !(((JavaNode)node.getParent()).getParent() instanceof ASTIfStatement))) {
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        Node inode;
        if (node.getNumChildren() > 0 && ConfusingTernaryRule.isMatch(inode = node.getChild(0))) {
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }

    private static boolean isMatch(Node node) {
        return ConfusingTernaryRule.isUnaryNot(node) || ConfusingTernaryRule.isNotEquals(node) || ConfusingTernaryRule.isConditionalWithAllMatches(node) || ConfusingTernaryRule.isParenthesisAroundMatch(node);
    }

    private static boolean isUnaryNot(Node node) {
        return node instanceof ASTUnaryExpressionNotPlusMinus && "!".equals(node.getImage());
    }

    private static boolean isNotEquals(Node node) {
        return node instanceof ASTEqualityExpression && "!=".equals(node.getImage());
    }

    private static boolean isConditionalWithAllMatches(Node node) {
        if (!(node instanceof ASTConditionalAndExpression) && !(node instanceof ASTConditionalOrExpression)) {
            return false;
        }
        int n = node.getNumChildren();
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Node inode = node.getChild(i);
            if (ConfusingTernaryRule.isMatch(inode)) continue;
            return false;
        }
        return true;
    }

    private static boolean isParenthesisAroundMatch(Node node) {
        if (!(node instanceof ASTPrimaryExpression) || node.getNumChildren() != 1) {
            return false;
        }
        Node inode = node.getChild(0);
        if (!(inode instanceof ASTPrimaryPrefix) || inode.getNumChildren() != 1) {
            return false;
        }
        Node jnode = inode.getChild(0);
        if (!(jnode instanceof ASTExpression) || jnode.getNumChildren() != 1) {
            return false;
        }
        Node knode = jnode.getChild(0);
        return ConfusingTernaryRule.isMatch(knode);
    }
}

