/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.metrics.api.JavaClassMetricKey;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaMetricsRule;
import net.sourceforge.pmd.util.StringUtil;

public class DataClassRule
extends AbstractJavaMetricsRule {
    private static final int ACCESSOR_OR_FIELD_FEW_LEVEL = 3;
    private static final int ACCESSOR_OR_FIELD_MANY_LEVEL = 5;
    private static final double WOC_LEVEL = 0.3333333333333333;
    private static final int WMC_HIGH_LEVEL = 31;
    private static final int WMC_VERY_HIGH_LEVEL = 47;

    @Override
    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        boolean isDataClass;
        boolean bl = isDataClass = this.interfaceRevealsData(node) && this.classRevealsDataAndLacksComplexity(node);
        if (isDataClass) {
            double woc = JavaMetrics.get(JavaClassMetricKey.WOC, node);
            int nopa = (int)JavaMetrics.get(JavaClassMetricKey.NOPA, node);
            int noam = (int)JavaMetrics.get(JavaClassMetricKey.NOAM, node);
            int wmc = (int)JavaMetrics.get(JavaClassMetricKey.WMC, node);
            this.addViolation(data, node, new Object[]{node.getSimpleName(), StringUtil.percentageString((double)woc, (int)3), nopa, noam, wmc});
        }
        return super.visit(node, data);
    }

    private boolean interfaceRevealsData(ASTAnyTypeDeclaration node) {
        double woc = JavaMetrics.get(JavaClassMetricKey.WOC, node);
        return woc < 0.3333333333333333;
    }

    private boolean classRevealsDataAndLacksComplexity(ASTAnyTypeDeclaration node) {
        int nopa = (int)JavaMetrics.get(JavaClassMetricKey.NOPA, node);
        int noam = (int)JavaMetrics.get(JavaClassMetricKey.NOAM, node);
        int wmc = (int)JavaMetrics.get(JavaClassMetricKey.WMC, node);
        return nopa + noam > 3 && wmc < 31 || nopa + noam > 5 && wmc < 47;
    }
}

