/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMemberSelector;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArguments;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.typeresolution.MethodType;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinition;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.Bound;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.Constraint;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.InferenceRuleType;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.TypeInferenceResolver;
import net.sourceforge.pmd.lang.java.typeresolution.typeinference.Variable;

@Deprecated
@InternalApi
public final class MethodTypeResolution {
    private static final Logger LOG = Logger.getLogger(MethodTypeResolution.class.getName());
    private static final List<Class<?>> PRIMITIVE_SUBTYPE_ORDER;
    private static final List<Class<?>> BOXED_PRIMITIVE_SUBTYPE_ORDER;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_BOXING_RULES;

    private MethodTypeResolution() {
    }

    public static boolean checkSubtypeability(MethodType method, MethodType subtypeableMethod) {
        List<JavaTypeDefinition> subtypeableParams = subtypeableMethod.getParameterTypes();
        List<JavaTypeDefinition> methodParams = method.getParameterTypes();
        if (!method.getMethod().isVarArgs() || !subtypeableMethod.getMethod().isVarArgs()) {
            for (int index = 0; index < subtypeableParams.size(); ++index) {
                if (MethodTypeResolution.isSubtypeable(methodParams.get(index), subtypeableParams.get(index))) continue;
                return false;
            }
        } else {
            int maxSize = Math.max(subtypeableParams.size(), methodParams.size());
            for (int index = 0; index < maxSize; ++index) {
                if (MethodTypeResolution.isSubtypeable(method.getArgTypeIncludingVararg(index), subtypeableMethod.getArgTypeIncludingVararg(index))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<MethodType> selectMethodsFirstPhase(JavaTypeDefinition context, List<MethodType> methodsToSearch, ASTArgumentList argList) {
        ArrayList<MethodType> selectedMethods = new ArrayList<MethodType>();
        int argCount = argList == null ? 0 : argList.getNumChildren();
        block0: for (int methodIndex = 0; methodIndex < methodsToSearch.size(); ++methodIndex) {
            int argIndex;
            MethodType methodType = methodsToSearch.get(methodIndex);
            if (MethodTypeResolution.getArity(methodType.getMethod()) != argCount) continue;
            if (!methodType.isParameterized()) {
                Class<?>[] methodParameterTypes = methodType.getMethod().getParameterTypes();
                for (argIndex = 0; argIndex < argCount; ++argIndex) {
                    if (((ASTExpression)argList.getChild(argIndex)).isStandAlonePrimitive() ? !methodParameterTypes[argIndex].isPrimitive() : methodParameterTypes[argIndex].isPrimitive()) continue block0;
                }
                if ((methodType = MethodTypeResolution.parameterizeInvocation(context, methodType.getMethod(), argList)) == null) continue;
            }
            boolean methodIsApplicable = true;
            for (argIndex = 0; argIndex < argCount; ++argIndex) {
                if (MethodTypeResolution.isSubtypeable(methodType.getParameterTypes().get(argIndex), (ASTExpression)argList.getChild(argIndex))) continue;
                methodIsApplicable = false;
                break;
            }
            if (!methodIsApplicable) continue;
            selectedMethods.add(methodType);
        }
        return selectedMethods;
    }

    public static MethodType parameterizeInvocation(JavaTypeDefinition context, Method method, ASTArgumentList argList) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        ArrayList<Bound> initialBounds = new ArrayList<Bound>();
        MethodTypeResolution.produceInitialBounds(method, context, variables, initialBounds);
        List<JavaTypeDefinition> resolvedTypeParameters = TypeInferenceResolver.inferTypes(MethodTypeResolution.produceInitialConstraints(method, argList, variables), initialBounds, variables);
        if (resolvedTypeParameters == null) {
            return null;
        }
        return MethodTypeResolution.getTypeDefOfMethod(context, method, resolvedTypeParameters);
    }

    public static List<Constraint> produceInitialConstraints(Method method, ASTArgumentList argList, List<Variable> variables) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        Type[] methodParameters = method.getGenericParameterTypes();
        TypeVariable<Method>[] methodTypeParameters = method.getTypeParameters();
        for (int i = 0; i < methodParameters.length; ++i) {
            int typeParamIndex = -1;
            if (methodParameters[i] instanceof TypeVariable) {
                typeParamIndex = JavaTypeDefinition.getGenericTypeIndex(methodTypeParameters, ((TypeVariable)methodParameters[i]).getName());
            }
            if (typeParamIndex == -1) continue;
            result.add(new Constraint(((TypeNode)argList.getChild(i)).getTypeDefinition(), variables.get(typeParamIndex), InferenceRuleType.LOOSE_INVOCATION));
        }
        return result;
    }

    public static void produceInitialBounds(Method method, JavaTypeDefinition context, List<Variable> variables, List<Bound> initialBounds) {
        TypeVariable<Method>[] typeVariables = method.getTypeParameters();
        variables.clear();
        for (int i = 0; i < typeVariables.length; ++i) {
            variables.add(new Variable());
        }
        for (int currVarIndex = 0; currVarIndex < typeVariables.length; ++currVarIndex) {
            Type[] bounds = typeVariables[currVarIndex].getBounds();
            boolean currVarHasNoProperUpperBound = true;
            for (Type bound : bounds) {
                int boundVarIndex = -1;
                if (bound instanceof TypeVariable) {
                    boundVarIndex = JavaTypeDefinition.getGenericTypeIndex(typeVariables, ((TypeVariable)bound).getName());
                }
                if (boundVarIndex != -1) {
                    initialBounds.add(new Bound(variables.get(currVarIndex), variables.get(boundVarIndex), InferenceRuleType.SUBTYPE));
                    continue;
                }
                currVarHasNoProperUpperBound = false;
                initialBounds.add(new Bound(variables.get(currVarIndex), context.resolveTypeDefinition(bound), InferenceRuleType.SUBTYPE));
            }
            if (!currVarHasNoProperUpperBound) continue;
            initialBounds.add(new Bound(variables.get(currVarIndex), JavaTypeDefinition.forClass(Object.class, new JavaTypeDefinition[0]), InferenceRuleType.SUBTYPE));
        }
    }

    public static List<MethodType> selectMethodsSecondPhase(List<MethodType> methodsToSearch, ASTArgumentList argList) {
        ArrayList<MethodType> selectedMethods = new ArrayList<MethodType>();
        int argCount = argList == null ? 0 : argList.getNumChildren();
        for (int methodIndex = 0; methodIndex < methodsToSearch.size(); ++methodIndex) {
            MethodType methodType = methodsToSearch.get(methodIndex);
            if (!methodType.isParameterized()) {
                throw new TypeInferenceResolver.ResolutionFailedException();
            }
            if (MethodTypeResolution.getArity(methodType.getMethod()) != argCount) continue;
            boolean methodIsApplicable = true;
            for (int argIndex = 0; argIndex < argCount; ++argIndex) {
                if (MethodTypeResolution.isMethodConvertible(methodType.getParameterTypes().get(argIndex), (ASTExpression)argList.getChild(argIndex))) continue;
                methodIsApplicable = false;
                break;
            }
            if (!methodIsApplicable) continue;
            selectedMethods.add(methodType);
        }
        return selectedMethods;
    }

    public static List<MethodType> selectMethodsThirdPhase(List<MethodType> methodsToSearch, ASTArgumentList argList) {
        ArrayList<MethodType> selectedMethods = new ArrayList<MethodType>();
        for (int methodIndex = 0; methodIndex < methodsToSearch.size(); ++methodIndex) {
            MethodType methodType = methodsToSearch.get(methodIndex);
            if (!methodType.isParameterized()) {
                throw new TypeInferenceResolver.ResolutionFailedException();
            }
            if (methodType.isVararg()) {
                boolean methodIsApplicable = true;
                List<JavaTypeDefinition> methodParameters = methodType.getParameterTypes();
                JavaTypeDefinition varargComponentType = methodType.getVarargComponentType();
                if (argList == null) {
                    methodIsApplicable = MethodTypeResolution.getArity(methodType.getMethod()) == 1;
                } else {
                    for (int argIndex = 0; argIndex < argList.getNumChildren(); ++argIndex) {
                        JavaTypeDefinition parameterType;
                        JavaTypeDefinition javaTypeDefinition = parameterType = argIndex < methodParameters.size() - 1 ? methodParameters.get(argIndex) : varargComponentType;
                        if (MethodTypeResolution.isMethodConvertible(parameterType, (ASTExpression)argList.getChild(argIndex))) continue;
                        methodIsApplicable = false;
                        break;
                    }
                }
                if (!methodIsApplicable) continue;
                selectedMethods.add(methodType);
                continue;
            }
            LOG.log(Level.FINE, "Method {0} couldn't be resolved", String.valueOf(methodType));
        }
        return selectedMethods;
    }

    public static JavaTypeDefinition getBestMethodReturnType(JavaTypeDefinition context, List<MethodType> methods, ASTArgumentList arguments) {
        try {
            List<MethodType> selectedMethods = MethodTypeResolution.selectMethodsFirstPhase(context, methods, arguments);
            if (!selectedMethods.isEmpty()) {
                return MethodTypeResolution.selectMostSpecificMethod(selectedMethods).getReturnType();
            }
            selectedMethods = MethodTypeResolution.selectMethodsSecondPhase(methods, arguments);
            if (!selectedMethods.isEmpty()) {
                return MethodTypeResolution.selectMostSpecificMethod(selectedMethods).getReturnType();
            }
            selectedMethods = MethodTypeResolution.selectMethodsThirdPhase(methods, arguments);
            if (!selectedMethods.isEmpty()) {
                return MethodTypeResolution.selectMostSpecificMethod(selectedMethods).getReturnType();
            }
            return null;
        }
        catch (TypeInferenceResolver.ResolutionFailedException e) {
            return null;
        }
    }

    public static MethodType selectMostSpecificMethod(List<MethodType> selectedMethods) {
        MethodType mostSpecific = selectedMethods.get(0);
        for (int methodIndex = 1; methodIndex < selectedMethods.size(); ++methodIndex) {
            MethodType nextMethod = selectedMethods.get(methodIndex);
            if (!MethodTypeResolution.checkSubtypeability(mostSpecific, nextMethod)) continue;
            mostSpecific = MethodTypeResolution.checkSubtypeability(nextMethod, mostSpecific) ? MethodTypeResolution.selectAmongMaximallySpecific(mostSpecific, nextMethod) : nextMethod;
        }
        return mostSpecific;
    }

    public static MethodType selectAmongMaximallySpecific(MethodType first, MethodType second) {
        if (first.isAbstract()) {
            if (second.isAbstract()) {
                return first;
            }
            return second;
        }
        if (second.isAbstract()) {
            return first;
        }
        return first;
    }

    public static List<MethodType> getApplicableMethods(JavaTypeDefinition context, String methodName, List<JavaTypeDefinition> typeArguments, int argArity, Class<?> accessingClass) {
        ArrayList<MethodType> result = new ArrayList<MethodType>();
        if (context == null) {
            return result;
        }
        Class<?> contextClass = context.getType();
        try {
            for (Method method : contextClass.getDeclaredMethods()) {
                if (!MethodTypeResolution.isMethodApplicable(method, methodName, argArity, accessingClass, typeArguments)) continue;
                result.add(MethodTypeResolution.getTypeDefOfMethod(context, method, typeArguments));
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        if (!contextClass.equals(Object.class)) {
            List<MethodType> inheritedMethods = MethodTypeResolution.getApplicableMethods(context.resolveTypeDefinition(contextClass.getGenericSuperclass()), methodName, typeArguments, argArity, accessingClass);
            for (MethodType inherited : inheritedMethods) {
                if (result.contains(inherited)) continue;
                result.add(inherited);
            }
        }
        for (Type interfaceType : contextClass.getGenericInterfaces()) {
            result.addAll(MethodTypeResolution.getApplicableMethods(context.resolveTypeDefinition(interfaceType), methodName, typeArguments, argArity, accessingClass));
        }
        return result;
    }

    public static MethodType getTypeDefOfMethod(JavaTypeDefinition context, Method method, List<JavaTypeDefinition> typeArguments) {
        if (typeArguments.isEmpty() && MethodTypeResolution.isGeneric(method)) {
            return MethodType.build(method);
        }
        JavaTypeDefinition returnType = context.resolveTypeDefinition(method.getGenericReturnType(), method, typeArguments);
        ArrayList<JavaTypeDefinition> argTypes = new ArrayList<JavaTypeDefinition>();
        for (Type argType : method.getGenericParameterTypes()) {
            argTypes.add(context.resolveTypeDefinition(argType, method, typeArguments));
        }
        return MethodType.build(returnType, argTypes, method);
    }

    public static boolean isMethodApplicable(Method method, String methodName, int argArity, Class<?> accessingClass, List<JavaTypeDefinition> typeArguments) {
        return !(!method.getName().equals(methodName) || !MethodTypeResolution.isMemberVisibleFromClass(method.getDeclaringClass(), method.getModifiers(), accessingClass) || method.isVarArgs() && argArity < MethodTypeResolution.getArity(method) - 1 || !method.isVarArgs() && argArity != MethodTypeResolution.getArity(method) || MethodTypeResolution.isGeneric(method) && !typeArguments.isEmpty() && method.getTypeParameters().length != typeArguments.size());
    }

    public static boolean isMemberVisibleFromClass(Class<?> classWithMember, int modifiers, Class<?> accessingClass) {
        if (accessingClass == null) {
            return false;
        }
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        boolean areInTheSamePackage = false;
        if (accessingClass.getPackage() != null) {
            areInTheSamePackage = accessingClass.getPackage().getName().equals(classWithMember.getPackage().getName());
        }
        return Modifier.isProtected(modifiers) ? areInTheSamePackage || classWithMember.isAssignableFrom(accessingClass) : (Modifier.isPrivate(modifiers) ? classWithMember.equals(accessingClass) : areInTheSamePackage);
    }

    public static boolean isGeneric(Method method) {
        return method.getTypeParameters().length != 0;
    }

    public static boolean isGeneric(Class<?> clazz) {
        return clazz.getTypeParameters().length != 0;
    }

    public static int getArity(Method method) {
        return method.getParameterTypes().length;
    }

    public static boolean isMethodConvertible(JavaTypeDefinition parameter, ASTExpression argument) {
        if (argument.getTypeDefinition() == null) {
            LOG.log(Level.FINE, "No type information for node {0}", argument.toString());
            return true;
        }
        return MethodTypeResolution.isMethodConvertible(parameter, argument.getTypeDefinition());
    }

    public static boolean isMethodConvertible(JavaTypeDefinition parameter, JavaTypeDefinition argument) {
        if (MethodTypeResolution.isSubtypeable(parameter, argument)) {
            return true;
        }
        int indexInPrimitive = PRIMITIVE_SUBTYPE_ORDER.indexOf(argument.getType());
        if (indexInPrimitive != -1 && MethodTypeResolution.isSubtypeable(parameter, JavaTypeDefinition.forClass(BOXED_PRIMITIVE_SUBTYPE_ORDER.get(indexInPrimitive), new JavaTypeDefinition[0]))) {
            return true;
        }
        int indexInBoxed = BOXED_PRIMITIVE_SUBTYPE_ORDER.indexOf(argument.getType());
        return indexInBoxed != -1 && MethodTypeResolution.isSubtypeable(parameter, JavaTypeDefinition.forClass(PRIMITIVE_SUBTYPE_ORDER.get(indexInBoxed), new JavaTypeDefinition[0]));
    }

    public static boolean isSubtypeable(JavaTypeDefinition parameter, ASTExpression argument) {
        if (argument.getTypeDefinition() == null) {
            LOG.log(Level.FINE, "No type information for node {0}", argument.toString());
            return true;
        }
        return MethodTypeResolution.isSubtypeable(parameter, argument.getTypeDefinition());
    }

    public static boolean isSubtypeable(Class<?> parameter, Class<?> argument) {
        return MethodTypeResolution.isSubtypeable(JavaTypeDefinition.forClass(parameter, new JavaTypeDefinition[0]), JavaTypeDefinition.forClass(argument, new JavaTypeDefinition[0]));
    }

    public static boolean isSubtypeable(JavaTypeDefinition parameter, JavaTypeDefinition argument) {
        int indexOfArg;
        if (argument.getType() == null) {
            return true;
        }
        if (parameter.getType().isAssignableFrom(argument.getType())) {
            if (!parameter.isGeneric() || parameter.isRawType() || argument.isRawType()) {
                return true;
            }
            JavaTypeDefinition argSuper = argument.getAsSuper(parameter.getType());
            return parameter.getType().equals(argSuper.getType());
        }
        int indexOfParameter = PRIMITIVE_SUBTYPE_ORDER.indexOf(parameter.getType());
        return indexOfParameter != -1 && (argument.getType() == Character.TYPE ? indexOfParameter <= 3 : (indexOfArg = PRIMITIVE_SUBTYPE_ORDER.indexOf(argument.getType())) != -1 && indexOfParameter <= indexOfArg);
    }

    public static JavaTypeDefinition boxPrimitive(JavaTypeDefinition def) {
        return JavaTypeDefinition.forClass(PRIMITIVE_BOXING_RULES.get(def.getType()), new JavaTypeDefinition[0]);
    }

    public static List<JavaTypeDefinition> getMethodExplicitTypeArugments(Node node) {
        ASTMemberSelector memberSelector = (ASTMemberSelector)node.getFirstChildOfType(ASTMemberSelector.class);
        if (memberSelector == null) {
            return Collections.emptyList();
        }
        ASTTypeArguments typeArguments = (ASTTypeArguments)memberSelector.getFirstChildOfType(ASTTypeArguments.class);
        if (typeArguments == null) {
            return Collections.emptyList();
        }
        ArrayList<JavaTypeDefinition> result = new ArrayList<JavaTypeDefinition>();
        for (int childIndex = 0; childIndex < typeArguments.getNumChildren(); ++childIndex) {
            result.add(((TypeNode)typeArguments.getChild(childIndex)).getTypeDefinition());
        }
        return result;
    }

    static {
        ArrayList<Class<Serializable>> primitiveList = new ArrayList<Class<Serializable>>();
        Class<Short> shortType = Short.TYPE;
        primitiveList.add(Double.TYPE);
        primitiveList.add(Float.TYPE);
        primitiveList.add(Long.TYPE);
        primitiveList.add(Integer.TYPE);
        primitiveList.add(shortType);
        primitiveList.add(Byte.TYPE);
        primitiveList.add(Character.TYPE);
        PRIMITIVE_SUBTYPE_ORDER = Collections.unmodifiableList(primitiveList);
        ArrayList<Class<Character>> boxedList = new ArrayList<Class<Character>>();
        boxedList.add(Double.class);
        boxedList.add(Float.class);
        boxedList.add(Long.class);
        boxedList.add(Integer.class);
        boxedList.add(Short.class);
        boxedList.add(Byte.class);
        boxedList.add(Character.class);
        BOXED_PRIMITIVE_SUBTYPE_ORDER = Collections.unmodifiableList(boxedList);
        HashMap<Class<Object>, Class<Void>> boxingRules = new HashMap<Class<Object>, Class<Void>>();
        boxingRules.put(Double.TYPE, Double.class);
        boxingRules.put(Float.TYPE, Float.class);
        boxingRules.put(Long.TYPE, Long.class);
        boxingRules.put(Integer.TYPE, Integer.class);
        boxingRules.put(shortType, Short.class);
        boxingRules.put(Byte.TYPE, Byte.class);
        boxingRules.put(Character.TYPE, Character.class);
        boxingRules.put(Boolean.TYPE, Boolean.class);
        boxingRules.put(Void.TYPE, Void.class);
        PRIMITIVE_BOXING_RULES = Collections.unmodifiableMap(boxingRules);
    }
}

