/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;

public class StringInstantiationRule
extends AbstractJavaRule {
    public StringInstantiationRule() {
        this.addRuleChainVisit(ASTAllocationExpression.class);
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (!(node.getChild(0) instanceof ASTClassOrInterfaceType)) {
            return data;
        }
        if (!TypeHelper.isA((TypeNode)((ASTClassOrInterfaceType)node.getChild(0)), String.class)) {
            return data;
        }
        if (this.isArrayAccess(node)) {
            this.addViolation(data, (Node)node);
            return data;
        }
        List exp = node.findDescendantsOfType(ASTExpression.class);
        if (exp.size() >= 2) {
            return data;
        }
        if (node.hasDescendantOfAnyType(new Class[]{ASTArrayDimsAndInits.class, ASTAdditiveExpression.class})) {
            return data;
        }
        ASTName name = (ASTName)node.getFirstDescendantOfType(ASTName.class);
        if (name == null) {
            this.addViolation(data, (Node)node);
            return data;
        }
        NameDeclaration nd = name.getNameDeclaration();
        if (nd == null) {
            return data;
        }
        if (nd instanceof TypedNameDeclaration && TypeHelper.isExactlyAny((TypedNameDeclaration)nd, String.class)) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean isArrayAccess(ASTAllocationExpression node) {
        ASTArguments arguments = (ASTArguments)node.getFirstChildOfType(ASTArguments.class);
        if (arguments == null || arguments.size() != 1) {
            return false;
        }
        Node firstArg = ((ASTArgumentList)arguments.getFirstChildOfType(ASTArgumentList.class)).getChild(0);
        ASTPrimaryExpression primary = (ASTPrimaryExpression)firstArg.getFirstChildOfType(ASTPrimaryExpression.class);
        if (primary == null || primary.getType() != String.class) {
            return false;
        }
        ASTPrimarySuffix suffix = (ASTPrimarySuffix)primary.getFirstChildOfType(ASTPrimarySuffix.class);
        return suffix != null && suffix.isArrayDereference();
    }
}

