/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.java.typeresolution.visitors.PMDASMVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Deprecated
@InternalApi
public final class PMDASMClassLoader
extends ClassLoader {
    private static PMDASMClassLoader cachedPMDASMClassLoader;
    private static ClassLoader cachedClassLoader;
    private final ConcurrentMap<String, Boolean> dontBother = new ConcurrentHashMap<String, Boolean>();

    private PMDASMClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static synchronized PMDASMClassLoader getInstance(ClassLoader parent) {
        if (parent.equals(cachedClassLoader)) {
            return cachedPMDASMClassLoader;
        }
        cachedClassLoader = parent;
        cachedPMDASMClassLoader = new PMDASMClassLoader(parent);
        return cachedPMDASMClassLoader;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> aClass = this.loadClassOrNull(name);
        if (aClass == null) {
            throw new ClassNotFoundException(name);
        }
        return aClass;
    }

    public Class<?> loadClassOrNull(String name) {
        if (this.dontBother.containsKey(name)) {
            return null;
        }
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException | LinkageError e) {
            this.dontBother.put(name, Boolean.TRUE);
            return null;
        }
    }

    public boolean couldResolve(String name) {
        return !this.dontBother.containsKey(name);
    }

    public synchronized Map<String, String> getImportedClasses(String name) throws ClassNotFoundException {
        Map<String, String> map;
        block17: {
            if (this.dontBother.containsKey(name)) {
                throw new ClassNotFoundException(name);
            }
            InputStream classResource = this.getResourceAsStream(name.replace('.', '/') + ".class");
            try {
                ClassReader reader = new ClassReader(classResource);
                PMDASMVisitor asmVisitor = new PMDASMVisitor(name);
                reader.accept((ClassVisitor)asmVisitor, 0);
                List<String> inner = asmVisitor.getInnerClasses();
                if (inner != null && !inner.isEmpty()) {
                    inner = new ArrayList<String>(inner);
                    for (String str : inner) {
                        try (InputStream innerClassStream = this.getResourceAsStream(str.replace('.', '/') + ".class");){
                            if (innerClassStream == null) continue;
                            reader = new ClassReader(innerClassStream);
                            reader.accept((ClassVisitor)asmVisitor, 0);
                        }
                    }
                }
                map = asmVisitor.getPackages();
                if (classResource == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (classResource != null) {
                        try {
                            classResource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.dontBother.put(name, Boolean.TRUE);
                    throw new ClassNotFoundException(name, e);
                }
            }
            classResource.close();
        }
        return map;
    }

    static {
        PMDASMClassLoader.registerAsParallelCapable();
    }
}

