/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl.visitors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorReducedAdapter;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class TccAttributeAccessCollector
extends JavaParserVisitorReducedAdapter {
    private final ASTAnyTypeDeclaration exploredClass;
    private String currentMethodName;
    private Map<String, Set<String>> methodAttributeAccess;

    public TccAttributeAccessCollector(ASTAnyTypeDeclaration exploredClass) {
        this.exploredClass = exploredClass;
    }

    public Map<String, Set<String>> start() {
        return (Map)this.visit(this.exploredClass, new HashMap());
    }

    @Override
    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        if (Objects.equals(node, this.exploredClass)) {
            this.methodAttributeAccess = new HashMap<String, Set<String>>();
            super.visit(node, data);
        } else if (node instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)node).isLocal()) {
            super.visit(node, data);
        }
        return this.methodAttributeAccess;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (!node.isAbstract()) {
            if (node.getFirstParentOfType(ASTAnyTypeDeclaration.class) == this.exploredClass) {
                this.currentMethodName = node.getQualifiedName().getOperation();
                this.methodAttributeAccess.put(this.currentMethodName, new HashSet());
                super.visit(node, data);
                this.currentMethodName = null;
            } else {
                super.visit(node, data);
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        if (this.currentMethodName != null) {
            Set<String> methodAccess = this.methodAttributeAccess.get(this.currentMethodName);
            String variableName = this.getVariableName(node);
            if (this.isLocalAttributeAccess(variableName, node.getScope())) {
                methodAccess.add(variableName);
            }
        }
        return super.visit(node, data);
    }

    private String getVariableName(ASTPrimaryExpression node) {
        List suffixes;
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)node.getFirstDescendantOfType(ASTPrimaryPrefix.class);
        if (prefix.usesThisModifier() && (suffixes = node.findChildrenOfType(ASTPrimarySuffix.class)).size() > 1 && !((ASTPrimarySuffix)suffixes.get(1)).isArguments()) {
            return ((ASTPrimarySuffix)suffixes.get(0)).getImage();
        }
        ASTName name = (ASTName)prefix.getFirstDescendantOfType(ASTName.class);
        String variableName = null;
        if (name != null) {
            int dotIndex = name.getImage().indexOf(".");
            variableName = dotIndex == -1 ? name.getImage() : name.getImage().substring(0, dotIndex);
        }
        return variableName;
    }

    private boolean isLocalAttributeAccess(String varName, Scope scope) {
        for (Scope currentScope = scope; currentScope != null; currentScope = currentScope.getParent()) {
            for (VariableNameDeclaration decl : currentScope.getDeclarations(VariableNameDeclaration.class).keySet()) {
                if (!decl.getImage().equals(varName) || !(currentScope instanceof ClassScope) || ((ClassScope)currentScope).getClassDeclaration().getNode() != this.exploredClass) continue;
                return true;
            }
        }
        return false;
    }
}

