/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.multifile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.multifile.ClassMirror;
import net.sourceforge.pmd.lang.java.multifile.ClassStats;
import net.sourceforge.pmd.lang.java.multifile.ProjectMirror;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaFieldSigMask;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSigMask;
import net.sourceforge.pmd.lang.java.qname.JavaOperationQualifiedName;
import net.sourceforge.pmd.lang.java.qname.JavaTypeQualifiedName;

final class PackageStats
implements ProjectMirror {
    static final PackageStats INSTANCE = new PackageStats();
    private final Map<String, PackageStats> subPackages = new HashMap<String, PackageStats>();
    private final Map<String, ClassStats> classes = new HashMap<String, ClassStats>();

    private PackageStats() {
    }

    void reset() {
        this.subPackages.clear();
        this.classes.clear();
    }

    ClassStats getClassStats(JavaTypeQualifiedName qname, boolean createIfNotFound) {
        ClassStats next;
        PackageStats container = this.getSubPackage(qname, createIfNotFound);
        if (container == null) {
            return null;
        }
        String topClassName = qname.getClassList().get(0);
        if (createIfNotFound && container.classes.get(topClassName) == null) {
            container.classes.put(topClassName, new ClassStats());
        }
        if ((next = container.classes.get(topClassName)) == null) {
            return null;
        }
        Iterator<String> it = qname.getClassList().iterator();
        if (it.hasNext()) {
            it.next();
        }
        while (it.hasNext() && next != null) {
            next = next.getNestedClassStats(it.next(), createIfNotFound);
        }
        return next;
    }

    private PackageStats getSubPackage(JavaTypeQualifiedName qname, boolean createIfNotFound) {
        if (qname.getPackageList().isEmpty()) {
            return this;
        }
        List<String> packagePath = qname.getPackageList();
        PackageStats next = this;
        Iterator<String> it = packagePath.iterator();
        while (it.hasNext() && next != null) {
            String currentPackage = it.next();
            if (createIfNotFound && next.subPackages.get(currentPackage) == null) {
                next.subPackages.put(currentPackage, new PackageStats());
            }
            next = next.subPackages.get(currentPackage);
        }
        return next;
    }

    @Override
    public boolean hasMatchingSig(JavaOperationQualifiedName qname, JavaOperationSigMask sigMask) {
        ClassStats clazz = this.getClassStats(qname.getClassName(), false);
        return clazz != null && clazz.hasMatchingOpSig(qname.getOperation(), sigMask);
    }

    @Override
    public boolean hasMatchingSig(JavaTypeQualifiedName qname, String fieldName, JavaFieldSigMask sigMask) {
        ClassStats clazz = this.getClassStats(qname, false);
        return clazz != null && clazz.hasMatchingFieldSig(fieldName, sigMask);
    }

    @Override
    public ClassMirror getClassMirror(JavaTypeQualifiedName className) {
        return this.getClassStats(className, false);
    }
}

