/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;

public class UselessStringValueOfRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTPrimaryPrefix node, Object data) {
        if (node.getNumChildren() == 0 || !(node.getChild(0) instanceof ASTName)) {
            return super.visit(node, data);
        }
        String image = ((ASTName)node.getChild(0)).getImage();
        if ("String.valueOf".equals(image)) {
            Node parent = node.getParent();
            if (parent.getNumChildren() != 2) {
                return super.visit(node, data);
            }
            ASTArgumentList args = (ASTArgumentList)parent.getFirstDescendantOfType(ASTArgumentList.class);
            if (args != null) {
                ASTType argType;
                NameDeclaration declaration;
                if (args.size() > 1) {
                    return super.visit(node, data);
                }
                ASTName arg = (ASTName)args.getFirstDescendantOfType(ASTName.class);
                if (arg != null && (declaration = arg.getNameDeclaration()) != null && (argType = (ASTType)declaration.getNode().getParent().getParent().getFirstDescendantOfType(ASTType.class)) != null && argType.getChild(0) instanceof ASTReferenceType && ((ASTReferenceType)argType.getChild(0)).isArray()) {
                    return super.visit(node, data);
                }
            }
            Node gp = parent.getParent();
            if (parent instanceof ASTPrimaryExpression && gp instanceof ASTAdditiveExpression && "+".equals(gp.getImage())) {
                boolean ok = false;
                if (gp.getChild(0) == parent) {
                    ok = !UselessStringValueOfRule.isPrimitive(gp.getChild(1));
                } else {
                    int i = 0;
                    while (!ok && gp.getChild(i) != parent) {
                        ok = !UselessStringValueOfRule.isPrimitive(gp.getChild(i));
                        ++i;
                    }
                }
                if (ok) {
                    super.addViolation(data, (Node)node);
                    return data;
                }
            }
        }
        return super.visit(node, data);
    }

    private static boolean isPrimitive(Node parent) {
        Node child;
        boolean result = false;
        if (parent instanceof ASTPrimaryExpression && parent.getNumChildren() == 1 && (child = parent.getChild(0)) instanceof ASTPrimaryPrefix && child.getNumChildren() == 1) {
            Node gc = child.getChild(0);
            if (gc instanceof ASTName) {
                ASTName name = (ASTName)gc;
                NameDeclaration nd = name.getNameDeclaration();
                if (nd instanceof VariableNameDeclaration && ((VariableNameDeclaration)nd).isPrimitiveType()) {
                    result = true;
                }
            } else if (gc instanceof ASTLiteral) {
                result = !((ASTLiteral)gc).isStringLiteral();
            }
        }
        return result;
    }
}

