/* Generated By:JJTree&JavaCC: Do not edit this line. JavaParser.java */
package net.sourceforge.pmd.lang.java.ast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.CharStream;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
public @Deprecated @net.sourceforge.pmd.annotation.InternalApi class JavaParser/*@bgen(jjtree)*/implements JavaParserTreeConstants, JavaParserConstants {/*@bgen(jjtree)*/
  protected JJTJavaParserState jjtree = new JJTJavaParserState();
  private int jdkVersion = 0;
  private boolean preview = false;

  public void setJdkVersion(int jdkVersion) {
   this.jdkVersion = jdkVersion;
  }

  public void setPreview(boolean preview) {
    this.preview = preview;
  }

  private void throwParseException(String message) {
    int line = -1;
    int col = -1;
    if (jj_lastpos != null) {
      line = jj_lastpos.beginLine;
      col = jj_lastpos.beginColumn;
    }
    throw new ParseException("Line " + line + ", Column " + col + ": " + message);
  }

  private void checkForBadAssertUsage(String in, String usage) {
    if (jdkVersion > 3 && in.equals("assert")) {
      throwParseException("Can't use 'assert' as " + usage + " when running in JDK 1.4 mode!");
    }
  }

  private void checkForBadStaticImportUsage() {
    if (jdkVersion < 5) {
      throwParseException("Can't use static imports when running in JDK 1.4 mode!");
    }
  }

  private void checkForBadAnnotationUsage() {
    if (jdkVersion < 5) {
      throwParseException("Can't use annotations when running in JDK 1.4 mode!");
    }
  }

  private void checkForBadGenericsUsage() {
    if (jdkVersion < 5) {
      throwParseException("Can't use generics unless running in JDK 1.5 mode!");
    }
  }

  private void checkForBadVariableArgumentsUsage() {
    if (jdkVersion < 5) {
      throwParseException("Can't use variable arguments (varargs) when running in JDK 1.4 mode!");
    }
  }

  private void checkForBadJDK15ForLoopSyntaxArgumentsUsage() {
    if (jdkVersion < 5) {
      throwParseException("Can't use JDK 1.5 for loop syntax when running in JDK 1.4 mode!");
    }
  }

  private void checkForBadEnumUsage(String in, String usage) {
    if (jdkVersion >= 5 && in.equals("enum")) {
      throwParseException("Can't use 'enum' as " + usage + " when running in JDK 1.5 mode!");
    }
  }

  private void checkForBadHexFloatingPointLiteral() {
    if (jdkVersion < 5) {
      throwParseException("Can't use hexadecimal floating point literals in pre-JDK 1.5 target");
    }
  }

  private void checkForBadNumericalLiteralslUsage(Token token) {
    if (jdkVersion < 7) {
      if (token.image.contains("_")) {
        throwParseException("Can't use underscores in numerical literals when running in JDK inferior to 1.7 mode!");
      }

      if (token.image.startsWith("0b") || token.image.startsWith("0B")) {
        throwParseException("Can't use binary numerical literals when running in JDK inferior to 1.7 mode!");
      }
    }
  }

  private void checkForBadDiamondUsage() {
        if (jdkVersion < 7) {
      throwParseException("Cannot use the diamond generic notation when running in JDK inferior to 1.7 mode!");
        }
  }

  private void checkForBadTryWithResourcesUsage() {
        if (jdkVersion < 7) {
      throwParseException("Cannot use the try-with-resources notation when running in JDK inferior to 1.7 mode!");
        }
  }

  private void checkForBadMultipleExceptionsCatching() {
        if (jdkVersion < 7) {
      throwParseException("Cannot catch multiple exceptions when running in JDK inferior to 1.7 mode!");
        }
  }

  private void checkForBadLambdaUsage() {
    if (jdkVersion < 8) {
      throwParseException("Cannot use lambda expressions when running in JDK inferior to 1.8 mode!");
    }
  }
  private void checkForBadMethodReferenceUsage() {
    if (jdkVersion < 8) {
      throwParseException("Cannot use method references when running in JDK inferior to 1.8 mode!");
    }
  }
  private void checkForBadDefaultImplementationUsage() {
    if (jdkVersion < 8) {
      throwParseException("Cannot use default implementations in interfaces when running in JDK inferior to 1.8 mode!");
    }
  }
  private void checkForBadIntersectionTypesInCasts() {
    if (jdkVersion < 8) {
      throwParseException("Cannot use intersection types in casts when running in JDK inferior to 1.8 mode!");
    }
  }
  private void checkForBadTypeAnnotations() {
    if (jdkVersion < 8) {
      throwParseException("Cannot use type annotations when running in JDK inferior to 1.8 mode!");
    }
  }
  private void checkforBadExplicitReceiverParameter() {
    if (jdkVersion < 8) {
      throwParseException("Cannot use explicit receiver parameters when running in JDK inferior to 1.8 mode!");
    }
  }

  private void checkForBadAnonymousDiamondUsage() {
    if (jdkVersion < 9) {
      ASTAllocationExpression node = (ASTAllocationExpression)jjtree.peekNode();
      ASTTypeArguments types = node.getFirstChildOfType(ASTClassOrInterfaceType.class).getFirstChildOfType(ASTTypeArguments.class);
      if (node.isAnonymousClass() && types != null && types.isDiamond()) {
        throwParseException("Cannot use '<>' with anonymous inner classes when running in JDK inferior to 9 mode!");
      }
    }
  }
  /**
   * Keeps track whether we are dealing with an interface or not. Needed since the tree is
   * is not fully constructed yet, when we check for private interface methods.
   * The flag is updated, if entering ClassOrInterfaceDeclaration and reset when leaving.
   * The flag is also reset, if entering a anonymous inner class or enums.
   */
  private boolean inInterface = false;
  private void checkForBadPrivateInterfaceMethod(ASTMethodDeclaration node) {
    if (jdkVersion < 9 && inInterface && node.isPrivate()) {
      throwParseException("Cannot use private interface methods when running in JDK inferior to 9 mode!");
    }
  }
  private void checkForBadIdentifier(String image) {
    if (jdkVersion >= 9 && "_".equals(image)) {
      throwParseException("With JDK 9, '_' is a keyword, and may not be used as an identifier!");
    }
  }
  private void checkForBadModuleUsage() {
    if (jdkVersion < 9) {
      throwParseException("Cannot use module declaration when running in JDK inferior to 9 mode!");
    }
  }
  private void checkForBadConciseTryWithResourcesUsage() {
    if (jdkVersion < 9) {
      throwParseException("Cannot use concise try-with-resources when running in JDK inferior to 9 mode!");
    }
  }
  private void checkForBadTypeIdentifierUsage(String image) {
    if (jdkVersion >= 10 && "var".equals(image)) {
      throwParseException("With JDK 10, 'var' is a contextual keyword and cannot be used for type declarations!");
    }
    if (jdkVersion >= 14 && "yield".equals(image)) {
      throwParseException("With JDK 14, 'yield' is a contextual keyword and cannot be used for type declarations!");
    }
    if (jdkVersion >= 16 && "record".equals(image)) {
      throwParseException("With JDK >= 16, 'record' is a contextual keyword and cannot be used for type declarations!");
    }
    if (jdkVersion >= 17 && "sealed".equals(image)) {
      throwParseException("With JDK >= 17, 'sealed' is a contextual keyword and cannot be used for type declarations!");
    }
    if (jdkVersion >= 17 && "permits".equals(image)) {
      throwParseException("With JDK >= 17, 'permits' is a contextual keyword and cannot be used for type declarations!");
    }
  }
  private void checkForMultipleCaseLabels() {
    if (jdkVersion < 14) {
      throwParseException("Multiple case labels in switch statements are only supported with Java >= 14");
    }
  }
  /**
   * Keeps track during tree construction, whether we are currently building a switch label.
   * A switch label must not contain a LambdaExpression.
   * Unfortunately, we have added LambdaExpression as part of PrimaryPrefix, which is wrong.
   * To keep compatibility, this flag is used, whether a LambdaExpression should be parsed
   * in PrimaryPrefix.
   * See also comment at #Expression().
   */
  private boolean inSwitchLabel = false;

  private void checkForSwitchRules() {
    if (jdkVersion < 14) {
      throwParseException("Switch rules in switch statements are only supported with Java >= 14");
    }
  }
  private void checkForSwitchExpression() {
    if (jdkVersion < 14) {
      throwParseException("Switch expressions are only supported with Java >= 14");
    }
  }

  private void checkForYieldStatement() {
    if (jdkVersion < 14) {
      throwParseException("Yield statements are only supported with Java >= 14");
    }
  }

  private void checkForTextBlockLiteral() {
    if (!(jdkVersion >= 15)) {
      throwParseException("Text block literals are only supported with Java >= 15");
    }
  }

  private void checkForNewStringSpaceEscape(String s) {
    if (jdkVersion < 15 && s.contains("\u005c\u005cs") && !s.contains("\u005c\u005c\u005c\u005cs")) {
      throwParseException("The escape sequence \u005c"\u005c\u005cs\u005c" is only supported with Java >= 15");
    }
  }

  private void checkforBadInstanceOfPattern() {
    if (jdkVersion < 16) {
      throwParseException("Pattern Matching for instanceof is only supported with JDK >= 16");
    }
  }

  private boolean isRecordTypeSupported() {
    return jdkVersion >= 16;
  }

  private void checkForRecordType() {
    if (!isRecordTypeSupported()) {
      throwParseException("Records are only supported with JDK >= 16");
    }
  }

  private void checkForLocalInterfaceOrEnumType() {
      if (!isRecordTypeSupported()) {
          throwParseException("Local interfaces and enums are only supported with JDK >= 16");
      }
  }

  private boolean isSealedClassSupported() {
      return jdkVersion >= 17;
  }

  private void checkForSealedClassUsage() {
     if (!isSealedClassSupported()) {
        throwParseException("Sealed Classes are only supported with JDK >= 17.");
     }
  }

  private boolean isJEP406Supported() {
    return (jdkVersion == 17 || jdkVersion == 18) && preview;
  }

  private void checkForPatternMatchingInSwitch() {
    if (!isJEP406Supported()) {
        throwParseException("Pattern Matching in Switch is only supported with JDK 17 Preview or JDK 18 Preview.");
    }
  }

  private void checkForNullCaseLabel() {
    if (!isJEP406Supported()) {
        throwParseException("Null case labels in switch are only supported with JDK 17 Preview or JDK 18 Preview.");
    }
  }

  private void checkForDefaultCaseLabel() {
    if (!isJEP406Supported()) {
        throwParseException("Default case labels in switch are only supported with JDK 17 Preview or JDK 18 Preview.");
    }
  }

  private void checkForGuardedPatterns() {
    if (!isJEP406Supported()) {
        throwParseException("Guarded patterns are only supported with JDK 17 Preview or JDK 18 Preview.");
    }
  }

  // This is a semantic LOOKAHEAD to determine if we're dealing with an assert
  // Note that this can't be replaced with a syntactic lookahead
  // since "assert" isn't a string literal token
  private boolean isNextTokenAnAssert() {
    if (jdkVersion <= 3) {
      return false;
    }

    return getToken(1).image.equals("assert");
  }

  private boolean isPrecededByComment(Token tok) {
      boolean res = false;
      while (!res && tok.specialToken != null) {
          tok = tok.specialToken;
          res = tok.kind == SINGLE_LINE_COMMENT ||
                tok.kind == FORMAL_COMMENT ||
                tok.kind == MULTI_LINE_COMMENT;
      }
      return res;
  }

  /**
   * Semantic lookahead to check if the next identifier is a
   * specific restricted keyword.
   *
   * <p>Restricted keywords are:
   * var, yield, record, sealed, permits, "non" + "-" + "sealed"
   *
   * <p>enum and assert is used like restricted keywords, as they were not keywords
   * in the early java versions.
   */
  private boolean isKeyword(String image) {
    return isKeyword(1, image);
  }

  private boolean isKeyword(int index, String image) {
      Token token = getToken(index);
      return token.kind == IDENTIFIER && token.image.equals(image);
  }

  private boolean isToken(int index, int kind) {
      return getToken(index).kind == kind;
  }

  /**
   * Semantic lookahead which matches "non-sealed".
   *
   * <p>"non-sealed" cannot be a token, for several reasons:
   * It is only a keyword with java15 preview+, it consists actually
   * of several separate tokens, which are valid on their own.
   */
  private boolean isNonSealedModifier() {
      if (isKeyword(1, "non") && isToken(2, MINUS) && isKeyword(3, "sealed")) {
          Token nonToken = getToken(1);
          Token minusToken = getToken(2);
          Token sealedToken = getToken(3);
          return nonToken.endColumn + 1 == minusToken.beginColumn
            && minusToken.endColumn + 1 == sealedToken.beginColumn;
      }
      return false;
  }

  private boolean classModifierForLocalTypesLookahead() {
      Token next = getToken(1);
      return next.kind == AT
        || next.kind == PUBLIC
        || next.kind == PROTECTED
        || next.kind == PRIVATE
        || next.kind == ABSTRACT
        || next.kind == STATIC
        || next.kind == FINAL
        || next.kind == STRICTFP;
  }

  private boolean localTypeDeclLookahead() {
      Token next = getToken(1);
      return next.kind == CLASS
        || isRecordTypeSupported() && next.kind == INTERFACE
        || isRecordTypeSupported() && next.kind == IDENTIFIER && next.image.equals("enum")
        || isRecordTypeSupported() && next.kind == IDENTIFIER && next.image.equals("record") && isToken(2, IDENTIFIER);
  }

  /**
   *  True if we're in a switch block, one precondition for parsing a yield
   *  statement.
   */
  private boolean inSwitchExprBlock = false;

  private boolean isYieldStart() {
    return inSwitchExprBlock && jdkVersion >= 14
    && isKeyword("yield")
    && mayStartExprAfterYield(2);
  }

  private boolean mayStartExprAfterYield(final int offset) {
      // based off of https://hg.openjdk.java.net/jdk/jdk/file/bc3da0226ffa/src/jdk.compiler/share/classes/com/sun/tools/javac/parser/JavacParser.java#l2580
      // please don't sue me
      Token token = getToken(offset);
      if (token == null) return false; // eof
      switch (token.kind) {
           case PLUS: case MINUS: case STRING_LITERAL: case CHARACTER_LITERAL:
           case INTEGER_LITERAL: case FLOATING_POINT_LITERAL: case HEX_FLOATING_POINT_LITERAL:
           case NULL: case IDENTIFIER: case TRUE: case FALSE:
           case NEW: case SWITCH: case THIS: case SUPER:
               return true;
           case INCR: case DECR:
               return getToken(offset + 1).kind != SEMICOLON; // eg yield++;
           case LPAREN:
               int lookahead = offset + 1;
               int balance = 1;
               Token t;
               while ((t = getToken(lookahead)) != null && balance > 0) {
                   switch (t.kind) {
                       case LPAREN: balance++; break;
                       case RPAREN: balance--; break;
                       case COMMA: if (balance == 1) return false; // a method call, eg yield(1, 2);
                   }
                   lookahead++;
               }
               // lambda:       yield () -> {};
               // method call:  yield ();
               return t != null
                   && (lookahead != offset + 2 // ie ()
                   || t.kind == LAMBDA);
           default:
               return false;
      }
  }

  private boolean shouldStartStatementInSwitch() {
    switch (getToken(1).kind) {
        case _DEFAULT:
        case CASE:
        case RBRACE:
            return false;
        default:
            return true;
    }
  }

  public Map<Integer, String> getSuppressMap() {
    return token_source.getSuppressMap();
  }

  public void setSuppressMarker(String marker) {
    token_source.setSuppressMarker(marker);
  }

/*****************************************
 * THE JAVA LANGUAGE GRAMMAR STARTS HERE *
 *****************************************/

/*
 * Program structuring syntax follows.
 */
  final public ASTCompilationUnit CompilationUnit() throws ParseException {
 /*@bgen(jjtree) CompilationUnit */
  ASTCompilationUnit jjtn000 = new ASTCompilationUnit(this, JJTCOMPILATIONUNIT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_1(2147483647)) {
        PackageDeclaration();
        label_1:
        while (true) {
          switch (jj_nt.kind) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[0] = jj_gen;
            break label_1;
          }
          EmptyStatement();
        }
      } else {
        ;
      }
      label_2:
      while (true) {
        switch (jj_nt.kind) {
        case IMPORT:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_2;
        }
        ImportDeclaration();
        label_3:
        while (true) {
          switch (jj_nt.kind) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[2] = jj_gen;
            break label_3;
          }
          EmptyStatement();
        }
      }
      if (jj_2_2(2147483647)) {
        ModuleDeclaration();
        label_4:
        while (true) {
          switch (jj_nt.kind) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[3] = jj_gen;
            break label_4;
          }
          EmptyStatement();
        }
      } else {
        ;
      }
      label_5:
      while (true) {
        if (jj_2_3(1)) {
          ;
        } else {
          break label_5;
        }
        TypeDeclaration();
        label_6:
        while (true) {
          switch (jj_nt.kind) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[4] = jj_gen;
            break label_6;
          }
          EmptyStatement();
        }
      }
      switch (jj_nt.kind) {
      case 125:
        jj_consume_token(125);
        break;
      default:
        jj_la1[5] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case 126:
        jj_consume_token(126);
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      jj_consume_token(0);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
     jjtn000.setComments(token_source.comments);
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
    throw new RuntimeException("Missing return statement in function");
  }

  final private void ModuleDeclLahead() throws ParseException {
    label_7:
    while (true) {
      switch (jj_nt.kind) {
      case AT:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_7;
      }
      Annotation();
    }
    if (isKeyword("open") || isKeyword("module")) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(IDENTIFIER);
  }

  final public void PackageDeclaration() throws ParseException {
 /*@bgen(jjtree) PackageDeclaration */
  ASTPackageDeclaration jjtn000 = new ASTPackageDeclaration(this, JJTPACKAGEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_8:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_8;
        }
        Annotation();
      }
      jj_consume_token(PACKAGE);
      Name();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ImportDeclaration() throws ParseException {
 /*@bgen(jjtree) ImportDeclaration */
  ASTImportDeclaration jjtn000 = new ASTImportDeclaration(this, JJTIMPORTDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IMPORT);
      switch (jj_nt.kind) {
      case STATIC:
        jj_consume_token(STATIC);
                       checkForBadStaticImportUsage();jjtn000.setStatic();
        break;
      default:
        jj_la1[9] = jj_gen;
        ;
      }
      Name();
      switch (jj_nt.kind) {
      case DOT:
        jj_consume_token(DOT);
        jj_consume_token(STAR);
                                                                                                jjtn000.setImportOnDemand();
        break;
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

/*
 * Modifiers. We match all modifiers in a single rule to reduce the chances of
 * syntax errors for simple modifier mistakes. It will also enable us to give
 * better error messages.
 */
  final public int Modifiers() throws ParseException {
   int modifiers = 0;
    label_9:
    while (true) {
      if (jj_2_4(2)) {
        ;
      } else {
        break label_9;
      }
      switch (jj_nt.kind) {
      case PUBLIC:
        jj_consume_token(PUBLIC);
              modifiers |= AccessNode.PUBLIC;
        break;
      case STATIC:
        jj_consume_token(STATIC);
               modifiers |= AccessNode.STATIC;
        break;
      case PROTECTED:
        jj_consume_token(PROTECTED);
                  modifiers |= AccessNode.PROTECTED;
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
                modifiers |= AccessNode.PRIVATE;
        break;
      case FINAL:
        jj_consume_token(FINAL);
              modifiers |= AccessNode.FINAL;
        break;
      case ABSTRACT:
        jj_consume_token(ABSTRACT);
                 modifiers |= AccessNode.ABSTRACT;
        break;
      case SYNCHRONIZED:
        jj_consume_token(SYNCHRONIZED);
                     modifiers |= AccessNode.SYNCHRONIZED;
        break;
      case NATIVE:
        jj_consume_token(NATIVE);
               modifiers |= AccessNode.NATIVE;
        break;
      case TRANSIENT:
        jj_consume_token(TRANSIENT);
                  modifiers |= AccessNode.TRANSIENT;
        break;
      case VOLATILE:
        jj_consume_token(VOLATILE);
                 modifiers |= AccessNode.VOLATILE;
        break;
      case STRICTFP:
        jj_consume_token(STRICTFP);
                 modifiers |= AccessNode.STRICTFP;
        break;
      case _DEFAULT:
        jj_consume_token(_DEFAULT);
                modifiers |= AccessNode.DEFAULT; checkForBadDefaultImplementationUsage();
        break;
      default:
        jj_la1[11] = jj_gen;
        if (isKeyword("sealed")) {
          jj_consume_token(IDENTIFIER);
                                                    modifiers |= AccessNode.SEALED; checkForSealedClassUsage();
        } else if (isNonSealedModifier()) {
          jj_consume_token(IDENTIFIER);
          jj_consume_token(MINUS);
          jj_consume_token(IDENTIFIER);
                                                                           modifiers |= AccessNode.NON_SEALED; checkForSealedClassUsage();
        } else {
          switch (jj_nt.kind) {
          case AT:
            Annotation();
            break;
          default:
            jj_la1[12] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
    {if (true) return modifiers;}
    throw new RuntimeException("Missing return statement in function");
  }

/*
 * Declaration syntax follows.
 */
  final public void TypeDeclaration() throws ParseException {
 /*@bgen(jjtree) TypeDeclaration */
   ASTTypeDeclaration jjtn000 = new ASTTypeDeclaration(this, JJTTYPEDECLARATION);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtn000.jjtSetFirstToken(getToken(1));int modifiers;
    try {
      modifiers = Modifiers();
      switch (jj_nt.kind) {
      case CLASS:
      case INTERFACE:
        ClassOrInterfaceDeclaration(modifiers);
        break;
      default:
        jj_la1[13] = jj_gen;
        if (isKeyword("enum")) {
          EnumDeclaration(modifiers);
        } else {
          switch (jj_nt.kind) {
          case AT:
            AnnotationTypeDeclaration(modifiers);
            break;
          default:
            jj_la1[14] = jj_gen;
            if (isKeyword("record")) {
              RecordDeclaration(modifiers);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ClassOrInterfaceDeclaration(int modifiers) throws ParseException {
 /*@bgen(jjtree) ClassOrInterfaceDeclaration */
    ASTClassOrInterfaceDeclaration jjtn000 = new ASTClassOrInterfaceDeclaration(this, JJTCLASSORINTERFACEDECLARATION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t = null;
    jjtn000.setModifiers(modifiers);
    boolean inInterfaceOld = inInterface;
    inInterface = false;
    try {
      switch (jj_nt.kind) {
      case CLASS:
        jj_consume_token(CLASS);
        break;
      case INTERFACE:
        jj_consume_token(INTERFACE);
                            jjtn000.setInterface(); inInterface = true;
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      t = jj_consume_token(IDENTIFIER);
                   checkForBadTypeIdentifierUsage(t.image); jjtn000.setImage(t.image);
      switch (jj_nt.kind) {
      case LT:
        TypeParameters();
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case EXTENDS:
        ExtendsList();
        break;
      default:
        jj_la1[17] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case IMPLEMENTS:
        ImplementsList();
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      if (isKeyword("permits")) {
        PermittedSubclasses();
      } else {
        ;
      }
      ClassOrInterfaceBody();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    inInterface = inInterfaceOld;
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ExtendsList() throws ParseException {
 /*@bgen(jjtree) ExtendsList */
   ASTExtendsList jjtn000 = new ASTExtendsList(this, JJTEXTENDSLIST);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtn000.jjtSetFirstToken(getToken(1));boolean extendsMoreThanOne = false;
    try {
      jj_consume_token(EXTENDS);
      label_10:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_10;
        }
        TypeAnnotation();
      }
      ClassOrInterfaceType();
      label_11:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        label_12:
        while (true) {
          switch (jj_nt.kind) {
          case AT:
            ;
            break;
          default:
            jj_la1[21] = jj_gen;
            break label_12;
          }
          TypeAnnotation();
        }
        ClassOrInterfaceType();
                                                      extendsMoreThanOne = true;
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void ImplementsList() throws ParseException {
 /*@bgen(jjtree) ImplementsList */
  ASTImplementsList jjtn000 = new ASTImplementsList(this, JJTIMPLEMENTSLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IMPLEMENTS);
      label_13:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_13;
        }
        TypeAnnotation();
      }
      ClassOrInterfaceType();
      label_14:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_14;
        }
        jj_consume_token(COMMA);
        label_15:
        while (true) {
          switch (jj_nt.kind) {
          case AT:
            ;
            break;
          default:
            jj_la1[24] = jj_gen;
            break label_15;
          }
          TypeAnnotation();
        }
        ClassOrInterfaceType();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void PermittedSubclasses() throws ParseException {
 /*@bgen(jjtree) PermitsList */
    ASTPermitsList jjtn000 = new ASTPermitsList(this, JJTPERMITSLIST);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    checkForSealedClassUsage();
    try {
      t = jj_consume_token(IDENTIFIER);
        if (!"permits".equals(t.image)) {
          {if (true) throw new ParseException("ERROR: expecting permits");}
        }
      TypeName();
      label_16:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_16;
        }
        jj_consume_token(COMMA);
        TypeName();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void EnumDeclaration(int modifiers) throws ParseException {
 /*@bgen(jjtree) EnumDeclaration */
ASTEnumDeclaration jjtn000 = new ASTEnumDeclaration(this, JJTENUMDECLARATION);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));Token t;
jjtn000.setModifiers(modifiers);
    try {
      t = jj_consume_token(IDENTIFIER);
    if (!"enum".equals(t.image)) {
      {if (true) throw new ParseException("ERROR: expecting enum");}
    }

    if (jdkVersion < 5) {
      {if (true) throw new ParseException("ERROR: Can't use enum as a keyword in pre-JDK 1.5 target");}
    }
      t = jj_consume_token(IDENTIFIER);
                  checkForBadTypeIdentifierUsage(t.image); jjtn000.setImage(t.image);
      switch (jj_nt.kind) {
      case IMPLEMENTS:
        ImplementsList();
        break;
      default:
        jj_la1[26] = jj_gen;
        ;
      }
      EnumBody();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void EnumBody() throws ParseException {
 /*@bgen(jjtree) EnumBody */
    ASTEnumBody jjtn000 = new ASTEnumBody(this, JJTENUMBODY);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));boolean inInterfaceOld = inInterface;
    inInterface = false;
    try {
      jj_consume_token(LBRACE);
      switch (jj_nt.kind) {
      case IDENTIFIER:
      case AT:
        label_17:
        while (true) {
          switch (jj_nt.kind) {
          case AT:
            ;
            break;
          default:
            jj_la1[27] = jj_gen;
            break label_17;
          }
          Annotation();
        }
        EnumConstant();
        label_18:
        while (true) {
          if (jj_2_5(2)) {
            ;
          } else {
            break label_18;
          }
          jj_consume_token(COMMA);
          label_19:
          while (true) {
            switch (jj_nt.kind) {
            case AT:
              ;
              break;
            default:
              jj_la1[28] = jj_gen;
              break label_19;
            }
            Annotation();
          }
          EnumConstant();
        }
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        label_20:
        while (true) {
          if (jj_2_6(1)) {
            ;
          } else {
            break label_20;
          }
          ClassOrInterfaceBodyDeclaration();
        }
        break;
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
     jjtree.closeNodeScope(jjtn000, true);
     jjtc000 = false;
     jjtn000.jjtSetLastToken(getToken(0));
     inInterface = inInterfaceOld;
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void EnumConstant() throws ParseException {
 /*@bgen(jjtree) EnumConstant */
 ASTEnumConstant jjtn000 = new ASTEnumConstant(this, JJTENUMCONSTANT);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
                  jjtn000.setImage(t.image);
      switch (jj_nt.kind) {
      case LPAREN:
        Arguments();
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case LBRACE:
        ClassOrInterfaceBody();
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void RecordDeclaration(int modifiers) throws ParseException {
 /*@bgen(jjtree) RecordDeclaration */
    ASTRecordDeclaration jjtn000 = new ASTRecordDeclaration(this, JJTRECORDDECLARATION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    jjtn000.setModifiers(modifiers);
    checkForRecordType();
    try {
      t = jj_consume_token(IDENTIFIER);
    if (!"record".equals(t.image)) {
      {if (true) throw new ParseException("ERROR: expecting record");}
    }
      t = jj_consume_token(IDENTIFIER);
                  checkForBadTypeIdentifierUsage(t.image); jjtn000.setImage(t.image);
      switch (jj_nt.kind) {
      case LT:
        TypeParameters();
        break;
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      RecordHeader();
      switch (jj_nt.kind) {
      case IMPLEMENTS:
        ImplementsList();
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      RecordBody();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void RecordHeader() throws ParseException {
    jj_consume_token(LPAREN);
    RecordComponentList();
    jj_consume_token(RPAREN);
  }

  final public void RecordComponentList() throws ParseException {
 /*@bgen(jjtree) RecordComponentList */
  ASTRecordComponentList jjtn000 = new ASTRecordComponentList(this, JJTRECORDCOMPONENTLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
      case AT:
        RecordComponent();
        label_21:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[36] = jj_gen;
            break label_21;
          }
          jj_consume_token(COMMA);
          RecordComponent();
        }
        break;
      default:
        jj_la1[37] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void RecordComponent() throws ParseException {
 /*@bgen(jjtree) RecordComponent */
  ASTRecordComponent jjtn000 = new ASTRecordComponent(this, JJTRECORDCOMPONENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_22:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_22;
        }
        RecordComponentModifier();
      }
      Type();
      switch (jj_nt.kind) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
           jjtn000.setVarargs();
        break;
      default:
        jj_la1[39] = jj_gen;
        ;
      }
      VariableDeclaratorId();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void RecordComponentModifier() throws ParseException {
    Annotation();
  }

  final public void RecordBody() throws ParseException {
 /*@bgen(jjtree) RecordBody */
  ASTRecordBody jjtn000 = new ASTRecordBody(this, JJTRECORDBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LBRACE);
      label_23:
      while (true) {
        if (jj_2_7(1)) {
          ;
        } else {
          break label_23;
        }
        RecordBodyDeclaration();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void RecordBodyDeclaration() throws ParseException {
    if (jj_2_8(2147483647)) {
      CompactConstructorDeclaration();
    } else if (jj_2_9(1)) {
      ClassOrInterfaceBodyDeclaration();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private void CompactConstructorDeclarationLookahead() throws ParseException {
    Modifiers();
    jj_consume_token(IDENTIFIER);
    jj_consume_token(LBRACE);
  }

  final public void CompactConstructorDeclaration() throws ParseException {
 /*@bgen(jjtree) CompactConstructorDeclaration */
  ASTCompactConstructorDeclaration jjtn000 = new ASTCompactConstructorDeclaration(this, JJTCOMPACTCONSTRUCTORDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));int modifiers;
    try {
      modifiers = Modifiers();
                            jjtn000.setModifiers(modifiers);
      jj_consume_token(IDENTIFIER);
                 jjtn000.setImage(token.image);
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void TypeParameters() throws ParseException {
 /*@bgen(jjtree) TypeParameters */
  ASTTypeParameters jjtn000 = new ASTTypeParameters(this, JJTTYPEPARAMETERS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LT);
        checkForBadGenericsUsage();
      TypeParameter();
      label_24:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[40] = jj_gen;
          break label_24;
        }
        jj_consume_token(COMMA);
        TypeParameter();
      }
      jj_consume_token(GT);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void TypeParameter() throws ParseException {
 /*@bgen(jjtree) TypeParameter */
 ASTTypeParameter jjtn000 = new ASTTypeParameter(this, JJTTYPEPARAMETER);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      label_25:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_25;
        }
        TypeAnnotation();
      }
      t = jj_consume_token(IDENTIFIER);
                   jjtn000.setImage(t.image);
      switch (jj_nt.kind) {
      case EXTENDS:
        TypeBound();
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void TypeBound() throws ParseException {
 /*@bgen(jjtree) TypeBound */
  ASTTypeBound jjtn000 = new ASTTypeBound(this, JJTTYPEBOUND);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(EXTENDS);
      label_26:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[43] = jj_gen;
          break label_26;
        }
        TypeAnnotation();
      }
      ClassOrInterfaceType();
      label_27:
      while (true) {
        switch (jj_nt.kind) {
        case BIT_AND:
          ;
          break;
        default:
          jj_la1[44] = jj_gen;
          break label_27;
        }
        jj_consume_token(BIT_AND);
        label_28:
        while (true) {
          switch (jj_nt.kind) {
          case AT:
            ;
            break;
          default:
            jj_la1[45] = jj_gen;
            break label_28;
          }
          TypeAnnotation();
        }
        ClassOrInterfaceType();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void ClassOrInterfaceBody() throws ParseException {
 /*@bgen(jjtree) ClassOrInterfaceBody */
  ASTClassOrInterfaceBody jjtn000 = new ASTClassOrInterfaceBody(this, JJTCLASSORINTERFACEBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LBRACE);
      label_29:
      while (true) {
        if (jj_2_10(1)) {
          ;
        } else {
          break label_29;
        }
        ClassOrInterfaceBodyDeclaration();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ClassOrInterfaceBodyDeclaration() throws ParseException {
 /*@bgen(jjtree) ClassOrInterfaceBodyDeclaration */
   ASTClassOrInterfaceBodyDeclaration jjtn000 = new ASTClassOrInterfaceBodyDeclaration(this, JJTCLASSORINTERFACEBODYDECLARATION);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtn000.jjtSetFirstToken(getToken(1));int modifiers;
    try {
      if (jj_2_16(2147483647)) {
        Initializer();
      } else if (jj_2_17(1)) {
        modifiers = Modifiers();
        if (jj_2_11(3)) {
          ClassOrInterfaceDeclaration(modifiers);
        } else if (isKeyword("enum")) {
          EnumDeclaration(modifiers);
        } else if (isKeyword("record")) {
          RecordDeclaration(modifiers);
        } else if (jj_2_12(2147483647)) {
          ConstructorDeclaration(modifiers);
        } else if (jj_2_13(2147483647)) {
          FieldDeclaration(modifiers);
        } else if (jj_2_14(2)) {
          MethodDeclaration(modifiers);
        } else if (jj_2_15(2)) {
          AnnotationTypeDeclaration(modifiers);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        switch (jj_nt.kind) {
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          break;
        default:
          jj_la1[46] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void FieldDeclaration(int modifiers) throws ParseException {
 /*@bgen(jjtree) FieldDeclaration */
 ASTFieldDeclaration jjtn000 = new ASTFieldDeclaration(this, JJTFIELDDECLARATION);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));jjtn000.setModifiers(modifiers);
    try {
      Type();
      VariableDeclarator();
      label_30:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[47] = jj_gen;
          break label_30;
        }
        jj_consume_token(COMMA);
        VariableDeclarator();
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void VariableDeclarator() throws ParseException {
 /*@bgen(jjtree) VariableDeclarator */
  ASTVariableDeclarator jjtn000 = new ASTVariableDeclarator(this, JJTVARIABLEDECLARATOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      VariableDeclaratorId();
      switch (jj_nt.kind) {
      case ASSIGN:
        jj_consume_token(ASSIGN);
        VariableInitializer();
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void VariableDeclaratorId() throws ParseException {
 /*@bgen(jjtree) VariableDeclaratorId */
  ASTVariableDeclaratorId jjtn000 = new ASTVariableDeclaratorId(this, JJTVARIABLEDECLARATORID);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token t;
  String image;
    try {
      if (jj_2_18(2)) {
        t = jj_consume_token(IDENTIFIER);
        jj_consume_token(DOT);
        jj_consume_token(THIS);
                                            checkforBadExplicitReceiverParameter(); jjtn000.setExplicitReceiverParameter(); image=t.image + ".this";
      } else {
        switch (jj_nt.kind) {
        case THIS:
          t = jj_consume_token(THIS);
                checkforBadExplicitReceiverParameter(); jjtn000.setExplicitReceiverParameter(); image = t.image;
          break;
        case IDENTIFIER:
          t = jj_consume_token(IDENTIFIER);
                      image = t.image;
          label_31:
          while (true) {
            switch (jj_nt.kind) {
            case LBRACKET:
              ;
              break;
            default:
              jj_la1[49] = jj_gen;
              break label_31;
            }
            jj_consume_token(LBRACKET);
            jj_consume_token(RBRACKET);
                                                      jjtn000.bumpArrayDepth();
          }
          break;
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    checkForBadAssertUsage(image, "a variable name");
    checkForBadEnumUsage(image, "a variable name");
    checkForBadIdentifier(image);
    jjtn000.setImage( image );
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void VariableInitializer() throws ParseException {
 /*@bgen(jjtree) VariableInitializer */
  ASTVariableInitializer jjtn000 = new ASTVariableInitializer(this, JJTVARIABLEINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case LBRACE:
        ArrayInitializer();
        break;
      default:
        jj_la1[51] = jj_gen;
        if (jj_2_19(1)) {
          Expression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ArrayInitializer() throws ParseException {
 /*@bgen(jjtree) ArrayInitializer */
  ASTArrayInitializer jjtn000 = new ASTArrayInitializer(this, JJTARRAYINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LBRACE);
      if (jj_2_21(1)) {
        VariableInitializer();
        label_32:
        while (true) {
          if (jj_2_20(2)) {
            ;
          } else {
            break label_32;
          }
          jj_consume_token(COMMA);
          VariableInitializer();
        }
      } else {
        ;
      }
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[52] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void MethodDeclaration(int modifiers) throws ParseException {
 /*@bgen(jjtree) MethodDeclaration */
    ASTMethodDeclaration jjtn000 = new ASTMethodDeclaration(this, JJTMETHODDECLARATION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));jjtn000.setModifiers(modifiers);
    { checkForBadPrivateInterfaceMethod(jjtn000); }
    try {
      switch (jj_nt.kind) {
      case LT:
        TypeParameters();
        break;
      default:
        jj_la1[53] = jj_gen;
        ;
      }
      label_33:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[54] = jj_gen;
          break label_33;
        }
        TypeAnnotation();
      }
      ResultType();
      MethodDeclarator();
      switch (jj_nt.kind) {
      case THROWS:
        jj_consume_token(THROWS);
        NameList();
        break;
      default:
        jj_la1[55] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case LBRACE:
        Block();
        break;
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[56] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void MethodDeclarator() throws ParseException {
 /*@bgen(jjtree) MethodDeclarator */
 ASTMethodDeclarator jjtn000 = new ASTMethodDeclarator(this, JJTMETHODDECLARATOR);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
    checkForBadAssertUsage(t.image, "a method name");
    checkForBadEnumUsage(t.image, "a method name");
    jjtn000.setImage( t.image );
      FormalParameters();
      label_34:
      while (true) {
        switch (jj_nt.kind) {
        case LBRACKET:
          ;
          break;
        default:
          jj_la1[57] = jj_gen;
          break label_34;
        }
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void FormalParameters() throws ParseException {
 /*@bgen(jjtree) FormalParameters */
  ASTFormalParameters jjtn000 = new ASTFormalParameters(this, JJTFORMALPARAMETERS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LPAREN);
      switch (jj_nt.kind) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FINAL:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
      case AT:
        FormalParameter();
        label_35:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[58] = jj_gen;
            break label_35;
          }
          jj_consume_token(COMMA);
          FormalParameter();
        }
        break;
      default:
        jj_la1[59] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void FormalParameter() throws ParseException {
 /*@bgen(jjtree) FormalParameter */
  ASTFormalParameter jjtn000 = new ASTFormalParameter(this, JJTFORMALPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_36:
      while (true) {
        switch (jj_nt.kind) {
        case FINAL:
        case AT:
          ;
          break;
        default:
          jj_la1[60] = jj_gen;
          break label_36;
        }
        switch (jj_nt.kind) {
        case FINAL:
          jj_consume_token(FINAL);
              jjtn000.setFinal(true);
          break;
        case AT:
          Annotation();
          break;
        default:
          jj_la1[61] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      Type();
      label_37:
      while (true) {
        switch (jj_nt.kind) {
        case BIT_OR:
          ;
          break;
        default:
          jj_la1[62] = jj_gen;
          break label_37;
        }
        jj_consume_token(BIT_OR);
                checkForBadMultipleExceptionsCatching();
        Type();
      }
      switch (jj_nt.kind) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
            checkForBadVariableArgumentsUsage();
                                                   jjtn000.setVarargs();
        break;
      default:
        jj_la1[63] = jj_gen;
        ;
      }
      VariableDeclaratorId();
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void ConstructorDeclaration(int modifiers) throws ParseException {
 /*@bgen(jjtree) ConstructorDeclaration */
 ASTConstructorDeclaration jjtn000 = new ASTConstructorDeclaration(this, JJTCONSTRUCTORDECLARATION);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));jjtn000.setModifiers(modifiers);
Token t;
    try {
      switch (jj_nt.kind) {
      case LT:
        TypeParameters();
        break;
      default:
        jj_la1[64] = jj_gen;
        ;
      }
      jj_consume_token(IDENTIFIER);
                  jjtn000.setImage(getToken(0).getImage());
      FormalParameters();
      switch (jj_nt.kind) {
      case THROWS:
        jj_consume_token(THROWS);
        NameList();
        break;
      default:
        jj_la1[65] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      if (jj_2_22(2147483647)) {
        ExplicitConstructorInvocation();
      } else {
        ;
      }
      label_38:
      while (true) {
        if (jj_2_23(1)) {
          ;
        } else {
          break label_38;
        }
        BlockStatement();
      }
      t = jj_consume_token(RBRACE);
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(getToken(0));
            if (isPrecededByComment(t)) { jjtn000.setContainsComment(); }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void ExplicitConstructorInvocation() throws ParseException {
 /*@bgen(jjtree) ExplicitConstructorInvocation */
  ASTExplicitConstructorInvocation jjtn000 = new ASTExplicitConstructorInvocation(this, JJTEXPLICITCONSTRUCTORINVOCATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_25(2147483647)) {
        jj_consume_token(THIS);
                                            jjtn000.setIsThis();
        Arguments();
        jj_consume_token(SEMICOLON);
      } else if (jj_2_26(2147483647)) {
        TypeArguments();
        jj_consume_token(THIS);
                                                                            jjtn000.setIsThis();
        Arguments();
        jj_consume_token(SEMICOLON);
      } else if (jj_2_27(1)) {
        if (jj_2_24(2147483647)) {
          PrimaryExpression();
          jj_consume_token(DOT);
        } else {
          ;
        }
        switch (jj_nt.kind) {
        case LT:
          TypeArguments();
          break;
        default:
          jj_la1[66] = jj_gen;
          ;
        }
        jj_consume_token(SUPER);
                                                                                              jjtn000.setIsSuper();
        Arguments();
        jj_consume_token(SEMICOLON);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Initializer() throws ParseException {
 /*@bgen(jjtree) Initializer */
  ASTInitializer jjtn000 = new ASTInitializer(this, JJTINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case STATIC:
        jj_consume_token(STATIC);
              jjtn000.setStatic();
        break;
      default:
        jj_la1[67] = jj_gen;
        ;
      }
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

/*
 * Type, name and expression syntax follows.
 * Type is the same as "UnannType" in JLS
 *
 * See https://docs.oracle.com/javase/specs/jls/se10/html/jls-8.html#jls-UnannType
 */
  final public void Type() throws ParseException {
 /*@bgen(jjtree) Type */
    ASTType jjtn000 = new ASTType(this, JJTTYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      if (jj_2_28(2)) {
        ReferenceType();
      } else {
        switch (jj_nt.kind) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FLOAT:
        case INT:
        case LONG:
        case SHORT:
          PrimitiveType();
          break;
        default:
          jj_la1[68] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
   if (jjtc000) {
     jjtree.clearNodeScope(jjtn000);
     jjtc000 = false;
   } else {
     jjtree.popNode();
   }
   if (jjte000 instanceof RuntimeException) {
     {if (true) throw (RuntimeException)jjte000;}
   }
   if (jjte000 instanceof ParseException) {
     {if (true) throw (ParseException)jjte000;}
   }
   {if (true) throw (Error)jjte000;}
    } finally {
   if (jjtc000) {
     jjtree.closeNodeScope(jjtn000, true);
     jjtn000.jjtSetLastToken(getToken(0));
   }
    }
  }

  final public void ReferenceType() throws ParseException {
 /*@bgen(jjtree) ReferenceType */
  ASTReferenceType jjtn000 = new ASTReferenceType(this, JJTREFERENCETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
        PrimitiveType();
        label_39:
        while (true) {
          switch (jj_nt.kind) {
          case AT:
            ;
            break;
          default:
            jj_la1[69] = jj_gen;
            break label_39;
          }
          TypeAnnotation();
        }
        label_40:
        while (true) {
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
                                                                jjtn000.bumpArrayDepth();
          if (jj_2_29(2)) {
            ;
          } else {
            break label_40;
          }
        }
        break;
      case IDENTIFIER:
        ClassOrInterfaceType();
        label_41:
        while (true) {
          switch (jj_nt.kind) {
          case AT:
            ;
            break;
          default:
            jj_la1[70] = jj_gen;
            break label_41;
          }
          TypeAnnotation();
        }
        label_42:
        while (true) {
          if (jj_2_30(2)) {
            ;
          } else {
            break label_42;
          }
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
                                                                          jjtn000.bumpArrayDepth();
        }
        break;
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void ClassOrInterfaceType() throws ParseException {
 /*@bgen(jjtree) ClassOrInterfaceType */
  ASTClassOrInterfaceType jjtn000 = new ASTClassOrInterfaceType(this, JJTCLASSORINTERFACETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));StringBuilder s = new StringBuilder();
  Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
                  s.append(t.image);
      if (jj_2_31(2)) {
        TypeArguments();
      } else {
        ;
      }
      label_43:
      while (true) {
        if (jj_2_32(2)) {
          ;
        } else {
          break label_43;
        }
        jj_consume_token(DOT);
        t = jj_consume_token(IDENTIFIER);
                                     s.append('.').append(t.image);
        if (jj_2_33(2)) {
          TypeArguments();
        } else {
          ;
        }
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
   jjtn000.setImage(s.toString());
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void TypeName() throws ParseException {
 /*@bgen(jjtree) ClassOrInterfaceType */
  ASTClassOrInterfaceType jjtn000 = new ASTClassOrInterfaceType(this, JJTCLASSORINTERFACETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));StringBuilder s = new StringBuilder();
  Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
                    s.append(t.image);
      label_44:
      while (true) {
        switch (jj_nt.kind) {
        case DOT:
          ;
          break;
        default:
          jj_la1[72] = jj_gen;
          break label_44;
        }
        jj_consume_token(DOT);
        t = jj_consume_token(IDENTIFIER);
                          s.append('.').append(t.image);
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
     jjtn000.setImage(s.toString());
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void TypeArguments() throws ParseException {
 /*@bgen(jjtree) TypeArguments */
  ASTTypeArguments jjtn000 = new ASTTypeArguments(this, JJTTYPEARGUMENTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_34(2)) {
        jj_consume_token(LT);
        checkForBadGenericsUsage();
        TypeArgument();
        label_45:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[73] = jj_gen;
            break label_45;
          }
          jj_consume_token(COMMA);
          TypeArgument();
        }
        jj_consume_token(GT);
      } else {
        switch (jj_nt.kind) {
        case LT:
          jj_consume_token(LT);
        checkForBadDiamondUsage();
          jj_consume_token(GT);
          break;
        default:
          jj_la1[74] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void TypeArgument() throws ParseException {
 /*@bgen(jjtree) TypeArgument */
  ASTTypeArgument jjtn000 = new ASTTypeArgument(this, JJTTYPEARGUMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_46:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[75] = jj_gen;
          break label_46;
        }
        TypeAnnotation();
      }
      switch (jj_nt.kind) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        ReferenceType();
        break;
      case HOOK:
        jj_consume_token(HOOK);
        switch (jj_nt.kind) {
        case EXTENDS:
        case SUPER:
          WildcardBounds();
          break;
        default:
          jj_la1[76] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void WildcardBounds() throws ParseException {
 /*@bgen(jjtree) WildcardBounds */
  ASTWildcardBounds jjtn000 = new ASTWildcardBounds(this, JJTWILDCARDBOUNDS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case EXTENDS:
        jj_consume_token(EXTENDS);
        break;
      case SUPER:
        jj_consume_token(SUPER);
        break;
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_47:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[79] = jj_gen;
          break label_47;
        }
        TypeAnnotation();
      }
      ReferenceType();
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void PrimitiveType() throws ParseException {
 /*@bgen(jjtree) PrimitiveType */
  ASTPrimitiveType jjtn000 = new ASTPrimitiveType(this, JJTPRIMITIVETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case BOOLEAN:
        jj_consume_token(BOOLEAN);
              jjtree.closeNodeScope(jjtn000, true);
              jjtc000 = false;
              jjtn000.jjtSetLastToken(getToken(0));
             jjtn000.setImage("boolean");
        break;
      case CHAR:
        jj_consume_token(CHAR);
           jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           jjtn000.jjtSetLastToken(getToken(0));
          jjtn000.setImage("char");
        break;
      case BYTE:
        jj_consume_token(BYTE);
           jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           jjtn000.jjtSetLastToken(getToken(0));
          jjtn000.setImage("byte");
        break;
      case SHORT:
        jj_consume_token(SHORT);
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(getToken(0));
           jjtn000.setImage("short");
        break;
      case INT:
        jj_consume_token(INT);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          jjtn000.jjtSetLastToken(getToken(0));
         jjtn000.setImage("int");
        break;
      case LONG:
        jj_consume_token(LONG);
           jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           jjtn000.jjtSetLastToken(getToken(0));
          jjtn000.setImage("long");
        break;
      case FLOAT:
        jj_consume_token(FLOAT);
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(getToken(0));
           jjtn000.setImage("float");
        break;
      case DOUBLE:
        jj_consume_token(DOUBLE);
             jjtree.closeNodeScope(jjtn000, true);
             jjtc000 = false;
             jjtn000.jjtSetLastToken(getToken(0));
            jjtn000.setImage("double");
        break;
      default:
        jj_la1[80] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ResultType() throws ParseException {
 /*@bgen(jjtree) ResultType */
  ASTResultType jjtn000 = new ASTResultType(this, JJTRESULTTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case VOID:
        jj_consume_token(VOID);
        break;
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        Type();
        break;
      default:
        jj_la1[81] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Name() throws ParseException {
 /*@bgen(jjtree) Name */
  ASTName jjtn000 = new ASTName(this, JJTNAME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));StringBuilder s = new StringBuilder();
  Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
    s.append(t.image);
      label_48:
      while (true) {
        if (jj_2_35(2)) {
          ;
        } else {
          break label_48;
        }
        jj_consume_token(DOT);
        t = jj_consume_token(IDENTIFIER);
     s.append('.').append(t.image);
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
   jjtn000.setImage(s.toString());
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void NameList() throws ParseException {
 /*@bgen(jjtree) NameList */
  ASTNameList jjtn000 = new ASTNameList(this, JJTNAMELIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_49:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[82] = jj_gen;
          break label_49;
        }
        TypeAnnotation();
      }
      Name();
      label_50:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[83] = jj_gen;
          break label_50;
        }
        jj_consume_token(COMMA);
        label_51:
        while (true) {
          switch (jj_nt.kind) {
          case AT:
            ;
            break;
          default:
            jj_la1[84] = jj_gen;
            break label_51;
          }
          TypeAnnotation();
        }
        Name();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

/*
 * Expression syntax follows.
 */
  final public void Expression() throws ParseException {
 /*@bgen(jjtree) Expression */
  ASTExpression jjtn000 = new ASTExpression(this, JJTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      ConditionalExpression();
      if (jj_2_36(2)) {
        AssignmentOperator();
        Expression();
      } else {
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void AssignmentOperator() throws ParseException {
 /*@bgen(jjtree) AssignmentOperator */
  ASTAssignmentOperator jjtn000 = new ASTAssignmentOperator(this, JJTASSIGNMENTOPERATOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case ASSIGN:
        jj_consume_token(ASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("=");
        break;
      case STARASSIGN:
        jj_consume_token(STARASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("*="); jjtn000.setCompound();
        break;
      case SLASHASSIGN:
        jj_consume_token(SLASHASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("/="); jjtn000.setCompound();
        break;
      case REMASSIGN:
        jj_consume_token(REMASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("%="); jjtn000.setCompound();
        break;
      case PLUSASSIGN:
        jj_consume_token(PLUSASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("+="); jjtn000.setCompound();
        break;
      case MINUSASSIGN:
        jj_consume_token(MINUSASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("-="); jjtn000.setCompound();
        break;
      case LSHIFTASSIGN:
        jj_consume_token(LSHIFTASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("<<="); jjtn000.setCompound();
        break;
      case RSIGNEDSHIFTASSIGN:
        jj_consume_token(RSIGNEDSHIFTASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage(">>="); jjtn000.setCompound();
        break;
      case RUNSIGNEDSHIFTASSIGN:
        jj_consume_token(RUNSIGNEDSHIFTASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage(">>>="); jjtn000.setCompound();
        break;
      case ANDASSIGN:
        jj_consume_token(ANDASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("&="); jjtn000.setCompound();
        break;
      case XORASSIGN:
        jj_consume_token(XORASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("^="); jjtn000.setCompound();
        break;
      case ORASSIGN:
        jj_consume_token(ORASSIGN);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setImage("|="); jjtn000.setCompound();
        break;
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
        if (jjtc000) {
          jjtree.closeNodeScope(jjtn000, true);
          jjtn000.jjtSetLastToken(getToken(0));
        }
    }
  }

// TODO Setting isTernary is unnecessary, since the node is only pushed on the stack if there is at least one child,
// ie if it's a ternary
  final public void ConditionalExpression() throws ParseException {
 /*@bgen(jjtree) #ConditionalExpression(> 1) */
  ASTConditionalExpression jjtn000 = new ASTConditionalExpression(this, JJTCONDITIONALEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      ConditionalOrExpression();
      if (jj_2_37(2)) {
        jj_consume_token(HOOK);
        Expression();
        jj_consume_token(COLON);
        ConditionalExpression();
      } else {
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ConditionalOrExpression() throws ParseException {
 /*@bgen(jjtree) #ConditionalOrExpression(> 1) */
  ASTConditionalOrExpression jjtn000 = new ASTConditionalOrExpression(this, JJTCONDITIONALOREXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      ConditionalAndExpression();
      label_52:
      while (true) {
        if (jj_2_38(2)) {
          ;
        } else {
          break label_52;
        }
        jj_consume_token(SC_OR);
        ConditionalAndExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ConditionalAndExpression() throws ParseException {
 /*@bgen(jjtree) #ConditionalAndExpression(> 1) */
  ASTConditionalAndExpression jjtn000 = new ASTConditionalAndExpression(this, JJTCONDITIONALANDEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      InclusiveOrExpression();
      label_53:
      while (true) {
        if (jj_2_39(2)) {
          ;
        } else {
          break label_53;
        }
        jj_consume_token(SC_AND);
        InclusiveOrExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void InclusiveOrExpression() throws ParseException {
 /*@bgen(jjtree) #InclusiveOrExpression(> 1) */
  ASTInclusiveOrExpression jjtn000 = new ASTInclusiveOrExpression(this, JJTINCLUSIVEOREXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      ExclusiveOrExpression();
      label_54:
      while (true) {
        if (jj_2_40(2)) {
          ;
        } else {
          break label_54;
        }
        jj_consume_token(BIT_OR);
        ExclusiveOrExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ExclusiveOrExpression() throws ParseException {
 /*@bgen(jjtree) #ExclusiveOrExpression(> 1) */
  ASTExclusiveOrExpression jjtn000 = new ASTExclusiveOrExpression(this, JJTEXCLUSIVEOREXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      AndExpression();
      label_55:
      while (true) {
        if (jj_2_41(2)) {
          ;
        } else {
          break label_55;
        }
        jj_consume_token(XOR);
        AndExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void AndExpression() throws ParseException {
 /*@bgen(jjtree) #AndExpression(> 1) */
  ASTAndExpression jjtn000 = new ASTAndExpression(this, JJTANDEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      EqualityExpression();
      label_56:
      while (true) {
        if (jj_2_42(2)) {
          ;
        } else {
          break label_56;
        }
        jj_consume_token(BIT_AND);
        EqualityExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void EqualityExpression() throws ParseException {
 /*@bgen(jjtree) #EqualityExpression(> 1) */
  ASTEqualityExpression jjtn000 = new ASTEqualityExpression(this, JJTEQUALITYEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      InstanceOfExpression();
      label_57:
      while (true) {
        if (jj_2_43(2)) {
          ;
        } else {
          break label_57;
        }
        switch (jj_nt.kind) {
        case EQ:
          jj_consume_token(EQ);
                                                 jjtn000.setImage("==");
          break;
        case NE:
          jj_consume_token(NE);
                                                                                  jjtn000.setImage("!=");
          break;
        default:
          jj_la1[86] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        InstanceOfExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Pattern() throws ParseException {
    PrimaryPattern();
    switch (jj_nt.kind) {
    case SC_AND:
                         ASTGuardedPattern jjtn001 = new ASTGuardedPattern(this, JJTGUARDEDPATTERN);
                         boolean jjtc001 = true;
                         jjtree.openNodeScope(jjtn001);
                         jjtn001.jjtSetFirstToken(getToken(1));
      try {
        GuardedPatternCondition();
      } catch (Throwable jjte001) {
                         if (jjtc001) {
                           jjtree.clearNodeScope(jjtn001);
                           jjtc001 = false;
                         } else {
                           jjtree.popNode();
                         }
                         if (jjte001 instanceof RuntimeException) {
                           {if (true) throw (RuntimeException)jjte001;}
                         }
                         if (jjte001 instanceof ParseException) {
                           {if (true) throw (ParseException)jjte001;}
                         }
                         {if (true) throw (Error)jjte001;}
      } finally {
                         if (jjtc001) {
                           jjtree.closeNodeScope(jjtn001,  2);
                           jjtn001.jjtSetLastToken(getToken(0));
                         }
      }
                                                                     checkForGuardedPatterns();
      break;
    default:
      jj_la1[87] = jj_gen;
      ;
    }
  }

  final public void GuardedPatternCondition() throws ParseException {
    jj_consume_token(SC_AND);
    ConditionalAndExpression();
  }

  final public void PrimaryPattern() throws ParseException {
    switch (jj_nt.kind) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FINAL:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case IDENTIFIER:
    case AT:
      TypePattern();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      Pattern();
      jj_consume_token(RPAREN);
                          AstImplUtil.bumpParenDepth((ASTPattern) jjtree.peekNode());
      break;
    default:
      jj_la1[88] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void TypePattern() throws ParseException {
 /*@bgen(jjtree) TypePattern */
  ASTTypePattern jjtn000 = new ASTTypePattern(this, JJTTYPEPATTERN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_58:
      while (true) {
        switch (jj_nt.kind) {
        case FINAL:
        case AT:
          ;
          break;
        default:
          jj_la1[89] = jj_gen;
          break label_58;
        }
        switch (jj_nt.kind) {
        case FINAL:
          jj_consume_token(FINAL);
             jjtn000.setFinal(true);
          break;
        case AT:
          Annotation();
          break;
        default:
          jj_la1[90] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      Type();
      VariableDeclaratorId();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void InstanceOfExpression() throws ParseException {
 /*@bgen(jjtree) #InstanceOfExpression(> 1) */
  ASTInstanceOfExpression jjtn000 = new ASTInstanceOfExpression(this, JJTINSTANCEOFEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      RelationalExpression();
      switch (jj_nt.kind) {
      case INSTANCEOF:
        jj_consume_token(INSTANCEOF);
        if (jj_2_44(2147483647)) {
                                  checkforBadInstanceOfPattern();
          PrimaryPattern();
        } else if (jj_2_45(2147483647)) {
          Pattern();
                                  checkforBadInstanceOfPattern();
        } else {
          switch (jj_nt.kind) {
          case BOOLEAN:
          case BYTE:
          case CHAR:
          case DOUBLE:
          case FLOAT:
          case INT:
          case LONG:
          case SHORT:
          case IDENTIFIER:
            Type();
            switch (jj_nt.kind) {
            case THIS:
            case IDENTIFIER:
           checkforBadInstanceOfPattern();
                                              ASTTypePattern jjtn001 = new ASTTypePattern(this, JJTTYPEPATTERN);
                                              boolean jjtc001 = true;
                                              jjtree.openNodeScope(jjtn001);
                                              jjtn001.jjtSetFirstToken(getToken(1));
              try {
                VariableDeclaratorId();
              } catch (Throwable jjte001) {
                                              if (jjtc001) {
                                                jjtree.clearNodeScope(jjtn001);
                                                jjtc001 = false;
                                              } else {
                                                jjtree.popNode();
                                              }
                                              if (jjte001 instanceof RuntimeException) {
                                                {if (true) throw (RuntimeException)jjte001;}
                                              }
                                              if (jjte001 instanceof ParseException) {
                                                {if (true) throw (ParseException)jjte001;}
                                              }
                                              {if (true) throw (Error)jjte001;}
              } finally {
                                              if (jjtc001) {
                                                jjtree.closeNodeScope(jjtn001,  2);
                                                jjtn001.jjtSetLastToken(getToken(0));
                                              }
              }
              break;
            default:
              jj_la1[91] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[92] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[93] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void RelationalExpression() throws ParseException {
 /*@bgen(jjtree) #RelationalExpression(> 1) */
  ASTRelationalExpression jjtn000 = new ASTRelationalExpression(this, JJTRELATIONALEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      ShiftExpression();
      label_59:
      while (true) {
        if (jj_2_46(2)) {
          ;
        } else {
          break label_59;
        }
        switch (jj_nt.kind) {
        case LT:
          jj_consume_token(LT);
           jjtn000.setImage("<");
          break;
        case GT:
          jj_consume_token(GT);
            jjtn000.setImage(">");
          break;
        case LE:
          jj_consume_token(LE);
             jjtn000.setImage("<=");
          break;
        case GE:
          jj_consume_token(GE);
             jjtn000.setImage(">=");
          break;
        default:
          jj_la1[94] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        ShiftExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ShiftExpression() throws ParseException {
 /*@bgen(jjtree) #ShiftExpression(> 1) */
  ASTShiftExpression jjtn000 = new ASTShiftExpression(this, JJTSHIFTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      AdditiveExpression();
      label_60:
      while (true) {
        if (jj_2_47(2)) {
          ;
        } else {
          break label_60;
        }
        switch (jj_nt.kind) {
        case LSHIFT:
          jj_consume_token(LSHIFT);
             jjtn000.setImage("<<");
          break;
        default:
          jj_la1[95] = jj_gen;
          if (jj_2_48(1)) {
            RSIGNEDSHIFT();
                        jjtn000.setImage(">>");
          } else if (jj_2_49(1)) {
            RUNSIGNEDSHIFT();
                          jjtn000.setImage(">>>");
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        AdditiveExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void AdditiveExpression() throws ParseException {
 /*@bgen(jjtree) #AdditiveExpression(> 1) */
  ASTAdditiveExpression jjtn000 = new ASTAdditiveExpression(this, JJTADDITIVEEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      MultiplicativeExpression();
      label_61:
      while (true) {
        if (jj_2_50(2)) {
          ;
        } else {
          break label_61;
        }
        switch (jj_nt.kind) {
        case PLUS:
          jj_consume_token(PLUS);
                                                   jjtn000.setImage("+");
          break;
        case MINUS:
          jj_consume_token(MINUS);
                                                                                  jjtn000.setImage("-");
          break;
        default:
          jj_la1[96] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        MultiplicativeExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void MultiplicativeExpression() throws ParseException {
 /*@bgen(jjtree) #MultiplicativeExpression(> 1) */
  ASTMultiplicativeExpression jjtn000 = new ASTMultiplicativeExpression(this, JJTMULTIPLICATIVEEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      UnaryExpression();
      label_62:
      while (true) {
        if (jj_2_51(2)) {
          ;
        } else {
          break label_62;
        }
        switch (jj_nt.kind) {
        case STAR:
          jj_consume_token(STAR);
                                          jjtn000.setImage("*");
          break;
        case SLASH:
          jj_consume_token(SLASH);
                                                                         jjtn000.setImage("/");
          break;
        case REM:
          jj_consume_token(REM);
                                                                                                        jjtn000.setImage("%");
          break;
        default:
          jj_la1[97] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        UnaryExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void UnaryExpression() throws ParseException {
 /*@bgen(jjtree) #UnaryExpression( ( jjtn000 . getImage ( ) != null )) */
  ASTUnaryExpression jjtn000 = new ASTUnaryExpression(this, JJTUNARYEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case PLUS:
      case MINUS:
        switch (jj_nt.kind) {
        case PLUS:
          jj_consume_token(PLUS);
        jjtn000.setImage("+");
          break;
        case MINUS:
          jj_consume_token(MINUS);
                                       jjtn000.setImage("-");
          break;
        default:
          jj_la1[98] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        UnaryExpression();
        break;
      case INCR:
        PreIncrementExpression();
        break;
      case DECR:
        PreDecrementExpression();
        break;
      default:
        jj_la1[99] = jj_gen;
        if (jj_2_52(1)) {
          UnaryExpressionNotPlusMinus();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000,  ( jjtn000 . getImage ( ) != null ));
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void PreIncrementExpression() throws ParseException {
 /*@bgen(jjtree) PreIncrementExpression */
  ASTPreIncrementExpression jjtn000 = new ASTPreIncrementExpression(this, JJTPREINCREMENTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(INCR);
      PrimaryExpression();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void PreDecrementExpression() throws ParseException {
 /*@bgen(jjtree) PreDecrementExpression */
  ASTPreDecrementExpression jjtn000 = new ASTPreDecrementExpression(this, JJTPREDECREMENTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(DECR);
      PrimaryExpression();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void UnaryExpressionNotPlusMinus() throws ParseException {
 /*@bgen(jjtree) #UnaryExpressionNotPlusMinus( ( jjtn000 . getImage ( ) != null )) */
  ASTUnaryExpressionNotPlusMinus jjtn000 = new ASTUnaryExpressionNotPlusMinus(this, JJTUNARYEXPRESSIONNOTPLUSMINUS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case BANG:
      case TILDE:
        switch (jj_nt.kind) {
        case TILDE:
          jj_consume_token(TILDE);
        jjtn000.setImage("~");
          break;
        case BANG:
          jj_consume_token(BANG);
                                       jjtn000.setImage("!");
          break;
        default:
          jj_la1[100] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        UnaryExpression();
        break;
      default:
        jj_la1[101] = jj_gen;
        if (jj_2_53(2147483647)) {
          CastExpression();
        } else if (jj_2_54(2147483647)) {
          CastExpression();
        } else if (jj_2_55(1)) {
          PostfixExpression();
        } else {
          switch (jj_nt.kind) {
          case SWITCH:
            SwitchExpression();
            break;
          default:
            jj_la1[102] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } catch (Throwable jjte000) {
   if (jjtc000) {
     jjtree.clearNodeScope(jjtn000);
     jjtc000 = false;
   } else {
     jjtree.popNode();
   }
   if (jjte000 instanceof RuntimeException) {
     {if (true) throw (RuntimeException)jjte000;}
   }
   if (jjte000 instanceof ParseException) {
     {if (true) throw (ParseException)jjte000;}
   }
   {if (true) throw (Error)jjte000;}
    } finally {
   if (jjtc000) {
     jjtree.closeNodeScope(jjtn000,  ( jjtn000 . getImage ( ) != null ));
     jjtn000.jjtSetLastToken(getToken(0));
   }
    }
  }

  final private void UnaryExprNotPmStart() throws ParseException {
    switch (jj_nt.kind) {
    case TILDE:
      jj_consume_token(TILDE);
      break;
    case BANG:
      jj_consume_token(BANG);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      break;
    case SWITCH:
      jj_consume_token(SWITCH);
      break;
    case NEW:
      jj_consume_token(NEW);
      break;
    case THIS:
      jj_consume_token(THIS);
      break;
    case SUPER:
      jj_consume_token(SUPER);
      break;
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case HEX_FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case TEXT_BLOCK_LITERAL:
      Literal();
      break;
    case AT:
      jj_consume_token(AT);
      break;
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    case VOID:
      jj_consume_token(VOID);
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      break;
    default:
      jj_la1[103] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PostfixExpression() throws ParseException {
 /*@bgen(jjtree) #PostfixExpression( ( jjtn000 . getImage ( ) != null )) */
  ASTPostfixExpression jjtn000 = new ASTPostfixExpression(this, JJTPOSTFIXEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      PrimaryExpression();
      switch (jj_nt.kind) {
      case INCR:
      case DECR:
        switch (jj_nt.kind) {
        case INCR:
          jj_consume_token(INCR);
                              jjtn000.setImage("++");
          break;
        case DECR:
          jj_consume_token(DECR);
                                                               jjtn000.setImage("--");
          break;
        default:
          jj_la1[104] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[105] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000,  ( jjtn000 . getImage ( ) != null ));
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void CastExpression() throws ParseException {
 /*@bgen(jjtree) CastExpression */
  ASTCastExpression jjtn000 = new ASTCastExpression(this, JJTCASTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_56(2147483647)) {
        jj_consume_token(LPAREN);
        label_63:
        while (true) {
          switch (jj_nt.kind) {
          case AT:
            ;
            break;
          default:
            jj_la1[106] = jj_gen;
            break label_63;
          }
          TypeAnnotation();
        }
        Type();
        jj_consume_token(RPAREN);
        UnaryExpression();
      } else {
        switch (jj_nt.kind) {
        case LPAREN:
          jj_consume_token(LPAREN);
          label_64:
          while (true) {
            switch (jj_nt.kind) {
            case AT:
              ;
              break;
            default:
              jj_la1[107] = jj_gen;
              break label_64;
            }
            TypeAnnotation();
          }
          Type();
          label_65:
          while (true) {
            switch (jj_nt.kind) {
            case BIT_AND:
              ;
              break;
            default:
              jj_la1[108] = jj_gen;
              break label_65;
            }
            jj_consume_token(BIT_AND);
                                        checkForBadIntersectionTypesInCasts(); jjtn000.setIntersectionTypes(true);
            ReferenceType();
          }
          jj_consume_token(RPAREN);
          UnaryExpressionNotPlusMinus();
          break;
        default:
          jj_la1[109] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void SwitchExpression() throws ParseException {
 /*@bgen(jjtree) SwitchExpression */
 ASTSwitchExpression jjtn000 = new ASTSwitchExpression(this, JJTSWITCHEXPRESSION);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));boolean prevInSwitchBlock = inSwitchExprBlock;
    try {
     checkForSwitchExpression();
      jj_consume_token(SWITCH);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
     inSwitchExprBlock = true;
      SwitchBlock();
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
     inSwitchExprBlock = prevInSwitchBlock;
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void PrimaryExpression() throws ParseException {
 /*@bgen(jjtree) PrimaryExpression */
  ASTPrimaryExpression jjtn000 = new ASTPrimaryExpression(this, JJTPRIMARYEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      PrimaryPrefix();
      label_66:
      while (true) {
        if (jj_2_57(2)) {
          ;
        } else {
          break label_66;
        }
        PrimarySuffix();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void MemberSelector() throws ParseException {
 /*@bgen(jjtree) MemberSelector */
ASTMemberSelector jjtn000 = new ASTMemberSelector(this, JJTMEMBERSELECTOR);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      switch (jj_nt.kind) {
      case DOT:
        jj_consume_token(DOT);
        TypeArguments();
        t = jj_consume_token(IDENTIFIER);
                                       jjtree.closeNodeScope(jjtn000, true);
                                       jjtc000 = false;
                                       jjtn000.jjtSetLastToken(getToken(0));
                                      jjtn000.setImage(t.image);
        break;
      case METHOD_REF:
        MethodReference();
        break;
      default:
        jj_la1[110] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void MethodReference() throws ParseException {
 /*@bgen(jjtree) MethodReference */
 ASTMethodReference jjtn000 = new ASTMethodReference(this, JJTMETHODREFERENCE);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t; checkForBadMethodReferenceUsage();
    try {
      jj_consume_token(METHOD_REF);
      switch (jj_nt.kind) {
      case LT:
        TypeArguments();
        break;
      default:
        jj_la1[111] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case NEW:
        jj_consume_token(NEW);
                                   jjtree.closeNodeScope(jjtn000, true);
                                   jjtc000 = false;
                                   jjtn000.jjtSetLastToken(getToken(0));
                                  jjtn000.setImage("new");
        break;
      case IDENTIFIER:
        t = jj_consume_token(IDENTIFIER);
                                                                               jjtree.closeNodeScope(jjtn000, true);
                                                                               jjtc000 = false;
                                                                               jjtn000.jjtSetLastToken(getToken(0));
                                                                              jjtn000.setImage(t.image);
        break;
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void PrimaryPrefix() throws ParseException {
 /*@bgen(jjtree) PrimaryPrefix */
 ASTPrimaryPrefix jjtn000 = new ASTPrimaryPrefix(this, JJTPRIMARYPREFIX);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      switch (jj_nt.kind) {
      case FALSE:
      case NULL:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case HEX_FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case TEXT_BLOCK_LITERAL:
        Literal();
        break;
      default:
        jj_la1[113] = jj_gen;
        if (jj_2_58(2)) {
          jj_consume_token(THIS);
                        jjtree.closeNodeScope(jjtn000, true);
                        jjtc000 = false;
                        jjtn000.jjtSetLastToken(getToken(0));
                       jjtn000.setUsesThisModifier();
        } else {
          switch (jj_nt.kind) {
          case SUPER:
            jj_consume_token(SUPER);
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            jjtn000.jjtSetLastToken(getToken(0));
           jjtn000.setUsesSuperModifier();
            break;
          default:
            jj_la1[114] = jj_gen;
            if (jj_2_59(2147483647) && (!inSwitchLabel)) {
              LambdaExpression();
            } else if (jj_2_60(2147483647) && (!inSwitchLabel)) {
              LambdaExpression();
            } else if (jj_2_61(2147483647) && (!inSwitchLabel)) {
              LambdaExpression();
            } else if (jj_2_62(3)) {
              jj_consume_token(LPAREN);
              Expression();
              jj_consume_token(RPAREN);
            } else {
              switch (jj_nt.kind) {
              case NEW:
                AllocationExpression();
                break;
              default:
                jj_la1[115] = jj_gen;
                if (jj_2_63(2147483647)) {
                  ResultType();
                  jj_consume_token(DOT);
                  jj_consume_token(CLASS);
                } else if (jj_2_64(2147483647)) {
                  Name();
                } else if (jj_2_65(2147483647)) {
                  ReferenceType();
                  MethodReference();
                } else {
                  switch (jj_nt.kind) {
                  case IDENTIFIER:
                    Name();
                    break;
                  default:
                    jj_la1[116] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                  }
                }
              }
            }
          }
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void LambdaExpression() throws ParseException {
 /*@bgen(jjtree) LambdaExpression */
  ASTLambdaExpression jjtn000 = new ASTLambdaExpression(this, JJTLAMBDAEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));checkForBadLambdaUsage();
    try {
      switch (jj_nt.kind) {
      case THIS:
      case IDENTIFIER:
        VariableDeclaratorId();
        jj_consume_token(LAMBDA);
        if (jj_2_66(1)) {
          Expression();
        } else {
          switch (jj_nt.kind) {
          case LBRACE:
            Block();
            break;
          default:
            jj_la1[117] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        break;
      default:
        jj_la1[121] = jj_gen;
        if (jj_2_69(3)) {
          LambdaParameters();
          jj_consume_token(LAMBDA);
          if (jj_2_67(1)) {
            Expression();
          } else {
            switch (jj_nt.kind) {
            case LBRACE:
              Block();
              break;
            default:
              jj_la1[118] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        } else if (jj_2_70(3)) {
          jj_consume_token(LPAREN);
          VariableDeclaratorId();
          label_67:
          while (true) {
            switch (jj_nt.kind) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[119] = jj_gen;
              break label_67;
            }
            jj_consume_token(COMMA);
            VariableDeclaratorId();
          }
          jj_consume_token(RPAREN);
          jj_consume_token(LAMBDA);
          if (jj_2_68(1)) {
            Expression();
          } else {
            switch (jj_nt.kind) {
            case LBRACE:
              Block();
              break;
            default:
              jj_la1[120] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void LambdaParameters() throws ParseException {
 /*@bgen(jjtree) FormalParameters */
  ASTFormalParameters jjtn000 = new ASTFormalParameters(this, JJTFORMALPARAMETERS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LPAREN);
      if (jj_2_71(1)) {
        LambdaParameterList();
      } else {
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void LambdaParameterList() throws ParseException {
    LambdaParameter();
    label_68:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[122] = jj_gen;
        break label_68;
      }
      jj_consume_token(COMMA);
      LambdaParameter();
    }
  }

  final public void LambdaParameter() throws ParseException {
 /*@bgen(jjtree) FormalParameter */
  ASTFormalParameter jjtn000 = new ASTFormalParameter(this, JJTFORMALPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_69:
      while (true) {
        switch (jj_nt.kind) {
        case FINAL:
        case AT:
          ;
          break;
        default:
          jj_la1[123] = jj_gen;
          break label_69;
        }
        switch (jj_nt.kind) {
        case FINAL:
          jj_consume_token(FINAL);
               jjtn000.setFinal(true);
          break;
        case AT:
          Annotation();
          break;
        default:
          jj_la1[124] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      LambdaParameterType();
      switch (jj_nt.kind) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
             checkForBadVariableArgumentsUsage();
                                                    jjtn000.setVarargs();
        break;
      default:
        jj_la1[125] = jj_gen;
        ;
      }
      VariableDeclaratorId();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void LambdaParameterType() throws ParseException {
    if (jdkVersion >= 11 && isKeyword("var")) {
      jj_consume_token(IDENTIFIER);
    } else {
      switch (jj_nt.kind) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        Type();
        break;
      default:
        jj_la1[126] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void PrimarySuffix() throws ParseException {
 /*@bgen(jjtree) PrimarySuffix */
 ASTPrimarySuffix jjtn000 = new ASTPrimarySuffix(this, JJTPRIMARYSUFFIX);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      if (jj_2_72(2)) {
        jj_consume_token(DOT);
        jj_consume_token(THIS);
      } else if (jj_2_73(2)) {
        jj_consume_token(DOT);
        jj_consume_token(SUPER);
      } else if (jj_2_74(2)) {
        jj_consume_token(DOT);
        AllocationExpression();
      } else if (jj_2_75(3)) {
        MemberSelector();
      } else {
        switch (jj_nt.kind) {
        case LBRACKET:
          jj_consume_token(LBRACKET);
          Expression();
          jj_consume_token(RBRACKET);
                         jjtree.closeNodeScope(jjtn000, true);
                         jjtc000 = false;
                         jjtn000.jjtSetLastToken(getToken(0));
                        jjtn000.setIsArrayDereference();
          break;
        case DOT:
          jj_consume_token(DOT);
          t = jj_consume_token(IDENTIFIER);
                       jjtree.closeNodeScope(jjtn000, true);
                       jjtc000 = false;
                       jjtn000.jjtSetLastToken(getToken(0));
                      jjtn000.setImage(t.image);
          break;
        case LPAREN:
          Arguments();
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
                jjtn000.jjtSetLastToken(getToken(0));
               jjtn000.setIsArguments();
          break;
        default:
          jj_la1[127] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Literal() throws ParseException {
 /*@bgen(jjtree) Literal */
  ASTLiteral jjtn000 = new ASTLiteral(this, JJTLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      switch (jj_nt.kind) {
      case INTEGER_LITERAL:
        t = jj_consume_token(INTEGER_LITERAL);
                        jjtree.closeNodeScope(jjtn000, true);
                        jjtc000 = false;
                        jjtn000.jjtSetLastToken(getToken(0));
                        checkForBadNumericalLiteralslUsage(t); jjtn000.setImage(t.image); jjtn000.setIntLiteral();
        break;
      case FLOATING_POINT_LITERAL:
        t = jj_consume_token(FLOATING_POINT_LITERAL);
                               jjtree.closeNodeScope(jjtn000, true);
                               jjtc000 = false;
                               jjtn000.jjtSetLastToken(getToken(0));
                               checkForBadNumericalLiteralslUsage(t); jjtn000.setImage(t.image); jjtn000.setFloatLiteral();
        break;
      case HEX_FLOATING_POINT_LITERAL:
        t = jj_consume_token(HEX_FLOATING_POINT_LITERAL);
                                   jjtree.closeNodeScope(jjtn000, true);
                                   jjtc000 = false;
                                   jjtn000.jjtSetLastToken(getToken(0));
                                   checkForBadHexFloatingPointLiteral(); checkForBadNumericalLiteralslUsage(t); jjtn000.setImage(t.image); jjtn000.setFloatLiteral();
        break;
      case CHARACTER_LITERAL:
        t = jj_consume_token(CHARACTER_LITERAL);
                          jjtree.closeNodeScope(jjtn000, true);
                          jjtc000 = false;
                          jjtn000.jjtSetLastToken(getToken(0));
                         jjtn000.setImage(t.image); jjtn000.setCharLiteral();
        break;
      case STRING_LITERAL:
        t = jj_consume_token(STRING_LITERAL);
                       jjtree.closeNodeScope(jjtn000, true);
                       jjtc000 = false;
                       jjtn000.jjtSetLastToken(getToken(0));
                      jjtn000.setImage(t.image); checkForNewStringSpaceEscape(t.image); jjtn000.setStringLiteral();
        break;
      case TEXT_BLOCK_LITERAL:
        t = jj_consume_token(TEXT_BLOCK_LITERAL);
                           jjtree.closeNodeScope(jjtn000, true);
                           jjtc000 = false;
                           jjtn000.jjtSetLastToken(getToken(0));
                           checkForTextBlockLiteral(); checkForNewStringSpaceEscape(t.image); jjtn000.setImage(t.image); jjtn000.setStringLiteral();
        break;
      case FALSE:
      case TRUE:
        BooleanLiteral();
        break;
      case NULL:
        NullLiteral();
        break;
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void BooleanLiteral() throws ParseException {
 /*@bgen(jjtree) BooleanLiteral */
  ASTBooleanLiteral jjtn000 = new ASTBooleanLiteral(this, JJTBOOLEANLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case TRUE:
        jj_consume_token(TRUE);
           jjtree.closeNodeScope(jjtn000, true);
           jjtc000 = false;
           jjtn000.jjtSetLastToken(getToken(0));
           jjtn000.setTrue();
        break;
      case FALSE:
        jj_consume_token(FALSE);
        break;
      default:
        jj_la1[129] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void NullLiteral() throws ParseException {
 /*@bgen(jjtree) NullLiteral */
  ASTNullLiteral jjtn000 = new ASTNullLiteral(this, JJTNULLLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(NULL);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Arguments() throws ParseException {
 /*@bgen(jjtree) Arguments */
  ASTArguments jjtn000 = new ASTArguments(this, JJTARGUMENTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LPAREN);
      if (jj_2_76(1)) {
        ArgumentList();
      } else {
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ArgumentList() throws ParseException {
 /*@bgen(jjtree) ArgumentList */
  ASTArgumentList jjtn000 = new ASTArgumentList(this, JJTARGUMENTLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      Expression();
      label_70:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[130] = jj_gen;
          break label_70;
        }
        jj_consume_token(COMMA);
        Expression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void AllocationExpression() throws ParseException {
 /*@bgen(jjtree) AllocationExpression */
  ASTAllocationExpression jjtn000 = new ASTAllocationExpression(this, JJTALLOCATIONEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(NEW);
      label_71:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[131] = jj_gen;
          break label_71;
        }
        TypeAnnotation();
      }
      if (jj_2_77(2)) {
        PrimitiveType();
        ArrayDimsAndInits();
      } else {
        switch (jj_nt.kind) {
        case IDENTIFIER:
          ClassOrInterfaceType();
          switch (jj_nt.kind) {
          case LBRACKET:
          case AT:
            ArrayDimsAndInits();
            break;
          case LPAREN:
            Arguments();
            switch (jj_nt.kind) {
            case LBRACE:
              boolean inInterfaceOld = inInterface; inInterface = false; /* a anonymous class is not a interface */
              ClassOrInterfaceBody();
              inInterface = inInterfaceOld;
              break;
            default:
              jj_la1[132] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[133] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      jjtn000.jjtSetLastToken(getToken(0));
      checkForBadAnonymousDiamondUsage();
          break;
        default:
          jj_la1[134] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

/*
 * The second LOOKAHEAD specification below is to parse to PrimarySuffix
 * if there is an expression between the "[...]".
 */
  final public void ArrayDimsAndInits() throws ParseException {
 /*@bgen(jjtree) ArrayDimsAndInits */
  ASTArrayDimsAndInits jjtn000 = new ASTArrayDimsAndInits(this, JJTARRAYDIMSANDINITS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_80(2)) {
        label_72:
        while (true) {
          label_73:
          while (true) {
            switch (jj_nt.kind) {
            case AT:
              ;
              break;
            default:
              jj_la1[135] = jj_gen;
              break label_73;
            }
            TypeAnnotation();
          }
          jj_consume_token(LBRACKET);
          Expression();
          jj_consume_token(RBRACKET);
                                                           jjtn000.bumpArrayDepth();
          if (jj_2_78(2)) {
            ;
          } else {
            break label_72;
          }
        }
        label_74:
        while (true) {
          if (jj_2_79(2)) {
            ;
          } else {
            break label_74;
          }
          jj_consume_token(LBRACKET);
          jj_consume_token(RBRACKET);
                                                                                                                jjtn000.bumpArrayDepth();
        }
      } else {
        switch (jj_nt.kind) {
        case LBRACKET:
          label_75:
          while (true) {
            jj_consume_token(LBRACKET);
            jj_consume_token(RBRACKET);
             jjtn000.bumpArrayDepth();
            switch (jj_nt.kind) {
            case LBRACKET:
              ;
              break;
            default:
              jj_la1[136] = jj_gen;
              break label_75;
            }
          }
          ArrayInitializer();
          break;
        default:
          jj_la1[137] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

/*
 * Statement syntax follows.
 */
  final public void Statement() throws ParseException {
 /*@bgen(jjtree) Statement */
  ASTStatement jjtn000 = new ASTStatement(this, JJTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (isNextTokenAnAssert()) {
        AssertStatement();
      } else if (isYieldStart()) {
        YieldStatement();
      } else if (jj_2_81(2)) {
        LabeledStatement();
      } else {
        switch (jj_nt.kind) {
        case LBRACE:
          Block();
          break;
        case SEMICOLON:
          EmptyStatement();
          break;
        default:
          jj_la1[138] = jj_gen;
          if (jj_2_82(1)) {
            StatementExpression();
            jj_consume_token(SEMICOLON);
          } else {
            switch (jj_nt.kind) {
            case SWITCH:
              SwitchStatement();
              break;
            case IF:
              IfStatement();
              break;
            case WHILE:
              WhileStatement();
              break;
            case DO:
              DoStatement();
              break;
            case FOR:
              ForStatement();
              break;
            case BREAK:
              BreakStatement();
              break;
            case CONTINUE:
              ContinueStatement();
              break;
            case RETURN:
              ReturnStatement();
              break;
            case THROW:
              ThrowStatement();
              break;
            case SYNCHRONIZED:
              SynchronizedStatement();
              break;
            case TRY:
              TryStatement();
              break;
            default:
              jj_la1[139] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void LabeledStatement() throws ParseException {
 /*@bgen(jjtree) LabeledStatement */
 ASTLabeledStatement jjtn000 = new ASTLabeledStatement(this, JJTLABELEDSTATEMENT);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
                  jjtn000.setImage(t.image);
      jj_consume_token(COLON);
      Statement();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void Block() throws ParseException {
 /*@bgen(jjtree) Block */
 ASTBlock jjtn000 = new ASTBlock(this, JJTBLOCK);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      jj_consume_token(LBRACE);
      label_76:
      while (true) {
        if (jj_2_83(1)) {
          ;
        } else {
          break label_76;
        }
        BlockStatement();
      }
      t = jj_consume_token(RBRACE);
                                      jjtree.closeNodeScope(jjtn000, true);
                                      jjtc000 = false;
                                      jjtn000.jjtSetLastToken(getToken(0));
                                      if (isPrecededByComment(t)) { jjtn000.setContainsComment(); }
    } catch (Throwable jjte000) {
        if (jjtc000) {
          jjtree.clearNodeScope(jjtn000);
          jjtc000 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte000 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte000;}
        }
        if (jjte000 instanceof ParseException) {
          {if (true) throw (ParseException)jjte000;}
        }
        {if (true) throw (Error)jjte000;}
    } finally {
        if (jjtc000) {
          jjtree.closeNodeScope(jjtn000, true);
          jjtn000.jjtSetLastToken(getToken(0));
        }
    }
  }

  final public void BlockStatement() throws ParseException {
 /*@bgen(jjtree) BlockStatement */
 ASTBlockStatement jjtn000 = new ASTBlockStatement(this, JJTBLOCKSTATEMENT);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));int mods = 0;
    try {
      if (isNextTokenAnAssert()) {
        AssertStatement();
      } else if (isYieldStart()) {
        YieldStatement();
      } else if (jj_2_85(2147483647)) {
        // this eagerly parses all modifiers and annotations. After that, either a local type declaration
            // or a local variable declaration follows.
            // This allows more modifiers for local variables than actually allowed
            // and the annotations for local variables need to be moved in the AST down again.
            mods = Modifiers();
        if (localTypeDeclLookahead()) {
          LocalTypeDecl(mods);
        } else if (jj_2_84(1)) {
            List<Node> annotationsAndChildren = new ArrayList<Node>();
            if (jjtree.nodeArity() > 0) { // peekNode would throw if the stack is empty
                while (jjtree.peekNode() instanceof ASTAnnotation) {
                  annotationsAndChildren.add(jjtree.popNode());
                }
            }
          LocalVariableDeclaration();
            ASTLocalVariableDeclaration localVarDecl = (ASTLocalVariableDeclaration) jjtree.peekNode();
            if ((mods & AccessNode.FINAL) == AccessNode.FINAL) {
                localVarDecl.setFinal(true);
            }
            if (!annotationsAndChildren.isEmpty()) {
                Collections.reverse(annotationsAndChildren);
                for (int i = 0; i < localVarDecl.getNumChildren(); i++) {
                    annotationsAndChildren.add(localVarDecl.getChild(i));
                }
                for (int i = 0; i < annotationsAndChildren.size(); i++) {
                    Node child = annotationsAndChildren.get(i);
                    child.jjtSetParent(localVarDecl);
                    localVarDecl.jjtAddChild(child, i);
                }
            }
          jj_consume_token(SEMICOLON);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else if (classModifierForLocalTypesLookahead() || localTypeDeclLookahead()) {
        mods = Modifiers();
        LocalTypeDecl(mods);
      } else if (jj_2_86(2147483647)) {
        LocalVariableDeclaration();
        jj_consume_token(SEMICOLON);
      } else if (jj_2_87(1)) {
        Statement();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void LocalTypeDecl(int mods) throws ParseException {
    if (jj_2_88(2147483647)) {
      ClassOrInterfaceDeclaration(mods);
    } else if (jj_2_89(2147483647)) {
      ClassOrInterfaceDeclaration(mods);
                                                                     checkForLocalInterfaceOrEnumType();
    } else if (isKeyword("record")) {
      RecordDeclaration(mods);
                                                                     checkForLocalInterfaceOrEnumType();
    } else if (isKeyword("enum")) {
      EnumDeclaration(mods);
                                                                 checkForLocalInterfaceOrEnumType();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
 * See https://docs.oracle.com/javase/specs/jls/se10/html/jls-14.html#jls-14.4
 */
  final public void LocalVariableDeclaration() throws ParseException {
 /*@bgen(jjtree) LocalVariableDeclaration */
  ASTLocalVariableDeclaration jjtn000 = new ASTLocalVariableDeclaration(this, JJTLOCALVARIABLEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      label_77:
      while (true) {
        switch (jj_nt.kind) {
        case FINAL:
        case AT:
          ;
          break;
        default:
          jj_la1[140] = jj_gen;
          break label_77;
        }
        switch (jj_nt.kind) {
        case FINAL:
          jj_consume_token(FINAL);
             jjtn000.setFinal(true);
          break;
        case AT:
          Annotation();
          break;
        default:
          jj_la1[141] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      LocalVariableType();
      VariableDeclarator();
      label_78:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[142] = jj_gen;
          break label_78;
        }
        jj_consume_token(COMMA);
        VariableDeclarator();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void LocalVariableType() throws ParseException {
    if (jdkVersion >= 10 && isKeyword("var")) {
      jj_consume_token(IDENTIFIER);
    } else {
      switch (jj_nt.kind) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case IDENTIFIER:
        Type();
        break;
      default:
        jj_la1[143] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void EmptyStatement() throws ParseException {
 /*@bgen(jjtree) EmptyStatement */
  ASTEmptyStatement jjtn000 = new ASTEmptyStatement(this, JJTEMPTYSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(SEMICOLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void StatementExpression() throws ParseException {
 /*@bgen(jjtree) StatementExpression */
  ASTStatementExpression jjtn000 = new ASTStatementExpression(this, JJTSTATEMENTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case INCR:
        PreIncrementExpression();
        break;
      case DECR:
        PreDecrementExpression();
        break;
      default:
        jj_la1[145] = jj_gen;
        if (jj_2_90(1)) {
          PostfixExpression();
          switch (jj_nt.kind) {
          case ASSIGN:
          case PLUSASSIGN:
          case MINUSASSIGN:
          case STARASSIGN:
          case SLASHASSIGN:
          case ANDASSIGN:
          case ORASSIGN:
          case XORASSIGN:
          case REMASSIGN:
          case LSHIFTASSIGN:
          case RSIGNEDSHIFTASSIGN:
          case RUNSIGNEDSHIFTASSIGN:
            AssignmentOperator();
            Expression();
            break;
          default:
            jj_la1[144] = jj_gen;
            ;
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void SwitchStatement() throws ParseException {
 /*@bgen(jjtree) SwitchStatement */
  ASTSwitchStatement jjtn000 = new ASTSwitchStatement(this, JJTSWITCHSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(SWITCH);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      SwitchBlock();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void SwitchBlock() throws ParseException {
    jj_consume_token(LBRACE);
    switch (jj_nt.kind) {
    case CASE:
    case _DEFAULT:
      SwitchLabel();
      switch (jj_nt.kind) {
      case LAMBDA:
        jj_consume_token(LAMBDA);
        SwitchLabeledRulePart();
        label_79:
        while (true) {
          switch (jj_nt.kind) {
          case CASE:
          case _DEFAULT:
            ;
            break;
          default:
            jj_la1[146] = jj_gen;
            break label_79;
          }
          SwitchLabeledRule();
        }
        break;
      case COLON:
        jj_consume_token(COLON);
        label_80:
        while (true) {
          if (jj_2_91(2)) {
            ;
          } else {
            break label_80;
          }
          SwitchLabel();
          jj_consume_token(COLON);
        }
        label_81:
        while (true) {
          if (shouldStartStatementInSwitch()) {
            ;
          } else {
            break label_81;
          }
          BlockStatement();
        }
        label_82:
        while (true) {
          switch (jj_nt.kind) {
          case CASE:
          case _DEFAULT:
            ;
            break;
          default:
            jj_la1[147] = jj_gen;
            break label_82;
          }
          SwitchLabeledStatementGroup();
        }
        break;
      default:
        jj_la1[148] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[149] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
  }

  final public void SwitchLabeledRule() throws ParseException {
 checkForSwitchRules();
    SwitchLabel();
    jj_consume_token(LAMBDA);
    SwitchLabeledRulePart();
  }

  final public void SwitchLabeledRulePart() throws ParseException {
 checkForSwitchRules();
    if (jj_2_92(1)) {
          ASTSwitchLabeledExpression jjtn001 = new ASTSwitchLabeledExpression(this, JJTSWITCHLABELEDEXPRESSION);
          boolean jjtc001 = true;
          jjtree.openNodeScope(jjtn001);
          jjtn001.jjtSetFirstToken(getToken(1));
      try {
        Expression();
        jj_consume_token(SEMICOLON);
      } catch (Throwable jjte001) {
          if (jjtc001) {
            jjtree.clearNodeScope(jjtn001);
            jjtc001 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte001 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte001;}
          }
          if (jjte001 instanceof ParseException) {
            {if (true) throw (ParseException)jjte001;}
          }
          {if (true) throw (Error)jjte001;}
      } finally {
          if (jjtc001) {
            jjtree.closeNodeScope(jjtn001,  2);
            jjtn001.jjtSetLastToken(getToken(0));
          }
      }
    } else {
      switch (jj_nt.kind) {
      case LBRACE:
          ASTSwitchLabeledBlock jjtn002 = new ASTSwitchLabeledBlock(this, JJTSWITCHLABELEDBLOCK);
          boolean jjtc002 = true;
          jjtree.openNodeScope(jjtn002);
          jjtn002.jjtSetFirstToken(getToken(1));
        try {
          Block();
        } catch (Throwable jjte002) {
          if (jjtc002) {
            jjtree.clearNodeScope(jjtn002);
            jjtc002 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte002 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte002;}
          }
          if (jjte002 instanceof ParseException) {
            {if (true) throw (ParseException)jjte002;}
          }
          {if (true) throw (Error)jjte002;}
        } finally {
          if (jjtc002) {
            jjtree.closeNodeScope(jjtn002,  2);
            jjtn002.jjtSetLastToken(getToken(0));
          }
        }
        break;
      case THROW:
          ASTSwitchLabeledThrowStatement jjtn003 = new ASTSwitchLabeledThrowStatement(this, JJTSWITCHLABELEDTHROWSTATEMENT);
          boolean jjtc003 = true;
          jjtree.openNodeScope(jjtn003);
          jjtn003.jjtSetFirstToken(getToken(1));
        try {
          ThrowStatement();
        } catch (Throwable jjte003) {
          if (jjtc003) {
            jjtree.clearNodeScope(jjtn003);
            jjtc003 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte003 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte003;}
          }
          if (jjte003 instanceof ParseException) {
            {if (true) throw (ParseException)jjte003;}
          }
          {if (true) throw (Error)jjte003;}
        } finally {
          if (jjtc003) {
            jjtree.closeNodeScope(jjtn003,  2);
            jjtn003.jjtSetLastToken(getToken(0));
          }
        }
        break;
      default:
        jj_la1[150] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

// For PMD 7, make this a real node to group the labels + statements
  final public void SwitchLabeledStatementGroup() throws ParseException {
    label_83:
    while (true) {
      SwitchLabel();
      jj_consume_token(COLON);
      if (jj_2_93(2)) {
        ;
      } else {
        break label_83;
      }
    }
    label_84:
    while (true) {
      if (shouldStartStatementInSwitch()) {
        ;
      } else {
        break label_84;
      }
      BlockStatement();
    }
  }

  final public void SwitchLabel() throws ParseException {
 /*@bgen(jjtree) SwitchLabel */
  ASTSwitchLabel jjtn000 = new ASTSwitchLabel(this, JJTSWITCHLABEL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
  inSwitchLabel = true;
      switch (jj_nt.kind) {
      case CASE:
        jj_consume_token(CASE);
        CaseLabelElement(jjtn000);
        label_85:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[151] = jj_gen;
            break label_85;
          }
                                      checkForMultipleCaseLabels();
          jj_consume_token(COMMA);
          CaseLabelElement(jjtn000);
        }
        break;
      case _DEFAULT:
        jj_consume_token(_DEFAULT);
             jjtn000.setDefault();
        break;
      default:
        jj_la1[152] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
  jjtree.closeNodeScope(jjtn000, true);
  jjtc000 = false;
  jjtn000.jjtSetLastToken(getToken(0));
  inSwitchLabel = false;
    } catch (Throwable jjte000) {
  if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof ParseException) {
    {if (true) throw (ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
  if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true);
    jjtn000.jjtSetLastToken(getToken(0));
  }
    }
  }

  final public void CaseLabelElement(ASTSwitchLabel label) throws ParseException {
    switch (jj_nt.kind) {
    case _DEFAULT:
      jj_consume_token(_DEFAULT);
               label.setDefault(); checkForDefaultCaseLabel();
      break;
    default:
      jj_la1[153] = jj_gen;
      if (jj_2_94(2147483647)) {
        Pattern();
                                    checkForPatternMatchingInSwitch();
      } else if (jj_2_95(1)) {
      ASTExpression jjtn001 = new ASTExpression(this, JJTEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      jjtn001.jjtSetFirstToken(getToken(1));
        try {
          ConditionalExpression();
        } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
        } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
        jjtn001.jjtSetLastToken(getToken(0));
      }
        }
            if ("null".equals(((ASTExpression) jjtree.peekNode()).jjtGetFirstToken().getImage())) {
                checkForNullCaseLabel();
            }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void YieldStatement() throws ParseException {
 /*@bgen(jjtree) YieldStatement */
  ASTYieldStatement jjtn000 = new ASTYieldStatement(this, JJTYIELDSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));checkForYieldStatement();
    try {
      jj_consume_token(IDENTIFIER);
      Expression();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void IfStatement() throws ParseException {
 /*@bgen(jjtree) IfStatement */
  ASTIfStatement jjtn000 = new ASTIfStatement(this, JJTIFSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(IF);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      Statement();
      switch (jj_nt.kind) {
      case ELSE:
        jj_consume_token(ELSE);
                                                               jjtn000.setHasElse();
        Statement();
        break;
      default:
        jj_la1[154] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void WhileStatement() throws ParseException {
 /*@bgen(jjtree) WhileStatement */
  ASTWhileStatement jjtn000 = new ASTWhileStatement(this, JJTWHILESTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      Statement();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void DoStatement() throws ParseException {
 /*@bgen(jjtree) DoStatement */
  ASTDoStatement jjtn000 = new ASTDoStatement(this, JJTDOSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(DO);
      Statement();
      jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ForStatement() throws ParseException {
 /*@bgen(jjtree) ForStatement */
  ASTForStatement jjtn000 = new ASTForStatement(this, JJTFORSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(FOR);
      jj_consume_token(LPAREN);
      if (jj_2_99(2147483647)) {
       checkForBadJDK15ForLoopSyntaxArgumentsUsage();
        LocalVariableDeclaration();
        jj_consume_token(COLON);
        Expression();
      } else if (jj_2_100(1)) {
        if (jj_2_96(1)) {
          ForInit();
        } else {
          ;
        }
        jj_consume_token(SEMICOLON);
        if (jj_2_97(1)) {
          Expression();
        } else {
          ;
        }
        jj_consume_token(SEMICOLON);
        if (jj_2_98(1)) {
          ForUpdate();
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
      Statement();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ForInit() throws ParseException {
 /*@bgen(jjtree) ForInit */
  ASTForInit jjtn000 = new ASTForInit(this, JJTFORINIT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_101(2147483647)) {
        LocalVariableDeclaration();
      } else if (jj_2_102(1)) {
        StatementExpressionList();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void StatementExpressionList() throws ParseException {
 /*@bgen(jjtree) StatementExpressionList */
  ASTStatementExpressionList jjtn000 = new ASTStatementExpressionList(this, JJTSTATEMENTEXPRESSIONLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      StatementExpression();
      label_86:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[155] = jj_gen;
          break label_86;
        }
        jj_consume_token(COMMA);
        StatementExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ForUpdate() throws ParseException {
 /*@bgen(jjtree) ForUpdate */
  ASTForUpdate jjtn000 = new ASTForUpdate(this, JJTFORUPDATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      StatementExpressionList();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void BreakStatement() throws ParseException {
 /*@bgen(jjtree) BreakStatement */
 ASTBreakStatement jjtn000 = new ASTBreakStatement(this, JJTBREAKSTATEMENT);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      jj_consume_token(BREAK);
      switch (jj_nt.kind) {
      case IDENTIFIER:
        t = jj_consume_token(IDENTIFIER);
                            jjtn000.setImage(t.image);
        break;
      default:
        jj_la1[156] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ContinueStatement() throws ParseException {
 /*@bgen(jjtree) ContinueStatement */
 ASTContinueStatement jjtn000 = new ASTContinueStatement(this, JJTCONTINUESTATEMENT);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      jj_consume_token(CONTINUE);
      switch (jj_nt.kind) {
      case IDENTIFIER:
        t = jj_consume_token(IDENTIFIER);
                               jjtn000.setImage(t.image);
        break;
      default:
        jj_la1[157] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ReturnStatement() throws ParseException {
 /*@bgen(jjtree) ReturnStatement */
  ASTReturnStatement jjtn000 = new ASTReturnStatement(this, JJTRETURNSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(RETURN);
      if (jj_2_103(1)) {
        Expression();
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ThrowStatement() throws ParseException {
 /*@bgen(jjtree) ThrowStatement */
  ASTThrowStatement jjtn000 = new ASTThrowStatement(this, JJTTHROWSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(THROW);
      Expression();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void SynchronizedStatement() throws ParseException {
 /*@bgen(jjtree) SynchronizedStatement */
  ASTSynchronizedStatement jjtn000 = new ASTSynchronizedStatement(this, JJTSYNCHRONIZEDSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(SYNCHRONIZED);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void TryStatement() throws ParseException {
 /*@bgen(jjtree) TryStatement */
  ASTTryStatement jjtn000 = new ASTTryStatement(this, JJTTRYSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(TRY);
      switch (jj_nt.kind) {
      case LPAREN:
        ResourceSpecification();
        break;
      default:
        jj_la1[158] = jj_gen;
        ;
      }
      Block();
      label_87:
      while (true) {
        switch (jj_nt.kind) {
        case CATCH:
          ;
          break;
        default:
          jj_la1[159] = jj_gen;
          break label_87;
        }
        CatchStatement();
      }
      switch (jj_nt.kind) {
      case FINALLY:
        FinallyStatement();
        break;
      default:
        jj_la1[160] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ResourceSpecification() throws ParseException {
 /*@bgen(jjtree) ResourceSpecification */
  ASTResourceSpecification jjtn000 = new ASTResourceSpecification(this, JJTRESOURCESPECIFICATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
     checkForBadTryWithResourcesUsage();
      jj_consume_token(LPAREN);
      Resources();
      if (jj_2_104(2)) {
        jj_consume_token(SEMICOLON);
      } else {
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void Resources() throws ParseException {
 /*@bgen(jjtree) Resources */
  ASTResources jjtn000 = new ASTResources(this, JJTRESOURCES);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      Resource();
      label_88:
      while (true) {
        if (jj_2_105(2)) {
          ;
        } else {
          break label_88;
        }
        jj_consume_token(SEMICOLON);
        Resource();
      }
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
            jjtn000.jjtSetLastToken(getToken(0));
          }
    }
  }

  final public void Resource() throws ParseException {
 /*@bgen(jjtree) Resource */
  ASTResource jjtn000 = new ASTResource(this, JJTRESOURCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_106(2147483647)) {
        switch (jj_nt.kind) {
        case IDENTIFIER:
        checkForBadConciseTryWithResourcesUsage();
          Name();
          break;
        case THIS:
          jj_consume_token(THIS);
          jj_consume_token(DOT);
          Name();
          break;
        default:
          jj_la1[161] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else if (jj_2_107(1)) {
        label_89:
        while (true) {
          switch (jj_nt.kind) {
          case FINAL:
          case AT:
            ;
            break;
          default:
            jj_la1[162] = jj_gen;
            break label_89;
          }
          switch (jj_nt.kind) {
          case FINAL:
            jj_consume_token(FINAL);
                jjtn000.setFinal(true);
            break;
          case AT:
            Annotation();
            break;
          default:
            jj_la1[163] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        LocalVariableType();
        VariableDeclaratorId();
        jj_consume_token(ASSIGN);
        Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void CatchStatement() throws ParseException {
 /*@bgen(jjtree) CatchStatement */
  ASTCatchStatement jjtn000 = new ASTCatchStatement(this, JJTCATCHSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(CATCH);
      jj_consume_token(LPAREN);
      FormalParameter();
      jj_consume_token(RPAREN);
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void FinallyStatement() throws ParseException {
 /*@bgen(jjtree) FinallyStatement */
  ASTFinallyStatement jjtn000 = new ASTFinallyStatement(this, JJTFINALLYSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(FINALLY);
      Block();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void AssertStatement() throws ParseException {
 /*@bgen(jjtree) AssertStatement */
    ASTAssertStatement jjtn000 = new ASTAssertStatement(this, JJTASSERTSTATEMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));if (jdkVersion <= 3) {
        throw new ParseException("Can't use 'assert' as a keyword when running in JDK 1.3 mode!");
    }
    try {
      jj_consume_token(IDENTIFIER);
      Expression();
      switch (jj_nt.kind) {
      case COLON:
        jj_consume_token(COLON);
        Expression();
        break;
      default:
        jj_la1[164] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

/* We use productions to match >>>, >> and > so that we can keep the
 * type declaration syntax with generics clean
 */
  final public void RUNSIGNEDSHIFT() throws ParseException {
 /*@bgen(jjtree) RUNSIGNEDSHIFT */
  ASTRUNSIGNEDSHIFT jjtn000 = new ASTRUNSIGNEDSHIFT(this, JJTRUNSIGNEDSHIFT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (getToken(1).kind == GT &&
                      ((Token.GTToken)getToken(1)).realKind == RUNSIGNEDSHIFT) {

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(GT);
      jj_consume_token(GT);
      jj_consume_token(GT);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void RSIGNEDSHIFT() throws ParseException {
 /*@bgen(jjtree) RSIGNEDSHIFT */
  ASTRSIGNEDSHIFT jjtn000 = new ASTRSIGNEDSHIFT(this, JJTRSIGNEDSHIFT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (getToken(1).kind == GT &&
                      ((Token.GTToken)getToken(1)).realKind == RSIGNEDSHIFT) {

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(GT);
      jj_consume_token(GT);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

/* Annotation syntax follows. */
  final public void Annotation() throws ParseException {
 /*@bgen(jjtree) Annotation */
  ASTAnnotation jjtn000 = new ASTAnnotation(this, JJTANNOTATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_108(2147483647)) {
        NormalAnnotation();
      } else if (jj_2_109(2147483647)) {
        SingleMemberAnnotation();
      } else {
        switch (jj_nt.kind) {
        case AT:
          MarkerAnnotation();
          break;
        default:
          jj_la1[165] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void NormalAnnotation() throws ParseException {
 /*@bgen(jjtree) NormalAnnotation */
  ASTNormalAnnotation jjtn000 = new ASTNormalAnnotation(this, JJTNORMALANNOTATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(AT);
      Name();
      jj_consume_token(LPAREN);
      switch (jj_nt.kind) {
      case IDENTIFIER:
        MemberValuePairs();
        break;
      default:
        jj_la1[166] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
                                               jjtree.closeNodeScope(jjtn000, true);
                                               jjtc000 = false;
                                               jjtn000.jjtSetLastToken(getToken(0));
                                              checkForBadAnnotationUsage();
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void MarkerAnnotation() throws ParseException {
 /*@bgen(jjtree) MarkerAnnotation */
  ASTMarkerAnnotation jjtn000 = new ASTMarkerAnnotation(this, JJTMARKERANNOTATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(AT);
      Name();
               jjtree.closeNodeScope(jjtn000, true);
               jjtc000 = false;
               jjtn000.jjtSetLastToken(getToken(0));
              checkForBadAnnotationUsage();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void SingleMemberAnnotation() throws ParseException {
 /*@bgen(jjtree) SingleMemberAnnotation */
  ASTSingleMemberAnnotation jjtn000 = new ASTSingleMemberAnnotation(this, JJTSINGLEMEMBERANNOTATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(AT);
      Name();
      jj_consume_token(LPAREN);
      MemberValue();
      jj_consume_token(RPAREN);
                                     jjtree.closeNodeScope(jjtn000, true);
                                     jjtc000 = false;
                                     jjtn000.jjtSetLastToken(getToken(0));
                                    checkForBadAnnotationUsage();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void MemberValuePairs() throws ParseException {
 /*@bgen(jjtree) MemberValuePairs */
  ASTMemberValuePairs jjtn000 = new ASTMemberValuePairs(this, JJTMEMBERVALUEPAIRS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      MemberValuePair();
      label_90:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[167] = jj_gen;
          break label_90;
        }
        jj_consume_token(COMMA);
        MemberValuePair();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void MemberValuePair() throws ParseException {
 /*@bgen(jjtree) MemberValuePair */
 ASTMemberValuePair jjtn000 = new ASTMemberValuePair(this, JJTMEMBERVALUEPAIR);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);
 jjtn000.jjtSetFirstToken(getToken(1));Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
                     jjtn000.setImage(t.image);
      jj_consume_token(ASSIGN);
      MemberValue();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

  final public void MemberValue() throws ParseException {
 /*@bgen(jjtree) MemberValue */
  ASTMemberValue jjtn000 = new ASTMemberValue(this, JJTMEMBERVALUE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      switch (jj_nt.kind) {
      case AT:
        Annotation();
        break;
      case LBRACE:
        MemberValueArrayInitializer();
        break;
      default:
        jj_la1[168] = jj_gen;
        if (jj_2_110(1)) {
          ConditionalExpression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof ParseException) {
       {if (true) throw (ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
       jjtn000.jjtSetLastToken(getToken(0));
     }
    }
  }

  final public void MemberValueArrayInitializer() throws ParseException {
 /*@bgen(jjtree) MemberValueArrayInitializer */
  ASTMemberValueArrayInitializer jjtn000 = new ASTMemberValueArrayInitializer(this, JJTMEMBERVALUEARRAYINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LBRACE);
      if (jj_2_112(1)) {
        MemberValue();
        label_91:
        while (true) {
          if (jj_2_111(2)) {
            ;
          } else {
            break label_91;
          }
          jj_consume_token(COMMA);
          MemberValue();
        }
        switch (jj_nt.kind) {
        case COMMA:
          jj_consume_token(COMMA);
          break;
        default:
          jj_la1[169] = jj_gen;
          ;
        }
      } else {
        ;
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

/*
 * We use that ghost production to factorise the check for JDK >= 1.8.
 */
  final public void TypeAnnotation() throws ParseException {
    Annotation();
                  checkForBadTypeAnnotations();
  }

/* Annotation Types. */
  final public void AnnotationTypeDeclaration(int modifiers) throws ParseException {
 /*@bgen(jjtree) AnnotationTypeDeclaration */
ASTAnnotationTypeDeclaration jjtn000 = new ASTAnnotationTypeDeclaration(this, JJTANNOTATIONTYPEDECLARATION);
boolean jjtc000 = true;
jjtree.openNodeScope(jjtn000);
jjtn000.jjtSetFirstToken(getToken(1));Token t;
jjtn000.setModifiers(modifiers);
    try {
      jj_consume_token(AT);
      jj_consume_token(INTERFACE);
      t = jj_consume_token(IDENTIFIER);
        checkForBadAnnotationUsage();
        checkForBadTypeIdentifierUsage(t.image);
        jjtn000.setImage(t.image);
      AnnotationTypeBody();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void AnnotationTypeBody() throws ParseException {
 /*@bgen(jjtree) AnnotationTypeBody */
  ASTAnnotationTypeBody jjtn000 = new ASTAnnotationTypeBody(this, JJTANNOTATIONTYPEBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(LBRACE);
      label_92:
      while (true) {
        if (jj_2_113(1)) {
          ;
        } else {
          break label_92;
        }
        AnnotationTypeMemberDeclaration();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void AnnotationTypeMemberDeclaration() throws ParseException {
 /*@bgen(jjtree) AnnotationTypeMemberDeclaration */
   ASTAnnotationTypeMemberDeclaration jjtn000 = new ASTAnnotationTypeMemberDeclaration(this, JJTANNOTATIONTYPEMEMBERDECLARATION);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000);
   jjtn000.jjtSetFirstToken(getToken(1));int modifiers;
    try {
      if (jj_2_116(1)) {
        modifiers = Modifiers();
        if (jj_2_114(2147483647)) {
          AnnotationMethodDeclaration(modifiers);
        } else {
          switch (jj_nt.kind) {
          case CLASS:
          case INTERFACE:
            ClassOrInterfaceDeclaration(modifiers);
            break;
          default:
            jj_la1[170] = jj_gen;
            if (jj_2_115(3)) {
              EnumDeclaration(modifiers);
            } else {
              switch (jj_nt.kind) {
              case AT:
                AnnotationTypeDeclaration(modifiers);
                break;
              case BOOLEAN:
              case BYTE:
              case CHAR:
              case DOUBLE:
              case FLOAT:
              case INT:
              case LONG:
              case SHORT:
              case IDENTIFIER:
                FieldDeclaration(modifiers);
                break;
              default:
                jj_la1[171] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      } else {
        switch (jj_nt.kind) {
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          break;
        default:
          jj_la1[172] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } catch (Throwable jjte000) {
   if (jjtc000) {
     jjtree.clearNodeScope(jjtn000);
     jjtc000 = false;
   } else {
     jjtree.popNode();
   }
   if (jjte000 instanceof RuntimeException) {
     {if (true) throw (RuntimeException)jjte000;}
   }
   if (jjte000 instanceof ParseException) {
     {if (true) throw (ParseException)jjte000;}
   }
   {if (true) throw (Error)jjte000;}
    } finally {
   if (jjtc000) {
     jjtree.closeNodeScope(jjtn000, true);
     jjtn000.jjtSetLastToken(getToken(0));
   }
    }
  }

  final public void AnnotationMethodDeclaration(int modifiers) throws ParseException {
 /*@bgen(jjtree) AnnotationMethodDeclaration */
  ASTAnnotationMethodDeclaration jjtn000 = new ASTAnnotationMethodDeclaration(this, JJTANNOTATIONMETHODDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));Token t;
  jjtn000.setModifiers(modifiers);
    try {
      Type();
      t = jj_consume_token(IDENTIFIER);
      jj_consume_token(LPAREN);
      jj_consume_token(RPAREN);
      switch (jj_nt.kind) {
      case _DEFAULT:
        DefaultValue();
        break;
      default:
        jj_la1[173] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
    jjtn000.setImage(t.image);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void DefaultValue() throws ParseException {
 /*@bgen(jjtree) DefaultValue */
  ASTDefaultValue jjtn000 = new ASTDefaultValue(this, JJTDEFAULTVALUE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      jj_consume_token(_DEFAULT);
      MemberValue();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ModuleDeclaration() throws ParseException {
 /*@bgen(jjtree) ModuleDeclaration */
    ASTModuleDeclaration jjtn000 = new ASTModuleDeclaration(this, JJTMODULEDECLARATION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);
    jjtn000.jjtSetFirstToken(getToken(1));StringBuilder s = new StringBuilder();
    Token t;
    checkForBadModuleUsage();
    try {
      label_93:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[174] = jj_gen;
          break label_93;
        }
        Annotation();
      }
      if (isKeyword("open")) {
        jj_consume_token(IDENTIFIER);
                                                                  jjtn000.setOpen(true);
      } else {
        ;
      }
      if (isKeyword("module")) {

      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(IDENTIFIER);
      t = jj_consume_token(IDENTIFIER);
                   s.append(t.image);
      label_94:
      while (true) {
        switch (jj_nt.kind) {
        case DOT:
          ;
          break;
        default:
          jj_la1[175] = jj_gen;
          break label_94;
        }
        jj_consume_token(DOT);
        t = jj_consume_token(IDENTIFIER);
                         s.append('.').append(t.image);
      }
                                                               jjtn000.setImage(s.toString());
      jj_consume_token(LBRACE);
      label_95:
      while (true) {
        if (jj_2_117(1)) {
          ;
        } else {
          break label_95;
        }
        ModuleDirective();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  final public void ModuleDirective() throws ParseException {
 /*@bgen(jjtree) ModuleDirective */
  ASTModuleDirective jjtn000 = new ASTModuleDirective(this, JJTMODULEDIRECTIVE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));
    try {
      if (jj_2_119(1)) {
        if (isKeyword("requires")) {

        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(IDENTIFIER);
                                                        jjtn000.setType(ASTModuleDirective.DirectiveType.REQUIRES);
        if (jj_2_118(1)) {
          if (isKeyword("transitive")) {
            jj_consume_token(IDENTIFIER);
                                                                 jjtn000.setRequiresModifier(ASTModuleDirective.RequiresModifier.TRANSITIVE);
          } else {
            switch (jj_nt.kind) {
            case STATIC:
              jj_consume_token(STATIC);
                            jjtn000.setRequiresModifier(ASTModuleDirective.RequiresModifier.STATIC);
              break;
            default:
              jj_la1[176] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        } else {
          ;
        }
        ModuleName();
        jj_consume_token(SEMICOLON);
      } else if (jj_2_120(1)) {
        if (isKeyword("exports")) {

        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(IDENTIFIER);
                                                        jjtn000.setType(ASTModuleDirective.DirectiveType.EXPORTS);
        Name();
        if (isKeyword("to")) {
          jj_consume_token(IDENTIFIER);
          ModuleName();
          label_96:
          while (true) {
            switch (jj_nt.kind) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[177] = jj_gen;
              break label_96;
            }
            jj_consume_token(COMMA);
            ModuleName();
          }
        } else {
          ;
        }
        jj_consume_token(SEMICOLON);
      } else if (jj_2_121(1)) {
        if (isKeyword("opens")) {

        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(IDENTIFIER);
                                                        jjtn000.setType(ASTModuleDirective.DirectiveType.OPENS);
        Name();
        if (isKeyword("to")) {
          jj_consume_token(IDENTIFIER);
          ModuleName();
          label_97:
          while (true) {
            switch (jj_nt.kind) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[178] = jj_gen;
              break label_97;
            }
            jj_consume_token(COMMA);
            ModuleName();
          }
        } else {
          ;
        }
        jj_consume_token(SEMICOLON);
      } else if (jj_2_122(1)) {
        if (isKeyword("uses")) {

        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(IDENTIFIER);
                                                        jjtn000.setType(ASTModuleDirective.DirectiveType.USES);
        Name();
        jj_consume_token(SEMICOLON);
      } else if (jj_2_123(1)) {
        if (isKeyword("provides")) {

        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(IDENTIFIER);
                                                        jjtn000.setType(ASTModuleDirective.DirectiveType.PROVIDES);
        Name();
        if (isKeyword("with")) {

        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(IDENTIFIER);
        Name();
        label_98:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[179] = jj_gen;
            break label_98;
          }
          jj_consume_token(COMMA);
          Name();
        }
        jj_consume_token(SEMICOLON);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
        jjtn000.jjtSetLastToken(getToken(0));
      }
    }
  }

// Similar to Name()
  final public void ModuleName() throws ParseException {
 /*@bgen(jjtree) ModuleName */
  ASTModuleName jjtn000 = new ASTModuleName(this, JJTMODULENAME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
  jjtn000.jjtSetFirstToken(getToken(1));StringBuilder s = new StringBuilder();
  Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
                   s.append(t.image);
      label_99:
      while (true) {
        switch (jj_nt.kind) {
        case DOT:
          ;
          break;
        default:
          jj_la1[180] = jj_gen;
          break label_99;
        }
        jj_consume_token(DOT);
        t = jj_consume_token(IDENTIFIER);
                        s.append('.').append(t.image);
      }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.jjtSetLastToken(getToken(0));
   jjtn000.setImage(s.toString());
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
      jjtn000.jjtSetLastToken(getToken(0));
    }
    }
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_106(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_107(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_108(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_109(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_110(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_111(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_112(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_113(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_114(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_115(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_116(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_117(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_118(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_119(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_120(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_121(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_122(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_123(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  private boolean jj_3R_353() {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_244() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_353()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_181()) return true;
    xsp = jj_scanpos;
    if (jj_3R_490()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_491()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_23()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_434() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_505() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_435() {
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_433() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_450()) {
    jj_scanpos = xsp;
    if (jj_3R_451()) return true;
    }
    return false;
  }

  private boolean jj_3R_450() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_383() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_433()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_125()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_434()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_435()) jj_scanpos = xsp;
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_3R_383()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_384()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_298()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_181()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_505()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_494() {
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_240()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_241()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_182()) return true;
    if (jj_3R_242()) return true;
    xsp = jj_scanpos;
    if (jj_3R_493()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_494()) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_135()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_20()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(82)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_407() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3_19()) return true;
    }
    return false;
  }

  private boolean jj_3R_468() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_492() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_332()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_456() {
    if (jj_scan_token(BIT_AND)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_468()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_382()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_179() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_416() {
    if (jj_3R_443()) return true;
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_351()) return true;
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_3R_179()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_407()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_125()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_126()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_3R_125()) return true;
    if (jj_3R_332()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_492()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(46)) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_244()) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_129()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("enum");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_130()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("record");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_120() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_3R_346()) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_455() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_10()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_443() {
    if (jj_scan_token(EXTENDS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_455()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_371()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_456()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_415() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_351() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_415()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(IDENTIFIER)) return true;
    xsp = jj_scanpos;
    if (jj_3R_416()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_351()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_352()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_3R_129()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_3R_129()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_526() {
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_3R_347()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3_9()) return true;
    }
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_481() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_7()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_524() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_523()) return true;
    return false;
  }

  private boolean jj_3R_525() {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_542() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_535() {
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_534() {
    if (jj_3R_542()) return true;
    return false;
  }

  private boolean jj_3R_523() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_534()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_125()) return true;
    xsp = jj_scanpos;
    if (jj_3R_535()) jj_scanpos = xsp;
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_512() {
    if (jj_3R_523()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_524()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_496() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_512()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_118()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_479() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_496()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_480() {
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_478() {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_478()) jj_scanpos = xsp;
    if (jj_3R_479()) return true;
    xsp = jj_scanpos;
    if (jj_3R_480()) jj_scanpos = xsp;
    if (jj_3R_481()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_525()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_526()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_498() {
    if (jj_scan_token(SEMICOLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_6()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_513() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_497() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_513()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_119()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_5()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_497()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(82)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_498()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_340()) jj_scanpos = xsp;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_511() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_510()) return true;
    return false;
  }

  private boolean jj_3R_508() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_510()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_511()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_521() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_506() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_509() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_521()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_520() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_scan_token(IMPLEMENTS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_508()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_371()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_509()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_507() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_520()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_scan_token(EXTENDS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_506()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_371()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_507()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_3R_350()) return true;
    return false;
  }

  private boolean jj_3R_235() {
    if (jj_3R_349()) return true;
    return false;
  }

  private boolean jj_3R_234() {
    if (jj_3R_348()) return true;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_3R_238()) return true;
    return false;
  }

  private boolean jj_3R_123() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_3R_232()) return true;
    }
    if (jj_scan_token(IDENTIFIER)) return true;
    xsp = jj_scanpos;
    if (jj_3R_233()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_234()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_235()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) jj_scanpos = xsp;
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_3R_129()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("enum");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_227()) {
    jj_scanpos = xsp;
    if (jj_3R_228()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("record");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_229()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(MINUS)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_scan_token(STRICTFP)) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_scan_token(VOLATILE)) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_scan_token(TRANSIENT)) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_scan_token(NATIVE)) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_scan_token(ABSTRACT)) return true;
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) {
    jj_scanpos = xsp;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("sealed");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_115()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isNonSealedModifier();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_129() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_4()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_225() {
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_224()) { jj_scanpos = xsp; break; }
    }
    jj_lookingAhead = true;
    jj_semLA = isKeyword("open") || isKeyword("module");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_225()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3_1() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_100()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(PACKAGE)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_222() {
    return false;
  }

  private boolean jj_3R_221() {
    return false;
  }

  private boolean jj_3R_220() {
    return false;
  }

  private boolean jj_3R_219() {
    return false;
  }

  private boolean jj_3R_218() {
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_118() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("transitive");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) return true;
    }
    return false;
  }

  private boolean jj_3_123() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("provides");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_222()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_122() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("uses");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_221()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_121() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("opens");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_220()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_120() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("exports");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_219()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_544() {
    if (jj_3R_548()) return true;
    return false;
  }

  private boolean jj_3R_215() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_119()) {
    jj_scanpos = xsp;
    if (jj_3_120()) {
    jj_scanpos = xsp;
    if (jj_3_121()) {
    jj_scanpos = xsp;
    if (jj_3_122()) {
    jj_scanpos = xsp;
    if (jj_3_123()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_119() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("requires");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_218()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_117() {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_548() {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_3R_125()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_544()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_114() {
    if (jj_3R_125()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_3R_245()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3_115() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_212() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_209() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_116()) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    return false;
  }

  private boolean jj_3_116() {
    if (jj_3R_129()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) {
    jj_scanpos = xsp;
    if (jj_3_115()) {
    jj_scanpos = xsp;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_113() {
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3R_495() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_113()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_495()) return true;
    return false;
  }

  private boolean jj_3_111() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3_112() {
    if (jj_3R_208()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_111()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(82)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_410() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_112()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_467() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_466()) return true;
    return false;
  }

  private boolean jj_3_110() {
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_3R_410()) return true;
    return false;
  }

  private boolean jj_3R_208() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) {
    jj_scanpos = xsp;
    if (jj_3_110()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_466() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_454() {
    if (jj_3R_466()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_467()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_442() {
    if (jj_3R_454()) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_412() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_183()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_208()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_413() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3_109() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_183()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_411() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_183()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_442()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_108() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_183()) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) return true;
    }
    return false;
  }

  private boolean jj_3R_345() {
    if (jj_3R_413()) return true;
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_3R_412()) return true;
    return false;
  }

  private boolean jj_3R_223() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_274() {
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_3R_411()) return true;
    return false;
  }

  private boolean jj_3R_476() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_275() {
    return false;
  }

  private boolean jj_3R_161() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                ((Token.GTToken)getToken(1)).realKind == RSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_274()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_336() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_162() {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                ((Token.GTToken)getToken(1)).realKind == RUNSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_275()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_134()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_476()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_503() {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_3R_183()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) return true;
    }
    return false;
  }

  private boolean jj_3R_502() {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_383()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3_105() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3R_205() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) return true;
    }
    return false;
  }

  private boolean jj_3_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_3R_204()) return true;
    }
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_409() {
    if (jj_scan_token(THIS)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3_107() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_205()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_206()) return true;
    if (jj_3R_179()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_408() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_203() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3_107()) return true;
    }
    return false;
  }

  private boolean jj_3R_334() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_408()) {
    jj_scanpos = xsp;
    if (jj_3R_409()) return true;
    }
    return false;
  }

  private boolean jj_3R_517() {
    if (jj_3R_203()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_105()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_104() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_501() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_517()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_104()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_487() {
    if (jj_3R_501()) return true;
    return false;
  }

  private boolean jj_3R_489() {
    if (jj_3R_503()) return true;
    return false;
  }

  private boolean jj_3R_488() {
    if (jj_3R_502()) return true;
    return false;
  }

  private boolean jj_3R_402() {
    if (jj_scan_token(TRY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_487()) jj_scanpos = xsp;
    if (jj_3R_390()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_488()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_489()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_401() {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3_103() {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_486() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_399() {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_103()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_541() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_194()) return true;
    return false;
  }

  private boolean jj_3R_485() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_398() {
    if (jj_scan_token(CONTINUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_486()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_397() {
    if (jj_scan_token(BREAK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_485()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3_101() {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_3R_194()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_541()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_483() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3_102() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_200() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3_102()) return true;
    }
    return false;
  }

  private boolean jj_3_99() {
    if (jj_3R_195()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_3R_195()) return true;
    return false;
  }

  private boolean jj_3_98() {
    if (jj_3R_201()) return true;
    return false;
  }

  private boolean jj_3_97() {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3_96() {
    if (jj_3R_200()) return true;
    return false;
  }

  private boolean jj_3_100() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_96()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_98()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_484() {
    if (jj_3R_195()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_396() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_484()) {
    jj_scanpos = xsp;
    if (jj_3_100()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_196()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_394() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_393() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_196()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_483()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_536() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_403()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_94() {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3_95() {
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_440() {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_403() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_439()) {
    jj_scanpos = xsp;
    if (jj_3R_440()) {
    jj_scanpos = xsp;
    if (jj_3_95()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_439() {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_403()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_536()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_530() {
    if (jj_3R_539()) return true;
    return false;
  }

  private boolean jj_3R_543() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_197() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) return true;
    }
    return false;
  }

  private boolean jj_3_93() {
    if (jj_3R_197()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_540() {
    Token xsp;
    if (jj_3_93()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_93()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_543()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_538() {
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_537() {
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3_92() {
    if (jj_3R_134()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_532() {
    if (jj_3R_540()) return true;
    return false;
  }

  private boolean jj_3R_531() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_529() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3R_537()) {
    jj_scanpos = xsp;
    if (jj_3R_538()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_91() {
    if (jj_3R_197()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_539() {
    if (jj_3R_197()) return true;
    if (jj_scan_token(LAMBDA)) return true;
    if (jj_3R_529()) return true;
    return false;
  }

  private boolean jj_3R_516() {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_91()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_531()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_532()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_515() {
    if (jj_scan_token(LAMBDA)) return true;
    if (jj_3R_529()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_530()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_500() {
    if (jj_3R_197()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_515()) {
    jj_scanpos = xsp;
    if (jj_3R_516()) return true;
    }
    return false;
  }

  private boolean jj_3R_499() {
    if (jj_3R_145()) return true;
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_482() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_500()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_389() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_392() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  private boolean jj_3_90() {
    if (jj_3R_176()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_499()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_3R_376()) return true;
    return false;
  }

  private boolean jj_3R_194() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3_90()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_3R_375()) return true;
    return false;
  }

  private boolean jj_3R_391() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = jdkVersion >= 10 && isKeyword("var");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_3R_337()) return true;
    }
    return false;
  }

  private boolean jj_3_89() {
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3_88() {
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_332()) return true;
    return false;
  }

  private boolean jj_3R_310() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) {
    jj_scanpos = xsp;
    if (jj_3R_389()) return true;
    }
    return false;
  }

  private boolean jj_3R_388() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_195() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_310()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_206()) return true;
    if (jj_3R_332()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_333()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_420() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_419() {
    if (jj_3R_243()) return true;
    return false;
  }

  private boolean jj_3R_418() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_417() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_358() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_417()) {
    jj_scanpos = xsp;
    if (jj_3R_418()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("record");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_419()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("enum");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_420()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_86() {
    if (jj_3R_125()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_87() {
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_3R_195()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_3R_129()) return true;
    if (jj_3R_358()) return true;
    return false;
  }

  private boolean jj_3_79() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_84() {
    if (jj_3R_195()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_3R_358()) return true;
    return false;
  }

  private boolean jj_3_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) return true;
    }
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_3R_129()) return true;
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = localTypeDeclLookahead();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3_84()) return true;
    }
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_3R_356()) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_3R_355()) return true;
    return false;
  }

  private boolean jj_3R_137() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isNextTokenAnAssert();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_249()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isYieldStart();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = classModifierForLocalTypesLookahead() || localTypeDeclLookahead();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_252()) {
    jj_scanpos = xsp;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3_87()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_83() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_390() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_83()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_196()) return true;
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_3R_402()) return true;
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_3R_401()) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_3R_399()) return true;
    return false;
  }

  private boolean jj_3R_321() {
    if (jj_3R_398()) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    if (jj_3R_396()) return true;
    return false;
  }

  private boolean jj_3R_318() {
    if (jj_3R_395()) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_3R_393()) return true;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_3R_392()) return true;
    return false;
  }

  private boolean jj_3_82() {
    if (jj_3R_194()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_3R_391()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3_81() {
    if (jj_3R_193()) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_3R_356()) return true;
    return false;
  }

  private boolean jj_3R_196() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isNextTokenAnAssert();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_311()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isYieldStart();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) {
    jj_scanpos = xsp;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3R_315()) {
    jj_scanpos = xsp;
    if (jj_3R_316()) {
    jj_scanpos = xsp;
    if (jj_3R_317()) {
    jj_scanpos = xsp;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) {
    jj_scanpos = xsp;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_311() {
    if (jj_3R_355()) return true;
    return false;
  }

  private boolean jj_3R_387() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_78() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_192()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_306() {
    Token xsp;
    if (jj_3R_387()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_387()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3_80() {
    Token xsp;
    if (jj_3_78()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_78()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_79()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_191() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) return true;
    }
    return false;
  }

  private boolean jj_3R_469() {
    if (jj_3R_237()) return true;
    return false;
  }

  private boolean jj_3R_459() {
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_461() {
    if (jj_3R_139()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_469()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_460() {
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_422() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_445() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_446() {
    if (jj_3R_371()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_460()) {
    jj_scanpos = xsp;
    if (jj_3R_461()) return true;
    }
    return false;
  }

  private boolean jj_3_68() {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3_77() {
    if (jj_3R_172()) return true;
    if (jj_3R_191()) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_scan_token(NEW)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_445()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3_77()) {
    jj_scanpos = xsp;
    if (jj_3R_446()) return true;
    }
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_3R_134()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_422()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_76() {
    if (jj_3R_190()) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_76()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_449() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_437() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_448() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_463()) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) return true;
    }
    return false;
  }

  private boolean jj_3R_463() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_458() {
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_432() {
    if (jj_3R_449()) return true;
    return false;
  }

  private boolean jj_3R_431() {
    if (jj_3R_448()) return true;
    return false;
  }

  private boolean jj_3R_430() {
    if (jj_scan_token(TEXT_BLOCK_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_429() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_428() {
    if (jj_scan_token(CHARACTER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_427() {
    if (jj_scan_token(HEX_FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_426() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_381() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_425()) {
    jj_scanpos = xsp;
    if (jj_3R_426()) {
    jj_scanpos = xsp;
    if (jj_3R_427()) {
    jj_scanpos = xsp;
    if (jj_3R_428()) {
    jj_scanpos = xsp;
    if (jj_3R_429()) {
    jj_scanpos = xsp;
    if (jj_3R_430()) {
    jj_scanpos = xsp;
    if (jj_3R_431()) {
    jj_scanpos = xsp;
    if (jj_3R_432()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_425() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_457() {
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3_67() {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_75() {
    if (jj_3R_189()) return true;
    return false;
  }

  private boolean jj_3_74() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_188()) return true;
    return false;
  }

  private boolean jj_3R_302() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_178() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3_75()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_73() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3R_471() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_303()) return true;
    return false;
  }

  private boolean jj_3_72() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_438() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_386() {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = jdkVersion >= 11 && isKeyword("var");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_3R_438()) return true;
    }
    return false;
  }

  private boolean jj_3_66() {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_452() {
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_385() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) {
    jj_scanpos = xsp;
    if (jj_3R_437()) return true;
    }
    return false;
  }

  private boolean jj_3R_436() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_303() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_385()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_386()) return true;
    xsp = jj_scanpos;
    if (jj_3R_452()) jj_scanpos = xsp;
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_3R_303()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_471()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_71() {
    if (jj_3R_187()) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_71()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_65() {
    if (jj_3R_143()) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3_64() {
    if (jj_3R_183()) return true;
    if (jj_scan_token(METHOD_REF)) return true;
    return false;
  }

  private boolean jj_3_70() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_179()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_186()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LAMBDA)) return true;
    xsp = jj_scanpos;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3R_459()) return true;
    }
    return false;
  }

  private boolean jj_3_63() {
    if (jj_3R_182()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_scan_token(NEW)) return true;
    return false;
  }

  private boolean jj_3_69() {
    if (jj_3R_185()) return true;
    if (jj_scan_token(LAMBDA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3R_458()) return true;
    }
    return false;
  }

  private boolean jj_3R_421() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_444()) {
    jj_scanpos = xsp;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3_70()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_444() {
    if (jj_3R_179()) return true;
    if (jj_scan_token(LAMBDA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3R_457()) return true;
    }
    return false;
  }

  private boolean jj_3_61() {
    if (jj_3R_181()) return true;
    if (jj_scan_token(LAMBDA)) return true;
    return false;
  }

  private boolean jj_3_60() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_179()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_180()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LAMBDA)) return true;
    return false;
  }

  private boolean jj_3_59() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LAMBDA)) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_3R_143()) return true;
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_528() {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_3R_182()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_3R_188()) return true;
    return false;
  }

  private boolean jj_3_62() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_3R_421()) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_3R_421()) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_381()) return true;
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_3R_421()) return true;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3_58() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_254() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !inSwitchLabel;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_361()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !inSwitchLabel;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_362()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !inSwitchLabel;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_363()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3R_364()) {
    jj_scanpos = xsp;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) {
    jj_scanpos = xsp;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_3R_381()) return true;
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  private boolean jj_3_57() {
    if (jj_3R_178()) return true;
    return false;
  }

  private boolean jj_3R_547() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(METHOD_REF)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_300()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_301()) {
    jj_scanpos = xsp;
    if (jj_3R_302()) return true;
    }
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_3R_184()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) return true;
    }
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_140()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_3R_254()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_57()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_514() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_527()) {
    jj_scanpos = xsp;
    if (jj_3R_528()) return true;
    }
    return false;
  }

  private boolean jj_3R_527() {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3R_174() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_380() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_482()) return true;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_545() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_546() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  private boolean jj_3_56() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_177()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_172()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_424() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_546()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_125()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_547()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_379() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) {
    jj_scanpos = xsp;
    if (jj_3R_424()) return true;
    }
    return false;
  }

  private boolean jj_3R_423() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_545()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_125()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_scan_token(BANG)) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_3R_138()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_514()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_175() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_3R_292()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_54() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_173()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_125()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_174()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_175()) return true;
    return false;
  }

  private boolean jj_3_53() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_171()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_172()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_163() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_374() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_3R_380()) return true;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3_55() {
    if (jj_3R_176()) return true;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_3R_379()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_3R_379()) return true;
    return false;
  }

  private boolean jj_3R_377() {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_170() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_279() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_377()) {
    jj_scanpos = xsp;
    if (jj_3R_378()) return true;
    }
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3_50() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) return true;
    }
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_376() {
    if (jj_scan_token(DECR)) return true;
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) return true;
    }
    }
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_scan_token(INCR)) return true;
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3_52() {
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_3R_376()) return true;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_3R_375()) return true;
    return false;
  }

  private boolean jj_3R_373() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_169() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3_52()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_276() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) {
    jj_scanpos = xsp;
    if (jj_3R_374()) return true;
    }
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_169()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_3R_165()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_50()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_49() {
    if (jj_3R_162()) return true;
    return false;
  }

  private boolean jj_3_48() {
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_scan_token(LSHIFT)) return true;
    return false;
  }

  private boolean jj_3_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) return true;
    }
    }
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_465() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_3R_160()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_47()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3_45() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) {
    jj_scanpos = xsp;
    if (jj_3R_157()) return true;
    }
    }
    }
    if (jj_3R_158()) return true;
    return false;
  }

  private boolean jj_3_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_3R_158()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_46()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_477() {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_475() {
    if (jj_3R_125()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_477()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_474() {
    if (jj_3R_198()) return true;
    return false;
  }

  private boolean jj_3R_473() {
    if (jj_3R_328()) return true;
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_472() {
    if (jj_scan_token(INSTANCEOF)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_473()) {
    jj_scanpos = xsp;
    if (jj_3R_474()) {
    jj_scanpos = xsp;
    if (jj_3R_475()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_3R_273()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_472()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_3R_406()) return true;
    return false;
  }

  private boolean jj_3R_453() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_464()) {
    jj_scanpos = xsp;
    if (jj_3R_465()) return true;
    }
    return false;
  }

  private boolean jj_3R_464() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) return true;
    }
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_441() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_453()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_125()) return true;
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_405() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_198()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_328() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_404()) {
    jj_scanpos = xsp;
    if (jj_3R_405()) return true;
    }
    return false;
  }

  private boolean jj_3R_404() {
    if (jj_3R_441()) return true;
    return false;
  }

  private boolean jj_3_42() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_406() {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_3R_328()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_329()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3_39() {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_3R_153()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_38() {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_3R_150()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_42()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_37() {
    if (jj_scan_token(HOOK)) return true;
    if (jj_3R_134()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_199()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_3R_149()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_41()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_3R_148()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_40()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_3R_147()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_39()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_330() {
    if (jj_3R_146()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_38()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_3R_330()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_scan_token(ORASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_scan_token(XORASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_scan_token(ANDASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(RUNSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_scan_token(RSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_scan_token(LSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_scan_token(MINUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_scan_token(PLUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(REMASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_scan_token(SLASHASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(STARASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_145() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) {
    jj_scanpos = xsp;
    if (jj_3R_270()) {
    jj_scanpos = xsp;
    if (jj_3R_271()) {
    jj_scanpos = xsp;
    if (jj_3R_272()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_36() {
    if (jj_3R_145()) return true;
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_199()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_533() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_519() {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_533()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_183()) return true;
    return false;
  }

  private boolean jj_3R_518() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_504() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_518()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_183()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_519()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_447() {
    if (jj_3R_462()) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_scan_token(HOOK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_447()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_35()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_299() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_470() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_182() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_3R_299()) return true;
    }
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(SHORT)) return true;
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_scan_token(BYTE)) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_172() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) {
    jj_scanpos = xsp;
    if (jj_3R_284()) {
    jj_scanpos = xsp;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) {
    jj_scanpos = xsp;
    if (jj_3R_287()) {
    jj_scanpos = xsp;
    if (jj_3R_288()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_462() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_470()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_144() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_258()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) return true;
    }
    return false;
  }

  private boolean jj_3_29() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_490() {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_504()) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_scan_token(LT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    }
    return false;
  }

  private boolean jj_3_34() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_144()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_369()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_372() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3R_522() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_510() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_522()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_370() {
    if (jj_3R_307()) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_33()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_371() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_32()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_3R_371()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_372()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_30()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_3R_172()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_370()) { jj_scanpos = xsp; break; }
    }
    if (jj_3_29()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_29()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_143() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) return true;
    }
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3R_239()) return true;
    }
    return false;
  }

  private boolean jj_3_28() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_451() {
    if (jj_3R_223()) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_3R_138()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_3R_140()) return true;
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_414() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_346() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_414()) jj_scanpos = xsp;
    if (jj_3R_390()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_3R_138()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_493() {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_504()) return true;
    return false;
  }

  private boolean jj_3_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_141()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_142()) jj_scanpos = xsp;
    if (jj_scan_token(SUPER)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_3R_140()) return true;
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_139()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_136() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3_27()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_384() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_383()) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_491() {
    if (jj_3R_136()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public JavaParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[181];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2080200,0x0,0x10000,0x0,0x10000,0x0,0x800000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x0,0x8209400,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa209400,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x8209400,0x0,0x0,0x8209400,0x0,0x0,0x0,0x0,0x800000,0x8209400,0x800000,0x0,0x8209400,0x8209400,0x0,0x0,0x0,0x0,0x0,0x0,0xa209400,0x2000000,0x2000000,0x0,0x8209400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9209400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x8209400,0x0,0x1000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50140800,0x2000000,0x2000000,0x0,0x8209400,0x0,0x0,0x82000,0x82000,0x0,0x82000,0x0,0x0,0x82000,0x80000,0x400000,0x0,0x0,0x0,0x0,0x4000,0x4000000,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x8209400,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x0,0xa224e20,0x0,0x8,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2014,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x2014,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x4000,0x2014,0x0,0x0,0x2014,0x0,0x0,0x0,0x0,0x8000,0x2014,0x8000,0x0,0x2014,0x1002014,0x0,0x0,0x0,0x0,0x0,0x0,0x2014,0x0,0x0,0x40000,0x2014,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x1145a0d4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x10400080,0x8000,0x40,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x2014,0x0,0x10400080,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48b1000,0x0,0x0,0x0,0x2014,0x0,0x0,0x0,0x0,0x0,0x0,0x80000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x2014,0x0,0x0,0x0,0x0,0x4000,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x20000,0x0,0x20000,0x20000,0x20000,0x0,0x0,0x100000,0x100000,0x0,0x80000,0x0,0x100000,0x0,0x100000,0x0,0x400000,0x0,0x0,0x100000,0x40000,0x100000,0x100000,0x40000,0x100000,0x40000,0x0,0x100000,0x100000,0x100100,0x40000,0x20000,0x800,0x2000,0x400000,0x0,0x40000,0x100100,0x100000,0x0,0x40000,0x100000,0x0,0x100000,0x0,0x100000,0x20000,0x40000,0x200000,0x8000,0x100,0x2000,0x40000,0x400000,0x100000,0x0,0x22000,0x8000,0x40000,0x100100,0x100000,0x100000,0x0,0x0,0x400000,0x0,0x400000,0x0,0x0,0x100000,0x100000,0x100,0x80000,0x40000,0x400000,0x100000,0x0,0x2000100,0x0,0x100000,0x0,0x100,0x100000,0x40000,0x100000,0x200000,0x48000000,0x0,0x100900,0x100000,0x100000,0x100,0x100,0x0,0x30400000,0x0,0x0,0x0,0x0,0x0,0x1800000,0x1800000,0x0,0x19009d6,0x0,0x0,0x100000,0x100000,0x0,0x800,0x80000,0x400000,0x100,0xd6,0x0,0x0,0x100,0x2000,0x2000,0x40000,0x2000,0x100,0x40000,0x100000,0x100000,0x0,0x100,0x88800,0xd6,0x0,0x40000,0x100000,0x2000,0x108800,0x100,0x100000,0x8000,0x8000,0x22000,0x0,0x100000,0x100000,0x40000,0x100,0x200000,0x0,0x0,0x0,0x4000000,0x0,0x2000,0x40000,0x0,0x0,0x0,0x40000,0x100,0x100,0x800,0x0,0x0,0x100,0x100000,0x100000,0x4000000,0x100000,0x100,0x40000,0x102000,0x40000,0x0,0x100100,0x20000,0x0,0x100000,0x80000,0x0,0x40000,0x40000,0x40000,0x80000,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x20000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ff000,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x800,0x18,0x460,0x18,0x1e,0x0,0x0,0x0,0x0,0x6,0x6,0x0,0x0,0x80,0x0,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ff000,0x6,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[123];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public JavaParser(CharStream stream) {
    token_source = new JavaParserTokenManager(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 181; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_lookingAhead = false;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 181; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public JavaParser(JavaParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 181; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(JavaParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 181; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[127];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 181; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 127; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 123; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
            case 116: jj_3_117(); break;
            case 117: jj_3_118(); break;
            case 118: jj_3_119(); break;
            case 119: jj_3_120(); break;
            case 120: jj_3_121(); break;
            case 121: jj_3_122(); break;
            case 122: jj_3_123(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
