/**
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */
/* Generated By:JJTree: Do not edit this line. ASTImportDeclaration.java */

package net.sourceforge.pmd.lang.java.ast;

/**
 * Represents an import declaration in a Java file.
 *
 * <pre>
 *   ImportDeclaration ::= "import" [ "static" ] Name [ "." "*" ] ";"
 * </pre>
 *
 */
public class ASTImportDeclaration extends AbstractJavaTypeNode {

    private boolean isImportOnDemand;
    private boolean isStatic;
    private Package pkg;

    public ASTImportDeclaration(int id) {
        super(id);
    }

    public ASTImportDeclaration(JavaParser p, int id) {
        super(p, id);
    }

    public void setImportOnDemand() {
        isImportOnDemand = true;
    }

    public boolean isImportOnDemand() {
        return isImportOnDemand;
    }

    public void setStatic() {
        isStatic = true;
    }

    public boolean isStatic() {
        return isStatic;
    }

    // TODO - this should go away, but the DuplicateImports rule still uses it
    // (in a clunky way)
    public ASTName getImportedNameNode() {
        return (ASTName) jjtGetChild(0);
    }


    /**
     * Returns the full name of the import. For on-demand imports, this is the name without
     * the final asterisk.
     */
    public String getImportedName() {
        return jjtGetChild(0).getImage();
    }


    /**
     * Returns the simple name of the type or method imported by this declaration.
     * For on-demand imports, returns {@code null}.
     */
    public String getImportedSimpleName() {
        if (isImportOnDemand) {
            return null;
        }

        String importName = getImportedName();
        return importName.substring(importName.lastIndexOf('.') + 1);
    }


    /**
     * Returns the "package" prefix of the imported name. For type imports, including on-demand
     * imports, this is really the package name of the imported type(s). For static imports,
     * this is actually the qualified name of the enclosing type, including the type name.
     */
    public String getPackageName() {
        String importName = getImportedName();
        if (isImportOnDemand) {
            return importName;
        }
        if (importName.indexOf('.') == -1) {
            return "";
        }
        int lastDot = importName.lastIndexOf('.');
        return importName.substring(0, lastDot);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void setPackage(Package packge) {
        this.pkg = packge;
    }


    /**
     * Returns the {@link Package} instance representing the package of the
     * type or method imported by this declaration. This may be null if the
     * auxclasspath is not correctly set, as this method depends on correct
     * type resolution.
     */
    public Package getPackage() {
        return this.pkg;
    }
}
