/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJUnitRule;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class TestClassWithoutTestCasesRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<Pattern> TEST_CLASS_PATTERN = ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"testClassPattern").defaultValue("^(?:.*\\.)?Test[^\\.]*$|^(?:.*\\.)?.*Tests?$|^(?:.*\\.)?.*TestCase$").desc("Test class name pattern to identify test classes by their fully qualified name. A empty pattern disables test class detection by name. Since PMD 6.51.0.")).build();

    public TestClassWithoutTestCasesRule() {
        this.addRuleChainVisit(ASTClassOrInterfaceBody.class);
        this.definePropertyDescriptor(TEST_CLASS_PATTERN);
    }

    @Override
    public Object visit(ASTClassOrInterfaceBody node, Object data) {
        if (AbstractJUnitRule.isTestClass(node) || AbstractJUnitRule.isJUnit5NestedClass(node) || this.isTestClassByPattern(node)) {
            List declarations = node.findChildrenOfType(ASTClassOrInterfaceBodyDeclaration.class);
            int testMethods = 0;
            int nestedTestClasses = 0;
            for (ASTClassOrInterfaceBodyDeclaration decl : declarations) {
                if (this.isTestMethod(decl)) {
                    ++testMethods;
                    continue;
                }
                if (!this.isNestedClass(decl)) continue;
                ++nestedTestClasses;
            }
            if (testMethods == 0 && nestedTestClasses == 0) {
                this.addViolation(data, (Node)node, this.getSimpleClassName(node));
            }
        }
        return data;
    }

    private String getSimpleClassName(ASTClassOrInterfaceBody node) {
        JavaNode parent = (JavaNode)node.getParent();
        if (parent instanceof ASTClassOrInterfaceDeclaration) {
            return ((ASTClassOrInterfaceDeclaration)parent).getSimpleName();
        }
        return "<anon>";
    }

    private boolean isTestClassByPattern(ASTClassOrInterfaceBody node) {
        Pattern testClassPattern = (Pattern)this.getProperty(TEST_CLASS_PATTERN);
        if (testClassPattern.pattern().isEmpty()) {
            return false;
        }
        ASTClassOrInterfaceDeclaration classDecl = null;
        if (node.getParent() instanceof ASTClassOrInterfaceDeclaration) {
            classDecl = (ASTClassOrInterfaceDeclaration)node.getParent();
        }
        if (classDecl == null || classDecl.isAbstract() || classDecl.isInterface()) {
            return false;
        }
        StringBuilder fullyQualifiedName = new StringBuilder();
        ASTPackageDeclaration packageDeclaration = classDecl.getRoot().getPackageDeclaration();
        if (packageDeclaration != null) {
            fullyQualifiedName.append(packageDeclaration.getName()).append('.');
        }
        List parentClasses = classDecl.getParentsOfType(ASTClassOrInterfaceDeclaration.class);
        for (int i = parentClasses.size() - 1; i >= 0; --i) {
            fullyQualifiedName.append(((ASTClassOrInterfaceDeclaration)parentClasses.get(i)).getSimpleName()).append('.');
        }
        fullyQualifiedName.append(classDecl.getSimpleName());
        return testClassPattern.matcher(fullyQualifiedName).find();
    }

    private boolean isTestMethod(ASTClassOrInterfaceBodyDeclaration decl) {
        JavaNode node = decl.getDeclarationNode();
        if (node instanceof ASTMethodDeclaration) {
            return AbstractJUnitRule.isTestMethod((ASTMethodDeclaration)node);
        }
        return false;
    }

    private boolean isNestedClass(ASTClassOrInterfaceBodyDeclaration decl) {
        JavaNode node = (JavaNode)decl.getParent();
        if (node instanceof ASTClassOrInterfaceBody) {
            return AbstractJUnitRule.isJUnit5NestedClass((ASTClassOrInterfaceBody)node);
        }
        return false;
    }
}

