/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.qname;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorReducedAdapter;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.qname.ImmutableList;
import net.sourceforge.pmd.lang.java.qname.JavaOperationQualifiedName;
import net.sourceforge.pmd.lang.java.qname.JavaTypeQualifiedName;
import net.sourceforge.pmd.lang.java.typeresolution.PMDASMClassLoader;
import org.apache.commons.lang3.mutable.MutableInt;

public class QualifiedNameResolver
extends JavaParserVisitorReducedAdapter {
    private final Map<String, ImmutableList<String>> foundPackages = new HashMap<String, ImmutableList<String>>(128);
    private final Stack<Map<String, Integer>> currentLocalIndices = new Stack();
    private final Stack<MutableInt> anonymousCounters = new Stack();
    private final Stack<MutableInt> lambdaCounters = new Stack();
    private final Stack<JavaTypeQualifiedName> innermostEnclosingTypeName = new Stack();
    private ImmutableList<String> packages;
    private ImmutableList<Integer> localIndices;
    private ImmutableList<String> classNames;
    private ClassLoader classLoader;

    public void initializeWith(ClassLoader classLoader, ASTCompilationUnit rootNode) {
        this.classLoader = PMDASMClassLoader.getInstance(classLoader);
        rootNode.jjtAccept(this, null);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.packages = this.getPackageList((ASTPackageDeclaration)node.getFirstChildOfType(ASTPackageDeclaration.class));
        this.localIndices = ImmutableList.ListFactory.emptyList();
        this.classNames = ImmutableList.ListFactory.emptyList();
        this.anonymousCounters.clear();
        this.currentLocalIndices.clear();
        return super.visit(node, data);
    }

    private ImmutableList<String> getPackageList(ASTPackageDeclaration pack) {
        if (pack == null) {
            return ImmutableList.ListFactory.emptyList();
        }
        String image = pack.getPackageNameImage();
        ImmutableList<String> fullExisting = this.foundPackages.get(image);
        if (fullExisting != null) {
            return fullExisting;
        }
        String[] allPacks = image.split("\\.");
        ImmutableList<String> longestPrefix = this.getLongestPackagePrefix(image, allPacks.length);
        StringBuilder prefixImage = new StringBuilder();
        for (String p : longestPrefix) {
            prefixImage.append(p);
        }
        for (int i = longestPrefix.size(); i < allPacks.length; ++i) {
            longestPrefix = longestPrefix.prepend(allPacks[i]);
            prefixImage.append(allPacks[i]);
            this.foundPackages.put(prefixImage.toString(), longestPrefix);
        }
        return longestPrefix;
    }

    private ImmutableList<String> getLongestPackagePrefix(String acc, int i) {
        ImmutableList<String> prefix = this.foundPackages.get(acc);
        if (prefix != null) {
            return prefix;
        }
        if (i == 1) {
            return ImmutableList.ListFactory.emptyList();
        }
        return this.getLongestPackagePrefix(acc.substring(0, acc.lastIndexOf(46)), i - 1);
    }

    @Override
    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        int localIndex = -1;
        if (node instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)node).isLocal()) {
            localIndex = QualifiedNameResolver.getNextIndexFromHistogram(this.currentLocalIndices.peek(), node.getImage(), 1);
        }
        this.updateClassContext(node.getImage(), localIndex);
        ((AbstractAnyTypeDeclaration)node).setQualifiedName(this.contextClassQName());
        super.visit(node, data);
        this.rollbackClassContext();
        return data;
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (!node.isAnonymousClass()) {
            return super.visit(node, data);
        }
        this.updateContextForAnonymousClass();
        node.setQualifiedName(this.contextClassQName());
        super.visit(node, data);
        this.rollbackClassContext();
        return data;
    }

    @Override
    public Object visit(ASTEnumConstant node, Object data) {
        if (!node.isAnonymousClass()) {
            return super.visit(node, data);
        }
        this.updateContextForAnonymousClass();
        node.setQualifiedName(this.contextClassQName());
        super.visit(node, data);
        this.rollbackClassContext();
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        String opname = QualifiedNameResolver.getOperationName(node.getMethodName(), (ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class));
        node.setQualifiedName(this.contextOperationQName(opname, false));
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        String opname = QualifiedNameResolver.getOperationName(this.classNames.head(), (ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class));
        node.setQualifiedName(this.contextOperationQName(opname, false));
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTLambdaExpression node, Object data) {
        String opname = "lambda$" + this.findLambdaScopeNameSegment(node) + "$" + this.lambdaCounters.peek().getAndIncrement();
        node.setQualifiedName(this.contextOperationQName(opname, true));
        return super.visit(node, data);
    }

    private void updateContextForAnonymousClass() {
        this.updateClassContext("" + this.anonymousCounters.peek().incrementAndGet(), -1);
    }

    private void updateClassContext(String className, int localIndex) {
        this.localIndices = this.localIndices.prepend(localIndex);
        this.classNames = this.classNames.prepend(className);
        this.anonymousCounters.push(new MutableInt(0));
        this.lambdaCounters.push(new MutableInt(0));
        this.currentLocalIndices.push(new HashMap());
        this.innermostEnclosingTypeName.push(this.contextClassQName());
    }

    private void rollbackClassContext() {
        this.localIndices = this.localIndices.tail();
        this.classNames = this.classNames.tail();
        this.anonymousCounters.pop();
        this.lambdaCounters.pop();
        this.currentLocalIndices.pop();
        this.innermostEnclosingTypeName.pop();
    }

    private JavaTypeQualifiedName contextClassQName() {
        return new JavaTypeQualifiedName(this.packages, this.classNames, this.localIndices).withClassLoader(this.classLoader);
    }

    private JavaOperationQualifiedName contextOperationQName(String op, boolean isLambda) {
        return new JavaOperationQualifiedName(this.innermostEnclosingTypeName.peek(), op, isLambda);
    }

    private String findLambdaScopeNameSegment(ASTLambdaExpression node) {
        Node parent;
        for (parent = node.jjtGetParent(); !(parent == null || parent instanceof ASTFieldDeclaration || parent instanceof ASTEnumConstant || parent instanceof ASTInitializer || parent instanceof MethodLikeNode); parent = parent.jjtGetParent()) {
        }
        if (parent == null) {
            throw new IllegalStateException("The enclosing scope must exist.");
        }
        if (parent instanceof ASTInitializer) {
            return ((ASTInitializer)parent).isStatic() ? "static" : "new";
        }
        if (parent instanceof ASTConstructorDeclaration) {
            return "new";
        }
        if (parent instanceof ASTLambdaExpression) {
            return "null";
        }
        if (parent instanceof ASTEnumConstant) {
            return "static";
        }
        if (parent instanceof ASTFieldDeclaration) {
            ASTFieldDeclaration field = (ASTFieldDeclaration)parent;
            if (field.isStatic() || field.isInterfaceMember()) {
                return "static";
            }
            if (this.innermostEnclosingTypeName.peek().isAnonymousClass()) {
                return "";
            }
            if (this.innermostEnclosingTypeName.peek().isLocalClass()) {
                return this.classNames.head();
            }
            return "new";
        }
        return ((ASTMethodDeclaration)parent).getMethodName();
    }

    private static String getOperationName(String methodName, ASTFormalParameters params) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        boolean first = true;
        for (ASTFormalParameter param : params) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(param.getTypeNode().getTypeImage());
            if (!param.isVarargs()) continue;
            sb.append("...");
        }
        sb.append(')');
        return sb.toString();
    }

    private static <T> int getNextIndexFromHistogram(Map<T, Integer> histogram, T key, int startIndex) {
        Integer count = histogram.get(key);
        if (count == null) {
            histogram.put(key, startIndex);
            return startIndex;
        }
        histogram.put(key, count + 1);
        return count + 1;
    }
}

