/**
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */
/* Generated By:JJTree: Do not edit this line. ASTPrimitiveType.java */

package net.sourceforge.pmd.lang.java.ast;

/**
 * Represents a primitive type.
 *
 * <pre>
 *
 * PrimitiveType ::= "boolean" | "char" | "byte" | "short" | "int" | "long" | "float" | "double"
 *
 * </pre>
 */
public class ASTPrimitiveType extends AbstractJavaTypeNode implements Dimensionable {

    private int arrayDepth;

    public ASTPrimitiveType(int id) {
        super(id);
    }

    public ASTPrimitiveType(JavaParser p, int id) {
        super(p, id);
    }

    public boolean isBoolean() {
        return "boolean".equals(getImage());
    }

    /**
     * Accept the visitor. *
     */
    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void bumpArrayDepth() {
        arrayDepth++;
    }

    @Override
    public int getArrayDepth() {
        return arrayDepth;
    }

    @Override
    public boolean isArray() {
        return arrayDepth > 0;
    }

}
