/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.Dimensionable;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class ASTVariableDeclaratorId
extends AbstractJavaTypeNode
implements Dimensionable {
    private int arrayDepth;
    private VariableNameDeclaration nameDeclaration;
    private boolean explicitReceiverParameter = false;

    public ASTVariableDeclaratorId(int id) {
        super(id);
    }

    public ASTVariableDeclaratorId(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public VariableNameDeclaration getNameDeclaration() {
        return this.nameDeclaration;
    }

    public void setNameDeclaration(VariableNameDeclaration decl) {
        this.nameDeclaration = decl;
    }

    public List<NameOccurrence> getUsages() {
        return (List)this.getScope().getDeclarations(VariableNameDeclaration.class).get(this.nameDeclaration);
    }

    public void bumpArrayDepth() {
        ++this.arrayDepth;
    }

    @Override
    public int getArrayDepth() {
        return this.arrayDepth;
    }

    @Override
    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    public boolean isExceptionBlockParameter() {
        return this.jjtGetParent().jjtGetParent() instanceof ASTCatchStatement;
    }

    public boolean isFormalParameter() {
        return this.jjtGetParent() instanceof ASTFormalParameter && !this.isExceptionBlockParameter() && !this.isResourceDeclaration() || this.isLambdaParamWithNoType();
    }

    public boolean isLocalVariable() {
        return this.getNthParent(2) instanceof ASTLocalVariableDeclaration;
    }

    public boolean isLambdaParameter() {
        return this.isLambdaParamWithNoType() || this.jjtGetParent() instanceof ASTFormalParameter && this.getNthParent(3) instanceof ASTLambdaExpression;
    }

    private boolean isLambdaParamWithNoType() {
        return this.jjtGetParent() instanceof ASTLambdaExpression;
    }

    public boolean isField() {
        return this.getNthParent(2) instanceof ASTFieldDeclaration;
    }

    public boolean isFinal() {
        if (this.isResourceDeclaration()) {
            return true;
        }
        if (this.isLambdaParamWithNoType()) {
            return false;
        }
        if (this.jjtGetParent() instanceof ASTFormalParameter) {
            return ((ASTFormalParameter)this.jjtGetParent()).isFinal();
        }
        Node grandpa = this.getNthParent(2);
        if (grandpa instanceof ASTLocalVariableDeclaration) {
            return ((ASTLocalVariableDeclaration)grandpa).isFinal();
        }
        if (grandpa instanceof ASTFieldDeclaration) {
            return ((ASTFieldDeclaration)grandpa).isFinal();
        }
        throw new IllegalStateException("All cases should be handled");
    }

    @Deprecated
    public void setExplicitReceiverParameter() {
        this.explicitReceiverParameter = true;
    }

    public boolean isExplicitReceiverParameter() {
        return this.explicitReceiverParameter;
    }

    public boolean isResourceDeclaration() {
        return this.jjtGetParent() instanceof ASTResource;
    }

    public boolean isTypeInferred() {
        return this.isLambdaParamWithNoType() || this.isLocalVariableTypeInferred() || this.isLambdaTypeInferred();
    }

    private boolean isLocalVariableTypeInferred() {
        if (this.isResourceDeclaration()) {
            return this.jjtGetParent().getFirstChildOfType(ASTType.class) == null;
        }
        if (this.getNthParent(2) instanceof ASTLocalVariableDeclaration) {
            return this.getNthParent(2).getFirstChildOfType(ASTType.class) == null;
        }
        return false;
    }

    private boolean isLambdaTypeInferred() {
        return this.getNthParent(3) instanceof ASTLambdaExpression && this.jjtGetParent().getFirstChildOfType(ASTType.class) == null;
    }

    public Node getTypeNameNode() {
        ASTType type = this.getTypeNode();
        return type == null ? null : this.getTypeNode().jjtGetChild(0);
    }

    public ASTType getTypeNode() {
        if (this.jjtGetParent() instanceof ASTFormalParameter) {
            return ((ASTFormalParameter)this.jjtGetParent()).getTypeNode();
        }
        if (this.isTypeInferred()) {
            return null;
        }
        Node n = this.jjtGetParent().jjtGetParent();
        if (n instanceof ASTLocalVariableDeclaration || n instanceof ASTFieldDeclaration) {
            return (ASTType)n.getFirstChildOfType(ASTType.class);
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        return super.getType();
    }
}

