/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.java.ast.ASTTopLevelDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ASTImportDeclaration
extends AbstractJavaNode
implements ASTTopLevelDeclaration {
    private boolean isImportOnDemand;
    private boolean isStatic;

    ASTImportDeclaration(int id) {
        super(id);
    }

    void setImportOnDemand() {
        this.isImportOnDemand = true;
    }

    public boolean isImportOnDemand() {
        return this.isImportOnDemand;
    }

    void setStatic() {
        this.isStatic = true;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public @NonNull String getImportedName() {
        return super.getImage();
    }

    public String getImage() {
        return null;
    }

    public String getImportedSimpleName() {
        if (this.isImportOnDemand) {
            return null;
        }
        String importName = this.getImportedName();
        return importName.substring(importName.lastIndexOf(46) + 1);
    }

    public String getPackageName() {
        String importName = this.getImportedName();
        if (this.isImportOnDemand) {
            return importName;
        }
        if (importName.indexOf(46) == -1) {
            return "";
        }
        int lastDot = importName.lastIndexOf(46);
        return importName.substring(0, lastDot);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }
}

