/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.DataflowPass;
import net.sourceforge.pmd.lang.java.rule.internal.JavaPropertyUtil;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.CollectionUtil;

public class ImmutableFieldRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<List<String>> IGNORED_ANNOTS = JavaPropertyUtil.ignoredAnnotationsDescriptor(new String[0]);
    private static final Set<String> INVALIDATING_CLASS_ANNOT = CollectionUtil.setOf((Object)"lombok.Builder", (Object[])new String[]{"lombok.Data", "lombok.Getter", "lombok.Setter", "lombok.Value"});

    public ImmutableFieldRule() {
        super(ASTFieldDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(IGNORED_ANNOTS);
    }

    @Override
    public Object visit(ASTFieldDeclaration field, Object data) {
        ASTAnyTypeDeclaration enclosingType = field.getEnclosingType();
        if (field.getEffectiveVisibility().isAtMost(AccessNode.Visibility.V_PRIVATE) && !field.getModifiers().hasAny(JModifier.VOLATILE, JModifier.STATIC, JModifier.FINAL) && !JavaAstUtils.hasAnyAnnotation(enclosingType, INVALIDATING_CLASS_ANNOT) && !JavaAstUtils.hasAnyAnnotation(field, (Collection)this.getProperty(IGNORED_ANNOTS))) {
            DataflowPass.DataflowResult dataflow = DataflowPass.getDataflowResult(field.getRoot());
            block0: for (ASTVariableDeclaratorId varId : field.getVarIds()) {
                boolean isBlank;
                boolean hasWrite = false;
                for (ASTAssignableExpr.ASTNamedReferenceExpr usage : varId.getLocalUsages()) {
                    if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE) continue;
                    hasWrite = true;
                    JavaNode enclosing = (JavaNode)usage.ancestors().map(NodeStream.asInstanceOf(ASTLambdaExpression.class, (Class[])new Class[]{ASTAnyTypeDeclaration.class, ASTConstructorDeclaration.class})).first();
                    if (enclosing instanceof ASTConstructorDeclaration && enclosing.getEnclosingType() == enclosingType) continue;
                    continue block0;
                }
                boolean bl = isBlank = varId.getInitializer() == null;
                if (!hasWrite && !isBlank) {
                    this.addViolation(data, (Node)varId, varId.getName());
                    continue;
                }
                if (!hasWrite || !this.defaultValueDoesNotReachEndOfCtor(dataflow, varId)) continue;
                this.addViolation(data, (Node)varId, varId.getName());
            }
        }
        return null;
    }

    private boolean defaultValueDoesNotReachEndOfCtor(DataflowPass.DataflowResult dataflow, ASTVariableDeclaratorId varId) {
        DataflowPass.AssignmentEntry fieldDef = DataflowPass.getFieldDefinition(varId);
        Set<DataflowPass.AssignmentEntry> killers = dataflow.getKillers(fieldDef);
        return CollectionUtil.none(killers, killer -> killer.isFieldAssignmentAtEndOfCtor() || this.isReassignedOnSomeCodePath(dataflow, (DataflowPass.AssignmentEntry)killer));
    }

    private boolean isReassignedOnSomeCodePath(DataflowPass.DataflowResult dataflow, DataflowPass.AssignmentEntry anAssignment) {
        Set<DataflowPass.AssignmentEntry> killers = dataflow.getKillers(anAssignment);
        return CollectionUtil.any(killers, killer -> !killer.isFieldAssignmentAtEndOfCtor());
    }
}

