/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class OverrideBothEqualsAndHashcodeRule
extends AbstractJavaRule {
    private boolean implementsComparable = false;
    private boolean containsEquals = false;
    private boolean containsHashCode = false;
    private Node nodeFound = null;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        super.visit(node, data);
        if (!this.implementsComparable && this.containsEquals ^ this.containsHashCode) {
            if (this.nodeFound == null) {
                this.nodeFound = node;
            }
            this.addViolation(data, this.nodeFound);
        }
        this.implementsComparable = false;
        this.containsEquals = false;
        this.containsHashCode = false;
        this.nodeFound = null;
        return data;
    }

    @Override
    public Object visit(ASTImplementsList node, Object data) {
        this.implementsComparable = node.children().filter(child -> TypeTestUtil.isA(Comparable.class, (TypeNode)child)).nonEmpty();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (this.implementsComparable) {
            return data;
        }
        int formalParamsCount = node.getFormalParameters().size();
        ASTFormalParameter formalParam = null;
        if (formalParamsCount > 0) {
            formalParam = (ASTFormalParameter)node.getFormalParameters().get(0);
        }
        if (formalParamsCount == 0 && "hashCode".equals(node.getName())) {
            this.containsHashCode = true;
            this.nodeFound = node;
        } else if (formalParamsCount == 1 && "equals".equals(node.getName()) && TypeTestUtil.isExactlyA(Object.class, (TypeNode)formalParam)) {
            this.containsEquals = true;
            this.nodeFound = node;
        }
        return super.visit(node, data);
    }
}

