/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StablePathMatcher {
    private final @Nullable JVariableSymbol owner;
    private final List<Segment> path;

    private StablePathMatcher(@Nullable JVariableSymbol owner, List<Segment> path) {
        this.owner = owner;
        this.path = path;
    }

    public boolean matches(@Nullable ASTExpression e) {
        if (e == null) {
            return false;
        }
        for (Segment segment : this.path) {
            boolean isField = segment.isField;
            String name = segment.name;
            if (isField) {
                if (!(e instanceof ASTFieldAccess)) {
                    return false;
                }
                ASTFieldAccess access = (ASTFieldAccess)e;
                if (!access.getName().equals(name)) {
                    return false;
                }
                e = access.getQualifier();
                continue;
            }
            if (!(e instanceof ASTMethodCall)) {
                return false;
            }
            ASTMethodCall call = (ASTMethodCall)e;
            if (!call.getMethodName().equals(name) || call.getArguments().size() != 0) {
                return false;
            }
            e = call.getQualifier();
        }
        if (e instanceof ASTVariableAccess) {
            return Objects.equals(((ASTVariableAccess)e).getReferencedSym(), this.owner);
        }
        if (e instanceof ASTFieldAccess) {
            ASTFieldAccess fieldAccess = (ASTFieldAccess)e;
            return JavaAstUtils.isUnqualifiedThis(fieldAccess.getQualifier()) && Objects.equals(fieldAccess.getReferencedSym(), this.owner);
        }
        return false;
    }

    public static @Nullable StablePathMatcher matching(ASTExpression e) {
        if (e == null) {
            return null;
        }
        JVariableSymbol owner = null;
        ArrayList<Segment> segments = new ArrayList<Segment>();
        while (e != null) {
            if (e instanceof ASTFieldAccess) {
                ASTFieldAccess access = (ASTFieldAccess)e;
                segments.add(new Segment(access.getName(), true));
                e = access.getQualifier();
                continue;
            }
            if (e instanceof ASTMethodCall) {
                ASTMethodCall call = (ASTMethodCall)e;
                if (JavaRuleUtil.isGetterCall(call)) {
                    segments.add(new Segment(call.getMethodName(), false));
                    e = call.getQualifier();
                    continue;
                }
                return null;
            }
            if (e instanceof ASTVariableAccess) {
                owner = ((ASTVariableAccess)e).getReferencedSym();
                if (owner != null) break;
                return null;
            }
            if (e instanceof ASTThisExpression) {
                if (((ASTThisExpression)e).getQualifier() == null) break;
                return null;
            }
            if (e instanceof ASTSuperExpression) {
                if (((ASTSuperExpression)e).getQualifier() == null) break;
                return null;
            }
            return null;
        }
        return new StablePathMatcher(owner, segments);
    }

    public static StablePathMatcher matching(JVariableSymbol e) {
        return new StablePathMatcher(e, Collections.emptyList());
    }

    private static final class Segment {
        final String name;
        final boolean isField;

        Segment(String name, boolean isField) {
            this.name = name;
            this.isField = isField;
        }

        public String toString() {
            return this.isField ? "." + this.name : "." + this.name + "()";
        }
    }
}

