/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaPropertyUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CommentDefaultAccessModifierRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Pattern> REGEX_DESCRIPTOR = ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"regex").desc("Regular expression")).defaultValue("\\/\\*\\s*(default|package)\\s*\\*\\/").build();
    private static final PropertyDescriptor<Boolean> TOP_LEVEL_TYPES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkTopLevelTypes").desc("Check for default access modifier in top-level classes, annotations, and enums")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<List<String>> IGNORED_ANNOTS = JavaPropertyUtil.ignoredAnnotationsDescriptor("com.google.common.annotations.VisibleForTesting", "android.support.annotation.VisibleForTesting", "co.elastic.clients.util.VisibleForTesting", "org.junit.jupiter.api.Test", "org.junit.jupiter.api.extension.RegisterExtension", "org.junit.jupiter.api.ParameterizedTest", "org.junit.jupiter.api.RepeatedTest", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.api.TestTemplate", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.AfterAll", "org.testng.annotations.Test", "org.testng.annotations.AfterClass", "org.testng.annotations.AfterGroups", "org.testng.annotations.AfterMethod", "org.testng.annotations.AfterSuite", "org.testng.annotations.AfterTest", "org.testng.annotations.BeforeClass", "org.testng.annotations.BeforeGroups", "org.testng.annotations.BeforeMethod", "org.testng.annotations.BeforeSuite", "org.testng.annotations.BeforeTest");

    public CommentDefaultAccessModifierRule() {
        super(ASTMethodDeclaration.class, ASTAnyTypeDeclaration.class, ASTConstructorDeclaration.class, ASTFieldDeclaration.class);
        this.definePropertyDescriptor(IGNORED_ANNOTS);
        this.definePropertyDescriptor(REGEX_DESCRIPTOR);
        this.definePropertyDescriptor(TOP_LEVEL_TYPES);
    }

    @Override
    public Object visit(ASTMethodDeclaration decl, Object data) {
        if (this.shouldReportNonTopLevel(decl)) {
            this.report((RuleContext)data, decl, "method", PrettyPrintingUtil.displaySignature(decl));
        }
        return data;
    }

    @Override
    public Object visit(ASTFieldDeclaration decl, Object data) {
        if (this.shouldReportNonTopLevel(decl)) {
            this.report((RuleContext)data, decl, "field", ((ASTVariableDeclaratorId)decl.getVarIds().firstOrThrow()).getName());
        }
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration decl, Object data) {
        if (this.shouldReportNonTopLevel(decl)) {
            this.report((RuleContext)data, decl, "constructor", PrettyPrintingUtil.displaySignature(decl));
        }
        return data;
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration decl, Object data) {
        this.checkTypeDecl(decl, (RuleContext)data, "annotation");
        return data;
    }

    @Override
    public Object visit(ASTEnumDeclaration decl, Object data) {
        this.checkTypeDecl(decl, (RuleContext)data, "enum");
        return data;
    }

    @Override
    public Object visit(ASTRecordDeclaration decl, Object data) {
        this.checkTypeDecl(decl, (RuleContext)data, "record");
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        this.checkTypeDecl(decl, (RuleContext)data, "class");
        return data;
    }

    private void checkTypeDecl(ASTAnyTypeDeclaration decl, RuleContext ctx, String typeKind) {
        if (decl.isNested() && this.shouldReportNonTopLevel(decl)) {
            this.report(ctx, decl, "nested " + typeKind, decl.getSimpleName());
        } else if (!decl.isNested() && this.shouldReportTypeDeclaration(decl)) {
            this.report(ctx, decl, "top-level " + typeKind, decl.getSimpleName());
        }
    }

    private void report(RuleContext ctx, AccessNode decl, String kind, String signature) {
        ctx.addViolation((Node)decl, new Object[]{kind, signature});
    }

    private boolean shouldReportNonTopLevel(AccessNode decl) {
        ASTAnyTypeDeclaration enclosing = decl.getEnclosingType();
        return this.isMissingComment(decl) && this.isNotIgnored(decl) && (!(decl instanceof ASTFieldDeclaration) || !enclosing.isAnnotationPresent("lombok.Value"));
    }

    private boolean isMissingComment(AccessNode decl) {
        return decl.getVisibility() == AccessNode.Visibility.V_PACKAGE && !this.hasOkComment(decl);
    }

    private boolean isNotIgnored(AccessNode decl) {
        return ((List)this.getProperty(IGNORED_ANNOTS)).stream().noneMatch(decl::isAnnotationPresent);
    }

    private boolean hasOkComment(AccessNode node) {
        Pattern regex = (Pattern)this.getProperty(REGEX_DESCRIPTOR);
        return JavaComment.getLeadingComments(node).anyMatch(it -> regex.matcher((CharSequence)it.getText()).matches());
    }

    private boolean shouldReportTypeDeclaration(ASTAnyTypeDeclaration decl) {
        return !(decl.isRegularInterface() && !decl.isAnnotation() || !this.isMissingComment(decl) || !this.isNotIgnored(decl) || !decl.isNested() && (Boolean)this.getProperty(TOP_LEVEL_TYPES) == false);
    }
}

