/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTRecordDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import org.apache.commons.lang3.StringUtils;

public class UnnecessaryModifierRule
extends AbstractJavaRulechainRule {
    public UnnecessaryModifierRule() {
        super(ASTAnyTypeDeclaration.class, ASTMethodDeclaration.class, ASTResource.class, ASTFieldDeclaration.class, ASTConstructorDeclaration.class);
        this.addRuleChainVisit(ASTRecordDeclaration.class);
    }

    private void reportUnnecessaryModifiers(Object data, JavaNode node, JModifier unnecessaryModifier, String explanation) {
        this.reportUnnecessaryModifiers(data, node, EnumSet.of(unnecessaryModifier), explanation);
    }

    private void reportUnnecessaryModifiers(Object data, JavaNode node, Set<JModifier> unnecessaryModifiers, String explanation) {
        if (unnecessaryModifiers.isEmpty()) {
            return;
        }
        super.addViolation(data, (Node)node, (Object[])new String[]{this.formatUnnecessaryModifiers(unnecessaryModifiers), PrettyPrintingUtil.getPrintableNodeKind(node), PrettyPrintingUtil.getNodeName(node), explanation.isEmpty() ? "" : ": " + explanation});
    }

    private String formatUnnecessaryModifiers(Set<JModifier> set) {
        return (set.size() > 1 ? "s" : "") + " '" + StringUtils.join(set, (String)" ") + "'";
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        if (node.hasExplicitModifiers(JModifier.PUBLIC, new JModifier[0])) {
            this.checkDeclarationInInterfaceType(data, node, EnumSet.of(JModifier.PUBLIC));
        }
        if (node.hasExplicitModifiers(JModifier.STATIC, new JModifier[0])) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.STATIC, "nested enums are implicitly static");
        }
        return data;
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        if (node.hasExplicitModifiers(JModifier.ABSTRACT, new JModifier[0])) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.ABSTRACT, "annotations types are implicitly abstract");
        }
        if (!node.isNested()) {
            return data;
        }
        this.checkDeclarationInInterfaceType(data, node, EnumSet.of(JModifier.PUBLIC));
        if (node.hasExplicitModifiers(JModifier.STATIC, new JModifier[0])) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.STATIC, "nested annotation types are implicitly static");
        }
        return data;
    }

    private boolean isParentInterfaceType(AccessNode node) {
        ASTAnyTypeDeclaration enclosing = node.getEnclosingType();
        return enclosing != null && enclosing.isInterface();
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface() && node.hasExplicitModifiers(JModifier.ABSTRACT, new JModifier[0])) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.ABSTRACT, "interface types are implicitly abstract");
        }
        if (!node.isNested()) {
            return data;
        }
        this.checkDeclarationInInterfaceType(data, node, EnumSet.of(JModifier.PUBLIC, JModifier.STATIC));
        if (node.hasExplicitModifiers(JModifier.STATIC, new JModifier[0]) && node.isInterface() && !this.isParentInterfaceType(node)) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.STATIC, "member interfaces are implicitly static");
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        this.checkDeclarationInInterfaceType(data, node, EnumSet.of(JModifier.PUBLIC, JModifier.ABSTRACT));
        if (node.hasExplicitModifiers(JModifier.FINAL, new JModifier[0]) && !this.isSafeVarargs(node)) {
            if (node.hasModifiers(JModifier.PRIVATE, new JModifier[0])) {
                this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.FINAL, "private methods cannot be overridden");
            } else {
                ASTAnyTypeDeclaration n = node.getEnclosingType();
                if (n.isAnonymous()) {
                    this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.FINAL, "an anonymous class cannot be extended");
                } else if (n.isFinal()) {
                    this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.FINAL, "the method is already in a final class");
                }
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTResource node, Object data) {
        if (!node.isConciseResource() && node.asLocalVariableDeclaration().hasExplicitModifiers(JModifier.FINAL, new JModifier[0])) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.FINAL, "resource specifications are implicitly final");
        }
        return data;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        this.checkDeclarationInInterfaceType(data, node, EnumSet.of(JModifier.PUBLIC, JModifier.STATIC, JModifier.FINAL));
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (node.getEnclosingType().isEnum() && node.hasExplicitModifiers(JModifier.PRIVATE, new JModifier[0])) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.PRIVATE, "enum constructors are implicitly private");
        }
        return data;
    }

    @Override
    public Object visit(ASTRecordDeclaration node, Object data) {
        if (node.hasExplicitModifiers(JModifier.STATIC, new JModifier[0])) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.STATIC, "records are implicitly static");
        }
        if (node.hasExplicitModifiers(JModifier.FINAL, new JModifier[0])) {
            this.reportUnnecessaryModifiers(data, (JavaNode)node, JModifier.FINAL, "records are implicitly final");
        }
        return data;
    }

    private boolean isSafeVarargs(ASTMethodDeclaration node) {
        return node.isAnnotationPresent(SafeVarargs.class.getName());
    }

    private void checkDeclarationInInterfaceType(Object data, AccessNode member, Set<JModifier> unnecessary) {
        ASTAnyTypeDeclaration parent = member.getEnclosingType();
        if (this.isParentInterfaceType(member)) {
            unnecessary.removeIf(mod -> !member.hasExplicitModifiers((JModifier)((Object)mod), new JModifier[0]));
            String explanation = "the " + PrettyPrintingUtil.getPrintableNodeKind(member) + " is declared in an " + PrettyPrintingUtil.getPrintableNodeKind(parent) + " type";
            this.reportUnnecessaryModifiers(data, (JavaNode)member, unnecessary, explanation);
        }
    }
}

