/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.internal;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.rule.internal.CommonPropertyDescriptors;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public abstract class AbstractJavaCounterCheckRule<T extends JavaNode>
extends AbstractJavaRulechainRule {
    private final PropertyDescriptor<Integer> reportLevel = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)CommonPropertyDescriptors.reportLevelProperty().desc("Threshold above which a node is reported")).require(NumericConstraints.positive())).defaultValue((Object)this.defaultReportLevel())).build();

    public AbstractJavaCounterCheckRule(Class<T> nodeType) {
        super(nodeType, new Class[0]);
        this.definePropertyDescriptor(this.reportLevel);
    }

    protected abstract int defaultReportLevel();

    protected boolean isIgnored(T node) {
        return false;
    }

    protected abstract boolean isViolation(T var1, int var2);

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        JavaNode t = node;
        if (!this.isIgnored(t) && this.isViolation(t, (Integer)this.getProperty(this.reportLevel))) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    public static abstract class AbstractLineLengthCheckRule<T extends JavaNode>
    extends AbstractJavaCounterCheckRule<T> {
        public AbstractLineLengthCheckRule(Class<T> nodeType) {
            super(nodeType);
        }

        @Override
        protected final boolean isViolation(T node, int reportLevel) {
            return (Integer)JavaMetrics.LINES_OF_CODE.computeFor(node, MetricOptions.emptyOptions()) > reportLevel;
        }
    }
}

