/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.util.CollectionUtil;

public class RedundantFieldInitializerRule
extends AbstractJavaRulechainRule {
    private static final Set<String> MAKE_FIELD_FINAL_CLASS_ANNOT = CollectionUtil.setOf((Object)"lombok.Value", (Object[])new String[0]);

    public RedundantFieldInitializerRule() {
        super(ASTFieldDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTFieldDeclaration fieldDeclaration, Object data) {
        if (!fieldDeclaration.hasModifiers(JModifier.FINAL, new JModifier[0]) && !JavaAstUtils.hasAnyAnnotation(fieldDeclaration.getEnclosingType(), MAKE_FIELD_FINAL_CLASS_ANNOT)) {
            for (ASTVariableDeclaratorId varId : fieldDeclaration.getVarIds()) {
                ASTExpression init = varId.getInitializer();
                if (init == null || RedundantFieldInitializerRule.isWhitelisted(init) || !JavaAstUtils.isDefaultValue(varId.getTypeMirror(), init)) continue;
                this.addViolation(data, (Node)varId);
            }
        }
        return data;
    }

    private static boolean isWhitelisted(ASTExpression e) {
        return e.descendantsOrSelf().any(it -> it instanceof ASTVariableAccess || it instanceof ASTFieldAccess);
    }
}

