/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTThrowsList;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavadocCommentOwner;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeParamOwnerNode;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ASTExecutableDeclaration
extends ModifierOwner,
ASTBodyDeclaration,
TypeParamOwnerNode,
GenericNode<JavaNode>,
JavadocCommentOwner {
    @Override
    public JExecutableSymbol getSymbol();

    public JMethodSig getGenericSignature();

    public String getName();

    default public boolean isAbstract() {
        return this.hasModifiers(JModifier.ABSTRACT, new JModifier[0]);
    }

    default public @NonNull ASTFormalParameters getFormalParameters() {
        return (ASTFormalParameters)this.firstChild(ASTFormalParameters.class);
    }

    default public int getArity() {
        return this.getFormalParameters().size();
    }

    default public @Nullable ASTBlock getBody() {
        JavaNode last = (JavaNode)this.getLastChild();
        return last instanceof ASTBlock ? (ASTBlock)last : null;
    }

    default public @Nullable ASTThrowsList getThrowsList() {
        return (ASTThrowsList)this.firstChild(ASTThrowsList.class);
    }

    default public boolean isVarargs() {
        JavaNode lastFormal = (JavaNode)this.getFormalParameters().getLastChild();
        return lastFormal instanceof ASTFormalParameter && ((ASTFormalParameter)lastFormal).isVarargs();
    }

    default public boolean isStatic() {
        return this.hasModifiers(JModifier.STATIC, new JModifier[0]);
    }

    default public boolean isFinal() {
        return this.hasModifiers(JModifier.FINAL, new JModifier[0]);
    }
}

