/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast.internal;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLabeledStatement;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTNumericLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.AssignmentOp;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.QualifiableExpression;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.UnaryOp;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstLocalVarSym;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavaAstUtils {
    private JavaAstUtils() {
    }

    public static boolean isConditional(JavaNode ifx) {
        return JavaAstUtils.isInfixExprWithOperator(ifx, BinaryOp.CONDITIONAL_OPS);
    }

    public static int numAlternatives(ASTSwitchBranch n) {
        return n.isDefault() ? 1 : n.getLabel().getExprList().count();
    }

    public static boolean isLiteralInt(JavaNode e, int value) {
        return e instanceof ASTNumericLiteral && ((ASTNumericLiteral)e).isIntegral() && ((ASTNumericLiteral)e).getValueAsInt() == value;
    }

    public static boolean isStringConcatExpr(@Nullable JavaNode e) {
        if (e instanceof ASTInfixExpression) {
            ASTInfixExpression infix = (ASTInfixExpression)e;
            return infix.getOperator() == BinaryOp.ADD && TypeTestUtil.isA(String.class, (TypeNode)infix);
        }
        return false;
    }

    public static @Nullable ASTExpression getOtherOperandIfInInfixExpr(@Nullable JavaNode e) {
        if (e != null && e.getParent() instanceof ASTInfixExpression) {
            return (ASTExpression)((JavaNode)e.getParent()).getChild(1 - e.getIndexInParent());
        }
        return null;
    }

    public static @Nullable ASTExpression getOtherOperandIfInAssignmentExpr(@Nullable JavaNode e) {
        if (e != null && e.getParent() instanceof ASTAssignmentExpression) {
            return (ASTExpression)((JavaNode)e.getParent()).getChild(1 - e.getIndexInParent());
        }
        return null;
    }

    public static boolean isMainMethod(JavaNode node) {
        return node instanceof ASTMethodDeclaration && ((ASTMethodDeclaration)node).isMainMethod();
    }

    public static boolean hasField(ASTTypeDeclaration node, String name) {
        if (node == null) {
            return false;
        }
        for (JFieldSymbol f : node.getSymbol().getDeclaredFields()) {
            String fname = f.getSimpleName();
            if (fname.startsWith("m_") || fname.startsWith("_")) {
                fname = fname.substring(fname.indexOf(95) + 1);
            }
            if (!fname.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParameters(ASTExecutableDeclaration node, Class<?> ... types) {
        ASTFormalParameters formals = node.getFormalParameters();
        if (formals.size() != types.length) {
            return false;
        }
        for (int i = 0; i < formals.size(); ++i) {
            ASTFormalParameter fi = (ASTFormalParameter)formals.get(i);
            if (TypeTestUtil.isExactlyA(types[i], (TypeNode)fi)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static boolean hasExceptionList(ASTExecutableDeclaration node, Class<? extends Throwable> ... types) {
        @NonNull List<ASTClassType> formals = ASTList.orEmpty(node.getThrowsList());
        if (formals.size() != types.length) {
            return false;
        }
        for (int i = 0; i < formals.size(); ++i) {
            ASTClassType fi = formals.get(i);
            if (TypeTestUtil.isExactlyA(types[i], (TypeNode)fi)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNeverUsed(ASTVariableId varId) {
        return CollectionUtil.none(varId.getLocalUsages(), JavaAstUtils::isReadUsage);
    }

    private static boolean isReadUsage(ASTAssignableExpr.ASTNamedReferenceExpr expr) {
        return expr.getAccessType() == ASTAssignableExpr.AccessType.READ || expr.getParent() instanceof ASTUnaryExpression && !(((JavaNode)expr.getParent()).getParent() instanceof ASTExpressionStatement);
    }

    public static boolean isVarAccessReadAndWrite(ASTAssignableExpr.ASTNamedReferenceExpr expr) {
        return expr.getAccessType() == ASTAssignableExpr.AccessType.WRITE && (!(expr.getParent() instanceof ASTAssignmentExpression) || ((ASTAssignmentExpression)expr.getParent()).getOperator().isCompound());
    }

    public static boolean isVarAccessStrictlyWrite(ASTAssignableExpr.ASTNamedReferenceExpr expr) {
        return expr.getParent() instanceof ASTAssignmentExpression && expr.getIndexInParent() == 0 && !((ASTAssignmentExpression)expr.getParent()).getOperator().isCompound();
    }

    public static Set<String> getStatementLabels(ASTStatement node) {
        if (!(node.getParent() instanceof ASTLabeledStatement)) {
            return Collections.emptySet();
        }
        return node.ancestors().takeWhile(it -> it instanceof ASTLabeledStatement).toStream().map(it -> ((ASTLabeledStatement)it).getLabel()).collect(Collectors.toSet());
    }

    public static boolean isAnonymousClassCreation(@Nullable ASTExpression expression) {
        return expression instanceof ASTConstructorCall && ((ASTConstructorCall)expression).isAnonymousClass();
    }

    public static @NonNull ASTExpression getTopLevelExpr(ASTExpression expr) {
        JavaNode last = (JavaNode)expr.ancestorsOrSelf().takeWhile(it -> it instanceof ASTExpression || it instanceof ASTArgumentList && it.getParent() instanceof ASTExpression).last();
        return (ASTExpression)Objects.requireNonNull(last);
    }

    public static NodeStream<ASTVariableId> getLoopVariables(ASTForStatement loop) {
        return NodeStream.of((Node)loop.getInit()).filterIs(ASTLocalVariableDeclaration.class).flatMap(rec$ -> ((ASTLocalVariableDeclaration)rec$).getVarIds());
    }

    public static boolean areComplements(ASTExpression e1, ASTExpression e2) {
        if (JavaAstUtils.isBooleanNegation(e1)) {
            return JavaAstUtils.areEqual(JavaAstUtils.unaryOperand(e1), e2);
        }
        if (JavaAstUtils.isBooleanNegation(e2)) {
            return JavaAstUtils.areEqual(e1, JavaAstUtils.unaryOperand(e2));
        }
        if (e1 instanceof ASTInfixExpression && e2 instanceof ASTInfixExpression) {
            ASTInfixExpression ifx1 = (ASTInfixExpression)e1;
            ASTInfixExpression ifx2 = (ASTInfixExpression)e2;
            if (ifx1.getOperator().getComplement() != ifx2.getOperator()) {
                return false;
            }
            if (ifx1.getOperator().hasSamePrecedenceAs(BinaryOp.EQ)) {
                return JavaAstUtils.areEqual(ifx1.getLeftOperand(), ifx2.getLeftOperand()) && JavaAstUtils.areEqual(ifx1.getRightOperand(), ifx2.getRightOperand()) || JavaAstUtils.areEqual(ifx2.getLeftOperand(), ifx1.getLeftOperand()) && JavaAstUtils.areEqual(ifx2.getRightOperand(), ifx1.getRightOperand());
            }
        }
        return false;
    }

    private static boolean areEqual(ASTExpression e1, ASTExpression e2) {
        return JavaAstUtils.tokenEquals(e1, e2);
    }

    public static boolean tokenEquals(JavaNode node, JavaNode that) {
        return JavaAstUtils.tokenEquals(node, that, null);
    }

    public static boolean tokenEquals(@NonNull JavaNode node, @NonNull JavaNode other, @Nullable Function<String, @NonNull String> varRenamer) {
        Iterator thisIt = GenericToken.range((GenericToken)node.getFirstToken(), (GenericToken)node.getLastToken()).iterator();
        Iterator thatIt = GenericToken.range((GenericToken)other.getFirstToken(), (GenericToken)other.getLastToken()).iterator();
        int lastKind = 0;
        while (thisIt.hasNext()) {
            if (!thatIt.hasNext()) {
                return false;
            }
            JavaccToken o1 = (JavaccToken)thisIt.next();
            JavaccToken o2 = (JavaccToken)thatIt.next();
            if (o1.kind != o2.kind) {
                return false;
            }
            String mappedImage = o1.getImage();
            if (varRenamer != null && o1.kind == 87 && lastKind != 98 && lastKind != 136 && o1.getNext() != null && o1.getNext().kind != 90) {
                mappedImage = varRenamer.apply(mappedImage);
            }
            if (!o2.getImage().equals(mappedImage)) {
                return false;
            }
            lastKind = o1.kind;
        }
        return !thatIt.hasNext();
    }

    public static boolean isNullLiteral(ASTExpression node) {
        return node instanceof ASTNullLiteral;
    }

    public static boolean isBooleanLiteral(JavaNode e) {
        return e instanceof ASTBooleanLiteral;
    }

    public static boolean isBooleanLiteral(JavaNode e, boolean value) {
        return e instanceof ASTBooleanLiteral && ((ASTBooleanLiteral)e).isTrue() == value;
    }

    public static boolean isBooleanNegation(JavaNode e) {
        return e instanceof ASTUnaryExpression && ((ASTUnaryExpression)e).getOperator() == UnaryOp.NEGATION;
    }

    public static @Nullable ASTExpression unaryOperand(@Nullable ASTExpression e) {
        return e instanceof ASTUnaryExpression ? ((ASTUnaryExpression)e).getOperand() : null;
    }

    public static boolean isThisFieldAccess(ASTExpression e) {
        if (!(e instanceof ASTAssignableExpr.ASTNamedReferenceExpr)) {
            return false;
        }
        JVariableSymbol sym = ((ASTAssignableExpr.ASTNamedReferenceExpr)e).getReferencedSym();
        return sym instanceof JFieldSymbol && !((JFieldSymbol)sym).isStatic() && ((JFieldSymbol)sym).getEnclosingClass().equals(e.getEnclosingType().getSymbol()) && (e instanceof ASTVariableAccess || JavaAstUtils.isSyntacticThisFieldAccess(e));
    }

    public static boolean isSyntacticThisFieldAccess(ASTExpression e) {
        ASTExpression qualifier;
        if (e instanceof ASTFieldAccess && (qualifier = ((ASTFieldAccess)e).getQualifier()) instanceof ASTThisExpression) {
            return ((ASTThisExpression)qualifier).getQualifier() == null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAnyAnnotation(Annotatable node, Collection<String> qualifiedNames) {
        if (node == null) return false;
        if (!qualifiedNames.stream().anyMatch(node::isAnnotationPresent)) return false;
        return true;
    }

    public static boolean isDefaultValue(JTypeMirror type, ASTExpression expr) {
        if (type.isPrimitive()) {
            if (type.isPrimitive(JPrimitiveType.PrimitiveTypeKind.BOOLEAN)) {
                return expr instanceof ASTBooleanLiteral && !((ASTBooleanLiteral)expr).isTrue();
            }
            Object constValue = expr.getConstValue();
            return constValue instanceof Number && ((Number)constValue).doubleValue() == 0.0 || constValue instanceof Character && constValue.equals(Character.valueOf('\u0000'));
        }
        return expr instanceof ASTNullLiteral;
    }

    public static boolean isReferenceToVar(@Nullable ASTExpression expression, @NonNull JVariableSymbol symbol) {
        return expression instanceof ASTAssignableExpr.ASTNamedReferenceExpr && symbol.equals(((ASTAssignableExpr.ASTNamedReferenceExpr)expression).getReferencedSym());
    }

    public static boolean isUnqualifiedThis(ASTExpression e) {
        return e instanceof ASTThisExpression && ((ASTThisExpression)e).getQualifier() == null;
    }

    public static boolean isUnqualifiedSuper(ASTExpression e) {
        return e instanceof ASTSuperExpression && ((ASTSuperExpression)e).getQualifier() == null;
    }

    public static boolean isUnqualifiedThisOrSuper(ASTExpression e) {
        return JavaAstUtils.isUnqualifiedSuper(e) || JavaAstUtils.isUnqualifiedThis(e);
    }

    public static boolean isReferenceToVar(@Nullable ASTExpression expression, @NonNull Set<? extends JVariableSymbol> symbols) {
        return expression instanceof ASTAssignableExpr.ASTNamedReferenceExpr && symbols.contains(((ASTAssignableExpr.ASTNamedReferenceExpr)expression).getReferencedSym());
    }

    public static boolean isReferenceToSameVar(ASTExpression e1, ASTExpression e2) {
        if (e1 instanceof ASTAssignableExpr.ASTNamedReferenceExpr && e2 instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
            if (OptionalBool.YES != JavaAstUtils.referenceSameSymbol((ASTAssignableExpr.ASTNamedReferenceExpr)e1, (ASTAssignableExpr.ASTNamedReferenceExpr)e2)) {
                return false;
            }
            if (e1.getClass() != e2.getClass()) {
                return JavaAstUtils.isSyntacticThisFieldAccess(e1) || JavaAstUtils.isSyntacticThisFieldAccess(e2);
            }
            if (e1 instanceof ASTFieldAccess && e2 instanceof ASTFieldAccess) {
                return JavaAstUtils.isReferenceToSameVar(((ASTFieldAccess)e1).getQualifier(), ((ASTFieldAccess)e2).getQualifier());
            }
            return e1 instanceof ASTVariableAccess && e2 instanceof ASTVariableAccess;
        }
        if (e1 instanceof ASTThisExpression || e2 instanceof ASTThisExpression) {
            return e1.getClass() == e2.getClass();
        }
        return false;
    }

    private static OptionalBool referenceSameSymbol(ASTAssignableExpr.ASTNamedReferenceExpr e1, ASTAssignableExpr.ASTNamedReferenceExpr e2) {
        if (!e1.getName().equals(e2.getName())) {
            return OptionalBool.NO;
        }
        JVariableSymbol ref1 = e1.getReferencedSym();
        JVariableSymbol ref2 = e2.getReferencedSym();
        if (ref1 == null || ref2 == null) {
            return OptionalBool.UNKNOWN;
        }
        return OptionalBool.definitely((boolean)ref1.equals(ref2));
    }

    public static boolean isReferenceToLocal(ASTExpression expr) {
        return expr instanceof ASTVariableAccess && ((ASTVariableAccess)expr).getReferencedSym() instanceof AstLocalVarSym;
    }

    public static boolean isRefToFieldOfThisInstance(ASTExpression usage) {
        if (!(usage instanceof ASTAssignableExpr.ASTNamedReferenceExpr)) {
            return false;
        }
        JVariableSymbol symbol = ((ASTAssignableExpr.ASTNamedReferenceExpr)usage).getReferencedSym();
        if (!(symbol instanceof JFieldSymbol)) {
            return false;
        }
        if (usage instanceof ASTVariableAccess) {
            return !Modifier.isStatic(((JFieldSymbol)symbol).getModifiers());
        }
        if (usage instanceof ASTFieldAccess) {
            return JavaAstUtils.isUnqualifiedThisOrSuper(((ASTFieldAccess)usage).getQualifier());
        }
        return false;
    }

    public static boolean isRefToFieldOfThisClass(ASTExpression usage) {
        if (!(usage instanceof ASTAssignableExpr.ASTNamedReferenceExpr)) {
            return false;
        }
        JVariableSymbol symbol = ((ASTAssignableExpr.ASTNamedReferenceExpr)usage).getReferencedSym();
        if (!(symbol instanceof JFieldSymbol)) {
            return false;
        }
        if (usage instanceof ASTVariableAccess) {
            return !Modifier.isStatic(((JFieldSymbol)symbol).getModifiers());
        }
        if (usage instanceof ASTFieldAccess && usage.getEnclosingType() != null) {
            return Objects.equals(((JFieldSymbol)symbol).getEnclosingClass(), usage.getEnclosingType().getSymbol());
        }
        return false;
    }

    public static OptionalBool isCallOnThisInstance(ASTMethodCall call) {
        if (call.getQualifier() != null) {
            return OptionalBool.definitely((boolean)JavaAstUtils.isUnqualifiedThisOrSuper(call.getQualifier()));
        }
        JMethodSig mtype = call.getMethodType();
        JExecutableSymbol methodSym = mtype.getSymbol();
        if (methodSym.isUnresolved()) {
            return OptionalBool.UNKNOWN;
        }
        return OptionalBool.definitely((!methodSym.isStatic() && methodSym.getEnclosingClass().equals(call.getEnclosingType().getSymbol()) ? 1 : 0) != 0);
    }

    public static ASTClassType getThisOrSuperQualifier(ASTExpression expr) {
        if (expr instanceof ASTThisExpression) {
            return ((ASTThisExpression)expr).getQualifier();
        }
        if (expr instanceof ASTSuperExpression) {
            return ((ASTSuperExpression)expr).getQualifier();
        }
        return null;
    }

    public static boolean isThisOrSuper(ASTExpression expr) {
        return expr instanceof ASTThisExpression || expr instanceof ASTSuperExpression;
    }

    public static NodeStream<ASTExpression> flattenOperands(ASTExpression e) {
        ArrayList<ASTExpression> result = new ArrayList<ASTExpression>();
        JavaAstUtils.flattenOperandsRec(e, result);
        return NodeStream.fromIterable(result);
    }

    private static void flattenOperandsRec(ASTExpression e, List<ASTExpression> result) {
        if (JavaAstUtils.isStringConcatExpr(e)) {
            ASTInfixExpression infix = (ASTInfixExpression)e;
            JavaAstUtils.flattenOperandsRec(infix.getLeftOperand(), result);
            JavaAstUtils.flattenOperandsRec(infix.getRightOperand(), result);
        } else {
            result.add(e);
        }
    }

    public static boolean isLastChild(Node it) {
        Node parent = it.getParent();
        return parent != null && it.getIndexInParent() == parent.getNumChildren() - 1;
    }

    public static NodeStream<QualifiableExpression> followingCallChain(ASTExpression expr) {
        return expr.ancestors().takeWhile(it -> it instanceof QualifiableExpression);
    }

    public static ASTExpression peelCasts(@Nullable ASTExpression expr) {
        while (expr instanceof ASTCastExpression) {
            expr = ((ASTCastExpression)expr).getOperand();
        }
        return expr;
    }

    public static boolean isArrayInitializer(ASTExpression expr) {
        return expr instanceof ASTArrayAllocation && ((ASTArrayAllocation)expr).getArrayInitializer() != null;
    }

    public static boolean isCloneMethod(ASTMethodDeclaration node) {
        return "clone".equals(node.getName()) && node.getArity() == 0 && !node.isStatic();
    }

    public static boolean isEqualsMethod(ASTMethodDeclaration node) {
        return "equals".equals(node.getName()) && node.getArity() == 1 && ((ASTFormalParameter)node.getFormalParameters().get(0)).getTypeMirror().isTop() && !node.isStatic();
    }

    public static boolean isHashCodeMethod(ASTMethodDeclaration node) {
        return "hashCode".equals(node.getName()) && node.getArity() == 0 && !node.isStatic();
    }

    public static boolean isArrayLengthFieldAccess(ASTExpression node) {
        if (node instanceof ASTFieldAccess) {
            ASTFieldAccess field = (ASTFieldAccess)node;
            return "length".equals(field.getName()) && field.getQualifier().getTypeMirror().isArray();
        }
        return false;
    }

    public static boolean mayBeBreakTarget(JavaNode it) {
        return it instanceof ASTLoopStatement || it instanceof ASTSwitchStatement || it instanceof ASTLabeledStatement;
    }

    public static boolean isInfixExprWithOperator(@Nullable JavaNode e, Set<BinaryOp> operators) {
        if (e instanceof ASTInfixExpression) {
            ASTInfixExpression infix = (ASTInfixExpression)e;
            return operators.contains(infix.getOperator());
        }
        return false;
    }

    public static boolean isInfixExprWithOperator(@Nullable JavaNode e, BinaryOp operator) {
        if (e instanceof ASTInfixExpression) {
            ASTInfixExpression infix = (ASTInfixExpression)e;
            return operator == infix.getOperator();
        }
        return false;
    }

    public static boolean isAssignmentExprWithOperator(@Nullable JavaNode e, AssignmentOp operator) {
        if (e instanceof ASTAssignmentExpression) {
            ASTAssignmentExpression infix = (ASTAssignmentExpression)e;
            return operator == infix.getOperator();
        }
        return false;
    }

    public static boolean isComment(JavaccToken t) {
        switch (t.kind) {
            case 4: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJustRethrowException(ASTCatchClause clause) {
        ASTBlock body = clause.getBody();
        if (body.size() == 1) {
            ASTStatement stmt = (ASTStatement)body.get(0);
            return stmt instanceof ASTThrowStatement && JavaAstUtils.isReferenceToVar(((ASTThrowStatement)stmt).getExpr(), (JVariableSymbol)clause.getParameter().getVarId().getSymbol());
        }
        return false;
    }

    public static boolean isInStaticCtx(JavaNode node) {
        return node.ancestors().any(it -> it instanceof ASTExecutableDeclaration && ((ASTExecutableDeclaration)it).isStatic() || it instanceof ASTInitializer && ((ASTInitializer)it).isStatic() || it instanceof ASTExplicitConstructorInvocation);
    }
}

