/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.impl.GenericNode;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ASTAssignableExpr
extends ASTPrimaryExpression {
    default public @NonNull AccessType getAccessType() {
        GenericNode parent = this.getParent();
        if (parent instanceof ASTUnaryExpression && !((ASTUnaryExpression)parent).getOperator().isPure() || this.getIndexInParent() == 0 && parent instanceof ASTAssignmentExpression) {
            return AccessType.WRITE;
        }
        return AccessType.READ;
    }

    public static enum AccessType {
        READ,
        WRITE;

    }

    public static interface ASTNamedReferenceExpr
    extends ASTAssignableExpr {
        public String getName();

        public @Nullable JVariableSig getSignature();

        default public @Nullable JVariableSymbol getReferencedSym() {
            JVariableSig sig = this.getSignature();
            return sig == null ? null : sig.getSymbol();
        }
    }
}

