/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.BaseFunctionalMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MethodRefMirrorImpl
extends BaseFunctionalMirror<ASTMethodReference>
implements ExprMirror.MethodRefMirror {
    private JMethodSig exactMethod;
    private JMethodSig ctdecl;

    MethodRefMirrorImpl(JavaExprMirrors mirrors, ASTMethodReference lambda, ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
        super(mirrors, lambda, parent, subexprMaker);
        this.exactMethod = mirrors.ts.UNRESOLVED_METHOD;
        this.setFunctionalMethod(mirrors.ts.UNRESOLVED_METHOD);
        this.setCompileTimeDecl(mirrors.ts.UNRESOLVED_METHOD);
    }

    @Override
    public void finishFailedInference(@Nullable JTypeMirror targetType) {
        JMethodSig exactMethod;
        super.finishFailedInference(targetType);
        if (!TypeOps.isUnresolved(this.getTypeToSearch()) && (exactMethod = ExprOps.getExactMethod(this)) != null) {
            this.setCompileTimeDecl(exactMethod);
            return;
        }
        this.setCompileTimeDecl(this.factory.ts.UNRESOLVED_METHOD);
    }

    @Override
    public boolean isEquivalentToUnderlyingAst() {
        AssertionUtil.validateState((this.ctdecl != null ? 1 : 0) != 0, (String)"overload resolution is not complete");
        return ((ASTMethodReference)this.myNode).getReferencedMethod().equals(this.ctdecl);
    }

    @Override
    public boolean isConstructorRef() {
        return ((ASTMethodReference)this.myNode).isConstructorReference();
    }

    @Override
    public JTypeMirror getLhsIfType() {
        ASTExpression lhsType = ((ASTMethodReference)this.myNode).getQualifier();
        return lhsType instanceof ASTTypeExpression ? lhsType.getTypeMirror() : null;
    }

    @Override
    public JTypeMirror getTypeToSearch() {
        return ((ASTMethodReference)this.myNode).getLhs().getTypeMirror();
    }

    @Override
    public String getMethodName() {
        return ((ASTMethodReference)this.myNode).getMethodName();
    }

    @Override
    public void setCompileTimeDecl(JMethodSig methodType) {
        this.ctdecl = methodType;
        if (this.mayMutateAst()) {
            InternalApiBridge.setCompileTimeDecl((ASTMethodReference)this.myNode, methodType);
        }
    }

    @Override
    public @NonNull List<JTypeMirror> getExplicitTypeArguments() {
        return CollectionUtil.map(ASTList.orEmpty(((ASTMethodReference)this.myNode).getExplicitTypeArguments()), TypeNode::getTypeMirror);
    }

    @Override
    public JMethodSig getCachedExactMethod() {
        return this.exactMethod;
    }

    @Override
    public void setCachedExactMethod(@Nullable JMethodSig sig) {
        this.exactMethod = sig;
    }
}

