/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValue;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.MethodUsage;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.internal.AbstractIgnoredAnnotationRule;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

public class UnusedPrivateMethodRule
extends AbstractIgnoredAnnotationRule {
    private static final Set<String> SERIALIZATION_METHODS = CollectionUtil.setOf((Object)"readObject", (Object[])new String[]{"readObjectNoData", "writeObject", "readResolve", "writeReplace"});

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return CollectionUtil.listOf((Object)"java.lang.Deprecated", (Object[])new String[]{"jakarta.annotation.PostConstruct", "jakarta.annotation.PreDestroy", "lombok.EqualsAndHashCode.Include"});
    }

    public Object visit(ASTCompilationUnit file, Object param) {
        Set<String> methodsUsedByAnnotations = UnusedPrivateMethodRule.methodsUsedByAnnotations(file);
        Map<JExecutableSymbol, ASTMethodDeclaration> candidates = this.findCandidates(file, methodsUsedByAnnotations);
        file.descendants().crossFindBoundaries().map(NodeStream.asInstanceOf(ASTMethodCall.class, (Class[])new Class[]{ASTMethodReference.class})).forEach(ref -> {
            OverloadSelectionResult selectionInfo = ref.getOverloadSelectionInfo();
            JExecutableSymbol calledMethod = selectionInfo.getMethodType().getSymbol();
            if (calledMethod.isUnresolved()) {
                UnusedPrivateMethodRule.handleUnresolvedCall(ref, selectionInfo, candidates);
                return;
            }
            candidates.compute(calledMethod, (sym2, reffed) -> {
                if (reffed != null && ref.ancestors(ASTMethodDeclaration.class).first() != reffed) {
                    return null;
                }
                return reffed;
            });
        });
        for (ASTMethodDeclaration unusedMethod : candidates.values()) {
            this.asCtx(param).addViolation((Node)unusedMethod, new Object[]{PrettyPrintingUtil.displaySignature(unusedMethod)});
        }
        return null;
    }

    private static void handleUnresolvedCall(MethodUsage ref, OverloadSelectionResult selectionInfo, Map<JExecutableSymbol, ASTMethodDeclaration> candidates) {
        boolean receiverMayBeInstanceOfThisClass;
        JTypeMirror receive = selectionInfo.getTypeToSearch();
        boolean bl = receiverMayBeInstanceOfThisClass = receive == null || TypeOps.isSpecialUnresolved(receive) || receive.equals(ref.getEnclosingType().getTypeMirror());
        if (receiverMayBeInstanceOfThisClass) {
            candidates.values().removeIf(it -> it.getName().equals(ref.getMethodName()));
        }
    }

    private Map<JExecutableSymbol, ASTMethodDeclaration> findCandidates(ASTCompilationUnit file, Set<String> methodsUsedByAnnotations) {
        return (Map)file.descendants(ASTMethodDeclaration.class).crossFindBoundaries().filter(it -> it.getVisibility() == ModifierOwner.Visibility.V_PRIVATE && !this.hasIgnoredAnnotation((Annotatable)it) && !this.hasExcludedName((ASTMethodDeclaration)it) && (it.getArity() != 0 || !methodsUsedByAnnotations.contains(it.getName()))).collect(Collectors.toMap(rec$ -> (JMethodSymbol)((ASTMethodDeclaration)rec$).getSymbol(), m -> m));
    }

    private static Set<String> methodsUsedByAnnotations(ASTCompilationUnit file) {
        return file.descendants(ASTAnnotation.class).crossFindBoundaries().toStream().flatMap(UnusedPrivateMethodRule::extractMethodsFromAnnotation).collect(Collectors.toSet());
    }

    private static Stream<String> extractMethodsFromAnnotation(ASTAnnotation a) {
        return Stream.concat(a.getFlatValues().toStream().map(ASTMemberValue::getConstValue).map(NodeStream.asInstanceOf(String.class, (Class[])new Class[0])).filter(StringUtils::isNotEmpty), NodeStream.of((Node)a).filter(it -> TypeTestUtil.isA("org.junit.jupiter.params.provider.MethodSource", (TypeNode)it) && it.getFlatValue("value").isEmpty()).ancestors(ASTMethodDeclaration.class).take(1).toStream().map(rec$ -> ((ASTMethodDeclaration)rec$).getName()));
    }

    private boolean hasExcludedName(ASTMethodDeclaration node) {
        return SERIALIZATION_METHODS.contains(node.getName());
    }
}

