/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.xpath.internal;

import java.util.function.BiPredicate;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseJavaXPathFunction;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;

public class BaseContextNodeTestFun<T extends JavaNode>
extends BaseJavaXPathFunction {
    static final XPathFunctionDefinition.Type[] SINGLE_STRING_SEQ = new XPathFunctionDefinition.Type[]{XPathFunctionDefinition.Type.SINGLE_STRING};
    private final Class<T> klass;
    private final BiPredicate<String, T> checker;
    public static final BaseJavaXPathFunction TYPE_IS_EXACTLY = new BaseContextNodeTestFun<TypeNode>(TypeNode.class, "typeIsExactly", TypeTestUtil::isExactlyA);
    public static final BaseJavaXPathFunction TYPE_IS = new BaseContextNodeTestFun<TypeNode>(TypeNode.class, "typeIs", TypeTestUtil::isA);
    public static final BaseJavaXPathFunction HAS_ANNOTATION = new BaseContextNodeTestFun<Annotatable>(Annotatable.class, "hasAnnotation", (name, node) -> node.isAnnotationPresent((String)name));

    protected BaseContextNodeTestFun(Class<T> klass, String localName, BiPredicate<String, T> checker) {
        super(localName);
        this.klass = klass;
        this.checker = checker;
    }

    public XPathFunctionDefinition.Type[] getArgumentTypes() {
        return SINGLE_STRING_SEQ;
    }

    public XPathFunctionDefinition.Type getResultType() {
        return XPathFunctionDefinition.Type.SINGLE_BOOLEAN;
    }

    public boolean dependsOnContext() {
        return true;
    }

    public XPathFunctionDefinition.FunctionCall makeCallExpression() {
        return (contextNode, arguments) -> {
            String fullTypeName = arguments[0].toString();
            return this.klass.isInstance(contextNode) && this.checker.test(fullTypeName, (String)((Object)((JavaNode)contextNode)));
        };
    }
}

