/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.EnumSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.InternalInterfaces;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum BinaryOp implements InternalInterfaces.OperatorLike
{
    CONDITIONAL_OR("||"),
    CONDITIONAL_AND("&&"),
    OR("|"),
    XOR("^"),
    AND("&"),
    EQ("=="),
    NE("!="),
    LE("<="),
    GE(">="),
    GT(">"),
    LT("<"),
    INSTANCEOF("instanceof"),
    LEFT_SHIFT("<<"),
    RIGHT_SHIFT(">>"),
    UNSIGNED_RIGHT_SHIFT(">>>"),
    ADD("+"),
    SUB("-"),
    MUL("*"),
    DIV("/"),
    MOD("%");

    public static final Set<BinaryOp> CONDITIONAL_OPS;
    public static final Set<BinaryOp> COMPARISON_OPS;
    public static final Set<BinaryOp> EQUALITY_OPS;
    public static final Set<BinaryOp> SHIFT_OPS;
    private final String code;

    private BinaryOp(String code) {
        this.code = code;
    }

    @Override
    public String getToken() {
        return this.code;
    }

    public String toString() {
        return this.code;
    }

    public int comparePrecedence(@NonNull BinaryOp other) {
        return Integer.compare(other.precedenceClass(), this.precedenceClass());
    }

    public boolean hasSamePrecedenceAs(@NonNull BinaryOp other) {
        return this.comparePrecedence(other) == 0;
    }

    public static Set<BinaryOp> opsWithGreaterPrecedence(BinaryOp op) {
        EnumSet<BinaryOp> range = EnumSet.range(op, MOD);
        range.remove(op);
        return range;
    }

    private int precedenceClass() {
        switch (this) {
            case CONDITIONAL_OR: {
                return 9;
            }
            case CONDITIONAL_AND: {
                return 8;
            }
            case OR: {
                return 7;
            }
            case XOR: {
                return 6;
            }
            case AND: {
                return 5;
            }
            case EQ: 
            case NE: {
                return 4;
            }
            case LE: 
            case GE: 
            case GT: 
            case LT: 
            case INSTANCEOF: {
                return 3;
            }
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return 2;
            }
            case ADD: 
            case SUB: {
                return 1;
            }
            case MUL: 
            case DIV: 
            case MOD: {
                return 0;
            }
        }
        throw AssertionUtil.shouldNotReachHere((String)("Invalid binary op " + this));
    }

    public @Nullable BinaryOp getComplement() {
        switch (this) {
            case CONDITIONAL_OR: {
                return CONDITIONAL_AND;
            }
            case CONDITIONAL_AND: {
                return CONDITIONAL_OR;
            }
            case OR: {
                return AND;
            }
            case AND: {
                return OR;
            }
            case EQ: {
                return NE;
            }
            case NE: {
                return EQ;
            }
            case LE: {
                return GT;
            }
            case GE: {
                return LT;
            }
            case GT: {
                return LE;
            }
            case LT: {
                return GE;
            }
        }
        return null;
    }

    static {
        CONDITIONAL_OPS = CollectionUtil.immutableEnumSet((Enum)CONDITIONAL_AND, (Enum[])new BinaryOp[]{CONDITIONAL_OR});
        COMPARISON_OPS = CollectionUtil.immutableEnumSet((Enum)LE, (Enum[])new BinaryOp[]{GE, GT, LT});
        EQUALITY_OPS = CollectionUtil.immutableEnumSet((Enum)EQ, (Enum[])new BinaryOp[]{NE});
        SHIFT_OPS = CollectionUtil.immutableEnumSet((Enum)LEFT_SHIFT, (Enum[])new BinaryOp[]{RIGHT_SHIFT, UNSIGNED_RIGHT_SHIFT});
    }
}

