/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.UnaryOp;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class ConfusingTernaryRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> IGNORE_ELSE_IF = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ignoreElseIf").desc("Ignore conditions with an else-if case")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<NullCheckBranch> NULL_CHECK_BRANCH = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"nullCheckBranch", NullCheckBranch.class).desc("One of `Any`, `Then`, `Else`. For `Any` null checks may have any form, for `Then` only `foo == null` is allowed, for `Else` only `foo != null` is allowed")).defaultValue((Object)NullCheckBranch.Any)).build();

    public ConfusingTernaryRule() {
        super(ASTIfStatement.class, ASTConditionalExpression.class);
        this.definePropertyDescriptor(IGNORE_ELSE_IF);
        this.definePropertyDescriptor(NULL_CHECK_BRANCH);
    }

    public Object visit(ASTIfStatement node, Object data) {
        if (node.hasElse() && this.isMatch(node.getCondition()) && (!((Boolean)this.getProperty(IGNORE_ELSE_IF)).booleanValue() || !(node.getElseBranch() instanceof ASTIfStatement) && !(node.getParent() instanceof ASTIfStatement))) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        if (this.isMatch(node.getCondition())) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }

    private boolean isMatch(ASTExpression node) {
        return ConfusingTernaryRule.isUnaryNot(node) || this.isNotEquals(node) || this.isConditionalWithAllMatches(node);
    }

    private static boolean isUnaryNot(ASTExpression node) {
        return node instanceof ASTUnaryExpression && ((ASTUnaryExpression)node).getOperator() == UnaryOp.NEGATION;
    }

    private boolean isNotEquals(ASTExpression node) {
        if (!(node instanceof ASTInfixExpression)) {
            return false;
        }
        ASTInfixExpression infix = (ASTInfixExpression)node;
        if (infix.getOperator() == BinaryOp.NE) {
            return !this.isNullComparison(infix) || this.getProperty(NULL_CHECK_BRANCH) == NullCheckBranch.Then;
        }
        return infix.getOperator() == BinaryOp.EQ && this.isNullComparison(infix) && this.getProperty(NULL_CHECK_BRANCH) == NullCheckBranch.Else;
    }

    private boolean isNullComparison(ASTInfixExpression infix) {
        return infix.getLeftOperand() instanceof ASTNullLiteral || infix.getRightOperand() instanceof ASTNullLiteral;
    }

    private boolean isConditionalWithAllMatches(ASTExpression node) {
        if (node instanceof ASTInfixExpression) {
            ASTInfixExpression infix = (ASTInfixExpression)node;
            return (infix.getOperator() == BinaryOp.CONDITIONAL_AND || infix.getOperator() == BinaryOp.CONDITIONAL_OR) && this.isMatch(infix.getLeftOperand()) && this.isMatch(infix.getRightOperand());
        }
        return false;
    }

    private static enum NullCheckBranch {
        Any,
        Then,
        Else;

    }
}

