/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTypePattern;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.InvocationMatcher;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CloseResourceRule
extends AbstractJavaRule {
    private static final String WRAPPING_TRY_WITH_RES_VAR_MESSAGE = "it is recommended to wrap resource ''{0}'' in try-with-resource declaration directly";
    private static final String REASSIGN_BEFORE_CLOSED_MESSAGE = "''{0}'' is reassigned, but the original instance is not closed";
    private static final String CLOSE_IN_FINALLY_BLOCK_MESSAGE = "''{0}'' is not closed within a finally block, thus might not be closed at all in case of exceptions";
    private static final PropertyDescriptor<List<String>> CLOSE_TARGETS_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"closeTargets").desc("Methods which may close this resource")).emptyDefaultValue().build();
    private static final PropertyDescriptor<List<String>> TYPES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"types").desc("Affected types")).defaultValues((Object)"java.lang.AutoCloseable", (Object[])new String[]{"java.sql.Connection", "java.sql.Statement", "java.sql.ResultSet"}).build();
    private static final PropertyDescriptor<Boolean> USE_CLOSE_AS_DEFAULT_TARGET = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"closeAsDefaultTarget").desc("Consider 'close' as a target by default")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<List<String>> ALLOWED_RESOURCE_TYPES = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"allowedResourceTypes").desc("Exact class names that do not need to be closed")).defaultValues((Object)"java.io.ByteArrayOutputStream", (Object[])new String[]{"java.io.ByteArrayInputStream", "java.io.StringWriter", "java.io.CharArrayWriter", "java.util.stream.Stream", "java.util.stream.IntStream", "java.util.stream.LongStream", "java.util.stream.DoubleStream"}).build();
    private static final PropertyDescriptor<Boolean> DETECT_CLOSE_NOT_IN_FINALLY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"closeNotInFinally").desc("Detect if 'close' (or other closeTargets) is called outside of a finally-block")).defaultValue((Object)false)).build();
    private static final InvocationMatcher OBJECTS_NON_NULL = InvocationMatcher.parse("java.util.Objects#nonNull(_)");
    private static final InvocationMatcher FILESYSTEMS_GET_DEFAULT = InvocationMatcher.parse("java.nio.file.FileSystems#getDefault()");
    private final Set<String> types = new HashSet<String>();
    private final Set<String> simpleTypes = new HashSet<String>();
    private final Set<String> closeTargets = new HashSet<String>();
    private final Set<String> reportedVarNames = new HashSet<String>();

    public CloseResourceRule() {
        this.definePropertyDescriptor(CLOSE_TARGETS_DESCRIPTOR);
        this.definePropertyDescriptor(TYPES_DESCRIPTOR);
        this.definePropertyDescriptor(USE_CLOSE_AS_DEFAULT_TARGET);
        this.definePropertyDescriptor(ALLOWED_RESOURCE_TYPES);
        this.definePropertyDescriptor(DETECT_CLOSE_NOT_IN_FINALLY);
    }

    public void start(RuleContext ctx) {
        this.closeTargets.clear();
        this.simpleTypes.clear();
        this.types.clear();
        if (this.getProperty(CLOSE_TARGETS_DESCRIPTOR) != null) {
            this.closeTargets.addAll((Collection)this.getProperty(CLOSE_TARGETS_DESCRIPTOR));
        }
        if (((Boolean)this.getProperty(USE_CLOSE_AS_DEFAULT_TARGET)).booleanValue()) {
            this.closeTargets.add("close");
        }
        if (this.getProperty(TYPES_DESCRIPTOR) != null) {
            this.types.addAll((Collection)this.getProperty(TYPES_DESCRIPTOR));
            for (String type : (List)this.getProperty(TYPES_DESCRIPTOR)) {
                this.simpleTypes.add(CloseResourceRule.toSimpleType(type));
            }
        }
    }

    private static String toSimpleType(String fullyQualifiedClassName) {
        int lastIndexOf = fullyQualifiedClassName.lastIndexOf(46);
        if (lastIndexOf > -1) {
            return fullyQualifiedClassName.substring(lastIndexOf + 1);
        }
        return fullyQualifiedClassName;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.checkForResources(node, data);
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.checkForResources(node, data);
        return super.visit(node, data);
    }

    private void checkForResources(ASTExecutableDeclaration methodOrConstructor, Object data) {
        this.reportedVarNames.clear();
        Map<ASTVariableId, TypeNode> resVars = this.getResourceVariables(methodOrConstructor);
        for (Map.Entry<ASTVariableId, TypeNode> resVarEntry : resVars.entrySet()) {
            ASTExpressionStatement reassigningStatement;
            ASTVariableId resVar = resVarEntry.getKey();
            TypeNode runtimeType = resVarEntry.getValue();
            TypeNode resVarType = this.wrappedResourceTypeOrReturn(resVar, runtimeType);
            if (this.isWrappingResourceSpecifiedInTry(resVar)) {
                this.reportedVarNames.add(resVar.getName());
                this.asCtx(data).addViolationWithMessage((Node)resVar, WRAPPING_TRY_WITH_RES_VAR_MESSAGE, new Object[]{resVar.getName()});
                continue;
            }
            if (this.shouldVarOfTypeBeClosedInMethod(resVar, resVarType, methodOrConstructor)) {
                this.reportedVarNames.add(resVar.getName());
                this.addCloseResourceViolation(resVar, runtimeType, data);
                continue;
            }
            if (!this.isNotAllowedResourceType(resVarType) || (reassigningStatement = this.getFirstReassigningStatementBeforeBeingClosed(resVar, methodOrConstructor)) == null) continue;
            this.reportedVarNames.add(resVar.getName());
            this.asCtx(data).addViolationWithMessage((Node)reassigningStatement, REASSIGN_BEFORE_CLOSED_MESSAGE, new Object[]{resVar.getName()});
        }
    }

    private Map<ASTVariableId, TypeNode> getResourceVariables(ASTExecutableDeclaration method) {
        HashMap<ASTVariableId, TypeNode> resVars = new HashMap<ASTVariableId, TypeNode>();
        if (method.getBody() == null) {
            return resVars;
        }
        List vars = method.getBody().descendants(ASTVariableId.class).filterNot(ASTVariableId::isFormalParameter).filterNot(ASTVariableId::isExceptionBlockParameter).filter(this::isVariableNotSpecifiedInTryWithResource).filter(var -> this.isResourceTypeOrSubtype((TypeNode)var) || this.isNodeInstanceOfResourceType(this.getTypeOfVariable((ASTVariableId)var))).filterNot(var -> var.isAnnotationPresent("lombok.Cleanup")).filterNot(this::isDefaultFileSystem).toList();
        for (ASTVariableId var2 : vars) {
            TypeNode varType = this.getTypeOfVariable(var2);
            resVars.put(var2, varType);
        }
        return resVars;
    }

    private TypeNode getTypeOfVariable(ASTVariableId var) {
        TypeNode runtimeType = this.getRuntimeTypeOfVariable(var);
        return runtimeType != null ? runtimeType : var.getTypeNode();
    }

    private TypeNode getRuntimeTypeOfVariable(ASTVariableId var) {
        ASTExpression initExpr = var.getInitializer();
        return var.isTypeInferred() || this.isRuntimeType(initExpr) ? initExpr : null;
    }

    private boolean isRuntimeType(ASTExpression expr) {
        if (expr == null || this.isMethodCall(expr) || expr instanceof ASTNullLiteral) {
            return false;
        }
        @Nullable JTypeDeclSymbol symbol = expr.getTypeMirror().getSymbol();
        return symbol != null && !symbol.isUnresolved();
    }

    private TypeNode wrappedResourceTypeOrReturn(ASTVariableId var, TypeNode defaultVal) {
        TypeNode wrappedResType = this.getWrappedResourceType(var);
        return wrappedResType != null ? wrappedResType : defaultVal;
    }

    private TypeNode getWrappedResourceType(ASTVariableId var) {
        ASTConstructorCall resAlloc;
        ASTExpression initExpr = this.initializerExpressionOf(var);
        if (initExpr != null && (resAlloc = this.getLastResourceAllocation(initExpr)) != null) {
            ASTExpression firstArgRes = this.getFirstArgumentVariableIfResource(resAlloc);
            return firstArgRes != null ? firstArgRes : resAlloc;
        }
        return null;
    }

    private ASTExpression initializerExpressionOf(ASTVariableId var) {
        return var.getInitializer();
    }

    private ASTConstructorCall getLastResourceAllocation(ASTExpression expr) {
        int lastAllocIndex;
        List allocations = expr.descendantsOrSelf().filterIs(ASTConstructorCall.class).toList();
        for (int allocIndex = lastAllocIndex = allocations.size() - 1; allocIndex >= 0; --allocIndex) {
            ASTConstructorCall allocation = (ASTConstructorCall)allocations.get(allocIndex);
            if (!this.isResourceTypeOrSubtype(allocation)) continue;
            return allocation;
        }
        return null;
    }

    private ASTExpression getFirstArgumentVariableIfResource(ASTConstructorCall allocation) {
        ASTArgumentList argsList = allocation.getArguments();
        if (argsList != null && argsList.size() > 0) {
            ASTExpression firstArg = (ASTExpression)argsList.get(0);
            return this.isNotMethodCall(firstArg) && this.isResourceTypeOrSubtype(firstArg) ? firstArg : null;
        }
        return null;
    }

    private boolean isNotMethodCall(ASTExpression expr) {
        return !this.isMethodCall(expr);
    }

    private boolean isMethodCall(ASTExpression expression) {
        return expression instanceof ASTMethodCall;
    }

    private boolean isWrappingResourceSpecifiedInTry(ASTVariableId var) {
        ASTVariableId referencedVar;
        JVariableSymbol referencedSym;
        ASTVariableAccess wrappedVarName = this.getWrappedVariableName(var);
        if (wrappedVarName != null && (referencedSym = wrappedVarName.getReferencedSym()) != null && (referencedVar = (ASTVariableId)referencedSym.tryGetNode()) != null) {
            List tryContainers = referencedVar.ancestors(ASTTryStatement.class).toList();
            for (ASTTryStatement tryContainer : tryContainers) {
                if (!this.isTryWithResourceSpecifyingVariable(tryContainer, referencedVar)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldVarOfTypeBeClosedInMethod(ASTVariableId var, TypeNode type, ASTExecutableDeclaration method) {
        return this.isNotAllowedResourceType(type) && this.isNotWrappingResourceMethodParameter(var, method) && this.isResourceVariableUnclosed(var);
    }

    private boolean isNotAllowedResourceType(TypeNode varType) {
        return !this.isAllowedResourceType(varType);
    }

    private boolean isAllowedResourceType(TypeNode refType) {
        List allowedResourceTypes = (List)this.getProperty(ALLOWED_RESOURCE_TYPES);
        if (allowedResourceTypes != null) {
            for (String type : allowedResourceTypes) {
                if (!TypeTestUtil.isExactlyA(type, refType)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotWrappingResourceMethodParameter(ASTVariableId var, ASTExecutableDeclaration method) {
        return !this.isWrappingResourceMethodParameter(var, method);
    }

    private boolean isWrappingResourceMethodParameter(ASTVariableId var, ASTExecutableDeclaration method) {
        ASTVariableAccess wrappedVarName = this.getWrappedVariableName(var);
        ASTFormalParameters methodParams = method.getFormalParameters();
        if (wrappedVarName != null) {
            Node parentUse = wrappedVarName.getParent();
            if (parentUse instanceof ASTCastExpression) {
                parentUse = parentUse.getParent();
            }
            return this.isReferencingMethodParameter(wrappedVarName, methodParams, parentUse instanceof ASTVariableDeclarator || parentUse instanceof ASTAssignmentExpression);
        }
        if (var.getParent() instanceof ASTTypePattern && var.getIndexInParent() == 2) {
            JavaNode check = null;
            if (((JavaNode)((JavaNode)var.getParent()).getParent()).getParent() instanceof ASTInfixExpression) {
                check = (JavaNode)((JavaNode)((JavaNode)((JavaNode)var.getParent()).getParent()).getParent()).getChild(0);
            }
            if (((JavaNode)var.getParent()).getParent() instanceof ASTSwitchLabel) {
                ASTSwitchLike sw = (ASTSwitchLike)var.ancestors(ASTSwitchLike.class).firstOrThrow();
                check = sw.getTestedExpression();
            }
            if (check instanceof ASTVariableAccess) {
                return this.isReferencingMethodParameter((ASTVariableAccess)check, methodParams, false);
            }
        }
        return false;
    }

    private boolean isReferencingMethodParameter(ASTVariableAccess wrappedVarName, ASTFormalParameters methodParams, boolean isAssignment) {
        for (ASTFormalParameter param : methodParams) {
            if (!isAssignment && !this.isResourceTypeOrSubtype(param) || !JavaAstUtils.isReferenceToVar((ASTExpression)wrappedVarName, (JVariableSymbol)param.getVarId().getSymbol())) continue;
            return true;
        }
        return false;
    }

    private ASTVariableAccess getWrappedVariableName(ASTVariableId var) {
        ASTExpression initializer = var.getInitializer();
        if (initializer != null) {
            return (ASTVariableAccess)var.getInitializer().descendantsOrSelf().filterIs(ASTVariableAccess.class).filter(usage -> !(usage.getParent() instanceof ASTMethodCall)).first();
        }
        return null;
    }

    private boolean isResourceTypeOrSubtype(TypeNode refType) {
        @Nullable JTypeDeclSymbol symbol = refType.getTypeMirror().getSymbol();
        return symbol != null && !symbol.isUnresolved() ? this.isNodeInstanceOfResourceType(refType) : this.nodeHasReferenceToResourceType(refType);
    }

    private boolean isNodeInstanceOfResourceType(TypeNode refType) {
        for (String resType : this.types) {
            if (!TypeTestUtil.isA(resType, refType)) continue;
            return true;
        }
        return false;
    }

    private boolean nodeHasReferenceToResourceType(TypeNode refType) {
        @Nullable JTypeDeclSymbol symbol = refType.getTypeMirror().getSymbol();
        if (symbol != null) {
            String simpleTypeName = symbol.getSimpleName();
            return this.isResourceTypeName(simpleTypeName);
        }
        return false;
    }

    private boolean isResourceTypeName(String typeName) {
        String simpleTypeName = CloseResourceRule.toSimpleType(typeName);
        return this.types.contains(typeName) || this.simpleTypes.contains(simpleTypeName);
    }

    private boolean isResourceVariableUnclosed(ASTVariableId var) {
        return !this.isResourceVariableClosed(var);
    }

    private boolean isResourceVariableClosed(ASTVariableId var) {
        Node methodOfVar = this.getMethodOfNode((Node)var);
        return this.hasTryStatementClosingResourceVariable(methodOfVar, var) || this.isReturnedByMethod(var, methodOfVar);
    }

    private Node getMethodOfNode(Node node) {
        Node parent = node.getParent();
        while (this.isNotMethod(parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    private boolean isNotMethod(Node node) {
        return !(node instanceof ASTBlock) && !(node instanceof ASTConstructorDeclaration);
    }

    private boolean hasTryStatementClosingResourceVariable(Node node, ASTVariableId var) {
        List tryStatements = node.descendants(ASTTryStatement.class).crossFindBoundaries().toList();
        for (ASTTryStatement tryStatement : tryStatements) {
            if (!this.tryStatementClosesResourceVariable(tryStatement, var)) continue;
            return true;
        }
        return false;
    }

    private boolean tryStatementClosesResourceVariable(ASTTryStatement tryStatement, ASTVariableId var) {
        if (tryStatement.getBeginLine() >= var.getBeginLine() && this.noneCriticalStatementsBetween(var, tryStatement)) {
            if (this.isTryWithResourceSpecifyingVariable(tryStatement, var)) {
                return true;
            }
            if (this.hasFinallyClause(tryStatement)) {
                ASTBlock finallyBody = tryStatement.getFinallyClause().getBody();
                return this.blockClosesResourceVariable(finallyBody, var);
            }
        }
        return false;
    }

    private boolean noneCriticalStatementsBetween(ASTVariableId var, ASTTryStatement tryStatement) {
        return !this.anyCriticalStatementBetween(var, tryStatement);
    }

    private boolean anyCriticalStatementBetween(ASTVariableId var, ASTTryStatement tryStatement) {
        ASTStatement varStatement = (ASTStatement)var.ancestors(ASTStatement.class).first();
        if (this.isNotNullInitialized(var) && this.areStatementsOfSameBlock(varStatement, tryStatement)) {
            for (ASTStatement bsBetween : this.getBlockStatementsBetween(varStatement, tryStatement)) {
                if (!this.isCriticalStatement(bsBetween)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotNullInitialized(ASTVariableId var) {
        return !this.hasNullInitializer(var);
    }

    private boolean hasNullInitializer(ASTVariableId var) {
        return var.getInitializer() instanceof ASTNullLiteral;
    }

    private boolean areStatementsOfSameBlock(ASTStatement bs0, ASTStatement bs1) {
        return bs0.getParent() == bs1.getParent();
    }

    private List<ASTStatement> getBlockStatementsBetween(ASTStatement top, ASTStatement bottom) {
        List blockStatements = ((JavaNode)top.getParent()).children(ASTStatement.class).toList();
        int topIndex = blockStatements.indexOf(top);
        int bottomIndex = blockStatements.indexOf(bottom);
        return blockStatements.subList(topIndex + 1, bottomIndex);
    }

    private boolean isCriticalStatement(ASTStatement blockStatement) {
        boolean isVarDeclaration = blockStatement.descendantsOrSelf().filterIs(ASTLocalVariableDeclaration.class).nonEmpty();
        boolean isAssignmentOperator = blockStatement.descendantsOrSelf().filterIs(ASTAssignmentExpression.class).nonEmpty();
        return !isVarDeclaration && !isAssignmentOperator;
    }

    private boolean isTryWithResourceSpecifyingVariable(ASTTryStatement tryStatement, ASTVariableId varId) {
        return tryStatement.isTryWithResources() && this.isVariableSpecifiedInTryWithResource(varId, tryStatement);
    }

    private boolean isVariableNotSpecifiedInTryWithResource(ASTVariableId varId) {
        @Nullable ASTTryStatement tryStatement = (ASTTryStatement)varId.ancestors(ASTTryStatement.class).filter(ASTTryStatement::isTryWithResources).first();
        return tryStatement == null || !this.isVariableSpecifiedInTryWithResource(varId, tryStatement);
    }

    private boolean isDefaultFileSystem(ASTVariableId varId) {
        @Nullable ASTExpression initializer = varId.getInitializer();
        return FILESYSTEMS_GET_DEFAULT.matchesCall(initializer);
    }

    private boolean isVariableSpecifiedInTryWithResource(ASTVariableId varId, ASTTryStatement tryWithResource) {
        if (tryWithResource.getResources().descendants(ASTVariableId.class).toList().contains(varId)) {
            return true;
        }
        List<ASTVariableAccess> usedVars = this.getResourcesSpecifiedInTryWith(tryWithResource);
        for (ASTVariableAccess res : usedVars) {
            if (!JavaAstUtils.isReferenceToVar((ASTExpression)res, (JVariableSymbol)varId.getSymbol())) continue;
            return true;
        }
        return false;
    }

    private List<ASTVariableAccess> getResourcesSpecifiedInTryWith(ASTTryStatement tryWithResource) {
        return tryWithResource.getResources().descendantsOrSelf().filterIs(ASTVariableAccess.class).toList();
    }

    private boolean hasFinallyClause(ASTTryStatement tryStatement) {
        return tryStatement.getFinallyClause() != null;
    }

    private boolean blockClosesResourceVariable(ASTBlock block, ASTVariableId variableToClose) {
        return this.hasNotConditionalCloseCallOnVariable(block, variableToClose) || this.hasMethodCallClosingResourceVariable(block, variableToClose);
    }

    private boolean hasNotConditionalCloseCallOnVariable(ASTBlock block, ASTVariableId variableToClose) {
        List methodCallsOnVariable = block.descendants(ASTMethodCall.class).filter(call -> this.isMethodCallOnVariable((ASTExpression)call, variableToClose)).toList();
        for (ASTMethodCall call2 : methodCallsOnVariable) {
            if (!this.isCloseTargetMethodCall(call2) || !this.isNotConditional(block, (Node)call2, variableToClose)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodCallOnVariable(ASTExpression expr, ASTVariableId variable) {
        if (expr instanceof ASTMethodCall) {
            ASTMethodCall methodCall = (ASTMethodCall)expr;
            return JavaAstUtils.isReferenceToVar(methodCall.getQualifier(), (JVariableSymbol)variable.getSymbol());
        }
        return false;
    }

    private boolean isNotConditional(ASTBlock enclosingBlock, Node node, ASTVariableId var) {
        ASTIfStatement ifStatement = this.findIfStatement(enclosingBlock, node);
        if (ifStatement != null) {
            ASTInfixExpression equalityExpr;
            if (ifStatement.getCondition() instanceof ASTInfixExpression && BinaryOp.NE == (equalityExpr = (ASTInfixExpression)ifStatement.getCondition()).getOperator()) {
                ASTExpression left = equalityExpr.getLeftOperand();
                ASTExpression right = equalityExpr.getRightOperand();
                if (JavaAstUtils.isReferenceToVar(left, (JVariableSymbol)var.getSymbol()) && this.isNullLiteral(right) || JavaAstUtils.isReferenceToVar(right, (JVariableSymbol)var.getSymbol()) && this.isNullLiteral(left)) {
                    return true;
                }
            }
            return this.isObjectsNonNull(ifStatement.getCondition(), var);
        }
        return true;
    }

    private boolean isObjectsNonNull(ASTExpression expression, ASTVariableId var) {
        if (OBJECTS_NON_NULL.matchesCall(expression)) {
            ASTMethodCall methodCall = (ASTMethodCall)expression;
            return JavaAstUtils.isReferenceToVar((ASTExpression)methodCall.getArguments().get(0), (JVariableSymbol)var.getSymbol());
        }
        return false;
    }

    private boolean isNullLiteral(JavaNode node) {
        return node instanceof ASTNullLiteral;
    }

    private ASTIfStatement findIfStatement(ASTBlock enclosingBlock, Node node) {
        ASTIfStatement ifStatement = (ASTIfStatement)node.ancestors(ASTIfStatement.class).first();
        List allIfStatements = enclosingBlock.descendants(ASTIfStatement.class).toList();
        if (ifStatement != null && allIfStatements.contains(ifStatement)) {
            return ifStatement;
        }
        return null;
    }

    private boolean hasMethodCallClosingResourceVariable(ASTBlock block, ASTVariableId variableToClose) {
        List methodCalls = block.descendants(ASTMethodCall.class).crossFindBoundaries().toList();
        for (ASTMethodCall call : methodCalls) {
            if (!this.isMethodCallClosingResourceVariable(call, variableToClose)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodCallClosingResourceVariable(ASTExpression expr, ASTVariableId variableToClose) {
        if (!(expr instanceof ASTMethodCall)) {
            return false;
        }
        ASTMethodCall call = (ASTMethodCall)expr;
        return (this.isCloseTargetMethodCall(call) || this.hasChainedCloseTargetMethodCall(call)) && this.variableIsPassedToMethod(variableToClose, call);
    }

    private boolean isCloseTargetMethodCall(ASTMethodCall methodCall) {
        String fullName = methodCall.getMethodName();
        if (methodCall.getQualifier() instanceof ASTTypeExpression) {
            fullName = methodCall.getQualifier().getText() + "." + fullName;
        }
        return this.closeTargets.contains(fullName);
    }

    private boolean hasChainedCloseTargetMethodCall(ASTMethodCall start) {
        ASTExpression walker = start;
        while (walker instanceof ASTMethodCall) {
            ASTMethodCall methodCall = walker;
            if (this.isCloseTargetMethodCall(methodCall)) {
                return true;
            }
            walker = methodCall.getQualifier();
        }
        return false;
    }

    private boolean variableIsPassedToMethod(ASTVariableId varName, ASTMethodCall methodCall) {
        List usedRefs = methodCall.getArguments().descendants(ASTAssignableExpr.ASTNamedReferenceExpr.class).toList();
        for (ASTAssignableExpr.ASTNamedReferenceExpr ref : usedRefs) {
            if (!((JVariableSymbol)varName.getSymbol()).equals(ref.getReferencedSym())) continue;
            return true;
        }
        return false;
    }

    private boolean isReturnedByMethod(ASTVariableId variable, Node method) {
        return method.descendants(ASTReturnStatement.class).crossFindBoundaries().descendants(ASTVariableAccess.class).filter(access -> !(access.getParent() instanceof ASTMethodCall)).filter(access -> JavaAstUtils.isReferenceToVar((ASTExpression)access, (JVariableSymbol)variable.getSymbol())).nonEmpty();
    }

    private void addCloseResourceViolation(ASTVariableId id, TypeNode type, Object data) {
        String resTypeName = this.getResourceTypeName(id, type);
        this.asCtx(data).addViolation((Node)id, new Object[]{resTypeName});
    }

    private String getResourceTypeName(ASTVariableId varId, TypeNode type) {
        if (type == null) {
            JTypeMirror typeMirror = varId.getTypeMirror();
            return typeMirror.getSymbol() != null ? typeMirror.getSymbol().getSimpleName() : typeMirror.toString();
        }
        if (type instanceof ASTType) {
            return PrettyPrintingUtil.prettyPrintType((ASTType)type);
        }
        @Nullable JTypeDeclSymbol symbol = type.getTypeMirror().getSymbol();
        if (symbol != null) {
            return symbol.getSimpleName();
        }
        @Nullable ASTLocalVariableDeclaration localVarDecl = (ASTLocalVariableDeclaration)varId.ancestors(ASTLocalVariableDeclaration.class).first();
        if (localVarDecl != null && localVarDecl.getTypeNode() != null) {
            return PrettyPrintingUtil.prettyPrintType(localVarDecl.getTypeNode());
        }
        return varId.getName();
    }

    public Object visit(ASTMethodCall node, Object data) {
        ASTVariableAccess closedVar;
        if (!((Boolean)this.getProperty(DETECT_CLOSE_NOT_IN_FINALLY)).booleanValue()) {
            return super.visit(node, data);
        }
        if (this.isCloseTargetMethodCall(node) && node.getQualifier() instanceof ASTVariableAccess && this.isNotInFinallyBlock(closedVar = (ASTVariableAccess)node.getQualifier()) && !this.reportedVarNames.contains(closedVar.getName())) {
            this.asCtx(data).addViolationWithMessage((Node)closedVar, CLOSE_IN_FINALLY_BLOCK_MESSAGE, new Object[]{closedVar.getName()});
        }
        return super.visit(node, data);
    }

    private boolean isNotInFinallyBlock(ASTVariableAccess closedVar) {
        return closedVar.ancestors(ASTFinallyClause.class).isEmpty();
    }

    private ASTExpressionStatement getFirstReassigningStatementBeforeBeingClosed(ASTVariableId variable, ASTExecutableDeclaration methodOrConstructor) {
        List statements = methodOrConstructor.descendants(ASTExpressionStatement.class).toList();
        boolean variableClosed = false;
        boolean isInitialized = !this.hasNullInitializer(variable);
        ASTExpression initializingExpression = this.initializerExpressionOf(variable);
        for (ASTExpressionStatement statement : statements) {
            if (this.isClosingVariableStatement(statement, variable)) {
                variableClosed = true;
            }
            if (!this.isAssignmentForVariable(statement, variable)) continue;
            ASTAssignmentExpression assignment = (ASTAssignmentExpression)statement.getFirstChild();
            if (isInitialized && !variableClosed && initializingExpression != null && !this.inSameIfBlock(statement, initializingExpression) && this.notInNullCheckIf(statement, variable) && this.isNotSelfAssignment(assignment)) {
                return statement;
            }
            if (variableClosed) {
                variableClosed = false;
            }
            if (isInitialized) continue;
            isInitialized = true;
            initializingExpression = statement.getExpr();
        }
        return null;
    }

    private boolean isNotSelfAssignment(ASTAssignmentExpression assignment) {
        return assignment.getRightOperand().descendantsOrSelf().filterIs(ASTVariableAccess.class).filter(access -> JavaAstUtils.isReferenceToSameVar(access, assignment.getLeftOperand())).isEmpty();
    }

    private boolean notInNullCheckIf(ASTExpressionStatement statement, ASTVariableId variable) {
        ASTIfStatement ifStatement;
        Node grandparent = statement.ancestors().get(1);
        return !(grandparent instanceof ASTIfStatement) || !JavaRuleUtil.isNullCheck((ifStatement = (ASTIfStatement)grandparent).getCondition(), (JVariableSymbol)variable.getSymbol());
    }

    private boolean inSameIfBlock(ASTExpressionStatement statement1, ASTExpression statement2) {
        List parents1 = statement1.ancestors(ASTIfStatement.class).toList();
        List parents2 = statement2.ancestors(ASTIfStatement.class).toList();
        parents1.retainAll(parents2);
        return !parents1.isEmpty();
    }

    private boolean isClosingVariableStatement(ASTExpressionStatement statement, ASTVariableId variable) {
        return this.isMethodCallClosingResourceVariable(statement.getExpr(), variable) || this.isMethodCallOnVariable(statement.getExpr(), variable);
    }

    private boolean isAssignmentForVariable(ASTExpressionStatement statement, ASTVariableId variable) {
        if (statement == null || variable == null || !(statement.getExpr() instanceof ASTAssignmentExpression)) {
            return false;
        }
        ASTAssignmentExpression assignment = (ASTAssignmentExpression)statement.getExpr();
        return JavaAstUtils.isReferenceToVar((ASTExpression)assignment.getLeftOperand(), (JVariableSymbol)variable.getSymbol());
    }
}

