/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.errorprone.OverrideBothEqualsAndHashcodeRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.CollectionUtil;

public class OverrideBothEqualsAndHashCodeOnComparableRule
extends OverrideBothEqualsAndHashcodeRule {
    private static final String MESSAGE_PREFIX = "When implementing Comparable, ";
    private static final String MISSING_HASH_CODE = "When implementing Comparable, hashCode() should be overridden";
    private static final String MISSING_EQUALS = "When implementing Comparable, equals() should be overridden";
    private static final String MISSING_EQUALS_AND_HASH_CODE = "When implementing Comparable, both equals() and hashCode() should be overridden";
    private static final Set<String> LOMBOK_GENERATED_EQUALS_HASHCODE = CollectionUtil.setOf((Object)"lombok.EqualsAndHashCode", (Object[])new String[]{"lombok.Data", "lombok.Value"});

    @Override
    protected boolean skipType(ASTTypeDeclaration node) {
        return !TypeTestUtil.isA(Comparable.class, (TypeNode)node) || TypeTestUtil.isA(Enum.class, (TypeNode)node);
    }

    @Override
    protected void maybeReport(RuleContext ctx, ASTTypeDeclaration node, ASTMethodDeclaration hashCodeMethod, ASTMethodDeclaration equalsMethod) {
        ASTMethodDeclaration compareToMethod = (ASTMethodDeclaration)node.getDeclarations(ASTMethodDeclaration.class).first(JavaAstUtils::isCompareToMethod);
        if (compareToMethod == null) {
            return;
        }
        if (equalsMethod == null && hashCodeMethod == null && JavaAstUtils.hasAnyAnnotation(node, LOMBOK_GENERATED_EQUALS_HASHCODE)) {
            return;
        }
        if (equalsMethod == null && hashCodeMethod == null) {
            if (!node.isRecord()) {
                ctx.addViolationWithMessage((Node)compareToMethod, MISSING_EQUALS_AND_HASH_CODE);
            }
        } else if (equalsMethod == null) {
            ctx.addViolationWithMessage((Node)hashCodeMethod, MISSING_EQUALS);
        } else if (hashCodeMethod == null) {
            ctx.addViolationWithMessage((Node)equalsMethod, MISSING_HASH_CODE);
        }
    }
}

