/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.infer.IncorporationAction;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.lang.java.types.internal.infer.ReductionStep;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailedException;
import net.sourceforge.pmd.lang.java.types.internal.infer.SupertypeCheckCache;
import net.sourceforge.pmd.lang.java.types.internal.infer.TypeInferenceLogger;
import net.sourceforge.pmd.lang.java.types.internal.infer.VarWalkStrategy;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class InferenceContext {
    private static int varId = 0;
    private static int ctxId = 0;
    private final Map<InstantiationListener, Set<InferenceVar>> instantiationListeners = new HashMap<InstantiationListener, Set<InferenceVar>>();
    private final Map<InferenceVar, Set<InferenceVar>> instantiationConstraints = new HashMap<InferenceVar, Set<InferenceVar>>();
    private boolean graphWasChanged = false;
    private final Set<InferenceVar> freeVars = new LinkedHashSet<InferenceVar>();
    private final Set<InferenceVar> inferenceVars = new LinkedHashSet<InferenceVar>();
    private final Deque<IncorporationAction> incorporationActions = new ArrayDeque<IncorporationAction>();
    final TypeSystem ts;
    private final SupertypeCheckCache supertypeCheckCache;
    final TypeInferenceLogger logger;
    private Substitution mapping = Substitution.EMPTY;
    private @Nullable InferenceContext parent;
    private boolean needsUncheckedConversion;
    private final int id;

    InferenceContext(TypeSystem ts, SupertypeCheckCache supertypeCheckCache, List<JTypeVar> tvars, TypeInferenceLogger logger) {
        this(ts, supertypeCheckCache, tvars, logger, true);
    }

    InferenceContext(TypeSystem ts, SupertypeCheckCache supertypeCheckCache, List<JTypeVar> tvars, TypeInferenceLogger logger, boolean addPrimaryBound) {
        this.ts = ts;
        this.supertypeCheckCache = supertypeCheckCache;
        this.logger = logger;
        this.id = ctxId++;
        for (JTypeVar p : tvars) {
            this.addVarImpl(p);
        }
        if (addPrimaryBound) {
            this.addPrimaryBounds();
        }
    }

    void addPrimaryBounds() {
        for (InferenceVar ivar : this.inferenceVars) {
            this.addPrimaryBound(ivar);
        }
    }

    public InferenceContext shallowCopy() {
        InferenceContext copy = new InferenceContext(this.ts, this.supertypeCheckCache, Collections.emptyList(), this.logger);
        copy.freeVars.addAll(this.freeVars);
        copy.inferenceVars.addAll(this.inferenceVars);
        copy.incorporationActions.addAll(this.incorporationActions);
        copy.instantiationConstraints.putAll(this.instantiationConstraints);
        copy.mapping = this.mapping;
        return copy;
    }

    public int getId() {
        return this.id;
    }

    private void addPrimaryBound(InferenceVar ivar) {
        for (JTypeMirror ui : TypeOps.asList(ivar.getBaseVar().getUpperBound())) {
            ivar.addPrimaryBound(InferenceVar.BoundKind.UPPER, this.mapToIVars(ui));
        }
    }

    InferenceVar addVar(JTypeVar tvar) {
        InferenceVar ivar = this.addVarImpl(tvar);
        this.addPrimaryBound(ivar);
        for (InferenceVar otherIvar : this.inferenceVars) {
            otherIvar.substBounds(this::mapToIVars);
        }
        return ivar;
    }

    private InferenceVar addVarImpl(@NonNull JTypeVar tvar) {
        InferenceVar ivar = new InferenceVar(this, tvar, varId++);
        this.freeVars.add(ivar);
        this.inferenceVars.add(ivar);
        this.mapping = this.mapping.plus(tvar, ivar);
        return ivar;
    }

    JTypeMirror mapToIVars(JTypeMirror t) {
        return TypeOps.subst(t, (Function<? super SubstVar, ? extends JTypeMirror>)this.mapping);
    }

    JMethodSig mapToIVars(JMethodSig t) {
        return t.subst((Function)this.mapping);
    }

    boolean isGround(JTypeVisitable t) {
        return !TypeOps.mentionsAny(t, this.freeVars);
    }

    boolean areAllGround(Collection<? extends JTypeVisitable> ts) {
        for (JTypeVisitable jTypeVisitable : ts) {
            if (this.isGround(jTypeVisitable)) continue;
            return false;
        }
        return true;
    }

    Set<InferenceVar> freeVarsIn(Iterable<? extends JTypeVisitable> types) {
        LinkedHashSet<InferenceVar> vars = new LinkedHashSet<InferenceVar>();
        for (InferenceVar ivar : this.freeVars) {
            for (JTypeVisitable jTypeVisitable : types) {
                if (!TypeOps.mentions(jTypeVisitable, ivar)) continue;
                vars.add(ivar);
            }
        }
        return vars;
    }

    Set<InferenceVar> freeVarsIn(JTypeVisitable t) {
        return this.freeVarsIn(Collections.singleton(t));
    }

    JTypeMirror ground(JTypeMirror t) {
        return t.subst(InferenceContext::groundSubst);
    }

    JClassType ground(JClassType t) {
        return t.subst(InferenceContext::groundSubst);
    }

    JMethodSig ground(JMethodSig t) {
        return t.subst(InferenceContext::groundSubst);
    }

    void setNeedsUncheckedConversion() {
        this.needsUncheckedConversion = true;
    }

    boolean needsUncheckedConversion() {
        return this.needsUncheckedConversion;
    }

    SupertypeCheckCache getSupertypeCheckCache() {
        return this.supertypeCheckCache;
    }

    private static JTypeMirror groundSubst(SubstVar var) {
        JTypeMirror inst;
        if (var instanceof InferenceVar && (inst = ((InferenceVar)var).getInst()) != null) {
            return inst;
        }
        return var;
    }

    static JMethodSig finalGround(JMethodSig t) {
        return t.subst(InferenceContext.finalGroundSubst());
    }

    public static Function<SubstVar, JTypeMirror> finalGroundSubst() {
        return s -> {
            if (!(s instanceof InferenceVar)) {
                return s;
            }
            InferenceVar ivar = (InferenceVar)s;
            return ivar.getInst() != null ? ivar.getInst() : s.getTypeSystem().ERROR;
        };
    }

    static JTypeMirror groundOrWildcard(JTypeMirror t) {
        return t.subst(s -> {
            if (!(s instanceof InferenceVar)) {
                return s;
            }
            InferenceVar ivar = (InferenceVar)s;
            return ivar.getInst() != null ? ivar.getInst() : s.getTypeSystem().UNBOUNDED_WILD;
        });
    }

    void duplicateInto(InferenceContext that) {
        boolean changedGraph = !that.freeVars.containsAll(this.freeVars) || !this.instantiationConstraints.isEmpty();
        that.graphWasChanged |= changedGraph;
        that.inferenceVars.addAll(this.inferenceVars);
        that.freeVars.addAll(this.freeVars);
        that.incorporationActions.addAll(this.incorporationActions);
        that.instantiationListeners.putAll(this.instantiationListeners);
        CollectionUtil.mergeMaps(that.instantiationConstraints, this.instantiationConstraints, (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        });
        this.parent = that;
        for (InferenceVar freeVar : this.freeVars) {
            that.incorporationActions.add(new IncorporationAction.PropagateAllBounds(freeVar));
        }
    }

    void addInstantiationDependencies(Set<? extends InferenceVar> from, Set<? extends InferenceVar> dependencies) {
        if (from.isEmpty()) {
            return;
        }
        HashSet<InferenceVar> outputVars = new HashSet<InferenceVar>(dependencies);
        outputVars.removeAll(from);
        if (outputVars.isEmpty()) {
            return;
        }
        for (InferenceVar inferenceVar : from) {
            this.logger.ivarDependencyRegistered(this, inferenceVar, outputVars);
            this.instantiationConstraints.merge(inferenceVar, outputVars, (o1, o2) -> {
                o2 = new LinkedHashSet(o2);
                o2.addAll(o1);
                return o2;
            });
        }
    }

    Map<InferenceVar, Set<InferenceVar>> getInstantiationDependencies() {
        return this.instantiationConstraints;
    }

    void addInstantiationListener(Set<? extends JTypeMirror> relevantTypes, InstantiationListener listener) {
        Set<InferenceVar> free = this.freeVarsIn(relevantTypes);
        if (free.isEmpty()) {
            listener.onInstantiation(this);
            return;
        }
        this.instantiationListeners.put(listener, free);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void callListeners() {
        if (this.instantiationListeners.isEmpty()) {
            return;
        }
        LinkedHashSet<InferenceVar> solved = new LinkedHashSet<InferenceVar>(this.inferenceVars);
        solved.removeAll(this.freeVars);
        Iterator iterator = new LinkedHashSet<Map.Entry<InstantiationListener, Set<InferenceVar>>>(this.instantiationListeners.entrySet()).iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!solved.containsAll((Collection)entry.getValue())) continue;
            try {
                ((InstantiationListener)entry.getKey()).onInstantiation(this);
                continue;
            }
            catch (ResolutionFailedException resolutionFailedException) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                this.instantiationListeners.remove(entry.getKey());
                continue;
            }
            break;
        }
        return;
    }

    Set<InferenceVar> getFreeVars() {
        return Collections.unmodifiableSet(this.freeVars);
    }

    private void onVarInstantiated(InferenceVar ivar) {
        if (this.parent != null) {
            this.parent.onVarInstantiated(ivar);
            return;
        }
        this.logger.ivarInstantiated(this, ivar, ivar.getInst());
        this.incorporationActions.addFirst(new IncorporationAction.SubstituteInst(ivar, ivar.getInst()){

            @Override
            public void apply(InferenceContext ctx) {
                InferenceContext.this.freeVars.removeIf(it -> it.getInst() != null);
                super.apply(ctx);
            }
        });
    }

    void onBoundAdded(InferenceVar ivar, InferenceVar.BoundKind kind, JTypeMirror bound, boolean isPrimary) {
        if (kind != InferenceVar.BoundKind.UPPER || bound != this.ts.OBJECT) {
            if (this.parent != null) {
                this.parent.onBoundAdded(ivar, kind, bound, isPrimary);
                return;
            }
            this.logger.boundAdded(this, ivar, kind, bound, isPrimary);
            this.incorporationActions.add(new IncorporationAction.CheckBound(ivar, kind, bound));
            this.incorporationActions.add(new IncorporationAction.PropagateBounds(ivar, kind, bound));
        }
    }

    void onIvarMerged(InferenceVar prev, InferenceVar delegate) {
        if (this.parent != null) {
            this.parent.onIvarMerged(prev, delegate);
            return;
        }
        this.logger.ivarMerged(this, prev, delegate);
        this.mapping = this.mapping.plus(prev.getBaseVar(), delegate);
        this.incorporationActions.addFirst(new IncorporationAction.SubstituteInst(prev, delegate));
    }

    void incorporate() {
        if (this.incorporationActions.isEmpty()) {
            return;
        }
        IncorporationAction hook = this.incorporationActions.pollFirst();
        while (hook != null) {
            if (hook.doApplyToInstVar || hook.ivar.getInst() == null) {
                hook.apply(this);
            }
            hook = this.incorporationActions.pollFirst();
        }
    }

    void solve() {
        this.solve(false);
    }

    boolean solve(boolean onlyBoundedVars) {
        return this.solve(() -> new VarWalkStrategy.GraphWalk(this, onlyBoundedVars));
    }

    void solve(InferenceVar var) {
        this.solve(new VarWalkStrategy.GraphWalk(var));
    }

    private boolean solve(Supplier<VarWalkStrategy> newWalker) {
        VarWalkStrategy strategy = newWalker.get();
        while (strategy != null && !this.solve(strategy)) {
            strategy = newWalker.get();
        }
        return this.freeVars.isEmpty();
    }

    private boolean solve(VarWalkStrategy walker) {
        this.graphWasChanged = false;
        this.incorporate();
        while (walker.hasNext()) {
            Object varsToSolve = walker.next();
            boolean progress = true;
            block1: while (!CollectionUtil.intersect(this.freeVars, (Collection)varsToSolve, (Collection[])new Collection[0]).isEmpty() && progress) {
                if (this.graphWasChanged) {
                    this.graphWasChanged = false;
                    this.logger.contextDependenciesChanged(this);
                    return false;
                }
                progress = false;
                for (List<ReductionStep> wave : ReductionStep.WAVES) {
                    if (!this.solveBatchProgressed((Set<InferenceVar>)varsToSolve, wave)) continue;
                    this.incorporate();
                    progress = true;
                    this.callListeners();
                    continue block1;
                }
            }
        }
        return true;
    }

    private boolean solveBatchProgressed(Set<InferenceVar> varsToSolve, List<ReductionStep> wave) {
        for (InferenceVar ivar : CollectionUtil.intersect(varsToSolve, this.freeVars, (Collection[])new Collection[0])) {
            for (ReductionStep step : wave) {
                if (!step.accepts(ivar, this)) continue;
                ivar.setInst(step.solve(ivar, this));
                this.onVarInstantiated(ivar);
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.inferenceVars.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Inference context " + this.getId()).append('\n');
        for (InferenceVar ivar : this.inferenceVars) {
            sb.append(ivar);
            if (ivar.getInst() != null) {
                sb.append(" := ").append(ivar.getInst()).append('\n');
                continue;
            }
            ivar.formatBounds(sb).append('\n');
        }
        return sb.toString();
    }

    public static interface InstantiationListener {
        public void onInstantiation(InferenceContext var1);
    }
}

