/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public final class LocalVariableNamingConventionsRule
extends AbstractNamingConventionRule<ASTVariableId> {
    private final PropertyDescriptor<Pattern> localVarRegex = this.defaultProp("localVar", "non-final local variable").build();
    private final PropertyDescriptor<Pattern> finalVarRegex = this.defaultProp("finalVar", "final local variable").build();
    private final PropertyDescriptor<Pattern> exceptionBlockParameterRegex = this.defaultProp("catchParameter", "exception block parameter").build();

    public LocalVariableNamingConventionsRule() {
        super(ASTVariableId.class, new Class[0]);
        this.definePropertyDescriptor(this.localVarRegex);
        this.definePropertyDescriptor(this.finalVarRegex);
        this.definePropertyDescriptor(this.exceptionBlockParameterRegex);
    }

    public Object visit(ASTVariableId node, Object data) {
        if (node.isUnnamed()) {
            return null;
        }
        if (node.isExceptionBlockParameter()) {
            this.checkMatches(node, this.exceptionBlockParameterRegex, data);
        } else if (node.isLocalVariable()) {
            this.checkMatches(node, node.isFinal() ? this.finalVarRegex : this.localVarRegex, data);
        }
        return data;
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]*";
    }

    @Override
    String nameExtractor(ASTVariableId node) {
        return node.getName();
    }

    @Override
    String kindDisplayName(ASTVariableId node, PropertyDescriptor<Pattern> descriptor) {
        if (node.isExceptionBlockParameter()) {
            return "exception block parameter";
        }
        if (node.isLocalVariable()) {
            return node.isFinal() ? "final local variable" : "local variable";
        }
        throw new UnsupportedOperationException("This rule doesn't handle this case");
    }
}

