/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFormalParamSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ImplicitMemberSymbols {
    private static final int VISIBILITY_MASK = 7;
    private static final int VARARGS_MOD = 128;

    private ImplicitMemberSymbols() {
    }

    public static JMethodSymbol enumValueOf(JClassSymbol enumSym) {
        assert (enumSym.isEnum()) : "Not an enum symbol " + enumSym;
        return new FakeMethodSym(enumSym, "valueOf", 9, TypeSystem::declaration, Collections.singletonList(t -> new FakeFormalParamSym((JExecutableSymbol)t, "name", (ts, s) -> ts.declaration(ts.getClassSymbol(String.class)))));
    }

    public static JMethodSymbol enumValues(JClassSymbol enumSym) {
        assert (enumSym.isEnum()) : "Not an enum symbol " + enumSym;
        return new FakeMethodSym(enumSym, "values", 9, (ts, c) -> ts.arrayType(ts.declaration((JClassSymbol)c)), Collections.emptyList());
    }

    public static JConstructorSymbol defaultCtor(JClassSymbol sym) {
        assert (sym != null);
        int modifiers = sym.isEnum() ? 2 : sym.getModifiers() & 7;
        return new FakeCtorSym(sym, modifiers, Collections.emptyList());
    }

    public static JMethodSymbol arrayClone(JClassSymbol arraySym) {
        assert (arraySym.isArray()) : "Not an array symbol " + arraySym;
        return new FakeMethodSym(arraySym, "clone", 17, TypeSystem::declaration, Collections.emptyList());
    }

    public static JConstructorSymbol arrayConstructor(JClassSymbol arraySym) {
        assert (arraySym.isArray()) : "Not an array symbol " + arraySym;
        return new FakeCtorSym(arraySym, 17, Collections.singletonList(c -> new FakeFormalParamSym((JExecutableSymbol)c, "arg0", (ts, sym) -> ts.INT)));
    }

    public static JConstructorSymbol recordConstructor(JClassSymbol recordSym, List<JFieldSymbol> recordComponents, boolean isVarargs) {
        assert (recordSym.isRecord()) : "Not a record symbol " + recordSym;
        int modifiers = isVarargs ? 129 : 1;
        return new FakeCtorSym(recordSym, modifiers, CollectionUtil.map(recordComponents, f -> c -> new FakeFormalParamSym((JExecutableSymbol)c, f.getSimpleName(), (ASTVariableId)f.tryGetNode(), (ts, sym) -> f.getTypeMirror(Substitution.EMPTY))));
    }

    public static JMethodSymbol recordAccessor(JClassSymbol recordSym, JFieldSymbol recordComponent) {
        assert (recordSym.isRecord()) : "Not a record symbol " + recordSym;
        return new FakeMethodSym(recordSym, recordComponent.getSimpleName(), 1, (ts, encl) -> recordComponent.getTypeMirror(Substitution.EMPTY), Collections.emptyList());
    }

    public static JFieldSymbol arrayLengthField(JClassSymbol arraySym) {
        assert (arraySym.isArray()) : "Not an array symbol " + arraySym;
        return new FakeFieldSym(arraySym, "length", 17, (ts, s) -> ts.INT);
    }

    private static final class FakeFieldSym
    implements JFieldSymbol {
        private final JClassSymbol owner;
        private final String name;
        private final int modifiers;
        private final BiFunction<? super TypeSystem, ? super JClassSymbol, ? extends JTypeMirror> type;

        FakeFieldSym(JClassSymbol owner, String name, int modifiers, BiFunction<? super TypeSystem, ? super JClassSymbol, ? extends JTypeMirror> type) {
            this.owner = owner;
            this.name = name;
            this.modifiers = modifiers;
            this.type = type;
        }

        @Override
        public TypeSystem getTypeSystem() {
            return this.owner.getTypeSystem();
        }

        @Override
        public JTypeMirror getTypeMirror(Substitution subst) {
            return this.type.apply(this.getTypeSystem(), this.owner).subst((Function)subst);
        }

        @Override
        public String getSimpleName() {
            return this.name;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public boolean isEnumConstant() {
            return false;
        }

        @Override
        public @NonNull JClassSymbol getEnclosingClass() {
            return this.owner;
        }

        public String toString() {
            return SymbolToStrings.FAKE.toString(this);
        }

        @Override
        public boolean equals(Object o) {
            return SymbolEquality.FIELD.equals(this, o);
        }

        public int hashCode() {
            return SymbolEquality.FIELD.hash(this);
        }
    }

    private static final class FakeFormalParamSym
    implements JFormalParamSymbol {
        private final JExecutableSymbol owner;
        private final String name;
        private final ASTVariableId node;
        private final BiFunction<? super TypeSystem, ? super JFormalParamSymbol, ? extends JTypeMirror> type;

        private FakeFormalParamSym(JExecutableSymbol owner, String name, BiFunction<? super TypeSystem, ? super JFormalParamSymbol, ? extends JTypeMirror> type) {
            this(owner, name, null, type);
        }

        private FakeFormalParamSym(JExecutableSymbol owner, String name, @Nullable ASTVariableId node, BiFunction<? super TypeSystem, ? super JFormalParamSymbol, ? extends JTypeMirror> type) {
            this.owner = owner;
            this.name = name;
            this.node = node;
            this.type = type;
        }

        @Override
        public @Nullable ASTVariableId tryGetNode() {
            return this.node;
        }

        @Override
        public TypeSystem getTypeSystem() {
            return this.owner.getTypeSystem();
        }

        @Override
        public JTypeMirror getTypeMirror(Substitution subst) {
            return this.type.apply(this.getTypeSystem(), this).subst((Function)subst);
        }

        @Override
        public JExecutableSymbol getDeclaringSymbol() {
            return this.owner;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public String getSimpleName() {
            return this.name;
        }

        public String toString() {
            return SymbolToStrings.FAKE.toString(this);
        }

        @Override
        public boolean equals(Object o) {
            return SymbolEquality.FORMAL_PARAM.equals(this, o);
        }

        public int hashCode() {
            return SymbolEquality.FORMAL_PARAM.hash(this);
        }
    }

    private static final class FakeCtorSym
    extends FakeExecutableSymBase<JConstructorSymbol>
    implements JConstructorSymbol {
        FakeCtorSym(JClassSymbol owner, int modifiers, List<Function<JConstructorSymbol, JFormalParamSymbol>> formals) {
            super(owner, "new", modifiers, formals);
        }

        @Override
        public boolean equals(Object o) {
            return SymbolEquality.CONSTRUCTOR.equals(this, o);
        }

        public int hashCode() {
            return SymbolEquality.CONSTRUCTOR.hash(this);
        }
    }

    private static final class FakeMethodSym
    extends FakeExecutableSymBase<JMethodSymbol>
    implements JMethodSymbol {
        private final BiFunction<? super TypeSystem, ? super JClassSymbol, ? extends JTypeMirror> returnType;

        FakeMethodSym(JClassSymbol owner, String name, int modifiers, BiFunction<? super TypeSystem, ? super JClassSymbol, ? extends JTypeMirror> returnType, List<Function<JMethodSymbol, JFormalParamSymbol>> formals) {
            super(owner, name, modifiers, formals);
            this.returnType = returnType;
        }

        @Override
        public boolean isBridge() {
            return false;
        }

        @Override
        public JTypeMirror getReturnType(Substitution subst) {
            return this.returnType.apply(this.getTypeSystem(), this.getEnclosingClass());
        }

        @Override
        public boolean equals(Object o) {
            return SymbolEquality.METHOD.equals(this, o);
        }

        public int hashCode() {
            return SymbolEquality.METHOD.hash(this);
        }
    }

    private static abstract class FakeExecutableSymBase<T extends JExecutableSymbol>
    implements JExecutableSymbol {
        private final JClassSymbol owner;
        private final String name;
        private final int modifiers;
        private final List<JFormalParamSymbol> formals;

        FakeExecutableSymBase(JClassSymbol owner, String name, int modifiers, List<Function<T, JFormalParamSymbol>> formals) {
            this.owner = owner;
            this.name = name;
            this.modifiers = modifiers;
            this.formals = CollectionUtil.map(formals, f -> (JFormalParamSymbol)f.apply(this));
        }

        @Override
        public TypeSystem getTypeSystem() {
            return this.owner.getTypeSystem();
        }

        @Override
        public List<JTypeMirror> getFormalParameterTypes(Substitution subst) {
            return CollectionUtil.map(this.formals, p -> p.getTypeMirror(subst));
        }

        @Override
        public List<JTypeMirror> getThrownExceptionTypes(Substitution subst) {
            return Collections.emptyList();
        }

        @Override
        public List<JTypeVar> getTypeParameters() {
            return Collections.emptyList();
        }

        @Override
        public String getSimpleName() {
            return this.name;
        }

        @Override
        public List<JFormalParamSymbol> getFormalParameters() {
            return this.formals;
        }

        @Override
        public boolean isVarargs() {
            return (this.modifiers & 0x80) != 0;
        }

        @Override
        public int getArity() {
            return this.formals.size();
        }

        @Override
        public @Nullable JTypeMirror getAnnotatedReceiverType(Substitution subst) {
            if (!this.hasReceiver()) {
                return null;
            }
            return this.getTypeSystem().declaration(this.owner).subst((Function)subst);
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public @NonNull JClassSymbol getEnclosingClass() {
            return this.owner;
        }

        public String toString() {
            return SymbolToStrings.FAKE.toString(this);
        }
    }
}

