/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.internal;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sourceforge.pmd.lang.java.symbols.JAccessibleElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.CoreResolvers;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.NameResolver;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainBuilder;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SuperTypesEnumerator;
import net.sourceforge.pmd.lang.java.symbols.table.internal.SymTableFactory;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.OverloadSet;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

public final class JavaResolvers {
    private static final BinaryOperator<List<JMethodSig>> STATIC_MERGER = (as, bs) -> JavaResolvers.methodMerger(true, as, bs);
    private static final BinaryOperator<List<JMethodSig>> NON_STATIC_MERGER = (as, bs) -> JavaResolvers.methodMerger(false, as, bs);

    private JavaResolvers() {
    }

    static String prependPackageName(String pack, String name) {
        return pack.isEmpty() ? name : pack + "." + name;
    }

    static boolean canBeImportedIn(String thisPackage, JAccessibleElementSymbol member) {
        return JavaResolvers.isAccessibleIn(null, thisPackage, member, false);
    }

    static @NonNull NameResolver<JTypeMirror> importedOnDemand(final Set<String> lazyImportedPackagesAndTypes, final SymbolResolver symResolver, final String thisPackage) {
        return new NameResolver.SingleNameResolver<JTypeMirror>(){

            @Override
            public @Nullable JTypeMirror resolveFirst(String simpleName) {
                for (String pack : lazyImportedPackagesAndTypes) {
                    String name = JavaResolvers.prependPackageName(pack, simpleName);
                    JClassSymbol sym = symResolver.resolveClassFromCanonicalName(name);
                    if (sym == null || !JavaResolvers.canBeImportedIn(thisPackage, sym)) continue;
                    return sym.getTypeSystem().typeOf(sym, false);
                }
                return null;
            }

            @Override
            public String toString() {
                return "ImportOnDemandResolver(" + lazyImportedPackagesAndTypes + ")";
            }
        };
    }

    static @NonNull NameResolver<JTypeMirror> packageResolver(final SymbolResolver symResolver, final String packageName) {
        return new NameResolver.SingleNameResolver<JTypeMirror>(){

            @Override
            public @Nullable JTypeMirror resolveFirst(String simpleName) {
                JClassSymbol sym = symResolver.resolveClassFromBinaryName(JavaResolvers.prependPackageName(packageName, simpleName));
                if (sym != null) {
                    return sym.getTypeSystem().typeOf(sym, false);
                }
                return null;
            }

            @Override
            public String toString() {
                return "PackageResolver(" + packageName + ")";
            }
        };
    }

    static NameResolver<JMethodSig> subtypeMethodResolver(final JClassType t) {
        final JClassSymbol nestRoot = t.getSymbol().getNestRoot();
        return new NameResolver<JMethodSig>(){

            @Override
            public @NonNull List<JMethodSig> resolveHere(String simpleName) {
                return t.streamMethods(it -> it.nameEquals(simpleName) && JavaResolvers.isAccessibleIn(nestRoot, it, true) && this.isNotStaticInterfaceMethod((JMethodSymbol)it)).collect(OverloadSet.collectMostSpecific(t));
            }

            private boolean isNotStaticInterfaceMethod(JMethodSymbol it) {
                return !it.isStatic() || it.getEnclosingClass().equals(t.getSymbol()) || !it.getEnclosingClass().isInterface();
            }

            @Override
            public String toString() {
                return "methods of " + t;
            }
        };
    }

    static NameResolver<JMethodSig> staticImportMethodResolver(final JClassType container, final @NonNull String accessPackageName, final String importedSimpleName) {
        assert (importedSimpleName != null);
        assert (accessPackageName != null);
        return new NameResolver<JMethodSig>(){

            @Override
            public @NonNull List<JMethodSig> resolveHere(String simpleName) {
                if (!simpleName.equals(importedSimpleName)) {
                    return Collections.emptyList();
                }
                return container.streamMethods(it -> Modifier.isStatic(it.getModifiers()) && it.nameEquals(simpleName) && JavaResolvers.canBeImportedIn(accessPackageName, it)).collect(OverloadSet.collectMostSpecific(container));
            }

            @Override
            public String toString() {
                return "static methods w/ name " + importedSimpleName + " of " + container;
            }
        };
    }

    static NameResolver<JVariableSig.FieldSig> staticImportFieldResolver(final JClassType containerType, final @NonNull String accessPackageName, final String importedSimpleName) {
        return new NameResolver<JVariableSig.FieldSig>(){
            List<JVariableSig.FieldSig> result;

            @Override
            public @NonNull List<JVariableSig.FieldSig> resolveHere(String simpleName) {
                if (!simpleName.equals(importedSimpleName)) {
                    return Collections.emptyList();
                }
                if (this.result == null) {
                    this.result = JavaResolvers.getMemberFieldResolver(containerType, accessPackageName, null, simpleName).resolveHere(simpleName);
                }
                return this.result;
            }

            @Override
            public String toString() {
                return "static methods w/ name " + importedSimpleName + " of " + containerType;
            }
        };
    }

    static NameResolver<JClassType> staticImportClassResolver(final JClassType containerType, final @NonNull String accessPackageName, final String importedSimpleName) {
        return new NameResolver<JClassType>(){
            List<JClassType> result;

            @Override
            public @NonNull List<JClassType> resolveHere(String simpleName) {
                if (!simpleName.equals(importedSimpleName)) {
                    return Collections.emptyList();
                }
                if (this.result == null) {
                    this.result = JavaResolvers.getMemberClassResolver(containerType, accessPackageName, null, simpleName).resolveHere(simpleName);
                }
                return this.result;
            }

            @Override
            public String toString() {
                return "static classes w/ name " + importedSimpleName + " of " + containerType;
            }
        };
    }

    static NameResolver<JMethodSig> staticImportOnDemandMethodResolver(final JClassType container, final @NonNull String accessPackageName) {
        assert (accessPackageName != null);
        return new NameResolver<JMethodSig>(){

            @Override
            public @NonNull List<JMethodSig> resolveHere(String simpleName) {
                return container.streamMethods(it -> Modifier.isStatic(it.getModifiers()) && it.nameEquals(simpleName) && JavaResolvers.canBeImportedIn(accessPackageName, it)).collect(OverloadSet.collectMostSpecific(container));
            }

            @Override
            public String toString() {
                return "all static methods of " + container;
            }
        };
    }

    static BinaryOperator<List<JMethodSig>> methodMerger(boolean inStaticType) {
        return inStaticType ? STATIC_MERGER : NON_STATIC_MERGER;
    }

    private static List<JMethodSig> methodMerger(boolean inStaticType, List<JMethodSig> myResult, List<JMethodSig> otherResult) {
        if (otherResult.isEmpty()) {
            return myResult;
        }
        BitSet isShadowed = new BitSet(otherResult.size());
        for (JMethodSig m1 : myResult) {
            int i = 0;
            for (JMethodSig m2 : otherResult) {
                boolean isAlreadyShadowed = isShadowed.get(i);
                if (!isAlreadyShadowed && TypeOps.areOverrideEquivalent(m1, m2) || inStaticType && !m2.isStatic()) {
                    isShadowed.set(i);
                }
                ++i;
            }
        }
        if (isShadowed.isEmpty()) {
            return CollectionUtil.concatView(myResult, otherResult);
        }
        ArrayList<JMethodSig> result = new ArrayList<JMethodSig>(myResult.size() + otherResult.size() - 1);
        result.addAll(myResult);
        JavaResolvers.copyIntoWithMask(otherResult, isShadowed, result);
        return Collections.unmodifiableList(result);
    }

    private static <T> void copyIntoWithMask(List<? extends T> input, BitSet denyList, List<? super T> result) {
        int last = 0;
        int i = denyList.nextSetBit(0);
        while (i >= 0) {
            if (last != i) {
                result.addAll(input.subList(last, i));
            }
            last = i + 1;
            i = denyList.nextSetBit(i + 1);
        }
        if (last != input.size()) {
            result.addAll(input.subList(last, input.size()));
        }
    }

    static Pair<NameResolver<JTypeMirror>, NameResolver<JVariableSig>> inheritedMembersResolvers(JClassType t) {
        Pair<ShadowChainBuilder.ResolverBuilder, ShadowChainBuilder.ResolverBuilder> builders = JavaResolvers.hidingWalkResolvers(t, t, t.getSymbol().getPackageName(), true, false, SuperTypesEnumerator.DIRECT_STRICT_SUPERTYPES);
        return Pair.of(((ShadowChainBuilder.ResolverBuilder)builders.getLeft()).build(), ((ShadowChainBuilder.ResolverBuilder)builders.getRight()).build());
    }

    static Pair<ShadowChainBuilder.ResolverBuilder, ShadowChainBuilder.ResolverBuilder> importOnDemandMembersResolvers(JClassType t, @NonNull String accessPackageName) {
        return JavaResolvers.hidingWalkResolvers(t, null, accessPackageName, false, true, SuperTypesEnumerator.JUST_SELF);
    }

    private static Pair<ShadowChainBuilder.ResolverBuilder, ShadowChainBuilder.ResolverBuilder> hidingWalkResolvers(JClassType t, @Nullable JClassType accessType, @NonNull String accessPackageName, boolean accessIsSubtypeOfOwner, boolean onlyStatic, SuperTypesEnumerator enumerator) {
        JClassSymbol nestRoot = accessType == null ? null : accessType.getSymbol().getNestRoot();
        ShadowChainBuilder.ResolverBuilder fields = SymTableFactory.VARS.new ShadowChainBuilder.ResolverBuilder();
        ShadowChainBuilder.ResolverBuilder types = SymTableFactory.TYPES.new ShadowChainBuilder.ResolverBuilder();
        Predicate<JVariableSig> isFieldAccessible = s -> JavaResolvers.filterStatic(onlyStatic, s.getSymbol()) && JavaResolvers.isAccessibleIn(nestRoot, accessPackageName, (JFieldSymbol)s.getSymbol(), accessIsSubtypeOfOwner);
        Predicate<JClassType> isTypeAccessible = s -> JavaResolvers.filterStatic(onlyStatic, s.getSymbol()) && JavaResolvers.isAccessibleIn(nestRoot, accessPackageName, s.getSymbol(), accessIsSubtypeOfOwner);
        for (JClassType next : enumerator.iterable(t)) {
            JavaResolvers.walkSelf(next, isFieldAccessible, isTypeAccessible, fields, types, (PSet<String>)HashTreePSet.empty(), (PSet<String>)HashTreePSet.empty());
        }
        return Pair.of((Object)types, (Object)fields);
    }

    private static boolean filterStatic(boolean onlyStatic, JElementSymbol symbol) {
        return !onlyStatic || Modifier.isStatic(((JAccessibleElementSymbol)symbol).getModifiers());
    }

    private static void walkSelf(JClassType t, Predicate<? super JVariableSig> isFieldAccessible, Predicate<? super JClassType> isTypeAccessible, ShadowChainBuilder.ResolverBuilder fields, ShadowChainBuilder.ResolverBuilder types, PSet<String> hiddenFields, PSet<String> hiddenTypes) {
        PSet<String> hiddenTypesInSup = JavaResolvers.processDeclarations(types, hiddenTypes, isTypeAccessible, t.getDeclaredClasses());
        PSet<String> hiddenFieldsInSup = JavaResolvers.processDeclarations(fields, hiddenFields, isFieldAccessible, t.getDeclaredFields());
        for (JClassType next : SuperTypesEnumerator.DIRECT_STRICT_SUPERTYPES.iterable(t)) {
            JavaResolvers.walkSelf(next, isFieldAccessible, isTypeAccessible, fields, types, hiddenFieldsInSup, hiddenTypesInSup);
        }
    }

    private static <S> PSet<String> processDeclarations(ShadowChainBuilder.ResolverBuilder builder, PSet<String> hidden, Predicate<? super S> isAccessible, List<? extends S> syms) {
        for (S inner : syms) {
            String simpleName = builder.getSimpleName(inner);
            if (hidden.contains((Object)simpleName)) continue;
            hidden = hidden.plus((Object)simpleName);
            if (!isAccessible.test(inner)) continue;
            builder.appendWithoutDuplicate(inner);
        }
        return hidden;
    }

    public static boolean isAccessibleIn(@NonNull JClassSymbol nestRoot, JAccessibleElementSymbol sym, boolean isOwnerASupertypeOfContext) {
        return JavaResolvers.isAccessibleIn(nestRoot, nestRoot.getPackageName(), sym, isOwnerASupertypeOfContext);
    }

    private static boolean isAccessibleIn(@Nullable JClassSymbol nestRoot, @NonNull String packageName, JAccessibleElementSymbol sym, boolean isOwnerASupertypeOfContext) {
        int modifiers = sym.getModifiers() & 7;
        switch (modifiers) {
            case 1: {
                return true;
            }
            case 2: {
                return nestRoot != null && nestRoot.equals(sym.getEnclosingClass().getNestRoot());
            }
            case 4: {
                if (isOwnerASupertypeOfContext) {
                    return true;
                }
            }
            case 0: {
                return sym.getPackageName().equals(packageName);
            }
        }
        throw AssertionUtil.shouldNotReachHere((String)("private field of an interface? " + sym + ", modifiers: " + Modifier.toString(sym.getModifiers())));
    }

    public static NameResolver<JClassType> getMemberClassResolver(JClassType c, @NonNull String accessPackageName, @Nullable JClassSymbol access, String name) {
        return JavaResolvers.getNamedMemberResolver(c, access, accessPackageName, JClassType::getDeclaredClass, name, JClassType::getSymbol, SymTableFactory.TYPES);
    }

    public static NameResolver<JVariableSig.FieldSig> getMemberFieldResolver(JClassType c, @NonNull String accessPackageName, @Nullable JClassSymbol access, String name) {
        return JavaResolvers.getNamedMemberResolver(c, access, accessPackageName, JClassType::getDeclaredField, name, JVariableSig.FieldSig::getSymbol, SymTableFactory.VARS);
    }

    private static <S> NameResolver<S> getNamedMemberResolver(JClassType c, @Nullable JClassSymbol access, @NonNull String accessPackageName, BiFunction<? super JClassType, String, ? extends S> getter, String name, Function<? super S, ? extends JAccessibleElementSymbol> symbolGetter, ShadowChainBuilder<? super S, ?> classes) {
        S found = getter.apply(c, name);
        if (found != null) {
            return CoreResolvers.singleton(name, found);
        }
        JClassSymbol nestRoot = access == null ? null : access.getNestRoot();
        Predicate<Object> isAccessible = s -> {
            JAccessibleElementSymbol sym = (JAccessibleElementSymbol)symbolGetter.apply((Object)s);
            return JavaResolvers.isAccessibleIn(nestRoot, accessPackageName, sym, JavaResolvers.isSubtype(access, sym.getEnclosingClass()));
        };
        ShadowChainBuilder.ResolverBuilder builder = classes.new ShadowChainBuilder.ResolverBuilder();
        for (JClassType next : SuperTypesEnumerator.DIRECT_STRICT_SUPERTYPES.iterable(c)) {
            JavaResolvers.walkForSingleName(next, isAccessible, name, getter, builder, (PSet<String>)HashTreePSet.empty());
        }
        return builder.build();
    }

    private static boolean isSubtype(JClassSymbol sub, JClassSymbol sup) {
        return sub != null && sub.getTypeSystem().typeOf(sub, true).getAsSuper(sup) != null;
    }

    private static <S> void walkForSingleName(JClassType t, Predicate<? super S> isAccessible, String name, BiFunction<? super JClassType, String, ? extends S> getter, ShadowChainBuilder.ResolverBuilder builder, PSet<String> hidden) {
        PSet<String> hiddenInSup = JavaResolvers.processDeclarations(builder, hidden, isAccessible, CollectionUtil.listOfNotNull(getter.apply(t, name)));
        if (!hiddenInSup.isEmpty()) {
            return;
        }
        for (JClassType next : SuperTypesEnumerator.DIRECT_STRICT_SUPERTYPES.iterable(t)) {
            JavaResolvers.walkForSingleName(next, isAccessible, name, getter, builder, hiddenInSup);
        }
    }
}

