/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailure;
import net.sourceforge.pmd.lang.java.types.internal.infer.TypeInferenceLogger;
import org.checkerframework.checker.nullness.qual.NonNull;

final class ResolutionFailedException
extends RuntimeException {
    private static final ThreadLocal<ResolutionFailedException> SHARED = ThreadLocal.withInitial(ResolutionFailedException::new);
    private static final boolean SHARE_EXCEPTION = true;
    private ResolutionFailure failure;

    private ResolutionFailedException() {
    }

    public ResolutionFailure getFailure() {
        return this.failure;
    }

    public void setFailure(ResolutionFailure location) {
        this.failure = location;
    }

    static ResolutionFailedException getSharedInstance() {
        return SHARED.get();
    }

    @Override
    public String toString() {
        return "ResolutionFailedException:failure=" + this.failure;
    }

    static ResolutionFailedException incompatibleBound(TypeInferenceLogger logger, InferenceVar ivar, InferenceVar.BoundKind k1, JTypeMirror b1, InferenceVar.BoundKind k2, JTypeMirror b2) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(null, "Incompatible bounds: " + k1.format(ivar, b1) + " and " + k2.format(ivar, b2)));
    }

    static ResolutionFailedException incompatibleBound(TypeInferenceLogger logger, JTypeMirror actual, JTypeMirror formal, JavaNode explicitTarg) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(explicitTarg, "Incompatible bounds: " + actual + " does not conform to " + formal));
    }

    static ResolutionFailedException incompatibleTypeParamCount(TypeInferenceLogger logger, ExprMirror site, JMethodSig m, int found, int required) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(site.getLocation(), "Wrong number of type arguments"));
    }

    static ResolutionFailedException incompatibleFormal(TypeInferenceLogger logger, ExprMirror arg, JTypeMirror found, JTypeMirror required) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(arg.getLocation(), "Incompatible formals: " + ResolutionFailedException.isNotConvertibleMessage(found, required)));
    }

    static ResolutionFailedException incompatibleReturn(TypeInferenceLogger logger, ExprMirror expr, JTypeMirror found, JTypeMirror required) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(expr.getLocation(), "Incompatible return type: " + ResolutionFailedException.isNotConvertibleMessage(found, required)));
    }

    private static @NonNull String isNotConvertibleMessage(JTypeMirror found, JTypeMirror required) {
        String rs;
        String fs = found.toString();
        if (fs.equals(rs = required.toString())) {
            TypePrettyPrint.TypePrettyPrinter PRETTY_PRINTER_CONFIG = new TypePrettyPrint.TypePrettyPrinter().qualifyTvars(true);
            fs = TypePrettyPrint.prettyPrint(found, PRETTY_PRINTER_CONFIG);
            rs = TypePrettyPrint.prettyPrint(required, PRETTY_PRINTER_CONFIG);
        }
        return fs + " is not convertible to " + rs;
    }

    static ResolutionFailedException incompatibleFormalExprNoReason(TypeInferenceLogger logger, ExprMirror arg, JTypeMirror required) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(arg.getLocation(), "Argument expression is not compatible with " + required));
    }

    static ResolutionFailedException notAVarargsMethod(TypeInferenceLogger logger, ExprMirror expr) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(expr.getLocation(), "Method is not varargs"));
    }

    static ResolutionFailedException unsolvableDependency(TypeInferenceLogger logger) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(null, "Unsolvable inference variable dependency"));
    }

    static ResolutionFailedException incompatibleArity(TypeInferenceLogger logger, int found, int required, ExprMirror location) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(location.getLocation(), "Incompatible arity: " + found + " != " + required));
    }

    static ResolutionFailedException lambdaCannotTargetVoidMethod(TypeInferenceLogger logger, ExprMirror location) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(location.getLocation(), "Lambda cannot target void method"));
    }

    static ResolutionFailedException lambdaCannotTargetValueMethod(TypeInferenceLogger logger, ExprMirror location) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(location.getLocation(), "Lambda cannot target non-void method"));
    }

    static ResolutionFailedException boundMethodRef(TypeInferenceLogger logger, ExprMirror location) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(location.getLocation(), "Lambda cannot target non-void method"));
    }

    static ResolutionFailedException mismatchedLambdaParameters(TypeInferenceLogger logger, JMethodSig expected, List<JTypeMirror> found, ExprMirror location) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(location.getLocation(), "Mismatched lambda parameter types: found " + found + " cannot be parameters of " + expected));
    }

    static ResolutionFailedException cannotInvokeInstanceMethodOnPrimitive(TypeInferenceLogger logger, JTypeMirror actual, ExprMirror location) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(location.getLocation(), "Cannot invoke instance method on primitive: " + actual));
    }

    static ResolutionFailedException noCtDeclaration(TypeInferenceLogger logger, JMethodSig fun, ExprMirror.MethodRefMirror mref) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(mref.getLocation(), "No compile time declaration found conforming to: " + fun));
    }

    static ResolutionFailedException notAFunctionalInterface(TypeInferenceLogger logger, JTypeMirror failedCandidate, ExprMirror loc) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(loc.getLocation(), "Not a functional interface: " + failedCandidate));
    }

    static ResolutionFailedException missingTargetTypeForFunctionalExpr(TypeInferenceLogger logger, ExprMirror loc) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(loc.getLocation(), "Missing target type for functional expression"));
    }

    static ResolutionFailedException lambdaCannotTargetGenericFunction(TypeInferenceLogger logger, JMethodSig fun, ExprMirror loc) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(loc.getLocation(), "Lambda expression cannot target a generic method: " + fun));
    }

    static ResolutionFailedException boundCallableReference(TypeInferenceLogger logger, JMethodSig fun, ExprMirror loc) {
        return ResolutionFailedException.getShared(logger.isNoop() ? ResolutionFailure.UNKNOWN : new ResolutionFailure(loc.getLocation(), "Lambda expression cannot target a generic method: " + fun));
    }

    private static @NonNull ResolutionFailedException getShared(ResolutionFailure failure) {
        ResolutionFailedException instance = ResolutionFailedException.getSharedInstance();
        instance.setFailure(failure);
        return instance;
    }
}

