/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.DataflowPass;
import net.sourceforge.pmd.util.OptionalBool;

public class ImplicitSwitchFallThroughRule
extends AbstractJavaRulechainRule {
    private static final Pattern IGNORED_COMMENT = Pattern.compile("/[/*].*\\bfalls?[ -]?thr(ough|u)\\b.*", 34);

    public ImplicitSwitchFallThroughRule() {
        super(ASTSwitchStatement.class, new Class[0]);
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        DataflowPass.DataflowResult dataflow = DataflowPass.getDataflowResult(node.getRoot());
        for (ASTSwitchBranch branch : node.getBranches()) {
            if (branch instanceof ASTSwitchFallthroughBranch && branch != node.getLastChild()) {
                ASTSwitchFallthroughBranch fallthrough = (ASTSwitchFallthroughBranch)branch;
                OptionalBool bool = dataflow.switchBranchFallsThrough(branch);
                if (bool == OptionalBool.NO || !fallthrough.getStatements().nonEmpty() || this.nextBranchHasComment(branch)) continue;
                this.asCtx(data).addViolation((Node)branch.getNextBranch().getLabel());
                continue;
            }
            return null;
        }
        return null;
    }

    boolean nextBranchHasComment(ASTSwitchBranch branch) {
        ASTSwitchBranch nextBranch = branch.getNextBranch();
        if (nextBranch == null) {
            return false;
        }
        for (JavaccToken special : GenericToken.previousSpecials((GenericToken)nextBranch.getFirstToken())) {
            if (!JavaAstUtils.isComment(special) || !IGNORED_COMMENT.matcher((CharSequence)special.getImageCs()).find()) continue;
            return true;
        }
        return false;
    }
}

