/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

abstract class SymbolicValueBuilder
extends AnnotationVisitor {
    private final AsmSymbolResolver resolver;

    SymbolicValueBuilder(AsmSymbolResolver resolver) {
        super(589824);
        this.resolver = resolver;
    }

    AsmSymbolResolver getResolver() {
        return this.resolver;
    }

    protected abstract void acceptValue(String var1, SymbolicValue var2);

    public void visitEnum(String name, String descriptor, String value) {
        this.acceptValue(name, SymbolicValue.SymEnum.fromTypeDescriptor(this.resolver.getTypeSystem(), descriptor, value));
    }

    public void visit(String name, Object value) {
        if (value instanceof Type) {
            this.acceptValue(name, SymbolicValue.SymClass.ofBinaryName(this.resolver.getTypeSystem(), ((Type)value).getClassName()));
        } else {
            this.acceptValue(name, SymbolicValue.of(this.resolver.getTypeSystem(), value));
        }
    }

    public AnnotationVisitor visitArray(String name) {
        return new ArrayValueBuilder(this.resolver, new ArrayList<SymbolicValue>(), v -> this.acceptValue(name, (SymbolicValue)v));
    }

    static class ArrayValueBuilder
    extends SymbolicValueBuilder {
        private final List<SymbolicValue> arrayElements;
        private final Consumer<SymbolicValue> finisher;

        ArrayValueBuilder(AsmSymbolResolver resolver, List<SymbolicValue> arrayElements, Consumer<SymbolicValue> finisher) {
            super(resolver);
            this.arrayElements = arrayElements;
            this.finisher = finisher;
        }

        @Override
        protected void acceptValue(String name, SymbolicValue v) {
            this.arrayElements.add(v);
        }

        public void visitEnd() {
            this.finisher.accept(SymbolicValue.SymArray.forElements(this.arrayElements));
        }
    }
}

