/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.coreimpl;

import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainIterator;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainNode;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainNodeBase;
import net.sourceforge.pmd.util.IteratorUtil;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ShadowChainIteratorImpl<S, I>
extends IteratorUtil.AbstractPausingIterator<ShadowChainNode<S, I>>
implements ShadowChainIterator<S, I> {
    private ShadowChainNode<S, I> nextGroupToTest;
    private final String name;

    ShadowChainIteratorImpl(ShadowChainNode<S, I> firstInclusive, String name) {
        this.nextGroupToTest = firstInclusive;
        this.name = name;
    }

    protected void computeNext() {
        ShadowChainNode<S, I> next = this.nextGroupThatKnows(this.nextGroupToTest, this.name);
        if (next == null) {
            this.done();
            return;
        }
        assert (!next.resolveHere(this.name).isEmpty()) : "Shadow iterator stopped on wrong node";
        this.setNext(next);
    }

    protected void prepareViewOn(ShadowChainNode<S, I> current) {
        if (!(current instanceof ShadowChainNodeBase)) {
            throw new IllegalStateException("Root group is empty " + current);
        }
        this.nextGroupToTest = current.getParent();
    }

    @Override
    public I getScopeTag() {
        return ((ShadowChainNodeBase)this.getCurrentValue()).getScopeTag();
    }

    @Override
    public List<S> getResults() {
        return ((ShadowChainNode)this.getCurrentValue()).resolveHere(this.name);
    }

    private @Nullable ShadowChainNode<S, I> nextGroupThatKnows(@Nullable ShadowChainNode<S, I> group, String name) {
        ShadowChainNode<S, I> parent;
        for (parent = group; parent != null && !ShadowChainIteratorImpl.definitelyKnows(parent, name); parent = parent.getParent()) {
        }
        return parent;
    }

    private static boolean definitelyKnows(@NonNull ShadowChainNode<?, ?> group, String name) {
        OptionalBool opt = group.knowsSymbol(name);
        if (opt.isKnown()) {
            return opt.isTrue();
        }
        return group.getResolver().resolveFirst(name) != null;
    }
}

