/* Generated By:JJTree&JavaCC: Do not edit this line. JavaParserImpl.java */
package net.sourceforge.pmd.lang.java.ast;

import static net.sourceforge.pmd.lang.java.ast.JavaTokenKinds.*;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType.PrimitiveTypeKind;

class JavaParserImpl/*@bgen(jjtree)*/implements JavaParserImplTreeConstants {/*@bgen(jjtree)*/
  protected net.sourceforge.pmd.lang.ast.impl.javacc.JjtreeBuilder<AbstractJavaNode> jjtree = new net.sourceforge.pmd.lang.ast.impl.javacc.JjtreeBuilder<AbstractJavaNode>();
  private int jdkVersion = 0;
  private boolean preview = false;

  public void setJdkVersion(int jdkVersion) {
   this.jdkVersion = jdkVersion;
  }

  public void setPreview(boolean preview) {
    this.preview = preview;
  }

  private void throwParseException(String message) {
    throw new net.sourceforge.pmd.lang.ast.ParseException(message).withLocation(token);
  }


  private boolean isRecordTypeSupported() {
    return jdkVersion >= 16;
  }

  private boolean localTypesSupported() {
    return isRecordTypeSupported();
  }

  /**
   * Keeps track during tree construction, whether we are currently building a switch label.
   * A switch label must not contain a LambdaExpression.
   * Unfortunately, we have added LambdaExpression as part of PrimaryPrefix, which is wrong.
   * To keep compatibility, this flag is used, whether a LambdaExpression should be parsed
   * in PrimaryPrefix.
   * See also comment at #Expression().
   */
  private boolean inSwitchLabel = false;

  // This is a semantic LOOKAHEAD to determine if we're dealing with an assert
  // Note that this can't be replaced with a syntactic lookahead
  // since "assert" isn't a string literal token
  private boolean isAssertStart() {
    if (jdkVersion <= 3) {
      return false;
    }

    return getToken(1).getImage().equals("assert");
  }

  private boolean isRecordStart() {
    return isRecordTypeSupported() && isKeyword("record") && isToken(2, IDENTIFIER);
  }

  private boolean isEnumStart() {
    return jdkVersion >= 5 && isKeyword("enum");
  }

  /**
   * Semantic lookahead to check if the next identifier is a
   * specific restricted keyword.
   *
   * <p>Restricted keywords are:
   * var, yield, record, sealed, permits, "non" + "-" + "sealed"
   *
   * <p>enum and assert is used like restricted keywords, as they were not keywords
   * in the early java versions.
   */
  private boolean isKeyword(String image) {
    return isKeyword(1, image);
  }

  private boolean isKeyword(int index, String image) {
      net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken token = getToken(index);
      return token.kind == IDENTIFIER && token.getImage().equals(image);
  }

  private boolean isToken(int index, int kind) {
      return getToken(index).kind == kind;
  }

  /**
   * Semantic lookahead which matches "non-sealed".
   *
   * <p>"non-sealed" cannot be a token, for several reasons:
   * It is only a keyword with java15 preview+, it consists actually
   * of several separate tokens, which are valid on their own.
   */
  private boolean isNonSealedModifier() {
      if (isKeyword(1, "non") && isToken(2, MINUS) && isKeyword(3, "sealed")) {
          JavaccToken nonToken = getToken(1);
          JavaccToken minusToken = getToken(2);
          JavaccToken sealedToken = getToken(3);
          return nonToken.getReportLocation().getEndColumn() == minusToken.getReportLocation().getStartColumn()
            && minusToken.getReportLocation().getEndColumn() == sealedToken.getReportLocation().getStartColumn();
      }
      return false;
  }

  private boolean classModifierForLocalTypesLookahead() {
      net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken next = getToken(1);
      return next.kind == AT
        || next.kind == PUBLIC
        || next.kind == PROTECTED
        || next.kind == PRIVATE
        || next.kind == ABSTRACT
        || next.kind == STATIC
        || next.kind == FINAL
        || next.kind == STRICTFP;
  }

  private boolean localTypeDeclAfterModifiers() {
      net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken next = getToken(1);
      return next.kind == CLASS
        || localTypesSupported() && (
              next.kind == INTERFACE
           || next.kind == AT && isToken(2, INTERFACE)
           || next.kind == IDENTIFIER && next.getImage().equals("enum")
           || next.kind == IDENTIFIER && next.getImage().equals("record") && isToken(2, IDENTIFIER)
      );
  }

  private boolean localTypeDeclGivenNextIsIdent() {
      return localTypesSupported() && (isRecordStart() || isEnumStart());
  }

  /**
   *  True if we're in a switch block, one precondition for parsing a yield
   *  statement.
   */
  private boolean inSwitchExprBlock = false;

  private boolean isYieldStart() {
    return inSwitchExprBlock
    && isKeyword("yield")
    && mayStartExprAfterYield(2);
  }

  private boolean mayStartExprAfterYield(final int offset) {
      // based off of https://hg.openjdk.java.net/jdk/jdk/file/bc3da0226ffa/src/jdk.compiler/share/classes/com/sun/tools/javac/parser/JavacParser.java#l2580
      // please don't sue me
      JavaccToken token = getToken(offset);
      if (token == null) return false; // eof
      switch (token.kind) {
           case PLUS: case MINUS: case STRING_LITERAL: case CHARACTER_LITERAL:
           case INTEGER_LITERAL: case FLOATING_POINT_LITERAL: case HEX_FLOATING_POINT_LITERAL:
           case NULL: case IDENTIFIER: case TRUE: case FALSE:
           case NEW: case SWITCH: case THIS: case SUPER:
               return true;
           case INCR: case DECR:
               return getToken(offset + 1).kind != SEMICOLON; // eg yield++;
           case LPAREN:
               int lookahead = offset + 1;
               int balance = 1;
               JavaccToken t;
               while ((t = getToken(lookahead)) != null && balance > 0) {
                   switch (t.kind) {
                       case LPAREN: balance++; break;
                       case RPAREN: balance--; break;
                       case COMMA: if (balance == 1) return false; // a method call, eg yield(1, 2);
                   }
                   lookahead++;
               }
               // lambda:       yield () -> {};
               // method call:  yield ();
               return t != null
                   && (lookahead != offset + 2 // ie ()
                   || t.kind == LAMBDA);
           default:
               return false;
      }
  }

  private boolean shouldStartStatementInSwitch() {
    switch (getToken(1).kind) {
        case _DEFAULT:
        case CASE:
        case RBRACE:
            return false;
        default:
            return true;
    }
  }

  public Map<Integer, String> getSuppressMap() {
    return token_source.getSuppressMap();
  }

  public void setSuppressMarker(String marker) {
    token_source.setSuppressMarker(marker);
  }

  private void setLastTokenImage(AbstractJavaNode node) {
    node.setImage(getToken(0).getImage());
  }

  private void fixLastToken() {
       AbstractJavaNode top = (AbstractJavaNode) jjtree.peekNode();
       top.setLastToken(getToken(0));
  }

  private void forceExprContext() {
       AbstractJavaNode top = jjtree.peekNode();

       if (top instanceof ASTAmbiguousName) {
           // see doc on the method
           AbstractJavaNode replacement = (AbstractJavaNode) ((ASTAmbiguousName) top).forceExprContext();
           jjtree.popNode();
           jjtree.pushNode(replacement);
       }
  }

  private void pushEmptyModifierList() {
        ASTModifierList emptyMods = new ASTModifierList(JJTMODIFIERLIST);

        emptyMods.setDeclaredModifiers(Collections.emptySet());

        JavaccToken tok = JavaccToken.implicitBefore(getToken(1));
        emptyMods.setFirstToken(tok);
        emptyMods.setLastToken(tok);

        jjtree.pushNode(emptyMods);
  }

  private void insertEmptyModifierListWithAnnotations(AbstractJavaNode node, AbstractJavaNode nodeWithAnnotations) {
        ASTModifierList emptyMods = new ASTModifierList(JJTMODIFIERLIST);

        emptyMods.setDeclaredModifiers(Collections.emptySet());

        JavaccToken tok = JavaccToken.implicitBefore(node.getFirstToken());
        emptyMods.setFirstToken(tok);
        emptyMods.setLastToken(tok);

        List<ASTAnnotation> annotations = new ArrayList<ASTAnnotation>();
        while (nodeWithAnnotations.getNumChildren() > 0 && nodeWithAnnotations.getChild(0) instanceof ASTAnnotation) {
            ASTAnnotation annotation = (ASTAnnotation) nodeWithAnnotations.getChild(0);
            nodeWithAnnotations.removeChildAtIndex(0);
            annotations.add(annotation);
        }
        for (int i = 0; i < annotations.size(); i++) {
            emptyMods.addChild(annotations.get(i), i);
        }
        if (!annotations.isEmpty()) {
            emptyMods.setFirstToken(annotations.get(0).getFirstToken());
            emptyMods.setLastToken(annotations.get(annotations.size() - 1).getLastToken());
        }

        node.insertChild(emptyMods, 0);
  }

  private void forceTypeContext() {
      AbstractJavaNode top = jjtree.peekNode();

      if (top instanceof ASTAmbiguousName) {
          // see doc on the method
          AbstractJavaNode replacement = ((ASTAmbiguousName) top).forceTypeContext();
          jjtree.popNode();
          jjtree.pushNode(replacement);
      }
  }


  // make the top node the last child of the second node on the stack
  // If the stack ends with ..[A][B], then it becomes ..[A[B]]
  private void injectTop() {
       AbstractJavaNode top = (AbstractJavaNode) jjtree.popNode();
       AbstractJavaNode prev = (AbstractJavaNode) jjtree.peekNode();
       prev.addChild(top, prev.getNumChildren());
       prev.setLastToken(top.getLastToken());
  }

    /**
     * Keeps track during tree construction, whether we are currently building an
     * explicit constructor invocation. Then the PrimaryExpression that may prefix
     * a qualified super constructor call may not consume "super" tokens.
     */
    private boolean inExplicitConstructorInvoc = false;

/*****************************************
 * THE JAVA LANGUAGE GRAMMAR STARTS HERE *
 *****************************************/

/*
 * Program structuring syntax follows.
 */
  final public ASTCompilationUnit CompilationUnit() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) CompilationUnit */
  ASTCompilationUnit jjtn000 = new ASTCompilationUnit(JJTCOMPILATIONUNIT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      if (jj_2_1(2147483647)) {
        PackageDeclaration();
        label_1:
        while (true) {
          switch (jj_nt.kind) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[0] = jj_gen;
            break label_1;
          }
          EmptyDeclaration();
        }
      } else {
        ;
      }
      label_2:
      while (true) {
        switch (jj_nt.kind) {
        case IMPORT:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_2;
        }
        ImportDeclaration();
        label_3:
        while (true) {
          switch (jj_nt.kind) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[2] = jj_gen;
            break label_3;
          }
          EmptyDeclaration();
        }
      }
      if (jj_2_2(2147483647)) {
        ModuleDeclaration();
        label_4:
        while (true) {
          switch (jj_nt.kind) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[3] = jj_gen;
            break label_4;
          }
          EmptyDeclaration();
        }
      } else {
        ;
      }
      label_5:
      while (true) {
        if (jj_2_3(1)) {
          ;
        } else {
          break label_5;
        }
        TypeDeclaration();
        label_6:
        while (true) {
          switch (jj_nt.kind) {
          case SEMICOLON:
            ;
            break;
          default:
            jj_la1[4] = jj_gen;
            break label_6;
          }
          EmptyDeclaration();
        }
      }
      if (jj_2_6(1)) {
        label_7:
        while (true) {
          if (jj_2_4(3)) {
            ;
          } else {
            break label_7;
          }
          ClassMemberDeclarationNoMethod();
        }
        ModifierList();
        MethodDeclaration();
        label_8:
        while (true) {
          if (jj_2_5(1)) {
            ;
          } else {
            break label_8;
          }
          ClassOrInterfaceBodyDeclaration();
        }
      } else {
        ;
      }
      jj_consume_token(0);
    jjtree.closeNodeScope(jjtn000, true, getToken(0));
    jjtc000 = false;
     jjtn000.setComments(token_source.comments);
     {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
    throw new Error("Missing return statement in function");
  }

// see ClassOrInterfaceBodyDeclaration()
  final public void ClassMemberDeclarationNoMethod() throws net.sourceforge.pmd.lang.ast.ParseException {
    ModifierList();
    if (jj_2_7(3)) {
      ClassOrInterfaceDeclaration();
    } else if (isKeyword("enum")) {
      EnumDeclaration();
    } else if (isKeyword("record")) {
      RecordDeclaration();
    } else if (jj_2_8(2147483647)) {
      ConstructorDeclaration();
    } else if (jj_2_9(2147483647)) {
      FieldDeclaration();
    } else if (jj_2_10(2)) {
      AnnotationTypeDeclaration();
    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final private void ModuleDeclLahead() throws net.sourceforge.pmd.lang.ast.ParseException {
    label_9:
    while (true) {
      switch (jj_nt.kind) {
      case AT:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_9;
      }
      Annotation();
    }
    if (isKeyword("open") || isKeyword("module")) {

    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
    jj_consume_token(IDENTIFIER);
  }

  final public void PackageDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) PackageDeclaration */
 ASTPackageDeclaration jjtn000 = new ASTPackageDeclaration(JJTPACKAGEDECLARATION);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));String image;
    try {
      ModAnnotationList();
      jj_consume_token(PACKAGE);
      image = VoidName();
                                                   jjtn000.setImage(image);
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ImportDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ImportDeclaration */
 ASTImportDeclaration jjtn000 = new ASTImportDeclaration(JJTIMPORTDECLARATION);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));String image;
    try {
      jj_consume_token(IMPORT);
      switch (jj_nt.kind) {
      case STATIC:
        jj_consume_token(STATIC);
                       jjtn000.setStatic();
        break;
      default:
        jj_la1[6] = jj_gen;
        ;
      }
      image = VoidName();
                     jjtn000.setImage(image);
      switch (jj_nt.kind) {
      case DOT:
        jj_consume_token(DOT);
        jj_consume_token(STAR);
             jjtn000.setImportOnDemand();
        break;
      default:
        jj_la1[7] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

/*
 * Modifiers. We match all modifiers in a single rule to reduce the chances of
 * syntax errors for simple modifier mistakes. It will also enable us to give
 * better error messages.
 */
  final public void ModifierList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ModifierList */
   ASTModifierList jjtn000 = new ASTModifierList(JJTMODIFIERLIST);
   boolean jjtc000 = true;
   jjtree.openNodeScope(jjtn000, getToken(1));EnumSet<JModifier> modifiers = EnumSet.noneOf(JModifier.class);
    try {
      label_10:
      while (true) {
        if (jj_2_11(2)) {
          ;
        } else {
          break label_10;
        }
        switch (jj_nt.kind) {
        case PUBLIC:
          jj_consume_token(PUBLIC);
                      modifiers.add(JModifier.PUBLIC);
          break;
        case STATIC:
          jj_consume_token(STATIC);
                      modifiers.add(JModifier.STATIC);
          break;
        case PROTECTED:
          jj_consume_token(PROTECTED);
                      modifiers.add(JModifier.PROTECTED);
          break;
        case PRIVATE:
          jj_consume_token(PRIVATE);
                      modifiers.add(JModifier.PRIVATE);
          break;
        case FINAL:
          jj_consume_token(FINAL);
                      modifiers.add(JModifier.FINAL);
          break;
        case ABSTRACT:
          jj_consume_token(ABSTRACT);
                      modifiers.add(JModifier.ABSTRACT);
          break;
        case SYNCHRONIZED:
          jj_consume_token(SYNCHRONIZED);
                      modifiers.add(JModifier.SYNCHRONIZED);
          break;
        case NATIVE:
          jj_consume_token(NATIVE);
                      modifiers.add(JModifier.NATIVE);
          break;
        case TRANSIENT:
          jj_consume_token(TRANSIENT);
                      modifiers.add(JModifier.TRANSIENT);
          break;
        case VOLATILE:
          jj_consume_token(VOLATILE);
                      modifiers.add(JModifier.VOLATILE);
          break;
        case STRICTFP:
          jj_consume_token(STRICTFP);
                      modifiers.add(JModifier.STRICTFP);
          break;
        case _DEFAULT:
          jj_consume_token(_DEFAULT);
                      modifiers.add(JModifier.DEFAULT);
          break;
        default:
          jj_la1[8] = jj_gen;
          if (isKeyword("sealed")) {
            jj_consume_token(IDENTIFIER);
                                                    modifiers.add(JModifier.SEALED);
          } else if (isNonSealedModifier()) {
            jj_consume_token(IDENTIFIER);
            jj_consume_token(MINUS);
            jj_consume_token(IDENTIFIER);
                                                                           modifiers.add(JModifier.NON_SEALED);
          } else {
            switch (jj_nt.kind) {
            case AT:
              Annotation();
              break;
            default:
              jj_la1[9] = jj_gen;
              jj_consume_token(-1);
              throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
            }
          }
        }
      }
   jjtn000.setDeclaredModifiers(modifiers);
   jjtree.closeNodeScope(jjtn000, true, getToken(0));
   jjtc000 = false;
   jjtree.injectRight(1);
    } catch (Throwable jjte000) {
   if (jjtc000) {
     jjtree.clearNodeScope(jjtn000);
     jjtc000 = false;
   } else {
     jjtree.popNode();
   }
   if (jjte000 instanceof RuntimeException) {
     {if (true) throw (RuntimeException)jjte000;}
   }
   if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
     {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
   }
   {if (true) throw (Error)jjte000;}
    } finally {
   if (jjtc000) {
     jjtree.closeNodeScope(jjtn000, true, getToken(0));
   }
    }
  }

/*
 * Declaration syntax follows.
 */
  final public void TypeDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
    ModifierList();
    switch (jj_nt.kind) {
    case CLASS:
    case INTERFACE:
      ClassOrInterfaceDeclaration();
      break;
    case AT:
      AnnotationTypeDeclaration();
      break;
    default:
      jj_la1[10] = jj_gen;
      if (isKeyword("enum")) {
        EnumDeclaration();
      } else if (isKeyword("record")) {
        RecordDeclaration();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void ClassOrInterfaceDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ClassDeclaration */
  ASTClassDeclaration jjtn000 = new ASTClassDeclaration(JJTCLASSDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case CLASS:
        jj_consume_token(CLASS);
        break;
      case INTERFACE:
        jj_consume_token(INTERFACE);
                            jjtn000.setInterface();
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      jj_consume_token(IDENTIFIER);
                 jjtn000.setSimpleName(getToken(0).getImage());
      switch (jj_nt.kind) {
      case LT:
        TypeParameters();
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case EXTENDS:
        ExtendsList();
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case IMPLEMENTS:
        ImplementsList();
        break;
      default:
        jj_la1[14] = jj_gen;
        ;
      }
      if (isKeyword("permits")) {
        PermittedSubclasses();
      } else {
        ;
      }
      ClassOrInterfaceBody();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ExtendsList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ExtendsList */
  ASTExtendsList jjtn000 = new ASTExtendsList(JJTEXTENDSLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(EXTENDS);
      AnnotatedClassOrInterfaceType();
      label_11:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[15] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        AnnotatedClassOrInterfaceType();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void ImplementsList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ImplementsList */
  ASTImplementsList jjtn000 = new ASTImplementsList(JJTIMPLEMENTSLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IMPLEMENTS);
      AnnotatedClassOrInterfaceType();
      label_12:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[16] = jj_gen;
          break label_12;
        }
        jj_consume_token(COMMA);
        AnnotatedClassOrInterfaceType();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void PermittedSubclasses() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) PermitsList */
  ASTPermitsList jjtn000 = new ASTPermitsList(JJTPERMITSLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      softKeyword("permits");
      ClassOrInterfaceType();
      label_13:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[17] = jj_gen;
          break label_13;
        }
        jj_consume_token(COMMA);
        ClassOrInterfaceType();
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void EnumDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) EnumDeclaration */
  ASTEnumDeclaration jjtn000 = new ASTEnumDeclaration(JJTENUMDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      softKeyword("enum");
      jj_consume_token(IDENTIFIER);
                 jjtn000.setSimpleName(getToken(0).getImage());
      switch (jj_nt.kind) {
      case IMPLEMENTS:
        ImplementsList();
        break;
      default:
        jj_la1[18] = jj_gen;
        ;
      }
      EnumBody();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void EnumBody() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) EnumBody */
  ASTEnumBody jjtn000 = new ASTEnumBody(JJTENUMBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LBRACE);
      switch (jj_nt.kind) {
      case IDENTIFIER:
      case AT:
        EnumConstant();
        label_14:
        while (true) {
          if (jj_2_12(2)) {
            ;
          } else {
            break label_14;
          }
          jj_consume_token(COMMA);
          EnumConstant();
        }
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
            jjtn000.setTrailingComma();
        break;
      default:
        jj_la1[20] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
            jjtn000.setSeparatorSemi();
        label_15:
        while (true) {
          if (jj_2_13(1)) {
            ;
          } else {
            break label_15;
          }
          ClassOrInterfaceBodyDeclaration();
        }
        break;
      default:
        jj_la1[21] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void EnumConstant() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) EnumConstant */
  ASTEnumConstant jjtn000 = new ASTEnumConstant(JJTENUMCONSTANT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      ModAnnotationList();
      VariableDeclaratorId();
      switch (jj_nt.kind) {
      case LPAREN:
        ArgumentList();
        break;
      default:
        jj_la1[22] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case LBRACE:
        AnonymousClassDeclaration();
        break;
      default:
        jj_la1[23] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void RecordDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) RecordDeclaration */
  ASTRecordDeclaration jjtn000 = new ASTRecordDeclaration(JJTRECORDDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      softKeyword("record");
      jj_consume_token(IDENTIFIER);
                 jjtn000.setSimpleName(getToken(0).getImage());
      switch (jj_nt.kind) {
      case LT:
        TypeParameters();
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
      RecordHeader();
      switch (jj_nt.kind) {
      case IMPLEMENTS:
        ImplementsList();
        break;
      default:
        jj_la1[25] = jj_gen;
        ;
      }
      RecordBody();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void RecordHeader() throws net.sourceforge.pmd.lang.ast.ParseException {
    jj_consume_token(LPAREN);
    RecordComponentList();
    jj_consume_token(RPAREN);
  }

  final public void RecordComponentList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) RecordComponentList */
  ASTRecordComponentList jjtn000 = new ASTRecordComponentList(JJTRECORDCOMPONENTLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      if (jj_2_14(1)) {
        RecordComponent();
        label_16:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[26] = jj_gen;
            break label_16;
          }
          jj_consume_token(COMMA);
          RecordComponent();
        }
      } else {
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void RecordComponent() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) RecordComponent */
  ASTRecordComponent jjtn000 = new ASTRecordComponent(JJTRECORDCOMPONENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      ModAnnotationList();
      FormalParamType();
      VariableDeclaratorId();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void RecordBody() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) RecordBody */
  ASTRecordBody jjtn000 = new ASTRecordBody(JJTRECORDBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LBRACE);
      label_17:
      while (true) {
        if (jj_2_15(1)) {
          ;
        } else {
          break label_17;
        }
        RecordBodyDeclaration();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void RecordBodyDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jj_2_16(2147483647)) {
      ModifierList();
      CompactConstructorDeclaration();
    } else if (jj_2_17(1)) {
      ClassOrInterfaceBodyDeclaration();
    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final private void CompactConstructorDeclarationLookahead() throws net.sourceforge.pmd.lang.ast.ParseException {
    ModifierList();
    jj_consume_token(IDENTIFIER);
    jj_consume_token(LBRACE);
  }

  final public void CompactConstructorDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) CompactConstructorDeclaration */
  ASTCompactConstructorDeclaration jjtn000 = new ASTCompactConstructorDeclaration(JJTCOMPACTCONSTRUCTORDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
                 jjtn000.setImage(token.getImage());
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void TypeParameters() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) TypeParameters */
  ASTTypeParameters jjtn000 = new ASTTypeParameters(JJTTYPEPARAMETERS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LT);
      TypeParameter();
      label_18:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[27] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
        TypeParameter();
      }
      jj_consume_token(GT);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void TypeParameter() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) TypeParameter */
  ASTTypeParameter jjtn000 = new ASTTypeParameter(JJTTYPEPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      AnnotationList();
      jj_consume_token(IDENTIFIER);
                 setLastTokenImage(jjtn000);
      switch (jj_nt.kind) {
      case EXTENDS:
        jj_consume_token(EXTENDS);
        IntersectionType();
        break;
      default:
        jj_la1[28] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void ClassOrInterfaceBody() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ClassBody */
  ASTClassBody jjtn000 = new ASTClassBody(JJTCLASSBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LBRACE);
      label_19:
      while (true) {
        if (jj_2_18(1)) {
          ;
        } else {
          break label_19;
        }
        ClassOrInterfaceBodyDeclaration();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ClassOrInterfaceBodyDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jj_2_24(2147483647)) {
      Initializer();
    } else if (jj_2_25(1)) {
      ModifierList();
      if (jj_2_19(3)) {
        ClassOrInterfaceDeclaration();
      } else if (isKeyword("enum")) {
        EnumDeclaration();
      } else if (isKeyword("record")) {
        RecordDeclaration();
      } else if (jj_2_20(2147483647)) {
        ConstructorDeclaration();
      } else if (jj_2_21(2147483647)) {
        FieldDeclaration();
      } else if (jj_2_22(2)) {
        MethodDeclaration();
      } else if (jj_2_23(2)) {
        AnnotationTypeDeclaration();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    } else {
      switch (jj_nt.kind) {
      case SEMICOLON:
    ASTEmptyDeclaration jjtn001 = new ASTEmptyDeclaration(JJTEMPTYDECLARATION);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          jj_consume_token(SEMICOLON);
        } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, true, getToken(0));
    }
        }
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void FieldDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) FieldDeclaration */
  ASTFieldDeclaration jjtn000 = new ASTFieldDeclaration(JJTFIELDDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      Type();
      VariableDeclarator();
      label_20:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[30] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        VariableDeclarator();
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void VariableDeclarator() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) VariableDeclarator */
  ASTVariableDeclarator jjtn000 = new ASTVariableDeclarator(JJTVARIABLEDECLARATOR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      VariableIdWithDims();
      switch (jj_nt.kind) {
      case ASSIGN:
        jj_consume_token(ASSIGN);
        VariableInitializer();
        break;
      default:
        jj_la1[31] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void VariableDeclaratorId() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) VariableId */
  ASTVariableId jjtn000 = new ASTVariableId(JJTVARIABLEID);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
                 jjtree.closeNodeScope(jjtn000, true, getToken(0));
                 jjtc000 = false;
                 jjtn000.setName(getToken(0).getImage());
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void VariableIdWithDims() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) VariableId */
  ASTVariableId jjtn000 = new ASTVariableId(JJTVARIABLEID);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
                 jjtn000.setName(getToken(0).getImage());
      switch (jj_nt.kind) {
      case LBRACKET:
      case AT:
        Dims();
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ReceiverParameter() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ReceiverParameter */
  ASTReceiverParameter jjtn000 = new ASTReceiverParameter(JJTRECEIVERPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      AnnotatedClassOrInterfaceType();
      switch (jj_nt.kind) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        jj_consume_token(DOT);
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
      jj_consume_token(THIS);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void VariableInitializer() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case LBRACE:
      ArrayInitializer();
      break;
    default:
      jj_la1[34] = jj_gen;
      if (jj_2_26(1)) {
        Expression();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void ArrayInitializer() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ArrayInitializer */
  ASTArrayInitializer jjtn000 = new ASTArrayInitializer(JJTARRAYINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LBRACE);
      if (jj_2_28(1)) {
        VariableInitializer();
        label_21:
        while (true) {
          if (jj_2_27(2)) {
            ;
          } else {
            break label_21;
          }
          jj_consume_token(COMMA);
          VariableInitializer();
        }
      } else {
        ;
      }
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void MethodDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) MethodDeclaration */
  ASTMethodDeclaration jjtn000 = new ASTMethodDeclaration(JJTMETHODDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case LT:
        TypeParameters();
        break;
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      ResultType();
      jj_consume_token(IDENTIFIER);
                 jjtn000.setName(getToken(0).getImage());
      FormalParameters();
      switch (jj_nt.kind) {
      case LBRACKET:
      case AT:
        Dims();
        break;
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case THROWS:
        ThrowsList();
        break;
      default:
        jj_la1[38] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case LBRACE:
        Block();
        break;
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void FormalParameters() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) FormalParameters */
  ASTFormalParameters jjtn000 = new ASTFormalParameters(JJTFORMALPARAMETERS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LPAREN);
      if (jj_2_31(1)) {
        if (jj_2_29(2147483647)) {
          ReceiverParameter();
        } else if (jj_2_30(1)) {
          FormalParameter();
        } else {
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        label_22:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[40] = jj_gen;
            break label_22;
          }
          jj_consume_token(COMMA);
          FormalParameter();
        }
      } else {
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void FormalParameter() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) FormalParameter */
  ASTFormalParameter jjtn000 = new ASTFormalParameter(JJTFORMALPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      LocalVarModifierList();
      FormalParamType();
      label_23:
      while (true) {
        switch (jj_nt.kind) {
        case BIT_OR:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_23;
        }
        jj_consume_token(BIT_OR);
        FormalParamType();
      }
      VariableIdWithDims();
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void FormalParamType() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      if (jj_2_32(2)) {
                                           ASTArrayType jjtn001 = new ASTArrayType(JJTARRAYTYPE);
                                           boolean jjtc001 = true;
                                           jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          VarargsDimensions();
        } catch (Throwable jjte001) {
                                           if (jjtc001) {
                                             jjtree.clearNodeScope(jjtn001);
                                             jjtc001 = false;
                                           } else {
                                             jjtree.popNode();
                                           }
                                           if (jjte001 instanceof RuntimeException) {
                                             {if (true) throw (RuntimeException)jjte001;}
                                           }
                                           if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                             {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                           }
                                           {if (true) throw (Error)jjte001;}
        } finally {
                                           if (jjtc001) {
                                             jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                           }
        }
      } else {
        ;
      }
      break;
    default:
      jj_la1[42] = jj_gen;
      if (jj_2_34(1)) {
        ClassOrInterfaceType();
        if (jj_2_33(2)) {
                                           ASTArrayType jjtn002 = new ASTArrayType(JJTARRAYTYPE);
                                           boolean jjtc002 = true;
                                           jjtree.openNodeScope(jjtn002, getToken(1));
          try {
            VarargsDimensions();
          } catch (Throwable jjte002) {
                                           if (jjtc002) {
                                             jjtree.clearNodeScope(jjtn002);
                                             jjtc002 = false;
                                           } else {
                                             jjtree.popNode();
                                           }
                                           if (jjte002 instanceof RuntimeException) {
                                             {if (true) throw (RuntimeException)jjte002;}
                                           }
                                           if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                             {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
                                           }
                                           {if (true) throw (Error)jjte002;}
          } finally {
                                           if (jjtc002) {
                                             jjtree.closeNodeScope(jjtn002,  2, getToken(0));
                                           }
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void VarargsDimensions() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ArrayDimensions */
  ASTArrayDimensions jjtn000 = new ASTArrayDimensions(JJTARRAYDIMENSIONS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      if (jj_2_36(2147483647)) {
        label_24:
        while (true) {
          ArrayTypeDim();
          if (jj_2_35(2147483647)) {
            ;
          } else {
            break label_24;
          }
        }
        switch (jj_nt.kind) {
        case AT:
        case ELLIPSIS:
          VarargsDim();
          break;
        default:
          jj_la1[43] = jj_gen;
          ;
        }
      } else {
        switch (jj_nt.kind) {
        case AT:
        case ELLIPSIS:
          VarargsDim();
          break;
        default:
          jj_la1[44] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void VarargsDim() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ArrayTypeDim */
  ASTArrayTypeDim jjtn000 = new ASTArrayTypeDim(JJTARRAYTYPEDIM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      TypeAnnotListNoInject();
      jj_consume_token(ELLIPSIS);
                                    jjtree.closeNodeScope(jjtn000, true, getToken(0));
                                    jjtc000 = false;
                                   jjtn000.setVarargs();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void ConstructorDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ConstructorDeclaration */
  ASTConstructorDeclaration jjtn000 = new ASTConstructorDeclaration(JJTCONSTRUCTORDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case LT:
        TypeParameters();
        break;
      default:
        jj_la1[45] = jj_gen;
        ;
      }
      jj_consume_token(IDENTIFIER);
                  setLastTokenImage(jjtn000);
      FormalParameters();
      switch (jj_nt.kind) {
      case THROWS:
        ThrowsList();
        break;
      default:
        jj_la1[46] = jj_gen;
        ;
      }
      ConstructorBlock();
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final private void ConstructorBlock() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) Block */
  ASTBlock jjtn000 = new ASTBlock(JJTBLOCK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LBRACE);
      if (jj_2_39(2147483647)) {
        ExplicitConstructorInvocation();
      } else {
        label_25:
        while (true) {
          if (jj_2_37(2)) {
            ;
          } else {
            break label_25;
          }
          BlockStatement();
        }
        if (jj_2_38(2147483647)) {
          ExplicitConstructorInvocation();
        } else {
          ;
        }
      }
      label_26:
      while (true) {
        if (jj_2_40(1)) {
          ;
        } else {
          break label_26;
        }
        BlockStatement();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void ExplicitConstructorInvocation() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ExplicitConstructorInvocation */
 ASTExplicitConstructorInvocation jjtn000 = new ASTExplicitConstructorInvocation(JJTEXPLICITCONSTRUCTORINVOCATION);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));boolean prev = inExplicitConstructorInvoc; inExplicitConstructorInvoc = true;
    try {
      if (jj_2_41(2147483647)) {
        TypeArguments();
        switch (jj_nt.kind) {
        case THIS:
          jj_consume_token(THIS);
          break;
        case SUPER:
          jj_consume_token(SUPER);
                                                            jjtn000.setIsSuper();
          break;
        default:
          jj_la1[47] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      } else if (jj_2_42(2147483647)) {
        jj_consume_token(THIS);
      } else if (jj_2_43(2147483647)) {
        jj_consume_token(SUPER);
                                                            jjtn000.setIsSuper();
      } else if (jj_2_44(1)) {
        PrimaryExpression();
        jj_consume_token(DOT);
        switch (jj_nt.kind) {
        case LT:
          TypeArguments();
          break;
        default:
          jj_la1[48] = jj_gen;
          ;
        }
        jj_consume_token(SUPER);
                                                            jjtn000.setIsSuper();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
   inExplicitConstructorInvoc = prev;
      ArgumentList();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void Initializer() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) Initializer */
  ASTInitializer jjtn000 = new ASTInitializer(JJTINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case STATIC:
        jj_consume_token(STATIC);
              jjtn000.setStatic();
        break;
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

/* JLS: https://docs.oracle.com/javase/specs/jls/se8/html/jls-4.html#jls-4.3

ReferenceType:
    ClassOrInterfaceType
    TypeVariable
    ArrayType
ClassOrInterfaceType:
    ClassType
    InterfaceType
ClassType:
    {Annotation} Identifier [TypeArguments]
    ClassOrInterfaceType . {Annotation} Identifier [TypeArguments]
InterfaceType:
    ClassType
TypeVariable:
    {Annotation} Identifier
ArrayType:
    PrimitiveType Dims
    ClassOrInterfaceType Dims
    TypeVariable Dims
Dims:
    {Annotation} [ ] {{Annotation} [ ]}

*/
  final public void IntersectionType() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) #IntersectionType( isIntersection) */
 ASTIntersectionType jjtn000 = new ASTIntersectionType(JJTINTERSECTIONTYPE);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));boolean isIntersection=false;
    try {
      AnnotatedType();
      label_27:
      while (true) {
        switch (jj_nt.kind) {
        case BIT_AND:
          ;
          break;
        default:
          jj_la1[50] = jj_gen;
          break label_27;
        }
        jj_consume_token(BIT_AND);
                         isIntersection=true;
        AnnotatedClassOrInterfaceType();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000,  isIntersection, getToken(0));
    }
    }
  }

  final public void AnnotationList() throws net.sourceforge.pmd.lang.ast.ParseException {
    label_28:
    while (true) {
      switch (jj_nt.kind) {
      case AT:
        ;
        break;
      default:
        jj_la1[51] = jj_gen;
        break label_28;
      }
      Annotation();
    }
  }

  final public void ModAnnotationList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ModifierList */
 ASTModifierList jjtn000 = new ASTModifierList(JJTMODIFIERLIST);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));jjtn000.setDeclaredModifiers(Collections.emptySet());
    try {
      label_29:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[52] = jj_gen;
          break label_29;
        }
        Annotation();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public int TypeAnnotListNoInject() throws net.sourceforge.pmd.lang.ast.ParseException {
 int num = 0;
    label_30:
    while (true) {
      switch (jj_nt.kind) {
      case AT:
        ;
        break;
      default:
        jj_la1[53] = jj_gen;
        break label_30;
      }
      TypeAnnotation();
                       num++;
    }
     {if (true) return num;}
    throw new Error("Missing return statement in function");
  }

// Type annotation lists are by default injected in the
// next node to be opened (most likely a type).
// Sometimes (array dims), this need not be and TypeAnnotListNoInject
// should be used.
  final public void TypeAnnotationList() throws net.sourceforge.pmd.lang.ast.ParseException {
 int size=0;
    size = TypeAnnotListNoInject();
                                  jjtree.injectRight(size);
  }

  final public void AnnotatedType() throws net.sourceforge.pmd.lang.ast.ParseException {
    TypeAnnotationList();
    Type();
  }

  final public void AnnotatedRefType() throws net.sourceforge.pmd.lang.ast.ParseException {
    TypeAnnotationList();
    ReferenceType();
  }

  final public void AnnotatedClassOrInterfaceType() throws net.sourceforge.pmd.lang.ast.ParseException {
    TypeAnnotationList();
    ClassOrInterfaceType();
  }

/*
 * Type, name and expression syntax follows.
 * Type is the same as "UnannType" in JLS
 *
 * See https://docs.oracle.com/javase/specs/jls/se10/html/jls-8.html#jls-UnannType
 */
  final public void Type() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      if (jj_2_45(2)) {
                                           ASTArrayType jjtn001 = new ASTArrayType(JJTARRAYTYPE);
                                           boolean jjtc001 = true;
                                           jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          Dims();
        } catch (Throwable jjte001) {
                                           if (jjtc001) {
                                             jjtree.clearNodeScope(jjtn001);
                                             jjtc001 = false;
                                           } else {
                                             jjtree.popNode();
                                           }
                                           if (jjte001 instanceof RuntimeException) {
                                             {if (true) throw (RuntimeException)jjte001;}
                                           }
                                           if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                             {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                           }
                                           {if (true) throw (Error)jjte001;}
        } finally {
                                           if (jjtc001) {
                                             jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                           }
        }
      } else {
        ;
      }
      break;
    default:
      jj_la1[54] = jj_gen;
      if (jj_2_47(1)) {
        ClassOrInterfaceType();
        if (jj_2_46(2)) {
                                           ASTArrayType jjtn002 = new ASTArrayType(JJTARRAYTYPE);
                                           boolean jjtc002 = true;
                                           jjtree.openNodeScope(jjtn002, getToken(1));
          try {
            Dims();
          } catch (Throwable jjte002) {
                                           if (jjtc002) {
                                             jjtree.clearNodeScope(jjtn002);
                                             jjtc002 = false;
                                           } else {
                                             jjtree.popNode();
                                           }
                                           if (jjte002 instanceof RuntimeException) {
                                             {if (true) throw (RuntimeException)jjte002;}
                                           }
                                           if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                             {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
                                           }
                                           {if (true) throw (Error)jjte002;}
          } finally {
                                           if (jjtc002) {
                                             jjtree.closeNodeScope(jjtn002,  2, getToken(0));
                                           }
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void Dims() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ArrayDimensions */
  ASTArrayDimensions jjtn000 = new ASTArrayDimensions(JJTARRAYDIMENSIONS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      label_31:
      while (true) {
        ArrayTypeDim();
        switch (jj_nt.kind) {
        case LBRACKET:
        case AT:
          ;
          break;
        default:
          jj_la1[55] = jj_gen;
          break label_31;
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ArrayTypeDim() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ArrayTypeDim */
  ASTArrayTypeDim jjtn000 = new ASTArrayTypeDim(JJTARRAYTYPEDIM);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      TypeAnnotListNoInject();
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void ReferenceType() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
                                            ASTArrayType jjtn001 = new ASTArrayType(JJTARRAYTYPE);
                                            boolean jjtc001 = true;
                                            jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        Dims();
      } catch (Throwable jjte001) {
                                            if (jjtc001) {
                                              jjtree.clearNodeScope(jjtn001);
                                              jjtc001 = false;
                                            } else {
                                              jjtree.popNode();
                                            }
                                            if (jjte001 instanceof RuntimeException) {
                                              {if (true) throw (RuntimeException)jjte001;}
                                            }
                                            if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                              {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                            }
                                            {if (true) throw (Error)jjte001;}
      } finally {
                                            if (jjtc001) {
                                              jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                            }
      }
      break;
    default:
      jj_la1[56] = jj_gen;
      if (jj_2_49(1)) {
        ClassOrInterfaceType();
        if (jj_2_48(2)) {
                                            ASTArrayType jjtn002 = new ASTArrayType(JJTARRAYTYPE);
                                            boolean jjtc002 = true;
                                            jjtree.openNodeScope(jjtn002, getToken(1));
          try {
            Dims();
          } catch (Throwable jjte002) {
                                            if (jjtc002) {
                                              jjtree.clearNodeScope(jjtn002);
                                              jjtc002 = false;
                                            } else {
                                              jjtree.popNode();
                                            }
                                            if (jjte002 instanceof RuntimeException) {
                                              {if (true) throw (RuntimeException)jjte002;}
                                            }
                                            if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                              {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
                                            }
                                            {if (true) throw (Error)jjte002;}
          } finally {
                                            if (jjtc002) {
                                              jjtree.closeNodeScope(jjtn002,  2, getToken(0));
                                            }
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

/**
 * Parses a ClassOrInterfaceType. The production itself is #void,
 * but the node exists (declared inline within the production).
 */
  final public void ClassOrInterfaceType() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jjtree.isInjectionPending()) {
          ASTClassType jjtn001 = new ASTClassType(JJTCLASSTYPE);
          boolean jjtc001 = true;
          jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(IDENTIFIER);
                        jjtn001.setSimpleName(getToken(0).getImage());
        switch (jj_nt.kind) {
        case LT:
          TypeArguments();
          break;
        default:
          jj_la1[57] = jj_gen;
          ;
        }
      } catch (Throwable jjte001) {
          if (jjtc001) {
            jjtree.clearNodeScope(jjtn001);
            jjtc001 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte001 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte001;}
          }
          if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
            {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
          }
          {if (true) throw (Error)jjte001;}
      } finally {
          if (jjtc001) {
            jjtree.closeNodeScope(jjtn001, true, getToken(0));
          }
      }
    } else {
      switch (jj_nt.kind) {
      case IDENTIFIER:
        AmbiguousName();
        switch (jj_nt.kind) {
        case LT:
          ASTClassType jjtn002 = new ASTClassType(JJTCLASSTYPE);
          boolean jjtc002 = true;
          jjtree.openNodeScope(jjtn002, getToken(1));
          try {
            TypeArguments();
          } catch (Throwable jjte002) {
          if (jjtc002) {
            jjtree.clearNodeScope(jjtn002);
            jjtc002 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte002 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte002;}
          }
          if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
            {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
          }
          {if (true) throw (Error)jjte002;}
          } finally {
          if (jjtc002) {
            jjtree.closeNodeScope(jjtn002,  2, getToken(0));
          }
          }
          break;
        default:
          jj_la1[58] = jj_gen;
          ;
        }
        // At this point the first ClassType may be on top of the stack,
        // but its image is not set. If it is on the stack we need to shrink the bounds
        // of the ambiguous name, or delete it.
        Node first = jjtree.peekNode();
        if (first instanceof ASTClassType) {
          // then we saw type arguments, so the last segment is definitely a type name
          ASTAmbiguousName name = first.firstChild(ASTAmbiguousName.class);
          name.shrinkOrDeleteInParentSetImage();
        }
        break;
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
    label_32:
    while (true) {
      if (jj_2_50(2)) {
        ;
      } else {
        break label_32;
      }
      jj_consume_token(DOT);
      ClassTypeSegment();
    }
    forceTypeContext();
  }

  final private void ClassTypeSegment() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) #ClassType( jjtree . nodeArity ( ) + 1) */
  ASTClassType jjtn000 = new ASTClassType(JJTCLASSTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      TypeAnnotListNoInject();
      jj_consume_token(IDENTIFIER);
       jjtn000.setSimpleName(getToken(0).getImage());
      switch (jj_nt.kind) {
      case LT:
        TypeArguments();
        break;
      default:
        jj_la1[60] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
       if (jjtc000) {
         jjtree.clearNodeScope(jjtn000);
         jjtc000 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte000 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte000;}
       }
       if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
         {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
       }
       {if (true) throw (Error)jjte000;}
    } finally {
       if (jjtc000) {
         jjtree.closeNodeScope(jjtn000,  jjtree . nodeArity ( ) + 1, getToken(0));
       }
    }
  }

  final public void TypeArguments() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) TypeArguments */
  ASTTypeArguments jjtn000 = new ASTTypeArguments(JJTTYPEARGUMENTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      if (jj_2_51(2)) {
        jj_consume_token(LT);
        TypeArgument();
        label_33:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[61] = jj_gen;
            break label_33;
          }
          jj_consume_token(COMMA);
          TypeArgument();
        }
        jj_consume_token(GT);
      } else {
        switch (jj_nt.kind) {
        case LT:
          jj_consume_token(LT);
          jj_consume_token(GT);
          break;
        default:
          jj_la1[62] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void TypeArgument() throws net.sourceforge.pmd.lang.ast.ParseException {
    TypeAnnotationList();
    if (jj_2_52(1)) {
      ReferenceType();
    } else {
      switch (jj_nt.kind) {
      case HOOK:
        WildcardType();
        break;
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void WildcardType() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) WildcardType */
  ASTWildcardType jjtn000 = new ASTWildcardType(JJTWILDCARDTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(HOOK);
      switch (jj_nt.kind) {
      case EXTENDS:
      case SUPER:
        switch (jj_nt.kind) {
        case EXTENDS:
          jj_consume_token(EXTENDS);
          break;
        case SUPER:
          jj_consume_token(SUPER);
                                  jjtn000.setLowerBound(true);
          break;
        default:
          jj_la1[64] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        AnnotatedRefType();
        break;
      default:
        jj_la1[65] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

/* JLS https://docs.oracle.com/javase/specs/jls/se10/html/jls-4.html#jls-PrimitiveType

PrimitiveType:
    {Annotation} NumericType
    {Annotation} boolean
NumericType:
    IntegralType
    FloatingPointType
IntegralType:
    (one of)
    byte short int long char
FloatingPointType:
    (one of)
    float double
*/
  final public void PrimitiveType() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) PrimitiveType */
  ASTPrimitiveType jjtn000 = new ASTPrimitiveType(JJTPRIMITIVETYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case BOOLEAN:
        jj_consume_token(BOOLEAN);
                  jjtree.closeNodeScope(jjtn000, true, getToken(0));
                  jjtc000 = false;
                 jjtn000.setKind(PrimitiveTypeKind.BOOLEAN);
        break;
      case CHAR:
        jj_consume_token(CHAR);
                  jjtree.closeNodeScope(jjtn000, true, getToken(0));
                  jjtc000 = false;
                 jjtn000.setKind(PrimitiveTypeKind.CHAR);
        break;
      case BYTE:
        jj_consume_token(BYTE);
                  jjtree.closeNodeScope(jjtn000, true, getToken(0));
                  jjtc000 = false;
                 jjtn000.setKind(PrimitiveTypeKind.BYTE);
        break;
      case SHORT:
        jj_consume_token(SHORT);
                  jjtree.closeNodeScope(jjtn000, true, getToken(0));
                  jjtc000 = false;
                 jjtn000.setKind(PrimitiveTypeKind.SHORT);
        break;
      case INT:
        jj_consume_token(INT);
                  jjtree.closeNodeScope(jjtn000, true, getToken(0));
                  jjtc000 = false;
                 jjtn000.setKind(PrimitiveTypeKind.INT);
        break;
      case LONG:
        jj_consume_token(LONG);
                  jjtree.closeNodeScope(jjtn000, true, getToken(0));
                  jjtc000 = false;
                 jjtn000.setKind(PrimitiveTypeKind.LONG);
        break;
      case FLOAT:
        jj_consume_token(FLOAT);
                  jjtree.closeNodeScope(jjtn000, true, getToken(0));
                  jjtc000 = false;
                 jjtn000.setKind(PrimitiveTypeKind.FLOAT);
        break;
      case DOUBLE:
        jj_consume_token(DOUBLE);
                  jjtree.closeNodeScope(jjtn000, true, getToken(0));
                  jjtc000 = false;
                 jjtn000.setKind(PrimitiveTypeKind.DOUBLE);
        break;
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    } finally {
        if (jjtc000) {
          jjtree.closeNodeScope(jjtn000, true, getToken(0));
        }
    }
  }

  final public void ResultType() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case VOID:
     ASTVoidType jjtn001 = new ASTVoidType(JJTVOIDTYPE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(VOID);
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true, getToken(0));
     }
      }
      break;
    default:
      jj_la1[67] = jj_gen;
      if (jj_2_53(1)) {
        AnnotatedType();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void ThrowsList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ThrowsList */
  ASTThrowsList jjtn000 = new ASTThrowsList(JJTTHROWSLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(THROWS);
      AnnotatedClassOrInterfaceType();
      label_34:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[68] = jj_gen;
          break label_34;
        }
        jj_consume_token(COMMA);
        AnnotatedClassOrInterfaceType();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

/*
 * Expression syntax follows.
 */
  final public void Expression() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) #AssignmentExpression(> 1) */
 ASTAssignmentExpression jjtn000 = new ASTAssignmentExpression(JJTASSIGNMENTEXPRESSION);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));AssignmentOp op = null;
    try {
      ConditionalExpression();
      switch (jj_nt.kind) {
      case ASSIGN:
      case PLUSASSIGN:
      case MINUSASSIGN:
      case STARASSIGN:
      case SLASHASSIGN:
      case ANDASSIGN:
      case ORASSIGN:
      case XORASSIGN:
      case REMASSIGN:
      case LSHIFTASSIGN:
      case RSIGNEDSHIFTASSIGN:
      case RUNSIGNEDSHIFTASSIGN:
        op = AssignmentOperator();
                                          jjtn000.setOp(op);
        Expression();
        break;
      default:
        jj_la1[69] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1, getToken(0));
    }
    }
  }

  final public AssignmentOp AssignmentOperator() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case ASSIGN:
      jj_consume_token(ASSIGN);
               {if (true) return AssignmentOp.ASSIGN;}
      break;
    case STARASSIGN:
      jj_consume_token(STARASSIGN);
               {if (true) return AssignmentOp.MUL_ASSIGN;}
      break;
    case SLASHASSIGN:
      jj_consume_token(SLASHASSIGN);
               {if (true) return AssignmentOp.DIV_ASSIGN;}
      break;
    case REMASSIGN:
      jj_consume_token(REMASSIGN);
               {if (true) return AssignmentOp.MOD_ASSIGN;}
      break;
    case PLUSASSIGN:
      jj_consume_token(PLUSASSIGN);
               {if (true) return AssignmentOp.ADD_ASSIGN;}
      break;
    case MINUSASSIGN:
      jj_consume_token(MINUSASSIGN);
               {if (true) return AssignmentOp.SUB_ASSIGN;}
      break;
    case LSHIFTASSIGN:
      jj_consume_token(LSHIFTASSIGN);
               {if (true) return AssignmentOp.LEFT_SHIFT_ASSIGN;}
      break;
    case RSIGNEDSHIFTASSIGN:
      jj_consume_token(RSIGNEDSHIFTASSIGN);
               {if (true) return AssignmentOp.RIGHT_SHIFT_ASSIGN;}
      break;
    case RUNSIGNEDSHIFTASSIGN:
      jj_consume_token(RUNSIGNEDSHIFTASSIGN);
               {if (true) return AssignmentOp.UNSIGNED_RIGHT_SHIFT_ASSIGN;}
      break;
    case ANDASSIGN:
      jj_consume_token(ANDASSIGN);
               {if (true) return AssignmentOp.AND_ASSIGN;}
      break;
    case XORASSIGN:
      jj_consume_token(XORASSIGN);
               {if (true) return AssignmentOp.XOR_ASSIGN;}
      break;
    case ORASSIGN:
      jj_consume_token(ORASSIGN);
               {if (true) return AssignmentOp.OR_ASSIGN;}
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
    throw new Error("Missing return statement in function");
  }

  final public void ConditionalExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) #ConditionalExpression(> 1) */
  ASTConditionalExpression jjtn000 = new ASTConditionalExpression(JJTCONDITIONALEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      ConditionalOrExpression();
      switch (jj_nt.kind) {
      case HOOK:
        jj_consume_token(HOOK);
        Expression();
        jj_consume_token(COLON);
        ConditionalExpression();
        break;
      default:
        jj_la1[71] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, jjtree.nodeArity() > 1, getToken(0));
    }
    }
  }

  final public void ConditionalOrExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    ConditionalAndExpression();
    label_35:
    while (true) {
      switch (jj_nt.kind) {
      case SC_OR:
        ;
        break;
      default:
        jj_la1[72] = jj_gen;
        break label_35;
      }
                                             ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
                                             boolean jjtc001 = true;
                                             jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(SC_OR);
                                                  jjtn001.setOp(BinaryOp.CONDITIONAL_OR);
        ConditionalAndExpression();
      } catch (Throwable jjte001) {
                                             if (jjtc001) {
                                               jjtree.clearNodeScope(jjtn001);
                                               jjtc001 = false;
                                             } else {
                                               jjtree.popNode();
                                             }
                                             if (jjte001 instanceof RuntimeException) {
                                               {if (true) throw (RuntimeException)jjte001;}
                                             }
                                             if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                               {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                             }
                                             {if (true) throw (Error)jjte001;}
      } finally {
                                             if (jjtc001) {
                                               jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                             }
      }
    }
  }

  final public void ConditionalAndExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    InclusiveOrExpression();
    label_36:
    while (true) {
      switch (jj_nt.kind) {
      case SC_AND:
        ;
        break;
      default:
        jj_la1[73] = jj_gen;
        break label_36;
      }
                                          ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
                                          boolean jjtc001 = true;
                                          jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(SC_AND);
                                               jjtn001.setOp(BinaryOp.CONDITIONAL_AND);
        InclusiveOrExpression();
      } catch (Throwable jjte001) {
                                          if (jjtc001) {
                                            jjtree.clearNodeScope(jjtn001);
                                            jjtc001 = false;
                                          } else {
                                            jjtree.popNode();
                                          }
                                          if (jjte001 instanceof RuntimeException) {
                                            {if (true) throw (RuntimeException)jjte001;}
                                          }
                                          if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                            {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                          }
                                          {if (true) throw (Error)jjte001;}
      } finally {
                                          if (jjtc001) {
                                            jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                          }
      }
    }
  }

  final public void InclusiveOrExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    ExclusiveOrExpression();
    label_37:
    while (true) {
      switch (jj_nt.kind) {
      case BIT_OR:
        ;
        break;
      default:
        jj_la1[74] = jj_gen;
        break label_37;
      }
                                          ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
                                          boolean jjtc001 = true;
                                          jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(BIT_OR);
                                              jjtn001.setOp(BinaryOp.OR);
        ExclusiveOrExpression();
      } catch (Throwable jjte001) {
                                          if (jjtc001) {
                                            jjtree.clearNodeScope(jjtn001);
                                            jjtc001 = false;
                                          } else {
                                            jjtree.popNode();
                                          }
                                          if (jjte001 instanceof RuntimeException) {
                                            {if (true) throw (RuntimeException)jjte001;}
                                          }
                                          if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                            {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                          }
                                          {if (true) throw (Error)jjte001;}
      } finally {
                                          if (jjtc001) {
                                            jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                          }
      }
    }
  }

  final public void ExclusiveOrExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    AndExpression();
    label_38:
    while (true) {
      switch (jj_nt.kind) {
      case XOR:
        ;
        break;
      default:
        jj_la1[75] = jj_gen;
        break label_38;
      }
                                   ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
                                   boolean jjtc001 = true;
                                   jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(XOR);
                                       jjtn001.setOp(BinaryOp.XOR);
        AndExpression();
      } catch (Throwable jjte001) {
                                   if (jjtc001) {
                                     jjtree.clearNodeScope(jjtn001);
                                     jjtc001 = false;
                                   } else {
                                     jjtree.popNode();
                                   }
                                   if (jjte001 instanceof RuntimeException) {
                                     {if (true) throw (RuntimeException)jjte001;}
                                   }
                                   if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                     {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                   }
                                   {if (true) throw (Error)jjte001;}
      } finally {
                                   if (jjtc001) {
                                     jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                   }
      }
    }
  }

  final public void AndExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    EqualityExpression();
    label_39:
    while (true) {
      switch (jj_nt.kind) {
      case BIT_AND:
        ;
        break;
      default:
        jj_la1[76] = jj_gen;
        break label_39;
      }
                                       ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
                                       boolean jjtc001 = true;
                                       jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(BIT_AND);
                                           jjtn001.setOp(BinaryOp.AND);
        EqualityExpression();
      } catch (Throwable jjte001) {
                                       if (jjtc001) {
                                         jjtree.clearNodeScope(jjtn001);
                                         jjtc001 = false;
                                       } else {
                                         jjtree.popNode();
                                       }
                                       if (jjte001 instanceof RuntimeException) {
                                         {if (true) throw (RuntimeException)jjte001;}
                                       }
                                       if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                         {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                       }
                                       {if (true) throw (Error)jjte001;}
      } finally {
                                       if (jjtc001) {
                                         jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                       }
      }
    }
  }

  final public void EqualityExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    InstanceOfExpression();
    label_40:
    while (true) {
      switch (jj_nt.kind) {
      case EQ:
      case NE:
        ;
        break;
      default:
        jj_la1[77] = jj_gen;
        break label_40;
      }
      ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case EQ:
          jj_consume_token(EQ);
                jjtn001.setOp(BinaryOp.EQ);
          break;
        case NE:
          jj_consume_token(NE);
                jjtn001.setOp(BinaryOp.NE);
          break;
        default:
          jj_la1[78] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        InstanceOfExpression();
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2, getToken(0));
      }
      }
    }
  }

  final public void Pattern() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jj_2_54(2147483647)) {
      RecordPattern();
    } else if (jj_2_55(1)) {
      TypePattern();
    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void TypePattern() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) TypePattern */
  ASTTypePattern jjtn000 = new ASTTypePattern(JJTTYPEPATTERN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      LocalVarModifierList();
      LocalVariableType();
      VariableDeclaratorId();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void RecordPattern() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) RecordPattern */
  ASTRecordPattern jjtn000 = new ASTRecordPattern(JJTRECORDPATTERN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      label_41:
      while (true) {
        switch (jj_nt.kind) {
        case AT:
          ;
          break;
        default:
          jj_la1[79] = jj_gen;
          break label_41;
        }
        Annotation();
      }
      ReferenceType();
      RecordStructurePattern();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void RecordStructurePattern() throws net.sourceforge.pmd.lang.ast.ParseException {
    jj_consume_token(LPAREN);
    if (jj_2_56(1)) {
      ComponentPatternList();
    } else {
      ;
    }
    jj_consume_token(RPAREN);
  }

  final public void ComponentPatternList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) PatternList */
  ASTPatternList jjtn000 = new ASTPatternList(JJTPATTERNLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      ComponentPattern();
      label_42:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[80] = jj_gen;
          break label_42;
        }
        jj_consume_token(COMMA);
        ComponentPattern();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ComponentPattern() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (isKeyword("_")) {
      UnnamedPattern();
    } else if (jj_2_57(1)) {
      Pattern();
    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void UnnamedPattern() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) UnnamedPattern */
  ASTUnnamedPattern jjtn000 = new ASTUnnamedPattern(JJTUNNAMEDPATTERN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      softKeyword("_");
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void InstanceOfExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    RelationalExpression();
    switch (jj_nt.kind) {
    case INSTANCEOF:
      ASTInfixExpression jjtn003 = new ASTInfixExpression(JJTINFIXEXPRESSION);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003, getToken(1));
      try {
        jj_consume_token(INSTANCEOF);
        if (jj_2_58(2147483647)) {
          RecordPattern();
        } else if (jj_2_59(1)) {
          AnnotatedRefType();
          switch (jj_nt.kind) {
          case IDENTIFIER:
          case LPAREN:
            switch (jj_nt.kind) {
            case IDENTIFIER:
                    ASTTypePattern jjtn001 = new ASTTypePattern(JJTTYPEPATTERN);
                    boolean jjtc001 = true;
                    jjtree.openNodeScope(jjtn001, getToken(1));
              try {
                VariableDeclaratorId();
              } catch (Throwable jjte001) {
                    if (jjtc001) {
                      jjtree.clearNodeScope(jjtn001);
                      jjtc001 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte001 instanceof RuntimeException) {
                      {if (true) throw (RuntimeException)jjte001;}
                    }
                    if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                    }
                    {if (true) throw (Error)jjte001;}
              } finally {
                    if (jjtc001) {
                      jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                    }
              }
              break;
            case LPAREN:
                    ASTRecordPattern jjtn002 = new ASTRecordPattern(JJTRECORDPATTERN);
                    boolean jjtc002 = true;
                    jjtree.openNodeScope(jjtn002, getToken(1));
              try {
                RecordStructurePattern();
              } catch (Throwable jjte002) {
                    if (jjtc002) {
                      jjtree.clearNodeScope(jjtn002);
                      jjtc002 = false;
                    } else {
                      jjtree.popNode();
                    }
                    if (jjte002 instanceof RuntimeException) {
                      {if (true) throw (RuntimeException)jjte002;}
                    }
                    if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
                    }
                    {if (true) throw (Error)jjte002;}
              } finally {
                    if (jjtc002) {
                      jjtree.closeNodeScope(jjtn002,  2, getToken(0));
                    }
              }
              break;
            default:
              jj_la1[81] = jj_gen;
              jj_consume_token(-1);
              throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
            }
            break;
          default:
            jj_la1[82] = jj_gen;
            ;
          }
        } else if (jj_2_60(1)) {
          Pattern();
        } else {
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
            jjtn003.setOp(BinaryOp.INSTANCEOF);
            AbstractJavaNode top = jjtree.popNode();
            if (top instanceof ASTPattern) {
               if (top instanceof ASTTypePattern && !(top.getChild(0) instanceof ASTModifierList)) {
                   insertEmptyModifierListWithAnnotations(top, (AbstractJavaNode) top.getChild(0));
               }
               top = new ASTPatternExpression((ASTPattern) top);
            } else {
               top = new ASTTypeExpression((ASTType) top);
            }
            jjtree.pushNode(top);
          jjtree.closeNodeScope(jjtn003,  2, getToken(0));
          jjtc003 = false;

      } catch (Throwable jjte003) {
      if (jjtc003) {
        jjtree.clearNodeScope(jjtn003);
        jjtc003 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte003 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte003;}
      }
      if (jjte003 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte003;}
      }
      {if (true) throw (Error)jjte003;}
      } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003,  2, getToken(0));
      }
      }
      break;
    default:
      jj_la1[83] = jj_gen;
      ;
    }
  }

  final public void RelationalExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    ShiftExpression();
    label_43:
    while (true) {
      switch (jj_nt.kind) {
      case LT:
      case LE:
      case GE:
      case GT:
        ;
        break;
      default:
        jj_la1[84] = jj_gen;
        break label_43;
      }
      ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case LT:
          jj_consume_token(LT);
                jjtn001.setOp(BinaryOp.LT);
          break;
        case GT:
          jj_consume_token(GT);
                jjtn001.setOp(BinaryOp.GT);
          break;
        case LE:
          jj_consume_token(LE);
                jjtn001.setOp(BinaryOp.LE);
          break;
        case GE:
          jj_consume_token(GE);
                jjtn001.setOp(BinaryOp.GE);
          break;
        default:
          jj_la1[85] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        ShiftExpression();
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2, getToken(0));
      }
      }
    }
  }

  final public void ShiftExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    AdditiveExpression();
    label_44:
    while (true) {
      if (jj_2_61(1)) {
        ;
      } else {
        break label_44;
      }
      ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case LSHIFT:
          jj_consume_token(LSHIFT);
                                  jjtn001.setOp(BinaryOp.LEFT_SHIFT);
          break;
        default:
          jj_la1[86] = jj_gen;
          if (jj_2_62(1)) {
            RSIGNEDSHIFT();
                                  jjtn001.setOp(BinaryOp.RIGHT_SHIFT);
          } else if (jj_2_63(1)) {
            RUNSIGNEDSHIFT();
                                  jjtn001.setOp(BinaryOp.UNSIGNED_RIGHT_SHIFT);
          } else {
            jj_consume_token(-1);
            throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
          }
        }
        AdditiveExpression();
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2, getToken(0));
      }
      }
    }
  }

  final public void AdditiveExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    MultiplicativeExpression();
    label_45:
    while (true) {
      switch (jj_nt.kind) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[87] = jj_gen;
        break label_45;
      }
      ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case PLUS:
          jj_consume_token(PLUS);
             jjtn001.setOp(BinaryOp.ADD);
          break;
        case MINUS:
          jj_consume_token(MINUS);
             jjtn001.setOp(BinaryOp.SUB);
          break;
        default:
          jj_la1[88] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        MultiplicativeExpression();
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2, getToken(0));
      }
      }
    }
  }

  final public void MultiplicativeExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    UnaryExpression();
    label_46:
    while (true) {
      switch (jj_nt.kind) {
      case STAR:
      case SLASH:
      case REM:
        ;
        break;
      default:
        jj_la1[89] = jj_gen;
        break label_46;
      }
      ASTInfixExpression jjtn001 = new ASTInfixExpression(JJTINFIXEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case STAR:
          jj_consume_token(STAR);
             jjtn001.setOp(BinaryOp.MUL);
          break;
        case SLASH:
          jj_consume_token(SLASH);
             jjtn001.setOp(BinaryOp.DIV);
          break;
        case REM:
          jj_consume_token(REM);
             jjtn001.setOp(BinaryOp.MOD);
          break;
        default:
          jj_la1[90] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        UnaryExpression();
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  2, getToken(0));
      }
      }
    }
  }

// TODO update operator setting for those expressions
  final public void UnaryExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case PLUS:
    case MINUS:
      ASTUnaryExpression jjtn001 = new ASTUnaryExpression(JJTUNARYEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case PLUS:
          jj_consume_token(PLUS);
           jjtn001.setOp(UnaryOp.UNARY_PLUS);
          break;
        case MINUS:
          jj_consume_token(MINUS);
                                                      jjtn001.setOp(UnaryOp.UNARY_MINUS);
          break;
        default:
          jj_la1[91] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        UnaryExpression();
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true, getToken(0));
      }
      }
      break;
    case INCR:
    case DECR:
      PrefixIncrementExpression();
      break;
    default:
      jj_la1[92] = jj_gen;
      if (jj_2_64(1)) {
        UnaryExpressionNotPlusMinus();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void PrefixIncrementExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) UnaryExpression */
  ASTUnaryExpression jjtn000 = new ASTUnaryExpression(JJTUNARYEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case INCR:
        jj_consume_token(INCR);
         jjtn000.setOp(UnaryOp.PRE_INCREMENT);
        break;
      case DECR:
        jj_consume_token(DECR);
          jjtn000.setOp(UnaryOp.PRE_DECREMENT);
        break;
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      PrimaryExpression();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void UnaryExpressionNotPlusMinus() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case BANG:
    case TILDE:
   ASTUnaryExpression jjtn001 = new ASTUnaryExpression(JJTUNARYEXPRESSION);
   boolean jjtc001 = true;
   jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case TILDE:
          jj_consume_token(TILDE);
         jjtn001.setOp(UnaryOp.COMPLEMENT);
          break;
        case BANG:
          jj_consume_token(BANG);
                                                    jjtn001.setOp(UnaryOp.NEGATION);
          break;
        default:
          jj_la1[94] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        UnaryExpression();
      } catch (Throwable jjte001) {
   if (jjtc001) {
     jjtree.clearNodeScope(jjtn001);
     jjtc001 = false;
   } else {
     jjtree.popNode();
   }
   if (jjte001 instanceof RuntimeException) {
     {if (true) throw (RuntimeException)jjte001;}
   }
   if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
     {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
   }
   {if (true) throw (Error)jjte001;}
      } finally {
   if (jjtc001) {
     jjtree.closeNodeScope(jjtn001, true, getToken(0));
   }
      }
      break;
    default:
      jj_la1[95] = jj_gen;
      if (jj_2_65(2147483647)) {
      ASTCastExpression jjtn002 = new ASTCastExpression(JJTCASTEXPRESSION);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002, getToken(1));
        try {
          jj_consume_token(LPAREN);
          AnnotatedType();
          jj_consume_token(RPAREN);
          UnaryExpression();
        } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
        } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002, true, getToken(0));
      }
        }
      } else if (jj_2_66(2147483647)) {
      ASTCastExpression jjtn003 = new ASTCastExpression(JJTCASTEXPRESSION);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003, getToken(1));
        try {
          jj_consume_token(LPAREN);
          IntersectionType();
          jj_consume_token(RPAREN);
          UnaryExpressionNotPlusMinus();
        } catch (Throwable jjte003) {
      if (jjtc003) {
        jjtree.clearNodeScope(jjtn003);
        jjtc003 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte003 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte003;}
      }
      if (jjte003 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte003;}
      }
      {if (true) throw (Error)jjte003;}
        } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, true, getToken(0));
      }
        }
      } else if (jj_2_67(1)) {
        PostfixExpression();
      } else {
        switch (jj_nt.kind) {
        case SWITCH:
          SwitchExpression();
          break;
        default:
          jj_la1[96] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
    }
  }

  final private void UnaryExprNotPmStart() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case TILDE:
      jj_consume_token(TILDE);
      break;
    case BANG:
      jj_consume_token(BANG);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      break;
    case SWITCH:
      jj_consume_token(SWITCH);
      break;
    case NEW:
      jj_consume_token(NEW);
      break;
    case THIS:
      jj_consume_token(THIS);
      break;
    case SUPER:
      jj_consume_token(SUPER);
      break;
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case TEXT_BLOCK_LITERAL:
      Literal();
      break;
    case AT:
      jj_consume_token(AT);
      break;
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    case VOID:
      jj_consume_token(VOID);
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
      PrimitiveType();
      break;
    default:
      jj_la1[97] = jj_gen;
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void PostfixExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    PrimaryExpression();
    switch (jj_nt.kind) {
    case INCR:
    case DECR:
      ASTUnaryExpression jjtn001 = new ASTUnaryExpression(JJTUNARYEXPRESSION);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case INCR:
          jj_consume_token(INCR);
            jjtree.closeNodeScope(jjtn001,  1, getToken(0));
            jjtc001 = false;
           jjtn001.setOp(UnaryOp.POST_INCREMENT);
          break;
        case DECR:
          jj_consume_token(DECR);
             jjtree.closeNodeScope(jjtn001,  1, getToken(0));
             jjtc001 = false;
            jjtn001.setOp(UnaryOp.POST_DECREMENT);
          break;
        default:
          jj_la1[98] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001,  1, getToken(0));
      }
      }
      break;
    default:
      jj_la1[99] = jj_gen;
      ;
    }
  }

  final public void SwitchExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) SwitchExpression */
 ASTSwitchExpression jjtn000 = new ASTSwitchExpression(JJTSWITCHEXPRESSION);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));boolean prevInSwitchBlock = inSwitchExprBlock;
    try {
      jj_consume_token(SWITCH);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
     inSwitchExprBlock = true;
      SwitchBlock();
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
      jjtc000 = false;
     inSwitchExprBlock = prevInSwitchBlock;
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

/**
 * A primary expression. This includes call chains, etc.
 *
 * A PrimaryPrefix corresponds to an unqualified primary expression,
 * e.g "new Foo()". Then, if any, suffixes of the form e.g. ".method()",
 * ".field" or "::ref" are added, each time enclosing the previous node.
 * Iteration stops after the first method reference, or we can't continue.
 *
 * The resulting subtree looks left-recursive, but the parsing is iterative.
 */
  final public void PrimaryExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    PrimaryPrefix();
    label_47:
    while (true) {
      if (jj_2_68(2147483647) && (!(jjtree.peekNode() instanceof ASTMethodReference))) {
        ;
      } else {
        break label_47;
      }
      PrimarySuffix();
    }
                                                                                                                        forceExprContext();
  }

/*
  Expressions that may be present at the start of a primary expression.
 */
  final public void PrimaryPrefix() throws net.sourceforge.pmd.lang.ast.ParseException {
 JavaccToken savedStart;
    switch (jj_nt.kind) {
    case FALSE:
    case NULL:
    case TRUE:
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case TEXT_BLOCK_LITERAL:
      Literal();
      break;
    case THIS:
    ASTThisExpression jjtn001 = new ASTThisExpression(JJTTHISEXPRESSION);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(THIS);
      } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, true, getToken(0));
    }
      }
      break;
    case SUPER:
    ASTSuperExpression jjtn002 = new ASTSuperExpression(JJTSUPEREXPRESSION);
    boolean jjtc002 = true;
    jjtree.openNodeScope(jjtn002, getToken(1));
      try {
        jj_consume_token(SUPER);
      } finally {
    if (jjtc002) {
      jjtree.closeNodeScope(jjtn002,  true, getToken(0));
    }
      }
      switch (jj_nt.kind) {
      case DOT:
        jj_consume_token(DOT);
        MemberSelector();
        break;
      case METHOD_REF:
        MethodReference();
        break;
      default:
        jj_la1[100] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      break;
    case NEW:
      UnqualifiedAllocationExpr();
      break;
    case VOID:
    ASTClassLiteral jjtn004 = new ASTClassLiteral(JJTCLASSLITERAL);
    boolean jjtc004 = true;
    jjtree.openNodeScope(jjtn004, getToken(1));
      try {
     ASTVoidType jjtn003 = new ASTVoidType(JJTVOIDTYPE);
     boolean jjtc003 = true;
     jjtree.openNodeScope(jjtn003, getToken(1));
        try {
          jj_consume_token(VOID);
        } finally {
     if (jjtc003) {
       jjtree.closeNodeScope(jjtn003, true, getToken(0));
     }
        }
        jj_consume_token(DOT);
        jj_consume_token(CLASS);
      } finally {
    if (jjtc004) {
      jjtree.closeNodeScope(jjtn004, true, getToken(0));
    }
      }
      break;
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    ASTArrayType jjtn005 = new ASTArrayType(JJTARRAYTYPE);
    boolean jjtc005 = true;
    jjtree.openNodeScope(jjtn005, getToken(1));
      try {
        PrimitiveType();
        switch (jj_nt.kind) {
        case LBRACKET:
        case AT:
          Dims();
          break;
        default:
          jj_la1[101] = jj_gen;
          ;
        }
      } catch (Throwable jjte005) {
    if (jjtc005) {
      jjtree.clearNodeScope(jjtn005);
      jjtc005 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte005 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte005;}
    }
    if (jjte005 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte005;}
    }
    {if (true) throw (Error)jjte005;}
      } finally {
    if (jjtc005) {
      jjtree.closeNodeScope(jjtn005, jjtree.nodeArity() > 1, getToken(0));
    }
      }
      switch (jj_nt.kind) {
      case METHOD_REF:
        MethodReference();
        break;
      case DOT:
        jj_consume_token(DOT);
             ASTClassLiteral jjtn006 = new ASTClassLiteral(JJTCLASSLITERAL);
             boolean jjtc006 = true;
             jjtree.openNodeScope(jjtn006, getToken(1));
        try {
          jj_consume_token(CLASS);
        } finally {
             if (jjtc006) {
               jjtree.closeNodeScope(jjtn006,  1, getToken(0));
             }
        }
        break;
      default:
        jj_la1[102] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      break;
    default:
      jj_la1[103] = jj_gen;
      if (jj_2_70(2147483647)) {
        AnnotatedRefType();
        MethodReference();
      } else if (jj_2_71(2147483647)) {
        LambdaExpression();
      } else {
        switch (jj_nt.kind) {
        case LPAREN:
          jj_consume_token(LPAREN);
       savedStart = getToken(0);
          Expression();
          jj_consume_token(RPAREN);
    AstImplUtil.bumpParenDepth((ASTExpression) jjtree.peekNode());
    AbstractJavaNode top = (AbstractJavaNode) jjtree.peekNode();
    top.setFirstToken(savedStart);
    top.setLastToken(getToken(0));
          break;
        case IDENTIFIER:
          AmbiguousName();
          if (jj_2_69(2147483647)) {
            PrimaryStep2();
          } else {
            ;
          }
          break;
        default:
          jj_la1[104] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
    }
  }

  final private void Step2Lahead() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case METHOD_REF:
      jj_consume_token(METHOD_REF);
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      break;
    case AT:
      jj_consume_token(AT);
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      break;
    case LT:
      TypeArguments();
      switch (jj_nt.kind) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        break;
      case DOT:
        jj_consume_token(DOT);
        break;
      case AT:
        jj_consume_token(AT);
        break;
      case METHOD_REF:
        jj_consume_token(METHOD_REF);
        break;
      default:
        jj_la1[105] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      break;
    default:
      jj_la1[107] = jj_gen;
      if (!inExplicitConstructorInvoc) {
        jj_consume_token(DOT);
      } else if (inExplicitConstructorInvoc) {
        jj_consume_token(DOT);
        switch (jj_nt.kind) {
        case CLASS:
          jj_consume_token(CLASS);
          break;
        case IDENTIFIER:
          jj_consume_token(IDENTIFIER);
          break;
        case LT:
          TypeArguments();
          jj_consume_token(IDENTIFIER);
          break;
        case NEW:
          jj_consume_token(NEW);
          break;
        case THIS:
          jj_consume_token(THIS);
          break;
        default:
          jj_la1[106] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final private void SuffixLAhead() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case METHOD_REF:
      jj_consume_token(METHOD_REF);
      break;
    case LBRACKET:
      jj_consume_token(LBRACKET);
      break;
    default:
      jj_la1[109] = jj_gen;
      if (!inExplicitConstructorInvoc) {
        jj_consume_token(DOT);
      } else if (inExplicitConstructorInvoc) {
        jj_consume_token(DOT);
        switch (jj_nt.kind) {
        case IDENTIFIER:
          jj_consume_token(IDENTIFIER);
          break;
        case LT:
          TypeArguments();
          jj_consume_token(IDENTIFIER);
          break;
        case NEW:
          jj_consume_token(NEW);
          break;
        default:
          jj_la1[108] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

// Step right after the *first* ambiguous name if any.
// Then we have more options than a primary suffix,
// we can still expect to have some class type and a
// class literal, or some type arguments and a method reference
  final public void PrimaryStep2() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case LT:
       forceTypeContext();
      TypeArguments();
                                             injectTop();
      label_48:
      while (true) {
        switch (jj_nt.kind) {
        case DOT:
          ;
          break;
        default:
          jj_la1[110] = jj_gen;
          break label_48;
        }
        jj_consume_token(DOT);
        ClassTypeSegment();
      }
      switch (jj_nt.kind) {
      case LBRACKET:
      case AT:
                                                                                           ASTArrayType jjtn001 = new ASTArrayType(JJTARRAYTYPE);
                                                                                           boolean jjtc001 = true;
                                                                                           jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          Dims();
        } catch (Throwable jjte001) {
                                                                                           if (jjtc001) {
                                                                                             jjtree.clearNodeScope(jjtn001);
                                                                                             jjtc001 = false;
                                                                                           } else {
                                                                                             jjtree.popNode();
                                                                                           }
                                                                                           if (jjte001 instanceof RuntimeException) {
                                                                                             {if (true) throw (RuntimeException)jjte001;}
                                                                                           }
                                                                                           if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                                                                             {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                                                                           }
                                                                                           {if (true) throw (Error)jjte001;}
        } finally {
                                                                                           if (jjtc001) {
                                                                                             jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                                                                           }
        }
        break;
      default:
        jj_la1[111] = jj_gen;
        ;
      }
      MethodReference();
      break;
    case METHOD_REF:
      MethodReference();
      break;
    case LPAREN:
        ASTMethodCall jjtn002 = new ASTMethodCall(JJTMETHODCALL);
        boolean jjtc002 = true;
        jjtree.openNodeScope(jjtn002, getToken(1));
      try {
        ArgumentList();
      } catch (Throwable jjte002) {
        if (jjtc002) {
          jjtree.clearNodeScope(jjtn002);
          jjtc002 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte002 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte002;}
        }
        if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
          {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
        }
        {if (true) throw (Error)jjte002;}
      } finally {
        if (jjtc002) {
          jjtree.closeNodeScope(jjtn002,  2, getToken(0));
        }
      }
      break;
    case DOT:
      jj_consume_token(DOT);
      switch (jj_nt.kind) {
      case CLASS:
           forceTypeContext();
                                  ASTClassLiteral jjtn003 = new ASTClassLiteral(JJTCLASSLITERAL);
                                  boolean jjtc003 = true;
                                  jjtree.openNodeScope(jjtn003, getToken(1));
        try {
          jj_consume_token(CLASS);
        } finally {
                                  if (jjtc003) {
                                    jjtree.closeNodeScope(jjtn003,  1, getToken(0));
                                  }
        }
        break;
      case THIS:
           forceTypeContext();
                                  ASTThisExpression jjtn004 = new ASTThisExpression(JJTTHISEXPRESSION);
                                  boolean jjtc004 = true;
                                  jjtree.openNodeScope(jjtn004, getToken(1));
        try {
          jj_consume_token(THIS);
        } finally {
                                  if (jjtc004) {
                                    jjtree.closeNodeScope(jjtn004,  1, getToken(0));
                                  }
        }
        break;
      case SUPER:
           forceTypeContext();
                                  ASTSuperExpression jjtn005 = new ASTSuperExpression(JJTSUPEREXPRESSION);
                                  boolean jjtc005 = true;
                                  jjtree.openNodeScope(jjtn005, getToken(1));
        try {
          jj_consume_token(SUPER);
        } finally {
                                  if (jjtc005) {
                                    jjtree.closeNodeScope(jjtn005,  1, getToken(0));
                                  }
        }
        switch (jj_nt.kind) {
        case DOT:
          jj_consume_token(DOT);
          MemberSelector();
          break;
        case METHOD_REF:
          MethodReference();
          break;
        default:
          jj_la1[112] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        break;
      case NEW:
      case IDENTIFIER:
      case LT:
        MemberSelector();
        break;
      case STRING_LITERAL:
      case STRING_TEMPLATE_BEGIN:
      case TEXT_BLOCK_LITERAL:
      case TEXT_BLOCK_TEMPLATE_MID:
           forceExprContext();
                                  ASTTemplateExpression jjtn006 = new ASTTemplateExpression(JJTTEMPLATEEXPRESSION);
                                  boolean jjtc006 = true;
                                  jjtree.openNodeScope(jjtn006, getToken(1));
        try {
          Template();
        } catch (Throwable jjte006) {
                                  if (jjtc006) {
                                    jjtree.clearNodeScope(jjtn006);
                                    jjtc006 = false;
                                  } else {
                                    jjtree.popNode();
                                  }
                                  if (jjte006 instanceof RuntimeException) {
                                    {if (true) throw (RuntimeException)jjte006;}
                                  }
                                  if (jjte006 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                    {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte006;}
                                  }
                                  {if (true) throw (Error)jjte006;}
        } finally {
                                  if (jjtc006) {
                                    jjtree.closeNodeScope(jjtn006,  2, getToken(0));
                                  }
        }
        break;
      default:
        jj_la1[113] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      break;
    default:
      jj_la1[115] = jj_gen;
      if (jj_2_72(2147483647)) {
                                forceTypeContext();
                                                       ASTArrayType jjtn007 = new ASTArrayType(JJTARRAYTYPE);
                                                       boolean jjtc007 = true;
                                                       jjtree.openNodeScope(jjtn007, getToken(1));
        try {
          Dims();
        } catch (Throwable jjte007) {
                                                       if (jjtc007) {
                                                         jjtree.clearNodeScope(jjtn007);
                                                         jjtc007 = false;
                                                       } else {
                                                         jjtree.popNode();
                                                       }
                                                       if (jjte007 instanceof RuntimeException) {
                                                         {if (true) throw (RuntimeException)jjte007;}
                                                       }
                                                       if (jjte007 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                                         {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte007;}
                                                       }
                                                       {if (true) throw (Error)jjte007;}
        } finally {
                                                       if (jjtc007) {
                                                         jjtree.closeNodeScope(jjtn007,  2, getToken(0));
                                                       }
        }
        switch (jj_nt.kind) {
        case METHOD_REF:
          MethodReference();
          break;
        case DOT:
          jj_consume_token(DOT);
                                                                                                      ASTClassLiteral jjtn008 = new ASTClassLiteral(JJTCLASSLITERAL);
                                                                                                      boolean jjtc008 = true;
                                                                                                      jjtree.openNodeScope(jjtn008, getToken(1));
          try {
            jj_consume_token(CLASS);
          } finally {
                                                                                                      if (jjtc008) {
                                                                                                        jjtree.closeNodeScope(jjtn008,  1, getToken(0));
                                                                                                      }
          }
          break;
        default:
          jj_la1[114] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      } else {
        switch (jj_nt.kind) {
        case LBRACKET:
       forceExprContext();
          jj_consume_token(LBRACKET);
          Expression();
                                               ASTArrayAccess jjtn009 = new ASTArrayAccess(JJTARRAYACCESS);
                                               boolean jjtc009 = true;
                                               jjtree.openNodeScope(jjtn009, getToken(1));
          try {
            jj_consume_token(RBRACKET);
          } finally {
                                               if (jjtc009) {
                                                 jjtree.closeNodeScope(jjtn009,  2, getToken(0));
                                               }
          }
          break;
        default:
          jj_la1[116] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
    }
  }

/**
 * Productions that may be present after a PrimaryPrefix. Basically
 * allows for call chains. We loop on this production in PrimaryExpression.
 */
  final public void PrimarySuffix() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case METHOD_REF:
      MethodReference();
      break;
    case LBRACKET:
   forceExprContext();
      jj_consume_token(LBRACKET);
      Expression();
                                           ASTArrayAccess jjtn001 = new ASTArrayAccess(JJTARRAYACCESS);
                                           boolean jjtc001 = true;
                                           jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(RBRACKET);
      } finally {
                                           if (jjtc001) {
                                             jjtree.closeNodeScope(jjtn001,  2, getToken(0));
                                           }
      }
      break;
    case DOT:
      jj_consume_token(DOT);
      MemberSelector();
      break;
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

/**
 * Part of a primary suffix that immediately follows a dot. Also
 * part of step 2.
 */
  final public void MemberSelector() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case NEW:
   forceExprContext();
      QualifiedAllocationExpr();
      break;
    case LT:
                 ASTMethodCall jjtn001 = new ASTMethodCall(JJTMETHODCALL);
                 boolean jjtc001 = true;
                 jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        TypeArguments();
        jj_consume_token(IDENTIFIER);
                                              setLastTokenImage(jjtn001);
        ArgumentList();
      } catch (Throwable jjte001) {
                 if (jjtc001) {
                   jjtree.clearNodeScope(jjtn001);
                   jjtc001 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte001 instanceof RuntimeException) {
                   {if (true) throw (RuntimeException)jjte001;}
                 }
                 if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                   {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                 }
                 {if (true) throw (Error)jjte001;}
      } finally {
                 if (jjtc001) {
                   jjtree.closeNodeScope(jjtn001,  3, getToken(0));
                 }
      }
      break;
    default:
      jj_la1[118] = jj_gen;
      if (jj_2_73(2)) {
                 ASTMethodCall jjtn002 = new ASTMethodCall(JJTMETHODCALL);
                 boolean jjtc002 = true;
                 jjtree.openNodeScope(jjtn002, getToken(1));
        try {
          jj_consume_token(IDENTIFIER);
                              setLastTokenImage(jjtn002);
          ArgumentList();
        } catch (Throwable jjte002) {
                 if (jjtc002) {
                   jjtree.clearNodeScope(jjtn002);
                   jjtc002 = false;
                 } else {
                   jjtree.popNode();
                 }
                 if (jjte002 instanceof RuntimeException) {
                   {if (true) throw (RuntimeException)jjte002;}
                 }
                 if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                   {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
                 }
                 {if (true) throw (Error)jjte002;}
        } finally {
                 if (jjtc002) {
                   jjtree.closeNodeScope(jjtn002,  2, getToken(0));
                 }
        }
      } else {
        switch (jj_nt.kind) {
        case IDENTIFIER:
                 ASTFieldAccess jjtn003 = new ASTFieldAccess(JJTFIELDACCESS);
                 boolean jjtc003 = true;
                 jjtree.openNodeScope(jjtn003, getToken(1));
          try {
            jj_consume_token(IDENTIFIER);
                               jjtree.closeNodeScope(jjtn003,  1, getToken(0));
                               jjtc003 = false;
                              setLastTokenImage(jjtn003);
          } finally {
                 if (jjtc003) {
                   jjtree.closeNodeScope(jjtn003,  1, getToken(0));
                 }
          }
          break;
        default:
          jj_la1[119] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
    }
  }

  final public void MethodReference() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) #MethodReference( jjtree . nodeArity ( ) + 1) */
  ASTMethodReference jjtn000 = new ASTMethodReference(JJTMETHODREFERENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(METHOD_REF);
      switch (jj_nt.kind) {
      case LT:
        TypeArguments();
        break;
      default:
        jj_la1[120] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case NEW:
        jj_consume_token(NEW);
        break;
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        break;
      default:
        jj_la1[121] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
                             jjtn000.setMethodName(getToken(0).getImage());
    jjtree.closeNodeScope(jjtn000,  jjtree . nodeArity ( ) + 1, getToken(0));
    jjtc000 = false;

    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000,  jjtree . nodeArity ( ) + 1, getToken(0));
    }
    }
  }

  final private void LambdaLahead() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (!inSwitchLabel) {

    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
    LambdaParameterList();
    jj_consume_token(LAMBDA);
  }

// Lambda expressions are not a PrimaryExpression in the JLS, instead they're
// separated from the AssignmentExpression production. Their use is restricted
// to method and constructor call argument, cast operand, the RHS of assignments,
// and the tail of a ternary expression
// https://docs.oracle.com/javase/specs/jls/se9/html/jls-15.html#jls-15.27
//
// To prevent LambdaExpressions in switch labels, the field #inSwitchLabel is used
// as a workaround.
  final public void LambdaExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) LambdaExpression */
  ASTLambdaExpression jjtn000 = new ASTLambdaExpression(JJTLAMBDAEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      LambdaParameterList();
      jj_consume_token(LAMBDA);
      if (jj_2_74(1)) {
        Expression();
      } else {
        switch (jj_nt.kind) {
        case LBRACE:
          Block();
          break;
        default:
          jj_la1[122] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void LambdaParameterList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) LambdaParameterList */
  ASTLambdaParameterList jjtn000 = new ASTLambdaParameterList(JJTLAMBDAPARAMETERLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case IDENTIFIER:
        SimpleLambdaParam();
        break;
      default:
        jj_la1[126] = jj_gen;
        if (jj_2_76(2147483647)) {
          jj_consume_token(LPAREN);
          switch (jj_nt.kind) {
          case IDENTIFIER:
            SimpleLambdaParam();
            label_49:
            while (true) {
              switch (jj_nt.kind) {
              case COMMA:
                ;
                break;
              default:
                jj_la1[123] = jj_gen;
                break label_49;
              }
              jj_consume_token(COMMA);
              SimpleLambdaParam();
            }
            break;
          default:
            jj_la1[124] = jj_gen;
            ;
          }
          jj_consume_token(RPAREN);
        } else {
          switch (jj_nt.kind) {
          case LPAREN:
            jj_consume_token(LPAREN);
            if (jj_2_75(1)) {
              LambdaParameter();
              label_50:
              while (true) {
                switch (jj_nt.kind) {
                case COMMA:
                  ;
                  break;
                default:
                  jj_la1[125] = jj_gen;
                  break label_50;
                }
                jj_consume_token(COMMA);
                LambdaParameter();
              }
            } else {
              ;
            }
            jj_consume_token(RPAREN);
            break;
          default:
            jj_la1[127] = jj_gen;
            jj_consume_token(-1);
            throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
          }
        }
      }
    } catch (Throwable jjte000) {
        if (jjtc000) {
          jjtree.clearNodeScope(jjtn000);
          jjtc000 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte000 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte000;}
        }
        if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
          {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
        }
        {if (true) throw (Error)jjte000;}
    } finally {
        if (jjtc000) {
          jjtree.closeNodeScope(jjtn000, true, getToken(0));
        }
    }
  }

  final public void SimpleLambdaParam() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) LambdaParameter */
 ASTLambdaParameter jjtn000 = new ASTLambdaParameter(JJTLAMBDAPARAMETER);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));pushEmptyModifierList();
    try {
      VariableDeclaratorId();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void LambdaParameter() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) LambdaParameter */
  ASTLambdaParameter jjtn000 = new ASTLambdaParameter(JJTLAMBDAPARAMETER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      LocalVarModifierList();
      if (jj_2_77(1)) {
        LambdaParameterType();
      } else {
        ;
      }
      VariableIdWithDims();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

/** Returns true if this is "var". */
  final public boolean LambdaParameterType() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jdkVersion >= 11 && isKeyword("var")) {
      jj_consume_token(IDENTIFIER);
                          {if (true) return true;}
    } else if (jj_2_78(1)) {
      FormalParamType();
                          {if (true) return false;}
    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
    throw new Error("Missing return statement in function");
  }

  final public void Template() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) Template */
  ASTTemplate jjtn000 = new ASTTemplate(JJTTEMPLATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case STRING_TEMPLATE_BEGIN:
        StringTemplate();
        break;
      case TEXT_BLOCK_TEMPLATE_MID:
        TextBlockTemplate();
        break;
      case STRING_LITERAL:
        ASTTemplateFragment jjtn001 = new ASTTemplateFragment(JJTTEMPLATEFRAGMENT);
        boolean jjtc001 = true;
        jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          jj_consume_token(STRING_LITERAL);
        } finally {
        if (jjtc001) {
          jjtree.closeNodeScope(jjtn001, true, getToken(0));
        }
        }
        break;
      case TEXT_BLOCK_LITERAL:
        ASTTemplateFragment jjtn002 = new ASTTemplateFragment(JJTTEMPLATEFRAGMENT);
        boolean jjtc002 = true;
        jjtree.openNodeScope(jjtn002, getToken(1));
        try {
          jj_consume_token(TEXT_BLOCK_LITERAL);
        } finally {
        if (jjtc002) {
          jjtree.closeNodeScope(jjtn002, true, getToken(0));
        }
        }
        break;
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    } catch (Throwable jjte000) {
        if (jjtc000) {
          jjtree.clearNodeScope(jjtn000);
          jjtc000 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte000 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte000;}
        }
        if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
          {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
        }
        {if (true) throw (Error)jjte000;}
    } finally {
        if (jjtc000) {
          jjtree.closeNodeScope(jjtn000, true, getToken(0));
        }
    }
  }

  final public void StringTemplate() throws net.sourceforge.pmd.lang.ast.ParseException {
          ASTTemplateFragment jjtn001 = new ASTTemplateFragment(JJTTEMPLATEFRAGMENT);
          boolean jjtc001 = true;
          jjtree.openNodeScope(jjtn001, getToken(1));
    try {
      jj_consume_token(STRING_TEMPLATE_BEGIN);
    } finally {
          if (jjtc001) {
            jjtree.closeNodeScope(jjtn001, true, getToken(0));
          }
    }
    EmbeddedExpression();
    label_51:
    while (true) {
      if (jj_2_79(2)) {
        ;
      } else {
        break label_51;
      }
                        ASTTemplateFragment jjtn002 = new ASTTemplateFragment(JJTTEMPLATEFRAGMENT);
                        boolean jjtc002 = true;
                        jjtree.openNodeScope(jjtn002, getToken(1));
      try {
        jj_consume_token(RBRACE);
        jj_consume_token(STRING_TEMPLATE_MID);
      } finally {
                        if (jjtc002) {
                          jjtree.closeNodeScope(jjtn002, true, getToken(0));
                        }
      }
      EmbeddedExpression();
    }
          ASTTemplateFragment jjtn003 = new ASTTemplateFragment(JJTTEMPLATEFRAGMENT);
          boolean jjtc003 = true;
          jjtree.openNodeScope(jjtn003, getToken(1));
    try {
      jj_consume_token(RBRACE);
      jj_consume_token(STRING_TEMPLATE_END);
    } finally {
          if (jjtc003) {
            jjtree.closeNodeScope(jjtn003, true, getToken(0));
          }
    }
  }

  final public void TextBlockTemplate() throws net.sourceforge.pmd.lang.ast.ParseException {
          ASTTemplateFragment jjtn001 = new ASTTemplateFragment(JJTTEMPLATEFRAGMENT);
          boolean jjtc001 = true;
          jjtree.openNodeScope(jjtn001, getToken(1));
    try {
      jj_consume_token(TEXT_BLOCK_TEMPLATE_MID);
    } finally {
          if (jjtc001) {
            jjtree.closeNodeScope(jjtn001, true, getToken(0));
          }
    }
    EmbeddedExpression();
    label_52:
    while (true) {
      if (jj_2_80(2)) {
        ;
      } else {
        break label_52;
      }
                        ASTTemplateFragment jjtn002 = new ASTTemplateFragment(JJTTEMPLATEFRAGMENT);
                        boolean jjtc002 = true;
                        jjtree.openNodeScope(jjtn002, getToken(1));
      try {
        jj_consume_token(RBRACE);
        jj_consume_token(TEXT_BLOCK_TEMPLATE_MID);
      } finally {
                        if (jjtc002) {
                          jjtree.closeNodeScope(jjtn002, true, getToken(0));
                        }
      }
      EmbeddedExpression();
    }
          ASTTemplateFragment jjtn003 = new ASTTemplateFragment(JJTTEMPLATEFRAGMENT);
          boolean jjtc003 = true;
          jjtree.openNodeScope(jjtn003, getToken(1));
    try {
      jj_consume_token(RBRACE);
      jj_consume_token(TEXT_BLOCK_LITERAL);
    } finally {
          if (jjtc003) {
            jjtree.closeNodeScope(jjtn003, true, getToken(0));
          }
    }
  }

  final public void EmbeddedExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jj_2_81(1)) {
      Expression();
    } else {
      ;
    }
  }

  final public void Literal() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
      NumericLiteral();
      break;
    case STRING_LITERAL:
    case TEXT_BLOCK_LITERAL:
      StringLiteral();
      break;
    case CHARACTER_LITERAL:
      CharLiteral();
      break;
    case FALSE:
    case TRUE:
    ASTBooleanLiteral jjtn001 = new ASTBooleanLiteral(JJTBOOLEANLITERAL);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        switch (jj_nt.kind) {
        case TRUE:
          jj_consume_token(TRUE);
            jjtree.closeNodeScope(jjtn001, true, getToken(0));
            jjtc001 = false;
            jjtn001.setTrue();
          break;
        case FALSE:
          jj_consume_token(FALSE);
          break;
        default:
          jj_la1[129] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, true, getToken(0));
    }
      }
      break;
    case NULL:
    ASTNullLiteral jjtn002 = new ASTNullLiteral(JJTNULLLITERAL);
    boolean jjtc002 = true;
    jjtree.openNodeScope(jjtn002, getToken(1));
      try {
        jj_consume_token(NULL);
      } finally {
    if (jjtc002) {
      jjtree.closeNodeScope(jjtn002, true, getToken(0));
    }
      }
      break;
    default:
      jj_la1[130] = jj_gen;
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void NumericLiteral() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) NumericLiteral */
  ASTNumericLiteral jjtn000 = new ASTNumericLiteral(JJTNUMERICLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case INTEGER_LITERAL:
        jj_consume_token(INTEGER_LITERAL);
                                    jjtn000.setIntLiteral();
        break;
      case FLOATING_POINT_LITERAL:
        jj_consume_token(FLOATING_POINT_LITERAL);
                                    jjtn000.setFloatLiteral();
        break;
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    jjtree.closeNodeScope(jjtn000, true, getToken(0));
    jjtc000 = false;
    setLastTokenImage(jjtn000);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void CharLiteral() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) CharLiteral */
  ASTCharLiteral jjtn000 = new ASTCharLiteral(JJTCHARLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(CHARACTER_LITERAL);
                        jjtree.closeNodeScope(jjtn000, true, getToken(0));
                        jjtc000 = false;
                        setLastTokenImage(jjtn000);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void StringLiteral() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) StringLiteral */
  ASTStringLiteral jjtn000 = new ASTStringLiteral(JJTSTRINGLITERAL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      switch (jj_nt.kind) {
      case STRING_LITERAL:
        jj_consume_token(STRING_LITERAL);
        break;
      case TEXT_BLOCK_LITERAL:
        jj_consume_token(TEXT_BLOCK_LITERAL);
                            jjtn000.setTextBlock();
        break;
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
     jjtree.closeNodeScope(jjtn000, true, getToken(0));
     jjtc000 = false;
     setLastTokenImage(jjtn000);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void ArgumentList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ArgumentList */
  ASTArgumentList jjtn000 = new ASTArgumentList(JJTARGUMENTLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LPAREN);
      if (jj_2_82(1)) {
        Expression();
        label_53:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[133] = jj_gen;
            break label_53;
          }
          jj_consume_token(COMMA);
          Expression();
        }
      } else {
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
   if (jjtc000) {
     jjtree.clearNodeScope(jjtn000);
     jjtc000 = false;
   } else {
     jjtree.popNode();
   }
   if (jjte000 instanceof RuntimeException) {
     {if (true) throw (RuntimeException)jjte000;}
   }
   if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
     {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
   }
   {if (true) throw (Error)jjte000;}
    } finally {
   if (jjtc000) {
     jjtree.closeNodeScope(jjtn000, true, getToken(0));
   }
    }
  }

// more straightforward because can't be an array creation expr
  final public void QualifiedAllocationExpr() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) #ConstructorCall( jjtree . nodeArity ( ) + 1) */
  ASTConstructorCall jjtn000 = new ASTConstructorCall(JJTCONSTRUCTORCALL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(NEW);
      switch (jj_nt.kind) {
      case LT:
        TypeArguments();
        break;
      default:
        jj_la1[134] = jj_gen;
        ;
      }
      AnnotatedClassOrInterfaceType();
      ArgumentList();
      switch (jj_nt.kind) {
      case LBRACE:
        AnonymousClassDeclaration();
        break;
      default:
        jj_la1[135] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000,  jjtree . nodeArity ( ) + 1, getToken(0));
     }
    }
  }

  final public void AnonymousClassDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) AnonymousClassDeclaration */
  ASTAnonymousClassDeclaration jjtn000 = new ASTAnonymousClassDeclaration(JJTANONYMOUSCLASSDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));pushEmptyModifierList();
    try {
      ClassOrInterfaceBody();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

// this is much weaker than the JLS but since we parse compilable code
// the actual terms we get respect the JLS.

// only used in PrimaryPrefix
  final public void UnqualifiedAllocationExpr() throws net.sourceforge.pmd.lang.ast.ParseException {
    boolean isArrayInit=false;
     ASTConstructorCall jjtn002 = new ASTConstructorCall(JJTCONSTRUCTORCALL);
     boolean jjtc002 = true;
     jjtree.openNodeScope(jjtn002, getToken(1));
    try {
       ASTArrayAllocation jjtn001 = new ASTArrayAllocation(JJTARRAYALLOCATION);
       boolean jjtc001 = true;
       jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(NEW);
        switch (jj_nt.kind) {
        case LT:
          TypeArguments();
          break;
        default:
          jj_la1[136] = jj_gen;
          ;
        }
        TypeAnnotationList();
        switch (jj_nt.kind) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case FLOAT:
        case INT:
        case LONG:
        case SHORT:
          PrimitiveType();
          ArrayDimsAndInits();
                                             isArrayInit=true;
          break;
        default:
          jj_la1[139] = jj_gen;
          if (jj_2_83(1)) {
            ClassOrInterfaceType();
            switch (jj_nt.kind) {
            case LBRACKET:
            case AT:
              ArrayDimsAndInits();
                                   isArrayInit=true;
              break;
            case LPAREN:
              ArgumentList();
              switch (jj_nt.kind) {
              case LBRACE:
                AnonymousClassDeclaration();
                break;
              default:
                jj_la1[137] = jj_gen;
                ;
              }
              break;
            default:
              jj_la1[138] = jj_gen;
              jj_consume_token(-1);
              throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
            }
          } else {
            jj_consume_token(-1);
            throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
          }
        }
         jjtree.closeNodeScope(jjtn001,  isArrayInit, getToken(0));
         jjtc001 = false;

      } catch (Throwable jjte001) {
       if (jjtc001) {
         jjtree.clearNodeScope(jjtn001);
         jjtc001 = false;
       } else {
         jjtree.popNode();
       }
       if (jjte001 instanceof RuntimeException) {
         {if (true) throw (RuntimeException)jjte001;}
       }
       if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
         {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
       }
       {if (true) throw (Error)jjte001;}
      } finally {
       if (jjtc001) {
         jjtree.closeNodeScope(jjtn001,  isArrayInit, getToken(0));
       }
      }
    } catch (Throwable jjte002) {
     if (jjtc002) {
       jjtree.clearNodeScope(jjtn002);
       jjtc002 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte002 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte002;}
     }
     if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
     }
     {if (true) throw (Error)jjte002;}
    } finally {
     if (jjtc002) {
       jjtree.closeNodeScope(jjtn002,  ! isArrayInit, getToken(0));
     }
    }
  }

/*
 * The array dimensions are appended to the array type and they're both
 * enclosed into an ArrayType node.
 */
  final public void ArrayDimsAndInits() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jj_2_84(2147483647)) {
                                              ASTArrayType jjtn002 = new ASTArrayType(JJTARRAYTYPE);
                                              boolean jjtc002 = true;
                                              jjtree.openNodeScope(jjtn002, getToken(1));
      try {
                                               ASTArrayDimensions jjtn001 = new ASTArrayDimensions(JJTARRAYDIMENSIONS);
                                               boolean jjtc001 = true;
                                               jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          label_54:
          while (true) {
            ArrayTypeDim();
            switch (jj_nt.kind) {
            case LBRACKET:
            case AT:
              ;
              break;
            default:
              jj_la1[140] = jj_gen;
              break label_54;
            }
          }
        } catch (Throwable jjte001) {
                                               if (jjtc001) {
                                                 jjtree.clearNodeScope(jjtn001);
                                                 jjtc001 = false;
                                               } else {
                                                 jjtree.popNode();
                                               }
                                               if (jjte001 instanceof RuntimeException) {
                                                 {if (true) throw (RuntimeException)jjte001;}
                                               }
                                               if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                                 {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
                                               }
                                               {if (true) throw (Error)jjte001;}
        } finally {
                                               if (jjtc001) {
                                                 jjtree.closeNodeScope(jjtn001, true, getToken(0));
                                               }
        }
      } catch (Throwable jjte002) {
                                              if (jjtc002) {
                                                jjtree.clearNodeScope(jjtn002);
                                                jjtc002 = false;
                                              } else {
                                                jjtree.popNode();
                                              }
                                              if (jjte002 instanceof RuntimeException) {
                                                {if (true) throw (RuntimeException)jjte002;}
                                              }
                                              if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                                {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
                                              }
                                              {if (true) throw (Error)jjte002;}
      } finally {
                                              if (jjtc002) {
                                                jjtree.closeNodeScope(jjtn002,  2, getToken(0));
                                              }
      }
      switch (jj_nt.kind) {
      case LBRACE:
        ArrayInitializer();
        break;
      default:
        jj_la1[141] = jj_gen;
        ;
      }
    } else {
      switch (jj_nt.kind) {
      case LBRACKET:
      case AT:
         ASTArrayType jjtn004 = new ASTArrayType(JJTARRAYTYPE);
         boolean jjtc004 = true;
         jjtree.openNodeScope(jjtn004, getToken(1));
        try {
           ASTArrayDimensions jjtn003 = new ASTArrayDimensions(JJTARRAYDIMENSIONS);
           boolean jjtc003 = true;
           jjtree.openNodeScope(jjtn003, getToken(1));
          try {
            label_55:
            while (true) {
              ArrayDimExpr();
              switch (jj_nt.kind) {
              case LBRACKET:
              case AT:
                ;
                break;
              default:
                jj_la1[142] = jj_gen;
                break label_55;
              }
            }
          } catch (Throwable jjte003) {
           if (jjtc003) {
             jjtree.clearNodeScope(jjtn003);
             jjtc003 = false;
           } else {
             jjtree.popNode();
           }
           if (jjte003 instanceof RuntimeException) {
             {if (true) throw (RuntimeException)jjte003;}
           }
           if (jjte003 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
             {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte003;}
           }
           {if (true) throw (Error)jjte003;}
          } finally {
           if (jjtc003) {
             jjtree.closeNodeScope(jjtn003, true, getToken(0));
           }
          }
        } catch (Throwable jjte004) {
         if (jjtc004) {
           jjtree.clearNodeScope(jjtn004);
           jjtc004 = false;
         } else {
           jjtree.popNode();
         }
         if (jjte004 instanceof RuntimeException) {
           {if (true) throw (RuntimeException)jjte004;}
         }
         if (jjte004 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
           {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte004;}
         }
         {if (true) throw (Error)jjte004;}
        } finally {
         if (jjtc004) {
           jjtree.closeNodeScope(jjtn004,  2, getToken(0));
         }
        }
        break;
      default:
        jj_la1[143] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

// may push either an ArrayDimExpr or ArrayTypeDim
  final public void ArrayDimExpr() throws net.sourceforge.pmd.lang.ast.ParseException {
 boolean hasExpr=false;
    ASTArrayTypeDim jjtn002 = new ASTArrayTypeDim(JJTARRAYTYPEDIM);
    boolean jjtc002 = true;
    jjtree.openNodeScope(jjtn002, getToken(1));
    try {
     ASTArrayDimExpr jjtn001 = new ASTArrayDimExpr(JJTARRAYDIMEXPR);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        TypeAnnotListNoInject();
        jj_consume_token(LBRACKET);
        if (jj_2_85(1)) {
          Expression();
                                                hasExpr=true;
        } else {
          ;
        }
        jj_consume_token(RBRACKET);
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001,  hasExpr, getToken(0));
     }
      }
    } catch (Throwable jjte002) {
    if (jjtc002) {
      jjtree.clearNodeScope(jjtn002);
      jjtc002 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte002 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte002;}
    }
    if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
    }
    {if (true) throw (Error)jjte002;}
    } finally {
    if (jjtc002) {
      jjtree.closeNodeScope(jjtn002,  ! hasExpr, getToken(0));
    }
    }
  }

/*
 * Statement syntax follows.
 */
  final public void Statement() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case BREAK:
    case CONTINUE:
    case DO:
    case FOR:
    case IF:
    case RETURN:
    case SWITCH:
    case SYNCHRONIZED:
    case THROW:
    case TRY:
    case WHILE:
    case LBRACE:
    case SEMICOLON:
      StatementNoIdent();
      break;
    default:
      jj_la1[144] = jj_gen;
      if (isYieldStart()) {
        YieldStatement();
      } else if (isAssertStart()) {
        AssertStatement();
      } else if (jj_2_86(2)) {
        LabeledStatement();
      } else if (jj_2_87(1)) {
    ASTExpressionStatement jjtn001 = new ASTExpressionStatement(JJTEXPRESSIONSTATEMENT);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          StatementExpression();
          jj_consume_token(SEMICOLON);
        } catch (Throwable jjte001) {
    if (jjtc001) {
      jjtree.clearNodeScope(jjtn001);
      jjtc001 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte001 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte001;}
    }
    if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
    }
    {if (true) throw (Error)jjte001;}
        } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, true, getToken(0));
    }
        }
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void StatementNoIdent() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case LBRACE:
      Block();
      break;
    case SEMICOLON:
      EmptyStatement();
      break;
    case SWITCH:
      SwitchStatement();
      break;
    case IF:
      IfStatement();
      break;
    case WHILE:
      WhileStatement();
      break;
    case DO:
      DoStatement();
      break;
    case FOR:
      ForStatement();
      break;
    case BREAK:
      BreakStatement();
      break;
    case CONTINUE:
      ContinueStatement();
      break;
    case RETURN:
      ReturnStatement();
      break;
    case THROW:
      ThrowStatement();
      break;
    case SYNCHRONIZED:
      SynchronizedStatement();
      break;
    case TRY:
      TryStatement();
      break;
    default:
      jj_la1[145] = jj_gen;
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void LabeledStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) LabeledStatement */
  ASTLabeledStatement jjtn000 = new ASTLabeledStatement(JJTLABELEDSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
                 setLastTokenImage(jjtn000);
      jj_consume_token(COLON);
      Statement();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void Block() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) Block */
  ASTBlock jjtn000 = new ASTBlock(JJTBLOCK);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LBRACE);
      label_56:
      while (true) {
        if (jj_2_88(1)) {
          ;
        } else {
          break label_56;
        }
        BlockStatement();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void BlockStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case FINAL:
    case AT:
      ModifierList();
      if (localTypeDeclAfterModifiers()) {
        LocalTypeDecl();
      } else if (true) {
        LocalVariableDeclarationPendingModifiers();
        jj_consume_token(SEMICOLON);
                                                                                                    fixLastToken();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      break;
    case IDENTIFIER:
      if (localTypeDeclGivenNextIsIdent()) {
        ModifierList();
        LocalTypeDecl();
      } else if (isAssertStart()) {
        AssertStatement();
      } else if (isYieldStart()) {
        YieldStatement();
      } else if (getToken(2).kind == COLON) {
        LabeledStatement();
      } else if (jj_2_89(2147483647)) {
        LocalVariableDeclaration();
        jj_consume_token(SEMICOLON);
                                                                                       fixLastToken();
      } else if (true) {
        ExpressionStatement();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      break;
    case ABSTRACT:
    case CLASS:
    case INTERFACE:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case STATIC:
    case TRANSIENT:
    case VOLATILE:
    case STRICTFP:
      ModifierList();
      LocalTypeDecl();
      break;
    case BREAK:
    case CONTINUE:
    case DO:
    case FOR:
    case IF:
    case RETURN:
    case SWITCH:
    case SYNCHRONIZED:
    case THROW:
    case TRY:
    case WHILE:
    case LBRACE:
    case SEMICOLON:
      StatementNoIdent();
      break;
    default:
      jj_la1[146] = jj_gen;
      if (jj_2_90(2147483647)) {
        LocalVariableDeclaration();
        jj_consume_token(SEMICOLON);
                                                                         fixLastToken();
      } else if (true) {
        ExpressionStatement();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final private void LocalTypeStartNoIdent() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case PUBLIC:
      jj_consume_token(PUBLIC);
      break;
    case STATIC:
      jj_consume_token(STATIC);
      break;
    case PROTECTED:
      jj_consume_token(PROTECTED);
      break;
    case PRIVATE:
      jj_consume_token(PRIVATE);
      break;
    case ABSTRACT:
      jj_consume_token(ABSTRACT);
      break;
    case NATIVE:
      jj_consume_token(NATIVE);
      break;
    case TRANSIENT:
      jj_consume_token(TRANSIENT);
      break;
    case VOLATILE:
      jj_consume_token(VOLATILE);
      break;
    case STRICTFP:
      jj_consume_token(STRICTFP);
      break;
    case CLASS:
      jj_consume_token(CLASS);
      break;
    case INTERFACE:
      jj_consume_token(INTERFACE);
      break;
    default:
      jj_la1[147] = jj_gen;
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void LocalTypeDecl() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case CLASS:
    case INTERFACE:
      ClassOrInterfaceDeclaration();
      break;
    default:
      jj_la1[148] = jj_gen;
      if (isKeyword("record")) {
        RecordDeclaration();
      } else if (isKeyword("enum")) {
        EnumDeclaration();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
    // Wrap the type decl into a statement
    // This can't be done with regular jjtree constructs, as the ModifierList
    // is adopted by the first node to be opened.
    ASTTypeDeclaration type = (ASTTypeDeclaration) jjtree.popNode();
    ASTLocalClassStatement stmt = new ASTLocalClassStatement(type);
    jjtree.pushNode(stmt);
  }

/*
 * See https://docs.oracle.com/javase/specs/jls/se10/html/jls-14.html#jls-14.4
 */
  final public void LocalVariableDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) LocalVariableDeclaration */
  ASTLocalVariableDeclaration jjtn000 = new ASTLocalVariableDeclaration(JJTLOCALVARIABLEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      LocalVarModifierList();
      LocalVariableType();
      VariableDeclarator();
      label_57:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[149] = jj_gen;
          break label_57;
        }
        jj_consume_token(COMMA);
        VariableDeclarator();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void LocalVariableDeclarationPendingModifiers() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) LocalVariableDeclaration */
  ASTLocalVariableDeclaration jjtn000 = new ASTLocalVariableDeclaration(JJTLOCALVARIABLEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      LocalVariableType();
      VariableDeclarator();
      label_58:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[150] = jj_gen;
          break label_58;
        }
        jj_consume_token(COMMA);
        VariableDeclarator();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final private void LocalVarModifierList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ModifierList */
 ASTModifierList jjtn000 = new ASTModifierList(JJTMODIFIERLIST);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));Set<JModifier> set = Collections.emptySet();
    try {
      label_59:
      while (true) {
        switch (jj_nt.kind) {
        case FINAL:
        case AT:
          ;
          break;
        default:
          jj_la1[151] = jj_gen;
          break label_59;
        }
        switch (jj_nt.kind) {
        case FINAL:
          jj_consume_token(FINAL);
                set = ASTModifierList.JUST_FINAL;
          break;
        case AT:
          Annotation();
          break;
        default:
          jj_la1[152] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
      jjtc000 = false;
     jjtn000.setDeclaredModifiers(set);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void LocalVariableType() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jdkVersion >= 10 && isKeyword("var")) {
      jj_consume_token(IDENTIFIER);
    } else if (jj_2_91(1)) {
      Type();
    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void EmptyStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) EmptyStatement */
  ASTEmptyStatement jjtn000 = new ASTEmptyStatement(JJTEMPTYSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(SEMICOLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void EmptyDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) EmptyDeclaration */
  ASTEmptyDeclaration jjtn000 = new ASTEmptyDeclaration(JJTEMPTYDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(SEMICOLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ExpressionStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ExpressionStatement */
  ASTExpressionStatement jjtn000 = new ASTExpressionStatement(JJTEXPRESSIONSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      StatementExpression();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void StatementExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
 AssignmentOp op = null;
    switch (jj_nt.kind) {
    case INCR:
    case DECR:
      PrefixIncrementExpression();
      break;
    default:
      jj_la1[154] = jj_gen;
      if (jj_2_92(1)) {
    ASTAssignmentExpression jjtn001 = new ASTAssignmentExpression(JJTASSIGNMENTEXPRESSION);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          PostfixExpression();
          switch (jj_nt.kind) {
          case ASSIGN:
          case PLUSASSIGN:
          case MINUSASSIGN:
          case STARASSIGN:
          case SLASHASSIGN:
          case ANDASSIGN:
          case ORASSIGN:
          case XORASSIGN:
          case REMASSIGN:
          case LSHIFTASSIGN:
          case RSIGNEDSHIFTASSIGN:
          case RUNSIGNEDSHIFTASSIGN:
            op = AssignmentOperator();
                                                  jjtn001.setOp(op);
            Expression();
            break;
          default:
            jj_la1[153] = jj_gen;
            ;
          }
        } catch (Throwable jjte001) {
    if (jjtc001) {
      jjtree.clearNodeScope(jjtn001);
      jjtc001 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte001 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte001;}
    }
    if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
    }
    {if (true) throw (Error)jjte001;}
        } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1, getToken(0));
    }
        }
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void SwitchStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) SwitchStatement */
  ASTSwitchStatement jjtn000 = new ASTSwitchStatement(JJTSWITCHSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(SWITCH);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      SwitchBlock();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void SwitchBlock() throws net.sourceforge.pmd.lang.ast.ParseException {
    jj_consume_token(LBRACE);
    if (jj_2_93(2147483647)) {
      label_60:
      while (true) {
        SwitchFallthroughBranch();
        switch (jj_nt.kind) {
        case CASE:
        case _DEFAULT:
          ;
          break;
        default:
          jj_la1[155] = jj_gen;
          break label_60;
        }
      }
    } else {
      label_61:
      while (true) {
        switch (jj_nt.kind) {
        case CASE:
        case _DEFAULT:
          ;
          break;
        default:
          jj_la1[156] = jj_gen;
          break label_61;
        }
        SwitchArrowBranch();
      }
    }
    jj_consume_token(RBRACE);
  }

  final public void SwitchArrowBranch() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) SwitchArrowBranch */
  ASTSwitchArrowBranch jjtn000 = new ASTSwitchArrowBranch(JJTSWITCHARROWBRANCH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      SwitchLabel();
      jj_consume_token(LAMBDA);
      if (jj_2_94(1)) {
        Expression();
        jj_consume_token(SEMICOLON);
      } else {
        switch (jj_nt.kind) {
        case LBRACE:
          Block();
          break;
        case THROW:
          ThrowStatement();
          break;
        default:
          jj_la1[157] = jj_gen;
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void SwitchFallthroughBranch() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) SwitchFallthroughBranch */
  ASTSwitchFallthroughBranch jjtn000 = new ASTSwitchFallthroughBranch(JJTSWITCHFALLTHROUGHBRANCH);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      SwitchLabel();
      jj_consume_token(COLON);
      label_62:
      while (true) {
        if (shouldStartStatementInSwitch()) {
          ;
        } else {
          break label_62;
        }
        BlockStatement();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void SwitchLabel() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) SwitchLabel */
  ASTSwitchLabel jjtn000 = new ASTSwitchLabel(JJTSWITCHLABEL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
  inSwitchLabel = true;
      switch (jj_nt.kind) {
      case CASE:
        jj_consume_token(CASE);
        CaseLabelElement(jjtn000);
        label_63:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[158] = jj_gen;
            break label_63;
          }
          jj_consume_token(COMMA);
          CaseLabelElement(jjtn000);
        }
        break;
      case _DEFAULT:
        jj_consume_token(_DEFAULT);
             jjtn000.setDefault();
        break;
      default:
        jj_la1[159] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
  jjtree.closeNodeScope(jjtn000, true, getToken(0));
  jjtc000 = false;
  inSwitchLabel = false;
    } catch (Throwable jjte000) {
  if (jjtc000) {
    jjtree.clearNodeScope(jjtn000);
    jjtc000 = false;
  } else {
    jjtree.popNode();
  }
  if (jjte000 instanceof RuntimeException) {
    {if (true) throw (RuntimeException)jjte000;}
  }
  if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
    {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
  }
  {if (true) throw (Error)jjte000;}
    } finally {
  if (jjtc000) {
    jjtree.closeNodeScope(jjtn000, true, getToken(0));
  }
    }
  }

  final public void CaseLabelElement(ASTSwitchLabel label) throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case NULL:
      ASTNullLiteral jjtn001 = new ASTNullLiteral(JJTNULLLITERAL);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(NULL);
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true, getToken(0));
      }
      }
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
        jj_consume_token(_DEFAULT);
                                         label.setDefault();
        break;
      default:
        jj_la1[160] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[161] = jj_gen;
      if (jj_2_95(2147483647)) {
        CasePattern();
        if (isKeyword("when")) {
          Guard();
        } else {
          ;
        }
      } else if (jj_2_96(1)) {
        CaseConstant();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void CaseConstant() throws net.sourceforge.pmd.lang.ast.ParseException {
    ConditionalExpression();
  }

  final public void CasePattern() throws net.sourceforge.pmd.lang.ast.ParseException {
    Pattern();
  }

  final public void Guard() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) Guard */
  ASTGuard jjtn000 = new ASTGuard(JJTGUARD);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      softKeyword("when");
      Expression();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void YieldStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) YieldStatement */
  ASTYieldStatement jjtn000 = new ASTYieldStatement(JJTYIELDSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
      Expression();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void IfStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) IfStatement */
  ASTIfStatement jjtn000 = new ASTIfStatement(JJTIFSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IF);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      Statement();
      switch (jj_nt.kind) {
      case ELSE:
        jj_consume_token(ELSE);
                                                               jjtn000.setHasElse();
        Statement();
        break;
      default:
        jj_la1[162] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void WhileStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) WhileStatement */
  ASTWhileStatement jjtn000 = new ASTWhileStatement(JJTWHILESTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      Statement();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void DoStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) DoStatement */
  ASTDoStatement jjtn000 = new ASTDoStatement(JJTDOSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(DO);
      Statement();
      jj_consume_token(WHILE);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ForStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 JavaccToken t;
    t = jj_consume_token(FOR);
    jj_consume_token(LPAREN);
    if (jj_2_100(2147483647)) {
        ASTForeachStatement jjtn001 = new ASTForeachStatement(JJTFOREACHSTATEMENT);
        boolean jjtc001 = true;
        jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        EnhancedForDeclaration();
        jj_consume_token(COLON);
        Expression();
        jj_consume_token(RPAREN);
        Statement();
                                                                   jjtree.closeNodeScope(jjtn001, true, getToken(0));
                                                                   jjtc001 = false;
                                                                   jjtn001.setFirstToken(t);
      } catch (Throwable jjte001) {
        if (jjtc001) {
          jjtree.clearNodeScope(jjtn001);
          jjtc001 = false;
        } else {
          jjtree.popNode();
        }
        if (jjte001 instanceof RuntimeException) {
          {if (true) throw (RuntimeException)jjte001;}
        }
        if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
          {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
        }
        {if (true) throw (Error)jjte001;}
      } finally {
        if (jjtc001) {
          jjtree.closeNodeScope(jjtn001, true, getToken(0));
        }
      }
    } else if (jj_2_101(1)) {
    ASTForStatement jjtn002 = new ASTForStatement(JJTFORSTATEMENT);
    boolean jjtc002 = true;
    jjtree.openNodeScope(jjtn002, getToken(1));
      try {
        if (jj_2_97(1)) {
          ForInit();
        } else {
          ;
        }
        jj_consume_token(SEMICOLON);
        if (jj_2_98(1)) {
          Expression();
        } else {
          ;
        }
        jj_consume_token(SEMICOLON);
        if (jj_2_99(1)) {
          ForUpdate();
        } else {
          ;
        }
        jj_consume_token(RPAREN);
        Statement();
     jjtree.closeNodeScope(jjtn002, true, getToken(0));
     jjtc002 = false;
     jjtn002.setFirstToken(t);
      } catch (Throwable jjte002) {
    if (jjtc002) {
      jjtree.clearNodeScope(jjtn002);
      jjtc002 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte002 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte002;}
    }
    if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
    }
    {if (true) throw (Error)jjte002;}
      } finally {
    if (jjtc002) {
      jjtree.closeNodeScope(jjtn002, true, getToken(0));
    }
      }
    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void EnhancedForDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
    LocalVariableDeclaration();
  }

  final public void ForInit() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ForInit */
  ASTForInit jjtn000 = new ASTForInit(JJTFORINIT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      if (jj_2_102(2147483647)) {
        LocalVariableDeclaration();
      } else if (jj_2_103(1)) {
        StatementExpressionList();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void StatementExpressionList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) StatementExpressionList */
  ASTStatementExpressionList jjtn000 = new ASTStatementExpressionList(JJTSTATEMENTEXPRESSIONLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      StatementExpression();
      label_64:
      while (true) {
        switch (jj_nt.kind) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[163] = jj_gen;
          break label_64;
        }
        jj_consume_token(COMMA);
        StatementExpression();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ForUpdate() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ForUpdate */
  ASTForUpdate jjtn000 = new ASTForUpdate(JJTFORUPDATE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      StatementExpressionList();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void BreakStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) BreakStatement */
  ASTBreakStatement jjtn000 = new ASTBreakStatement(JJTBREAKSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(BREAK);
      switch (jj_nt.kind) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
                           setLastTokenImage(jjtn000);
        break;
      default:
        jj_la1[164] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ContinueStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ContinueStatement */
  ASTContinueStatement jjtn000 = new ASTContinueStatement(JJTCONTINUESTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(CONTINUE);
      switch (jj_nt.kind) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
                              setLastTokenImage(jjtn000);
        break;
      default:
        jj_la1[165] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ReturnStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ReturnStatement */
  ASTReturnStatement jjtn000 = new ASTReturnStatement(JJTRETURNSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(RETURN);
      if (jj_2_104(1)) {
        Expression();
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ThrowStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ThrowStatement */
  ASTThrowStatement jjtn000 = new ASTThrowStatement(JJTTHROWSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(THROW);
      Expression();
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void SynchronizedStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) SynchronizedStatement */
  ASTSynchronizedStatement jjtn000 = new ASTSynchronizedStatement(JJTSYNCHRONIZEDSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(SYNCHRONIZED);
      jj_consume_token(LPAREN);
      Expression();
      jj_consume_token(RPAREN);
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void TryStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) TryStatement */
  ASTTryStatement jjtn000 = new ASTTryStatement(JJTTRYSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(TRY);
      switch (jj_nt.kind) {
      case LPAREN:
        ResourceList();
        break;
      default:
        jj_la1[166] = jj_gen;
        ;
      }
      Block();
      label_65:
      while (true) {
        switch (jj_nt.kind) {
        case CATCH:
          ;
          break;
        default:
          jj_la1[167] = jj_gen;
          break label_65;
        }
        CatchClause();
      }
      switch (jj_nt.kind) {
      case FINALLY:
        FinallyClause();
        break;
      default:
        jj_la1[168] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ResourceList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ResourceList */
  ASTResourceList jjtn000 = new ASTResourceList(JJTRESOURCELIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LPAREN);
      Resource();
      label_66:
      while (true) {
        if (jj_2_105(2)) {
          ;
        } else {
          break label_66;
        }
        jj_consume_token(SEMICOLON);
        Resource();
      }
      switch (jj_nt.kind) {
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
              jjtn000.setTrailingSemi();
        break;
      default:
        jj_la1[169] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
            {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true, getToken(0));
          }
    }
  }

  final public void Resource() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) Resource */
  ASTResource jjtn000 = new ASTResource(JJTRESOURCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      if (jj_2_106(2147483647)) {
          ASTLocalVariableDeclaration jjtn001 = new ASTLocalVariableDeclaration(JJTLOCALVARIABLEDECLARATION);
          boolean jjtc001 = true;
          jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          LocalVarModifierList();
          LocalVariableType();
          VariableDeclarator();
        } catch (Throwable jjte001) {
          if (jjtc001) {
            jjtree.clearNodeScope(jjtn001);
            jjtc001 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte001 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte001;}
          }
          if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
            {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
          }
          {if (true) throw (Error)jjte001;}
        } finally {
          if (jjtc001) {
            jjtree.closeNodeScope(jjtn001, true, getToken(0));
          }
        }
      } else if (jj_2_107(1)) {
        PrimaryExpression();
    Node top = jjtree.peekNode();
    if (!(top instanceof ASTVariableAccess || top instanceof ASTFieldAccess || top instanceof ASTThisExpression))
      throwParseException("Expected a variable or field access, but was a " + top.getXPathNodeName());
     jjtree.closeNodeScope(jjtn000, true, getToken(0));
     jjtc000 = false;

      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void CatchClause() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) CatchClause */
  ASTCatchClause jjtn000 = new ASTCatchClause(JJTCATCHCLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(CATCH);
      jj_consume_token(LPAREN);
      CatchParameter();
      jj_consume_token(RPAREN);
      Block();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void CatchParameter() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) CatchParameter */
 ASTCatchParameter jjtn000 = new ASTCatchParameter(JJTCATCHPARAMETER);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000, getToken(1));boolean multi=false;
    try {
      LocalVarModifierList();
     ASTUnionType jjtn001 = new ASTUnionType(JJTUNIONTYPE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        AnnotatedClassOrInterfaceType();
        label_67:
        while (true) {
          switch (jj_nt.kind) {
          case BIT_OR:
            ;
            break;
          default:
            jj_la1[170] = jj_gen;
            break label_67;
          }
          jj_consume_token(BIT_OR);
          AnnotatedClassOrInterfaceType();
                                                                             multi=true;
        }
      } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001,  multi, getToken(0));
     }
      }
      VariableDeclaratorId();
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void FinallyClause() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) FinallyClause */
  ASTFinallyClause jjtn000 = new ASTFinallyClause(JJTFINALLYCLAUSE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(FINALLY);
      Block();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void AssertStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) AssertStatement */
  ASTAssertStatement jjtn000 = new ASTAssertStatement(JJTASSERTSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
      Expression();
      switch (jj_nt.kind) {
      case COLON:
        jj_consume_token(COLON);
        Expression();
        break;
      default:
        jj_la1[171] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

/* We use productions to match >>>, >> and > so that we can keep the
 * type declaration syntax with generics clean
 */
  final public void RUNSIGNEDSHIFT() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (JavaTokenDocumentBehavior.getRealKind(getToken(1)) == RUNSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
    jj_consume_token(GT);
    jj_consume_token(GT);
    jj_consume_token(GT);
  }

  final public void RSIGNEDSHIFT() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (JavaTokenDocumentBehavior.getRealKind(getToken(1)) == RSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
    jj_consume_token(GT);
    jj_consume_token(GT);
  }

/* Annotation syntax follows. */
  final public void Annotation() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) Annotation */
  ASTAnnotation jjtn000 = new ASTAnnotation(JJTANNOTATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(AT);
      ClassName();
      switch (jj_nt.kind) {
      case LPAREN:
        AnnotationMemberList();
        break;
      default:
        jj_la1[172] = jj_gen;
        ;
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void AnnotationMemberList() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) AnnotationMemberList */
  ASTAnnotationMemberList jjtn000 = new ASTAnnotationMemberList(JJTANNOTATIONMEMBERLIST);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LPAREN);
      if (jj_2_109(2147483647)) {
        MemberValuePair();
        label_68:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[173] = jj_gen;
            break label_68;
          }
          jj_consume_token(COMMA);
          MemberValuePair();
        }
      } else {
        if (jj_2_108(1)) {
          ShorthandAnnotationValue();
        } else {
          ;
        }
      }
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
     if (jjtc000) {
       jjtree.clearNodeScope(jjtn000);
       jjtc000 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte000 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte000;}
     }
     if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
       {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
     }
     {if (true) throw (Error)jjte000;}
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true, getToken(0));
     }
    }
  }

  final public void ShorthandAnnotationValue() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) MemberValuePair */
    ASTMemberValuePair jjtn000 = new ASTMemberValuePair(JJTMEMBERVALUEPAIR);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000, getToken(1));jjtn000.setImage("value");
    jjtn000.setShorthand();
    try {
      MemberValue();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void MemberValuePair() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) MemberValuePair */
  ASTMemberValuePair jjtn000 = new ASTMemberValuePair(JJTMEMBERVALUEPAIR);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
                   setLastTokenImage(jjtn000);
      jj_consume_token(ASSIGN);
      MemberValue();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true, getToken(0));
      }
    }
  }

  final public void MemberValue() throws net.sourceforge.pmd.lang.ast.ParseException {
    switch (jj_nt.kind) {
    case AT:
      Annotation();
      break;
    case LBRACE:
      MemberValueArrayInitializer();
      break;
    default:
      jj_la1[174] = jj_gen;
      if (jj_2_110(1)) {
        ConditionalExpression();
      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void MemberValueArrayInitializer() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) MemberValueArrayInitializer */
  ASTMemberValueArrayInitializer jjtn000 = new ASTMemberValueArrayInitializer(JJTMEMBERVALUEARRAYINITIALIZER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LBRACE);
      if (jj_2_112(1)) {
        MemberValue();
        label_69:
        while (true) {
          if (jj_2_111(2)) {
            ;
          } else {
            break label_69;
          }
          jj_consume_token(COMMA);
          MemberValue();
        }
      } else {
        ;
      }
      switch (jj_nt.kind) {
      case COMMA:
        jj_consume_token(COMMA);
        break;
      default:
        jj_la1[175] = jj_gen;
        ;
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

/*
 * We use that ghost production to factorise the check for JDK >= 1.8.
 */
  final public void TypeAnnotation() throws net.sourceforge.pmd.lang.ast.ParseException {
    Annotation();
  }

/* Annotation Types. */
  final public void AnnotationTypeDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) AnnotationTypeDeclaration */
  ASTAnnotationTypeDeclaration jjtn000 = new ASTAnnotationTypeDeclaration(JJTANNOTATIONTYPEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(AT);
      jj_consume_token(INTERFACE);
      jj_consume_token(IDENTIFIER);
                                 jjtn000.setSimpleName(getToken(0).getImage());
      AnnotationTypeBody();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void AnnotationTypeBody() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) AnnotationTypeBody */
  ASTAnnotationTypeBody jjtn000 = new ASTAnnotationTypeBody(JJTANNOTATIONTYPEBODY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(LBRACE);
      label_70:
      while (true) {
        if (jj_2_113(1)) {
          ;
        } else {
          break label_70;
        }
        AnnotationTypeMemberDeclaration();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void AnnotationTypeMemberDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
    if (jj_2_117(1)) {
      ModifierList();
      if (jj_2_114(2147483647)) {
        AnnotationMethodDeclaration();
      } else {
        switch (jj_nt.kind) {
        case CLASS:
        case INTERFACE:
          ClassOrInterfaceDeclaration();
          break;
        default:
          jj_la1[176] = jj_gen;
          if (jj_2_115(3)) {
            EnumDeclaration();
          } else {
            switch (jj_nt.kind) {
            case AT:
              AnnotationTypeDeclaration();
              break;
            default:
              jj_la1[177] = jj_gen;
              if (jj_2_116(1)) {
                FieldDeclaration();
              } else {
                jj_consume_token(-1);
                throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
              }
            }
          }
        }
      }
    } else {
      switch (jj_nt.kind) {
      case SEMICOLON:
     ASTEmptyDeclaration jjtn001 = new ASTEmptyDeclaration(JJTEMPTYDECLARATION);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001, getToken(1));
        try {
          jj_consume_token(SEMICOLON);
        } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true, getToken(0));
     }
        }
        break;
      default:
        jj_la1[178] = jj_gen;
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
    }
  }

  final public void AnnotationMethodDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) MethodDeclaration */
  ASTMethodDeclaration jjtn000 = new ASTMethodDeclaration(JJTMETHODDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      Type();
      jj_consume_token(IDENTIFIER);
                 jjtn000.setName(getToken(0).getImage());
    ASTFormalParameters jjtn001 = new ASTFormalParameters(JJTFORMALPARAMETERS);
    boolean jjtc001 = true;
    jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        jj_consume_token(LPAREN);
        jj_consume_token(RPAREN);
      } finally {
    if (jjtc001) {
      jjtree.closeNodeScope(jjtn001, true, getToken(0));
    }
      }
      switch (jj_nt.kind) {
      case LBRACKET:
      case AT:
        Dims();
        break;
      default:
        jj_la1[179] = jj_gen;
        ;
      }
      switch (jj_nt.kind) {
      case _DEFAULT:
        DefaultValue();
        break;
      default:
        jj_la1[180] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void DefaultValue() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) DefaultValue */
  ASTDefaultValue jjtn000 = new ASTDefaultValue(JJTDEFAULTVALUE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(_DEFAULT);
      MemberValue();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ModuleDeclaration() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ModuleDeclaration */
  ASTModuleDeclaration jjtn000 = new ASTModuleDeclaration(JJTMODULEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      AnnotationList();
      if (isKeyword("open")) {
        jj_consume_token(IDENTIFIER);
                                                jjtn000.setOpen(true);
      } else {
        ;
      }
      if (isKeyword("module")) {

      } else {
        jj_consume_token(-1);
        throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
      }
      jj_consume_token(IDENTIFIER);
      ModuleName();
      jj_consume_token(LBRACE);
      label_71:
      while (true) {
        if (jj_2_118(1)) {
          ;
        } else {
          break label_71;
        }
        ModuleDirective();
      }
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void ModuleDirective() throws net.sourceforge.pmd.lang.ast.ParseException {
 String packageName;
    if (jj_2_120(1)) {
      ASTModuleRequiresDirective jjtn001 = new ASTModuleRequiresDirective(JJTMODULEREQUIRESDIRECTIVE);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001, getToken(1));
      try {
        if (isKeyword("requires")) {

        } else {
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        jj_consume_token(IDENTIFIER);
        if (jj_2_119(1)) {
          if (isKeyword("transitive")) {
            jj_consume_token(IDENTIFIER);
                                                            jjtn001.setTransitive();
          } else {
            switch (jj_nt.kind) {
            case STATIC:
              jj_consume_token(STATIC);
                                                            jjtn001.setStatic();
              break;
            default:
              jj_la1[181] = jj_gen;
              jj_consume_token(-1);
              throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
            }
          }
        } else {
          ;
        }
        ModuleName();
        jj_consume_token(SEMICOLON);
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true, getToken(0));
      }
      }
    } else if (jj_2_121(1)) {
      ASTModuleExportsDirective jjtn002 = new ASTModuleExportsDirective(JJTMODULEEXPORTSDIRECTIVE);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002, getToken(1));
      try {
        if (isKeyword("exports")) {

        } else {
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        jj_consume_token(IDENTIFIER);
        packageName = VoidNameNoLookahead();
                                                                                         jjtn002.setPackageName(packageName);
        if (isKeyword("to")) {
          jj_consume_token(IDENTIFIER);
          ModuleName();
          label_72:
          while (true) {
            switch (jj_nt.kind) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[182] = jj_gen;
              break label_72;
            }
            jj_consume_token(COMMA);
            ModuleName();
          }
        } else {
          ;
        }
        jj_consume_token(SEMICOLON);
      } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
      } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002, true, getToken(0));
      }
      }
    } else if (jj_2_122(1)) {
      ASTModuleOpensDirective jjtn003 = new ASTModuleOpensDirective(JJTMODULEOPENSDIRECTIVE);
      boolean jjtc003 = true;
      jjtree.openNodeScope(jjtn003, getToken(1));
      try {
        if (isKeyword("opens")) {

        } else {
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        jj_consume_token(IDENTIFIER);
        packageName = VoidNameNoLookahead();
                                                                                         jjtn003.setPackageName(packageName);
        if (isKeyword("to")) {
          jj_consume_token(IDENTIFIER);
          ModuleName();
          label_73:
          while (true) {
            switch (jj_nt.kind) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[183] = jj_gen;
              break label_73;
            }
            jj_consume_token(COMMA);
            ModuleName();
          }
        } else {
          ;
        }
        jj_consume_token(SEMICOLON);
      } catch (Throwable jjte003) {
      if (jjtc003) {
        jjtree.clearNodeScope(jjtn003);
        jjtc003 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte003 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte003;}
      }
      if (jjte003 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte003;}
      }
      {if (true) throw (Error)jjte003;}
      } finally {
      if (jjtc003) {
        jjtree.closeNodeScope(jjtn003, true, getToken(0));
      }
      }
    } else if (jj_2_123(1)) {
      ASTModuleUsesDirective jjtn004 = new ASTModuleUsesDirective(JJTMODULEUSESDIRECTIVE);
      boolean jjtc004 = true;
      jjtree.openNodeScope(jjtn004, getToken(1));
      try {
        if (isKeyword("uses")) {

        } else {
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        jj_consume_token(IDENTIFIER);
        ClassName();
        jj_consume_token(SEMICOLON);
      } catch (Throwable jjte004) {
      if (jjtc004) {
        jjtree.clearNodeScope(jjtn004);
        jjtc004 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte004 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte004;}
      }
      if (jjte004 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte004;}
      }
      {if (true) throw (Error)jjte004;}
      } finally {
      if (jjtc004) {
        jjtree.closeNodeScope(jjtn004, true, getToken(0));
      }
      }
    } else if (jj_2_124(1)) {
      ASTModuleProvidesDirective jjtn005 = new ASTModuleProvidesDirective(JJTMODULEPROVIDESDIRECTIVE);
      boolean jjtc005 = true;
      jjtree.openNodeScope(jjtn005, getToken(1));
      try {
        if (isKeyword("provides")) {

        } else {
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        jj_consume_token(IDENTIFIER);
        ClassName();
        if (isKeyword("with")) {

        } else {
          jj_consume_token(-1);
          throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
        }
        jj_consume_token(IDENTIFIER);
        ClassName();
        label_74:
        while (true) {
          switch (jj_nt.kind) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[184] = jj_gen;
            break label_74;
          }
          jj_consume_token(COMMA);
          ClassName();
        }
        jj_consume_token(SEMICOLON);
      } catch (Throwable jjte005) {
      if (jjtc005) {
        jjtree.clearNodeScope(jjtn005);
        jjtc005 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte005 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte005;}
      }
      if (jjte005 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
        {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte005;}
      }
      {if (true) throw (Error)jjte005;}
      } finally {
      if (jjtc005) {
        jjtree.closeNodeScope(jjtn005, true, getToken(0));
      }
      }
    } else {
      jj_consume_token(-1);
      throw net.sourceforge.pmd.util.AssertionUtil.shouldNotReachHere("consumetoken(-1) should have thrown");
    }
  }

  final public void ModuleName() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) ModuleName */
  ASTModuleName jjtn000 = new ASTModuleName(JJTMODULENAME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));String name;
    try {
      name = VoidNameNoLookahead();
                               jjtree.closeNodeScope(jjtn000, true, getToken(0));
                               jjtc000 = false;
                               jjtn000.setName(name);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public void AmbiguousName() throws net.sourceforge.pmd.lang.ast.ParseException {
 /*@bgen(jjtree) AmbiguousName */
  ASTAmbiguousName jjtn000 = new ASTAmbiguousName(JJTAMBIGUOUSNAME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));String name;
    try {
      name = VoidName();
                    jjtree.closeNodeScope(jjtn000, true, getToken(0));
                    jjtc000 = false;
                    jjtn000.setImage(name);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
      {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true, getToken(0));
    }
    }
  }

  final public String VoidName() throws net.sourceforge.pmd.lang.ast.ParseException {
  StringBuilder s = new StringBuilder();
  JavaccToken t;
    t = jj_consume_token(IDENTIFIER);
                                      s.append(t.getImage());
    label_75:
    while (true) {
      if (jj_2_125(2)) {
        ;
      } else {
        break label_75;
      }
      jj_consume_token(DOT);
      t = jj_consume_token(IDENTIFIER);
                                      s.append('.').append(t.getImage());
    }
   {if (true) return s.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String VoidNameNoLookahead() throws net.sourceforge.pmd.lang.ast.ParseException {
  StringBuilder s = new StringBuilder();
  JavaccToken t;
    t = jj_consume_token(IDENTIFIER);
                         s.append(t.getImage());
    label_76:
    while (true) {
      switch (jj_nt.kind) {
      case DOT:
        ;
        break;
      default:
        jj_la1[185] = jj_gen;
        break label_76;
      }
      jj_consume_token(DOT);
      t = jj_consume_token(IDENTIFIER);
                         s.append('.').append(t.getImage());
    }
   {if (true) return s.toString();}
    throw new Error("Missing return statement in function");
  }

// Produces a ClassOrInterfaceType, possibly with an ambiguous LHS
  final public void ClassName() throws net.sourceforge.pmd.lang.ast.ParseException {
    AmbiguousName();
                      forceTypeContext();
  }

// This is used to get JJTree to generate a node.
// Variable references are always ambiguous
// when they're parsed, so they're not created
// normally by jjtree, but rather by the disambiguation
// hooks spread across the parser
//noinspection UnusedProduction
  final public void VariableAccess() throws net.sourceforge.pmd.lang.ast.ParseException {
                        /*@bgen(jjtree) VariableAccess */
  ASTVariableAccess jjtn000 = new ASTVariableAccess(JJTVARIABLEACCESS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
    } finally {
                              if (jjtc000) {
                                jjtree.closeNodeScope(jjtn000, true, getToken(0));
                              }
    }
  }

// those are created manually
  final public void TypeExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
                        /*@bgen(jjtree) TypeExpression */
  ASTTypeExpression jjtn000 = new ASTTypeExpression(JJTTYPEEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
    } finally {
                              if (jjtc000) {
                                jjtree.closeNodeScope(jjtn000, true, getToken(0));
                              }
    }
  }

  final public void PatternExpression() throws net.sourceforge.pmd.lang.ast.ParseException {
                           /*@bgen(jjtree) PatternExpression */
  ASTPatternExpression jjtn000 = new ASTPatternExpression(JJTPATTERNEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      jj_consume_token(IDENTIFIER);
    } finally {
                                 if (jjtc000) {
                                   jjtree.closeNodeScope(jjtn000, true, getToken(0));
                                 }
    }
  }

  final public void LocalClassStatement() throws net.sourceforge.pmd.lang.ast.ParseException {
                             /*@bgen(jjtree) LocalClassStatement */
  ASTLocalClassStatement jjtn000 = new ASTLocalClassStatement(JJTLOCALCLASSSTATEMENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000, getToken(1));
    try {
      TypeDeclaration();
    } catch (Throwable jjte000) {
                                   if (jjtc000) {
                                     jjtree.clearNodeScope(jjtn000);
                                     jjtc000 = false;
                                   } else {
                                     jjtree.popNode();
                                   }
                                   if (jjte000 instanceof RuntimeException) {
                                     {if (true) throw (RuntimeException)jjte000;}
                                   }
                                   if (jjte000 instanceof net.sourceforge.pmd.lang.ast.ParseException) {
                                     {if (true) throw (net.sourceforge.pmd.lang.ast.ParseException)jjte000;}
                                   }
                                   {if (true) throw (Error)jjte000;}
    } finally {
                                   if (jjtc000) {
                                     jjtree.closeNodeScope(jjtn000, true, getToken(0));
                                   }
    }
  }

  final public void softKeyword(String name) throws net.sourceforge.pmd.lang.ast.ParseException {
    jj_consume_token(IDENTIFIER);
        if (!getToken(0).getImageCs().contentEquals(name))
            throwParseException("Expecting keyword '" + name + "'");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_106(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_107(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_108(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_109(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_110(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_111(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_112(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_113(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_114(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_115(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_116(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_117(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_118(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_119(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_120(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_121(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_122(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_123(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  private boolean jj_2_124(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_124(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  private boolean jj_2_125(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_125(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  private boolean jj_3R_270() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_587() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_3R_290()) return true;
    return false;
  }

  private boolean jj_3_43() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3R_276() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_340()) jj_scanpos = xsp;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3_42() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3_38() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_44() {
    if (jj_3R_124()) return true;
    if (jj_scan_token(DOT)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) jj_scanpos = xsp;
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_3R_302()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    }
    return false;
  }

  private boolean jj_3_39() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_3R_121()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_589() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_37() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3_125() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_577() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_37()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_589()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_123() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3_44()) return true;
    }
    }
    }
    if (jj_3R_148()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_345() {
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_125()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_576() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_560() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_576()) {
    jj_scanpos = xsp;
    if (jj_3R_577()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_40()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_181() {
    return false;
  }

  private boolean jj_3R_180() {
    return false;
  }

  private boolean jj_3R_179() {
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_3R_345()) return true;
    return false;
  }

  private boolean jj_3R_178() {
    return false;
  }

  private boolean jj_3R_559() {
    if (jj_3R_575()) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_3R_119()) return true;
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3R_177() {
    return false;
  }

  private boolean jj_3R_208() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_338()) return true;
    xsp = jj_scanpos;
    if (jj_3R_559()) jj_scanpos = xsp;
    if (jj_3R_560()) return true;
    return false;
  }

  private boolean jj_3_124() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("provides");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_181()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_123() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("uses");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_180()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_3R_121()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3_122() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("opens");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_179()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_121() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("exports");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_178()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_119() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("transitive");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) return true;
    }
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_3R_228()) return true;
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_594() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_120()) {
    jj_scanpos = xsp;
    if (jj_3_121()) {
    jj_scanpos = xsp;
    if (jj_3_122()) {
    jj_scanpos = xsp;
    if (jj_3_123()) {
    jj_scanpos = xsp;
    if (jj_3_124()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_120() {
    jj_lookingAhead = true;
    jj_semLA = isKeyword("requires");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_177()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_214() {
    if (jj_3R_289()) return true;
    return false;
  }

  private boolean jj_3R_213() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    if (jj_3R_288()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_288()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_531()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_119() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) return true;
    }
    return false;
  }

  private boolean jj_3_29() {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3_118() {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_3R_120()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_33()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_151() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3_34()) return true;
    }
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_3R_140()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_212()) return true;
    if (jj_3R_151()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_594()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_255()) return true;
    return false;
  }

  private boolean jj_3R_597() {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3_27() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3_31() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3_30()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_587()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_596() {
    if (jj_3R_597()) return true;
    return false;
  }

  private boolean jj_3R_211() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_595() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_scan_token(LPAREN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_3R_86()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_595()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_596()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_563() {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_562() {
    if (jj_3R_575()) return true;
    return false;
  }

  private boolean jj_3R_561() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_114() {
    if (jj_3R_86()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3_116() {
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_195()) jj_scanpos = xsp;
    if (jj_3R_196()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_338()) return true;
    xsp = jj_scanpos;
    if (jj_3R_561()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_562()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_563()) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_115() {
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_3R_115()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_27()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_273()) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(97)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_168() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_117()) {
    jj_scanpos = xsp;
    if (jj_3R_269()) return true;
    }
    return false;
  }

  private boolean jj_3_117() {
    if (jj_3R_82()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_171()) {
    jj_scanpos = xsp;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3_115()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3_116()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_26() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_209() {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3R_115() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_209()) {
    jj_scanpos = xsp;
    if (jj_3_26()) return true;
    }
    return false;
  }

  private boolean jj_3_113() {
    if (jj_3R_168()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_564() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_113()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_210()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) jj_scanpos = xsp;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_109() {
    if (jj_3R_121()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_385() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_564()) return true;
    return false;
  }

  private boolean jj_3_111() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_385()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_141()) return true;
    return false;
  }

  private boolean jj_3R_370() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_3R_255()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_332()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_86()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_109()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    return false;
  }

  private boolean jj_3_112() {
    if (jj_3R_167()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_111()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_20() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_108()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_334() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_112()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(97)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_3R_86()) return true;
    if (jj_3R_262()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_339()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_110() {
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_3R_334()) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) {
    jj_scanpos = xsp;
    if (jj_3_110()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3_24() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(47)) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_417() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_416()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_416() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_281()) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_82()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("enum");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_110()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("record");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_3R_276()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_165() {
    if (jj_3R_167()) return true;
    return false;
  }

  private boolean jj_3_109() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_3R_335()) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_202() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_18()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_108() {
    if (jj_3R_165()) return true;
    return false;
  }

  private boolean jj_3R_388() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_108()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_387() {
    if (jj_3R_416()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_417()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_3R_121()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_342()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_scan_token(LPAREN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_387()) {
    jj_scanpos = xsp;
    if (jj_3R_388()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_281()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_282()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_528() {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_274()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_275()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_233() {
    return false;
  }

  private boolean jj_3R_580() {
    if (jj_3R_505()) return true;
    return false;
  }

  private boolean jj_3R_583() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_234() {
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_3R_82()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_136() {
    jj_lookingAhead = true;
    jj_semLA = JavaTokenDocumentBehavior.getRealKind(getToken(1)) == RSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_233()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_137() {
    jj_lookingAhead = true;
    jj_semLA = JavaTokenDocumentBehavior.getRealKind(getToken(1)) == RUNSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_234()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_579() {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_3R_82()) return true;
    if (jj_3R_284()) return true;
    return false;
  }

  private boolean jj_3R_106() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3_17()) return true;
    }
    return false;
  }

  private boolean jj_3R_578() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_114()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_528()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_535() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_15()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_555() {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_3R_205()) return true;
    if (jj_3R_151()) return true;
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_571() {
    if (jj_3R_212()) return true;
    if (jj_3R_210()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_583()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_105()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_578()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_548() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_548()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_554() {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_571()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_534() {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_336() {
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3R_162() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_3R_265()) return true;
    }
    return false;
  }

  private boolean jj_3_106() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_162()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_163()) return true;
    if (jj_3R_164()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3_105() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_161()) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_270()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) jj_scanpos = xsp;
    if (jj_3R_337()) return true;
    xsp = jj_scanpos;
    if (jj_3R_534()) jj_scanpos = xsp;
    if (jj_3R_535()) return true;
    return false;
  }

  private boolean jj_3_107() {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_3R_205()) return true;
    if (jj_3R_164()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_579()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_580()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_161() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3_107()) return true;
    }
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_3R_212()) return true;
    if (jj_3R_163()) return true;
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_570() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_551() {
    if (jj_scan_token(SEMICOLON)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_13()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_550() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_549() {
    if (jj_3R_104()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_12()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_444() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_161()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_105()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_570()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_549()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_550()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_551()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_422() {
    if (jj_3R_444()) return true;
    return false;
  }

  private boolean jj_3R_271() {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3R_540() {
    if (jj_3R_555()) return true;
    return false;
  }

  private boolean jj_3R_539() {
    if (jj_3R_554()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_3R_270()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) jj_scanpos = xsp;
    if (jj_3R_272()) return true;
    return false;
  }

  private boolean jj_3R_567() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_402() {
    if (jj_scan_token(TRY)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_422()) jj_scanpos = xsp;
    if (jj_3R_341()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_539()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_540()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_3R_270()) return true;
    if (jj_3R_120()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_567()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_566() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_401() {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3_104() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_210()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_566()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_421() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_565() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_278() {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_210()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_565()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_197() {
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_593() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_153()) return true;
    return false;
  }

  private boolean jj_3R_399() {
    if (jj_scan_token(RETURN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_104()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_420() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_3R_280()) return true;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_3R_279()) return true;
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_3R_278()) return true;
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3R_398() {
    if (jj_scan_token(CONTINUE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_421()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_84() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_3R_197()) return true;
    }
    if (jj_scan_token(IDENTIFIER)) return true;
    xsp = jj_scanpos;
    if (jj_3R_198()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_200()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_201()) jj_scanpos = xsp;
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_397() {
    if (jj_scan_token(BREAK)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_420()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_157() {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3_102() {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_3R_82()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("enum");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_187()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("record");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_188()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_160() {
    if (jj_3R_153()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_593()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_103() {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_156() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3_103()) return true;
    }
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_537() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_419()) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(MINUS)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_158() {
    if (jj_3R_159()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_scan_token(STRICTFP)) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_scan_token(VOLATILE)) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_scan_token(TRANSIENT)) return true;
    return false;
  }

  private boolean jj_3_100() {
    if (jj_3R_158()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_scan_token(NATIVE)) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_scan_token(ABSTRACT)) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3_99() {
    if (jj_3R_157()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3_98() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3_97() {
    if (jj_3R_156()) return true;
    return false;
  }

  private boolean jj_3R_538() {
    if (jj_3R_158()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_419()) return true;
    return false;
  }

  private boolean jj_3_101() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_98()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_99()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_419()) return true;
    return false;
  }

  private boolean jj_3_11() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) {
    jj_scanpos = xsp;
    if (jj_3R_94()) {
    jj_scanpos = xsp;
    if (jj_3R_95()) {
    jj_scanpos = xsp;
    if (jj_3R_96()) {
    jj_scanpos = xsp;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) {
    jj_scanpos = xsp;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("sealed");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_101()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isNonSealedModifier();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_121()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_82() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_11()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_396() {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_538()) {
    jj_scanpos = xsp;
    if (jj_3_101()) return true;
    }
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_419()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    return false;
  }

  private boolean jj_3R_394() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_419()) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_203()) return true;
    return false;
  }

  private boolean jj_3R_414() {
    if (jj_3R_439()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_86()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_87()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_393() {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_419()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_537()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_8() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) jj_scanpos = xsp;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_183()) { jj_scanpos = xsp; break; }
    }
    jj_lookingAhead = true;
    jj_semLA = isKeyword("open") || isKeyword("module");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_184()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_3R_208()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_189() {
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_330()) return true;
    return false;
  }

  private boolean jj_3R_592() {
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_412() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_439() {
    if (jj_3R_270()) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_3R_82()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("enum");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_189()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("record");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3_10()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_413() {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3R_591() {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3_95() {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3_6() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_4()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_82()) return true;
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3_96() {
    if (jj_3R_155()) return true;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_383() {
    if (jj_3R_413()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_414()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_1() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_77()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(PACKAGE)) return true;
    return false;
  }

  private boolean jj_3R_568() {
    if (jj_3R_581()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_330() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_382()) {
    jj_scanpos = xsp;
    if (jj_3R_383()) {
    jj_scanpos = xsp;
    if (jj_3_96()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_scan_token(NULL)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_412()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_94() {
    if (jj_3R_114()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_330()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_331()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_154() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) return true;
    }
    return false;
  }

  private boolean jj_3R_590() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3_93() {
    if (jj_3R_154()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_581() {
    if (jj_3R_154()) return true;
    if (jj_scan_token(COLON)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_590()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_582() {
    if (jj_3R_154()) return true;
    if (jj_scan_token(LAMBDA)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_94()) {
    jj_scanpos = xsp;
    if (jj_3R_591()) {
    jj_scanpos = xsp;
    if (jj_3R_592()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_569() {
    if (jj_3R_582()) return true;
    return false;
  }

  private boolean jj_3R_553() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_569()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_423() {
    if (jj_3R_435()) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_552() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    if (jj_3R_568()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_568()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_344() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_536() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_552()) {
    jj_scanpos = xsp;
    if (jj_3R_553()) return true;
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_392() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_536()) return true;
    return false;
  }

  private boolean jj_3_92() {
    if (jj_3R_143()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_423()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_153() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3_92()) return true;
    }
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_3R_329()) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_3R_153()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_391() {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_91() {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_163() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = jdkVersion >= 10 && isKeyword("var");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3_91()) return true;
    }
    return false;
  }

  private boolean jj_3R_287() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) return true;
    }
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_212() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_287()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_527() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_3R_163()) return true;
    if (jj_3R_262()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_527()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_262()) return true;
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_212()) return true;
    if (jj_3R_163()) return true;
    if (jj_3R_262()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_263()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_351() {
    if (jj_3R_169()) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_3R_207()) return true;
    return false;
  }

  private boolean jj_3R_349() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_299() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("record");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_350()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("enum");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_351()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_503() {
    if (jj_3R_286()) return true;
    return false;
  }

  private boolean jj_3_90() {
    if (jj_3R_86()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_89() {
    if (jj_3R_128()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_3R_301()) return true;
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_3R_159()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_3R_301()) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_3R_300()) return true;
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_3R_159()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_220() {
    if (jj_3R_82()) return true;
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_3R_348()) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_3R_347()) return true;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_3R_82()) return true;
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_3R_346()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_219() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = localTypeDeclGivenNextIsIdent();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_293()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isAssertStart();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_294()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isYieldStart();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_295()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = getToken(2).kind == COLON;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = true;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_298()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_3R_82()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = localTypeDeclAfterModifiers();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_291()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = true;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_292()) return true;
    }
    return false;
  }

  private boolean jj_3R_122() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_218()) {
    jj_scanpos = xsp;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) {
    jj_scanpos = xsp;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = true;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_223()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_88() {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_341() {
    if (jj_scan_token(LBRACE)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_88()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_419()) return true;
    return false;
  }

  private boolean jj_3R_502() {
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_3R_402()) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_3R_401()) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_3R_400()) return true;
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_3R_399()) return true;
    return false;
  }

  private boolean jj_3_85() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_3R_398()) return true;
    return false;
  }

  private boolean jj_3R_359() {
    if (jj_3R_397()) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_3R_396()) return true;
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_3R_395()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_3R_394()) return true;
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_3R_393()) return true;
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_3R_392()) return true;
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_3R_391()) return true;
    return false;
  }

  private boolean jj_3R_300() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) {
    jj_scanpos = xsp;
    if (jj_3R_355()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) {
    jj_scanpos = xsp;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) {
    jj_scanpos = xsp;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) {
    jj_scanpos = xsp;
    if (jj_3R_363()) {
    jj_scanpos = xsp;
    if (jj_3R_364()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3_87() {
    if (jj_3R_153()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_86() {
    if (jj_3R_152()) return true;
    return false;
  }

  private boolean jj_3R_443() {
    if (jj_3R_347()) return true;
    return false;
  }

  private boolean jj_3R_442() {
    if (jj_3R_348()) return true;
    return false;
  }

  private boolean jj_3R_419() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_441()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isYieldStart();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_442()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isAssertStart();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_443()) {
    jj_scanpos = xsp;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3_87()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_441() {
    if (jj_3R_300()) return true;
    return false;
  }

  private boolean jj_3_84() {
    if (jj_3R_139()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_488() {
    if (jj_3R_505()) return true;
    return false;
  }

  private boolean jj_3R_504() {
    if (jj_3R_511()) return true;
    return false;
  }

  private boolean jj_3R_511() {
    if (jj_3R_228()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_85()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_487() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    if (jj_3R_504()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_504()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_473() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_486()) {
    jj_scanpos = xsp;
    if (jj_3R_487()) return true;
    }
    return false;
  }

  private boolean jj_3R_486() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    if (jj_3R_502()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_502()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_503()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_475() {
    if (jj_3R_148()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_488()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_474() {
    if (jj_3R_473()) return true;
    return false;
  }

  private boolean jj_3R_447() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3_83() {
    if (jj_3R_120()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_474()) {
    jj_scanpos = xsp;
    if (jj_3R_475()) return true;
    }
    return false;
  }

  private boolean jj_3R_448() {
    if (jj_3R_140()) return true;
    if (jj_3R_473()) return true;
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_scan_token(NEW)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_447()) jj_scanpos = xsp;
    if (jj_3R_139()) return true;
    xsp = jj_scanpos;
    if (jj_3R_448()) {
    jj_scanpos = xsp;
    if (jj_3_83()) return true;
    }
    return false;
  }

  private boolean jj_3R_505() {
    if (jj_3R_202()) return true;
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_501() {
    if (jj_3R_505()) return true;
    return false;
  }

  private boolean jj_3R_500() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_485() {
    if (jj_scan_token(NEW)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_500()) jj_scanpos = xsp;
    if (jj_3R_210()) return true;
    if (jj_3R_148()) return true;
    xsp = jj_scanpos;
    if (jj_3R_501()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_82() {
    if (jj_3R_114()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_367()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_scan_token(LPAREN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_82()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_438() {
    if (jj_scan_token(TEXT_BLOCK_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_407() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_3R_438()) return true;
    }
    return false;
  }

  private boolean jj_3R_408() {
    if (jj_scan_token(CHARACTER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_437() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_436() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_406() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) {
    jj_scanpos = xsp;
    if (jj_3R_437()) return true;
    }
    return false;
  }

  private boolean jj_3R_377() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_376() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_409()) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) return true;
    }
    return false;
  }

  private boolean jj_3R_409() {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_3R_408()) return true;
    return false;
  }

  private boolean jj_3R_374() {
    if (jj_3R_407()) return true;
    return false;
  }

  private boolean jj_3R_323() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) {
    jj_scanpos = xsp;
    if (jj_3R_374()) {
    jj_scanpos = xsp;
    if (jj_3R_375()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) {
    jj_scanpos = xsp;
    if (jj_3R_377()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_373() {
    if (jj_3R_406()) return true;
    return false;
  }

  private boolean jj_3_81() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_522() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_80() {
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(TEXT_BLOCK_TEMPLATE_MID)) return true;
    if (jj_3R_522()) return true;
    return false;
  }

  private boolean jj_3R_519() {
    if (jj_scan_token(TEXT_BLOCK_TEMPLATE_MID)) return true;
    if (jj_3R_522()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_80()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(TEXT_BLOCK_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_79() {
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(STRING_TEMPLATE_MID)) return true;
    if (jj_3R_522()) return true;
    return false;
  }

  private boolean jj_3R_518() {
    if (jj_scan_token(STRING_TEMPLATE_BEGIN)) return true;
    if (jj_3R_522()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_79()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    if (jj_scan_token(STRING_TEMPLATE_END)) return true;
    return false;
  }

  private boolean jj_3R_515() {
    if (jj_scan_token(TEXT_BLOCK_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_514() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_513() {
    if (jj_3R_519()) return true;
    return false;
  }

  private boolean jj_3R_450() {
    if (jj_3R_341()) return true;
    return false;
  }

  private boolean jj_3R_508() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_512()) {
    jj_scanpos = xsp;
    if (jj_3R_513()) {
    jj_scanpos = xsp;
    if (jj_3R_514()) {
    jj_scanpos = xsp;
    if (jj_3R_515()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_512() {
    if (jj_3R_518()) return true;
    return false;
  }

  private boolean jj_3R_410() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_378()) return true;
    return false;
  }

  private boolean jj_3R_411() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_149()) return true;
    return false;
  }

  private boolean jj_3_78() {
    if (jj_3R_151()) return true;
    return false;
  }

  private boolean jj_3R_150() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = jdkVersion >= 11 && isKeyword("var");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3_78()) return true;
    }
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_74() {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_497() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3_77() {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_3R_212()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) jj_scanpos = xsp;
    if (jj_3R_255()) return true;
    return false;
  }

  private boolean jj_3_76() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) return true;
    }
    return false;
  }

  private boolean jj_3R_379() {
    if (jj_3R_378()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_410()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_75() {
    if (jj_3R_149()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_411()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_scan_token(LPAREN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_75()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_scan_token(LPAREN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_379()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_254() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_326()) {
    jj_scanpos = xsp;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_3R_378()) return true;
    return false;
  }

  private boolean jj_3R_496() {
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_490() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_369() {
    if (jj_3R_254()) return true;
    if (jj_scan_token(LAMBDA)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3R_450()) return true;
    }
    return false;
  }

  private boolean jj_3R_253() {
    return false;
  }

  private boolean jj_3R_146() {
    jj_lookingAhead = true;
    jj_semLA = !inSwitchLabel;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_253()) return true;
    if (jj_3R_254()) return true;
    if (jj_scan_token(LAMBDA)) return true;
    return false;
  }

  private boolean jj_3R_472() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_471() {
    if (jj_3R_302()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_489() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_449() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_429() {
    if (jj_scan_token(METHOD_REF)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_449()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_3R_302()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_3R_302()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_73() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_507() {
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_446() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_470()) {
    jj_scanpos = xsp;
    if (jj_3R_471()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3R_472()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_470() {
    if (jj_3R_485()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_72() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_3R_147()) return true;
    }
    return false;
  }

  private boolean jj_3R_433() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_446()) return true;
    return false;
  }

  private boolean jj_3R_432() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_404() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_431()) {
    jj_scanpos = xsp;
    if (jj_3R_432()) {
    jj_scanpos = xsp;
    if (jj_3R_433()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_431() {
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_481() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_506() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_446()) return true;
    return false;
  }

  private boolean jj_3R_495() {
    if (jj_3R_508()) return true;
    return false;
  }

  private boolean jj_3R_480() {
    if (jj_3R_125()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_496()) {
    jj_scanpos = xsp;
    if (jj_3R_497()) return true;
    }
    return false;
  }

  private boolean jj_3R_494() {
    if (jj_3R_446()) return true;
    return false;
  }

  private boolean jj_3R_493() {
    if (jj_scan_token(SUPER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_506()) {
    jj_scanpos = xsp;
    if (jj_3R_507()) return true;
    }
    return false;
  }

  private boolean jj_3R_492() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_491() {
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_478() {
    if (jj_3R_148()) return true;
    return false;
  }

  private boolean jj_3R_479() {
    if (jj_scan_token(DOT)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_491()) {
    jj_scanpos = xsp;
    if (jj_3R_492()) {
    jj_scanpos = xsp;
    if (jj_3R_493()) {
    jj_scanpos = xsp;
    if (jj_3R_494()) {
    jj_scanpos = xsp;
    if (jj_3R_495()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_477() {
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_451() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_476()) {
    jj_scanpos = xsp;
    if (jj_3R_477()) {
    jj_scanpos = xsp;
    if (jj_3R_478()) {
    jj_scanpos = xsp;
    if (jj_3R_479()) {
    jj_scanpos = xsp;
    if (jj_3R_480()) {
    jj_scanpos = xsp;
    if (jj_3R_481()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_476() {
    if (jj_3R_302()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_489()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_490()) jj_scanpos = xsp;
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3_69() {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3R_250() {
    if (jj_scan_token(DOT)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_144() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !inExplicitConstructorInvoc;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(98)) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = inExplicitConstructorInvoc;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_250()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_252() {
    if (jj_scan_token(DOT)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_325()) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_430() {
    if (jj_3R_451()) return true;
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_3R_302()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_145() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = !inExplicitConstructorInvoc;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_scan_token(98)) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = inExplicitConstructorInvoc;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_252()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_3R_290()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_430()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_425() {
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3_71() {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_426() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3_70() {
    if (jj_scan_token(AT)) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_68() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_3R_369()) return true;
    return false;
  }

  private boolean jj_3R_311() {
    if (jj_3R_134()) return true;
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_428() {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_427() {
    if (jj_3R_429()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_3R_404()) return true;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_scan_token(VOID)) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_3R_140()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_426()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_427()) {
    jj_scanpos = xsp;
    if (jj_3R_428()) return true;
    }
    return false;
  }

  private boolean jj_3R_424() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_446()) return true;
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_3R_323()) return true;
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_3R_368()) return true;
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_scan_token(SUPER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_424()) {
    jj_scanpos = xsp;
    if (jj_3R_425()) return true;
    }
    return false;
  }

  private boolean jj_3R_306() {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_226() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) {
    jj_scanpos = xsp;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) {
    jj_scanpos = xsp;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_3R_323()) return true;
    return false;
  }

  private boolean jj_3R_124() {
    if (jj_3R_226()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_366()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_321() {
    if (jj_scan_token(BANG)) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_536()) return true;
    return false;
  }

  private boolean jj_3R_468() {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3R_467() {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_445() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_467()) {
    jj_scanpos = xsp;
    if (jj_3R_468()) return true;
    }
    return false;
  }

  private boolean jj_3R_547() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_3R_124()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_445()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_142() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_3R_249()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_66() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_141()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3_65() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_139()) return true;
    if (jj_3R_140()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_3R_322()) return true;
    return false;
  }

  private boolean jj_3_67() {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_141()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_236() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_129()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_526()) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3R_235() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) return true;
    }
    if (jj_3R_526()) return true;
    return false;
  }

  private boolean jj_3R_138() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_381() {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3R_380() {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3R_329() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_380()) {
    jj_scanpos = xsp;
    if (jj_3R_381()) return true;
    }
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_546() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_64() {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_533() {
    if (jj_3R_329()) return true;
    return false;
  }

  private boolean jj_3R_532() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_546()) {
    jj_scanpos = xsp;
    if (jj_3R_547()) return true;
    }
    if (jj_3R_526()) return true;
    return false;
  }

  private boolean jj_3R_526() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_532()) {
    jj_scanpos = xsp;
    if (jj_3R_533()) {
    jj_scanpos = xsp;
    if (jj_3_64()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_586() {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  private boolean jj_3R_585() {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  private boolean jj_3R_584() {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_572() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_584()) {
    jj_scanpos = xsp;
    if (jj_3R_585()) {
    jj_scanpos = xsp;
    if (jj_3R_586()) return true;
    }
    }
    if (jj_3R_526()) return true;
    return false;
  }

  private boolean jj_3R_521() {
    if (jj_3R_526()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_572()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_574() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_573() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_556() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_573()) {
    jj_scanpos = xsp;
    if (jj_3R_574()) return true;
    }
    if (jj_3R_521()) return true;
    return false;
  }

  private boolean jj_3R_517() {
    if (jj_3R_521()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_556()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_63() {
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3_62() {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_scan_token(LSHIFT)) return true;
    return false;
  }

  private boolean jj_3_61() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3_63()) return true;
    }
    }
    if (jj_3R_517()) return true;
    return false;
  }

  private boolean jj_3R_510() {
    if (jj_3R_517()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_61()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_544() {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_543() {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_542() {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_541() {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_529() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_541()) {
    jj_scanpos = xsp;
    if (jj_3R_542()) {
    jj_scanpos = xsp;
    if (jj_3R_543()) {
    jj_scanpos = xsp;
    if (jj_3R_544()) return true;
    }
    }
    }
    if (jj_3R_510()) return true;
    return false;
  }

  private boolean jj_3R_499() {
    if (jj_3R_510()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_529()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_58() {
    if (jj_3R_128()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_558() {
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3R_557() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_545() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_557()) {
    jj_scanpos = xsp;
    if (jj_3R_558()) return true;
    }
    return false;
  }

  private boolean jj_3_60() {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3_59() {
    if (jj_3R_134()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_545()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_530() {
    if (jj_3R_319()) return true;
    return false;
  }

  private boolean jj_3R_523() {
    if (jj_scan_token(INSTANCEOF)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_530()) {
    jj_scanpos = xsp;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_465() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_231()) return true;
    return false;
  }

  private boolean jj_3R_483() {
    if (jj_3R_499()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_523()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_371() {
    if (jj_3R_270()) return true;
    return false;
  }

  private boolean jj_3_57() {
    if (jj_3R_133()) return true;
    return false;
  }

  private boolean jj_3R_231() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = isKeyword("_");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3_57()) return true;
    }
    return false;
  }

  private boolean jj_3R_318() {
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3_56() {
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_132() {
    if (jj_3R_231()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_465()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_384() {
    if (jj_scan_token(LPAREN)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_56()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_372() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_372()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_128()) return true;
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3_54() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_130()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_128()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_212()) return true;
    if (jj_3R_163()) return true;
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3_55() {
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_3R_319()) return true;
    return false;
  }

  private boolean jj_3R_133() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3_55()) return true;
    }
    return false;
  }

  private boolean jj_3R_516() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_466()) return true;
    return false;
  }

  private boolean jj_3R_525() {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_524() {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_498() {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_415()) return true;
    return false;
  }

  private boolean jj_3R_509() {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_440()) return true;
    return false;
  }

  private boolean jj_3R_520() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_524()) {
    jj_scanpos = xsp;
    if (jj_3R_525()) return true;
    }
    if (jj_3R_483()) return true;
    return false;
  }

  private boolean jj_3R_482() {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_386()) return true;
    return false;
  }

  private boolean jj_3R_466() {
    if (jj_3R_483()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_520()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_452() {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_333()) return true;
    return false;
  }

  private boolean jj_3R_440() {
    if (jj_3R_466()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_516()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_434() {
    if (jj_scan_token(HOOK)) return true;
    if (jj_3R_114()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_166()) return true;
    return false;
  }

  private boolean jj_3R_415() {
    if (jj_3R_440()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_509()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_386() {
    if (jj_3R_415()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_498()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_3R_386()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_482()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_3R_333()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_452()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_3R_266()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_434()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_464() {
    if (jj_scan_token(ORASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_588() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_463() {
    if (jj_scan_token(XORASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_462() {
    if (jj_scan_token(ANDASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_461() {
    if (jj_scan_token(RUNSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_460() {
    if (jj_scan_token(RSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_459() {
    if (jj_scan_token(LSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_458() {
    if (jj_scan_token(MINUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_457() {
    if (jj_scan_token(PLUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_456() {
    if (jj_scan_token(REMASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_455() {
    if (jj_scan_token(SLASHASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_454() {
    if (jj_scan_token(STARASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_435() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_453()) {
    jj_scanpos = xsp;
    if (jj_3R_454()) {
    jj_scanpos = xsp;
    if (jj_3R_455()) {
    jj_scanpos = xsp;
    if (jj_3R_456()) {
    jj_scanpos = xsp;
    if (jj_3R_457()) {
    jj_scanpos = xsp;
    if (jj_3R_458()) {
    jj_scanpos = xsp;
    if (jj_3R_459()) {
    jj_scanpos = xsp;
    if (jj_3R_460()) {
    jj_scanpos = xsp;
    if (jj_3R_461()) {
    jj_scanpos = xsp;
    if (jj_3R_462()) {
    jj_scanpos = xsp;
    if (jj_3R_463()) {
    jj_scanpos = xsp;
    if (jj_3R_464()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_453() {
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_405() {
    if (jj_3R_435()) return true;
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_3R_166()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_405()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_575() {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_210()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_588()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_53() {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_196() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_277()) {
    jj_scanpos = xsp;
    if (jj_3_53()) return true;
    }
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_scan_token(VOID)) return true;
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_3R_317()) return true;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_245() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_242() {
    if (jj_scan_token(SHORT)) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_scan_token(BYTE)) return true;
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_140() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) {
    jj_scanpos = xsp;
    if (jj_3R_242()) {
    jj_scanpos = xsp;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_484() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3_52() {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_389() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_469() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_3R_484()) return true;
    }
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_403() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_scan_token(HOOK)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_469()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_3R_139()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3R_229()) return true;
    }
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_scan_token(LT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_51() {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_127()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_403()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_302() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_51()) {
    jj_scanpos = xsp;
    if (jj_3R_365()) return true;
    }
    return false;
  }

  private boolean jj_3R_418() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_3R_228()) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_418()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_50() {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_390() {
    if (jj_3R_302()) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_3R_290()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_390()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_48() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_215() {
    if (jj_scan_token(IDENTIFIER)) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_389()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_120() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = jjtree.isInjectionPending();
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_50()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_49() {
    if (jj_3R_120()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_46() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_3R_140()) return true;
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_128() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3_49()) return true;
    }
    return false;
  }

  private boolean jj_3_45() {
    if (jj_3R_125()) return true;
    return false;
  }

  private boolean jj_3R_315() {
    if (jj_3R_228()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    if (jj_3R_227()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_227()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_47() {
    if (jj_3R_120()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_3R_140()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3_45()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_86() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    xsp = jj_scanpos;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3_47()) return true;
    }
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_3R_139()) return true;
    if (jj_3R_120()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_3R_139()) return true;
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_3R_139()) return true;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_3R_370()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_316()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_205() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_283()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_3R_182()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_217()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_303() {
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_3R_129()) return true;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_247()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_531() {
    if (jj_3R_289()) return true;
    return false;
  }

  /** Generated net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken Manager. */
  public JavaParserImplTokenManager token_source;
  /** Current token. */
  public net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken token;
  /** Next token. */
  public net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken jj_nt;
  private net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[186];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4100400,0x0,0x20000,0x20000,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10412800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10412800,0x0,0x10412800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1000000,0x10412800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x12412800,0x0,0x0,0x0,0x0,0x0,0x12412800,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10412800,0x0,0x0,0x0,0x0,0xa0281000,0xa0281000,0xa42a1400,0x20400,0x20000,0x0,0x0,0x4000000,0x4000000,0x0,0x0,0x104000,0x104000,0x0,0x0,0x104000,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x8000,0x8000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x2,0x0,0x0,0x0,0x0,0x8000,0x0,0x14449c40,0x0,0x10,0x10,0x0,0x0,0x1,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x4028,0x0,0x0,0x0,0x200000,0x90000,0x0,0x8000,0x0,0x0,0x0,0x0,0x4028,0x0,0x4028,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000,0x10000,0x4028,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x228b41a8,0x0,0x0,0x0,0x0,0x0,0x228941a8,0x0,0x0,0x80080,0x0,0x80,0x0,0x0,0x0,0x0,0x90080,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x20800100,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4028,0x0,0x0,0x0,0x0,0x9162000,0x9162000,0x1d56bc50,0x14409c50,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x4000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x800000,0x10000000,0x0,0x0,0x40000000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4800000,0x4800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4840c04,0x0,0x0,0x0,0x40000000,0x0,0x40c04,0x4800000,0x40000000,0x800000,0x44000000,0x800000,0x40000000,0x0,0x40000000,0x0,0x8d0800,0x0,0x4000000,0x40000000,0x40000000,0x0,0x800000,0x0,0x800000,0x10000000,0x0,0x800000,0x0,0x800000,0x4000000,0xd0800,0x0,0x40c04,0x4,0x40800,0x0,0x0,0x10000000,0x0,0x10000000,0x44000000,0x0,0x40000000,0x10000000,0x40000000,0x40000000,0x10000000,0x10000000,0x10800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x10000000,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x1,0x0,0x1,0x1,0x1,0x8,0x0,0x4,0x0,0x8,0x8,0x0,0x20,0x0,0x0,0x2,0x2,0x2,0x0,0x8,0x2,0x1,0x0,0x0,0x20,0x0,0x2,0x2,0x0,0x1,0x2,0x10,0x8,0x0,0x0,0x2,0x20,0x8,0x0,0x1,0x2,0x800000,0x0,0x8,0x8,0x20,0x0,0x0,0x20,0x0,0x400000,0x8,0x8,0x8,0x0,0x8,0x0,0x20,0x20,0x0,0x20,0x2,0x20,0x100,0x0,0x0,0x0,0x0,0x2,0xf8000010,0xf8000010,0x100,0x4000,0x8000,0x800000,0x1000000,0x400000,0x2400,0x2400,0x8,0x2,0x0,0x0,0x0,0x1820,0x1820,0x4000000,0xc0000,0xc0000,0x2300000,0x2300000,0xc0000,0xf0000,0x30000,0xc0,0xc0,0x0,0xc8,0x30000,0x30000,0x4,0x8,0x4,0x0,0x0,0xc,0x20,0x28,0x20,0x0,0x4,0x8,0x4,0x20,0x4,0x24,0x0,0x4,0x20,0x0,0x20,0x0,0x0,0x2,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x20,0x0,0x20,0x0,0x8,0x0,0x8,0x0,0x8,0x8,0x1,0x1,0x9,0x0,0x0,0x2,0x2,0x8,0x8,0xf8000010,0x30000,0x0,0x0,0x0,0x2,0x0,0x2,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x1,0x800000,0x200,0x0,0x2,0x8,0x2,0x0,0x8,0x1,0x8,0x0,0x0,0x2,0x2,0x2,0x4,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800,0x800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x100,0x0,0x0,0x100,0x0,0x100,0x0,0x100,0x0,0x0,0x100,0x0,0x100,0x100,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[125];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied net.sourceforge.pmd.lang.ast.impl.javacc.CharStream. */
  public JavaParserImpl(net.sourceforge.pmd.lang.ast.impl.javacc.CharStream stream) {
    token_source = new JavaParserImplTokenManager(stream);
    token = token_source.input_stream.getTokenDocument().open();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 186; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(net.sourceforge.pmd.lang.ast.impl.javacc.CharStream stream) {
    token_source.ReInit(stream);
    token = token_source.input_stream.getTokenDocument().open();
    token.next = jj_nt = token_source.getNextToken();
    jj_lookingAhead = false;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 186; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken Manager. */
  public JavaParserImpl(JavaParserImplTokenManager tm) {
    token_source = tm;
    token = token_source.input_stream.getTokenDocument().open();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 186; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(JavaParserImplTokenManager tm) {
    token_source = tm;
    token = token_source.input_stream.getTokenDocument().open();
    token.next = jj_nt = token_source.getNextToken();
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 186; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken jj_consume_token(int kind) throws net.sourceforge.pmd.lang.ast.ParseException {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken. */
  final public net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

/** Get the specific net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken. */
  final public net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken getToken(int index) {
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate net.sourceforge.pmd.lang.ast.ParseException. */
  public net.sourceforge.pmd.lang.ast.ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[140];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 186; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 140; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new net.sourceforge.pmd.lang.ast.ParseException(token, exptokseq);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 125; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
            case 116: jj_3_117(); break;
            case 117: jj_3_118(); break;
            case 118: jj_3_119(); break;
            case 119: jj_3_120(); break;
            case 120: jj_3_121(); break;
            case 121: jj_3_122(); break;
            case 122: jj_3_123(); break;
            case 123: jj_3_124(); break;
            case 124: jj_3_125(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken first;
    int arg;
    JJCalls next;
  }

}
