/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class UseEnumCollectionsRule
extends AbstractJavaRulechainRule {
    public UseEnumCollectionsRule() {
        super(ASTConstructorCall.class, new Class[0]);
    }

    public Object visit(ASTConstructorCall call, Object data) {
        List<JTypeMirror> typeArgs;
        JTypeDeclSymbol keySymbol;
        boolean isMap;
        JTypeMirror builtType = call.getTypeMirror();
        if (!builtType.isRaw() && ((isMap = TypeTestUtil.isExactlyA(HashMap.class, builtType)) || TypeTestUtil.isExactlyA(HashSet.class, builtType)) && (keySymbol = (typeArgs = ((JClassType)builtType).getTypeArgs()).get(0).getSymbol()) instanceof JClassSymbol && ((JClassSymbol)keySymbol).isEnum()) {
            String enumCollectionReplacement = isMap ? "EnumMap" : "EnumSet";
            this.asCtx(data).addViolation((Node)call.getTypeNode(), new Object[]{enumCollectionReplacement});
        }
        return null;
    }
}

